/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.ITubeConnectable;
import com.eloraam.redpower.core.ITubeFlow;
import com.eloraam.redpower.core.MachineLib;
import com.eloraam.redpower.core.TubeItem;
import com.eloraam.redpower.core.TubeLib;
import com.eloraam.redpower.core.WorldCoord;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class TubeFlow {
    public LinkedList<TubeItem> contents = new LinkedList();

    public abstract boolean schedule(TubeItem var1, TubeScheduleContext var2);

    public boolean handleItem(TubeItem item, TubeScheduleContext context) {
        return false;
    }

    public abstract TileEntity getParent();

    public boolean update() {
        boolean hasChanged = false;
        if (this.contents.size() == 0) {
            return false;
        }
        TubeScheduleContext tsc = new TubeScheduleContext(this.getParent());
        for (TubeItem tubeItem : this.contents) {
            tubeItem.progress = (short)(tubeItem.progress + tubeItem.power + 16);
            if (tubeItem.progress < 128) continue;
            if (tubeItem.power > 0) {
                tubeItem.power = (short)(tubeItem.power - 1);
            }
            hasChanged = true;
            if (!tubeItem.scheduled) {
                if (this.schedule(tubeItem, tsc)) continue;
                tsc.tii.remove();
                continue;
            }
            tsc.tii.remove();
            if (tsc.world.field_72995_K) continue;
            tsc.tir.add(tubeItem);
        }
        if (tsc.world.field_72995_K) {
            // empty if block
        }
        for (TubeItem ti : tsc.tir) {
            if (ti.side >= 0 && (tsc.cons & 1 << ti.side) != 0) {
                tsc.dest = tsc.wc.copy();
                tsc.dest.step(ti.side);
                ITubeConnectable itc = CoreLib.getTileEntity((IBlockAccess)tsc.world, tsc.dest, ITubeConnectable.class);
                if (itc instanceof ITubeFlow) {
                    ITubeFlow itf = (ITubeFlow)itc;
                    itf.addTubeItem(ti);
                    continue;
                }
                if (itc != null && itc.tubeItemEnter((ti.side ^ 1) & 0x3F, ti.mode, ti) || this.handleItem(ti, tsc)) continue;
                ti.progress = 0;
                ti.scheduled = false;
                ti.mode = (byte)2;
                this.contents.add(ti);
                continue;
            }
            if (tsc.cons == 0) {
                MachineLib.ejectItem(tsc.world, tsc.wc, ti.item, 1);
                continue;
            }
            ti.side = (byte)Integer.numberOfTrailingZeros(tsc.cons);
            ti.progress = (short)128;
            ti.scheduled = false;
            this.contents.add(ti);
            hasChanged = true;
        }
        return hasChanged;
    }

    public void add(TubeItem ti) {
        ti.progress = 0;
        ti.scheduled = false;
        this.contents.add(ti);
    }

    public void onRemove() {
        TileEntity te = this.getParent();
        for (TubeItem ti : this.contents) {
            if (ti == null || ti.item.field_77994_a <= 0) continue;
            CoreLib.dropItem(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e, ti.item);
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList items = tag.func_150295_c("Items", 10);
        if (items.func_74745_c() > 0) {
            this.contents = new LinkedList();
            for (int i = 0; i < items.func_74745_c(); ++i) {
                NBTTagCompound item = items.func_150305_b(i);
                this.contents.add(TubeItem.newFromNBT(item));
            }
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList items = new NBTTagList();
        if (this.contents != null) {
            for (TubeItem ti : this.contents) {
                NBTTagCompound item = new NBTTagCompound();
                ti.writeToNBT(item);
                items.func_74742_a((NBTBase)item);
            }
        }
        tag.func_74782_a("Items", (NBTBase)items);
    }

    public static class TubeScheduleContext {
        public World world;
        public WorldCoord wc;
        public int cons;
        public List<TubeItem> tir = new ArrayList<TubeItem>();
        public Iterator<TubeItem> tii;
        public WorldCoord dest = null;

        public TubeScheduleContext(TileEntity te) {
            this.world = te.func_145831_w();
            this.wc = new WorldCoord(te);
            this.cons = TubeLib.getConnections((IBlockAccess)this.world, this.wc.x, this.wc.y, this.wc.z);
        }
    }
}

