/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.ITubeConnectable;
import com.eloraam.redpower.core.ITubeRequest;
import com.eloraam.redpower.core.MachineLib;
import com.eloraam.redpower.core.TubeItem;
import com.eloraam.redpower.core.WorldCoord;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TubeLib {
    private static Set<List<Integer>> tubeClassMapping = new HashSet<List<Integer>>();

    public static void addCompatibleMapping(int a, int b) {
        tubeClassMapping.add(Arrays.asList(a, b));
        tubeClassMapping.add(Arrays.asList(b, a));
    }

    public static boolean isCompatible(int a, int b) {
        return a == b || tubeClassMapping.contains(Arrays.asList(a, b));
    }

    private static boolean isConSide(IBlockAccess iba, int x, int y, int z, int col, int side) {
        TileEntity te = iba.func_147438_o(x, y, z);
        if (te instanceof ITubeConnectable) {
            ITubeConnectable itc = (ITubeConnectable)te;
            if (!TubeLib.isCompatible(col, itc.getTubeConClass())) {
                return false;
            }
            int sides = itc.getTubeConnectableSides();
            return (sides & 1 << side) > 0;
        }
        if (TubeLib.isCompatible(col, 0) && te instanceof IInventory) {
            if (!(te instanceof ISidedInventory)) {
                return true;
            }
            ISidedInventory isi = (ISidedInventory)te;
            if (isi.func_70302_i_() > 0) {
                int[] slots = isi.func_94128_d(side);
                return slots != null && slots.length > 0;
            }
        }
        return false;
    }

    public static int getConnections(IBlockAccess iba, int x, int y, int z) {
        ITubeConnectable itc = CoreLib.getTileEntity(iba, x, y, z, ITubeConnectable.class);
        if (itc == null) {
            return 0;
        }
        int trs = 0;
        int col = itc.getTubeConClass();
        int sides = itc.getTubeConnectableSides();
        if ((sides & 1) > 0 && TubeLib.isConSide(iba, x, y - 1, z, col, 1)) {
            trs |= 1;
        }
        if ((sides & 2) > 0 && TubeLib.isConSide(iba, x, y + 1, z, col, 0)) {
            trs |= 2;
        }
        if ((sides & 4) > 0 && TubeLib.isConSide(iba, x, y, z - 1, col, 3)) {
            trs |= 4;
        }
        if ((sides & 8) > 0 && TubeLib.isConSide(iba, x, y, z + 1, col, 2)) {
            trs |= 8;
        }
        if ((sides & 0x10) > 0 && TubeLib.isConSide(iba, x - 1, y, z, col, 5)) {
            trs |= 0x10;
        }
        if ((sides & 0x20) > 0 && TubeLib.isConSide(iba, x + 1, y, z, col, 4)) {
            trs |= 0x20;
        }
        return trs;
    }

    public static int findRoute(World world, WorldCoord wc, TubeItem te, int sides, int state) {
        OutRouteFinder rf = new OutRouteFinder(world, te, state);
        return rf.find(wc, sides);
    }

    public static int findRoute(World world, WorldCoord wc, TubeItem te, int sides, int state, int start) {
        OutRouteFinder rf = new OutRouteFinder(world, te, state);
        rf.startDir = start;
        return rf.find(wc, sides);
    }

    public static boolean addToTubeRoute(World world, ItemStack ist, WorldCoord src, WorldCoord wc, int side) {
        return TubeLib.addToTubeRoute(world, new TubeItem(0, ist), src, wc, side);
    }

    public static boolean addToTubeRoute(World world, TubeItem ti, WorldCoord src, WorldCoord wc, int side) {
        ITubeConnectable ite = CoreLib.getTileEntity((IBlockAccess)world, wc, ITubeConnectable.class);
        if (ite == null) {
            return false;
        }
        ti.mode = 1;
        int s = TubeLib.findRoute(world, src, ti, 1 << (side ^ 1), 1);
        return s >= 0 && ite.tubeItemEnter(side, 0, ti);
    }

    static {
        TubeLib.addCompatibleMapping(0, 17);
        TubeLib.addCompatibleMapping(17, 18);
        for (int i = 0; i < 16; ++i) {
            TubeLib.addCompatibleMapping(0, 1 + i);
            TubeLib.addCompatibleMapping(17, 1 + i);
            TubeLib.addCompatibleMapping(17, 19 + i);
            TubeLib.addCompatibleMapping(18, 19 + i);
        }
    }

    private static class WorldRoute
    implements Comparable<WorldRoute> {
        public WorldCoord wc;
        public int start;
        public int side;
        public int weight;
        public boolean solved = false;

        public WorldRoute(WorldCoord w, int st, int s, int wt) {
            this.wc = w;
            this.start = st;
            this.side = s;
            this.weight = wt;
        }

        @Override
        public int compareTo(WorldRoute wr) {
            return this.weight - wr.weight;
        }
    }

    private static class RouteFinder {
        int startDir = 0;
        WorldRoute result;
        World worldObj;
        Set<WorldCoord> scanmap = new HashSet<WorldCoord>();
        PriorityQueue<WorldRoute> scanpos = new PriorityQueue();

        public RouteFinder(World world) {
            this.worldObj = world;
        }

        public void addPoint(WorldCoord wc, int start, int side, int weight) {
            ITubeConnectable itc = CoreLib.getTileEntity((IBlockAccess)this.worldObj, wc, ITubeConnectable.class);
            if (itc != null && itc.canRouteItems() && !this.scanmap.contains(wc)) {
                this.scanmap.add(wc);
                this.scanpos.add(new WorldRoute(wc, start, side ^ 1, weight));
            }
        }

        public int find(WorldCoord wc, int sides) {
            for (int wr = 0; wr < 6; ++wr) {
                if ((sides & 1 << wr) == 0) continue;
                WorldCoord cons = wc.copy();
                cons.step(wr);
                this.addPoint(cons, wr, wr, wr == this.startDir ? 0 : 1);
            }
            while (this.scanpos.size() > 0) {
                WorldRoute route = this.scanpos.poll();
                if (route.solved) {
                    this.result = route;
                    return route.start;
                }
                int cons = TubeLib.getConnections((IBlockAccess)this.worldObj, route.wc.x, route.wc.y, route.wc.z);
                for (int side = 0; side < 6; ++side) {
                    if (side == route.side || (cons & 1 << side) == 0) continue;
                    WorldCoord wcp = route.wc.copy();
                    wcp.step(side);
                    this.addPoint(wcp, route.start, side, route.weight + 2);
                }
            }
            return -1;
        }

        public WorldCoord getResultPoint() {
            return this.result.wc;
        }
    }

    public static class RequestRouteFinder
    extends RouteFinder {
        TubeItem tubeItem;

        public RequestRouteFinder(World world, TubeItem item) {
            super(world);
            this.tubeItem = item;
        }

        @Override
        public void addPoint(WorldCoord wc, int st, int side, int weight) {
            ITubeRequest itr = CoreLib.getTileEntity((IBlockAccess)this.worldObj, wc, ITubeRequest.class);
            if (itr != null) {
                if (itr.requestTubeItem(this.tubeItem, false)) {
                    WorldRoute itc1 = new WorldRoute(wc, 0, side, weight);
                    itc1.solved = true;
                    this.scanpos.add(itc1);
                }
            } else {
                int side1;
                ITubeConnectable itc = CoreLib.getTileEntity((IBlockAccess)this.worldObj, wc, ITubeConnectable.class);
                if (itc != null && itc.tubeItemCanEnter(side1 = (side ^ 1) & 0xFF, 0, this.tubeItem) && itc.canRouteItems() && !this.scanmap.contains(wc)) {
                    this.scanmap.add(wc);
                    this.scanpos.add(new WorldRoute(wc, st, side1, weight + itc.tubeWeight(side1, 0)));
                }
            }
        }
    }

    private static class OutRouteFinder
    extends RouteFinder {
        int state;
        TubeItem tubeItem;

        public OutRouteFinder(World world, TubeItem ti, int st) {
            super(world);
            this.state = st;
            this.tubeItem = ti;
        }

        @Override
        public void addPoint(WorldCoord wc, int start, int side, int weight) {
            int opside = (side ^ 1) & 0xFF;
            if (this.state != 3 && this.tubeItem.priority == 0 && MachineLib.canAddToInventory(this.worldObj, this.tubeItem.item, wc, opside)) {
                WorldRoute route = new WorldRoute(wc, start, side, weight);
                route.solved = true;
                this.scanpos.add(route);
            } else {
                ITubeConnectable itc = CoreLib.getTileEntity((IBlockAccess)this.worldObj, wc, ITubeConnectable.class);
                if (itc != null) {
                    if (itc.tubeItemCanEnter(opside, this.state, this.tubeItem)) {
                        WorldRoute route = new WorldRoute(wc, start, opside, weight + itc.tubeWeight(opside, this.state));
                        route.solved = true;
                        this.scanpos.add(route);
                    } else if (itc.tubeItemCanEnter(opside, 0, this.tubeItem) && itc.canRouteItems() && !this.scanmap.contains(wc)) {
                        this.scanmap.add(wc);
                        this.scanpos.add(new WorldRoute(wc, start, opside, weight + itc.tubeWeight(opside, this.state)));
                    }
                }
            }
        }
    }

    public static class InRouteFinder
    extends RouteFinder {
        MachineLib.FilterMap filterMap;
        int subFilt = -1;

        public InRouteFinder(World world, MachineLib.FilterMap map) {
            super(world);
            this.filterMap = map;
        }

        @Override
        public void addPoint(WorldCoord wc, int st, int side, int weight) {
            IInventory inv = MachineLib.getInventory(this.worldObj, wc);
            if (inv == null) {
                super.addPoint(wc, st, side, weight);
            } else {
                int[] slots;
                int opside = (side ^ 1) & 0x3F;
                if (inv instanceof ISidedInventory) {
                    ISidedInventory sm = (ISidedInventory)inv;
                    slots = sm.func_94128_d(opside);
                } else {
                    slots = IntStream.range(0, inv.func_70302_i_()).toArray();
                }
                if (this.filterMap.size() == 0) {
                    if (!MachineLib.emptyInventory(inv, slots)) {
                        WorldRoute sm2 = new WorldRoute(wc, 0, opside, weight);
                        sm2.solved = true;
                        this.scanpos.add(sm2);
                    } else {
                        super.addPoint(wc, st, side, weight);
                    }
                } else {
                    int sm1 = -1;
                    if (this.subFilt < 0) {
                        sm1 = MachineLib.matchAnyStack(this.filterMap, inv, slots);
                    } else if (MachineLib.matchOneStack(this.filterMap, inv, slots, this.subFilt)) {
                        sm1 = this.subFilt;
                    }
                    if (sm1 < 0) {
                        super.addPoint(wc, st, side, weight);
                    } else {
                        WorldRoute nr = new WorldRoute(wc, sm1, opside, weight);
                        nr.solved = true;
                        this.scanpos.add(nr);
                    }
                }
            }
        }

        public void setSubFilt(int sf) {
            this.subFilt = sf;
        }

        public int getResultSide() {
            return this.result.side;
        }
    }
}

