/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.lighting;

import com.eloraam.redpower.RedPowerLighting;
import com.eloraam.redpower.core.RenderContext;
import com.eloraam.redpower.core.RenderCustomBlock;
import com.eloraam.redpower.lighting.BlockLamp;
import com.eloraam.redpower.lighting.TileLamp;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderLamp
extends RenderCustomBlock {
    static int[] lightColors = new int[]{0xFFFFFF, 12608256, 11868853, 7308529, 0xBFBF00, 7074048, 15812213, 0x535353, 0x939393, 34695, 6160576, 1250240, 5187328, 558848, 10620678, 0x1F1F1F};
    static int[] lightColorsOff = new int[16];
    private RenderContext context = new RenderContext();

    public RenderLamp(BlockLamp block) {
        super((Block)block);
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTicks) {
        TileLamp lamp = (TileLamp)tile;
        World world = tile.func_145831_w();
        GL11.glDisable((int)2896);
        boolean lit = lamp.Powered != lamp.Inverted;
        Tessellator tess = Tessellator.field_78398_a;
        this.context.bindBlockTexture();
        this.context.setDefaults();
        this.context.setPos(x, y, z);
        this.context.readGlobalLights((IBlockAccess)world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        if (MinecraftForgeClient.getRenderPass() == 0) {
            this.context.setSize(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            this.context.setupBox();
            this.context.transform();
            this.context.setIcon(lit ? RedPowerLighting.lampOn[lamp.Color] : RedPowerLighting.lampOff[lamp.Color]);
            tess.func_78382_b();
            this.context.renderGlobFaces(63);
            tess.func_78381_a();
        }
        if (MinecraftForgeClient.getRenderPass() == 1 && lit) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3008);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glDisable((int)2884);
            this.context.setPos(x, y, z);
            this.context.setTintHex(lightColors[lamp.Color]);
            this.context.setLocalLights(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            this.context.setSize(-0.05, -0.05, -0.05, 1.05, 1.05, 1.05);
            this.context.setupBox();
            this.context.transform();
            this.context.setSize(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            this.context.doMappingBox(0);
            this.context.doLightLocal(63);
            tess.func_78382_b();
            this.context.renderAlpha(63, 0.5f);
            tess.func_78381_a();
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
        }
        GL11.glEnable((int)2896);
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        int meta = item.func_77960_j();
        this.block.func_149683_g();
        this.context.setDefaults();
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.context.setPos(-0.5, -0.5, -0.5);
        } else {
            this.context.setPos(0.0, 0.0, 0.0);
        }
        this.context.useNormal = true;
        boolean lit = (meta & 0x10) > 0;
        Tessellator tess = Tessellator.field_78398_a;
        this.context.setIcon(lit ? RedPowerLighting.lampOn[meta & 0xF] : RedPowerLighting.lampOff[meta & 0xF]);
        tess.func_78382_b();
        this.context.renderBox(63, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        tess.func_78381_a();
        this.context.useNormal = false;
        if (lit) {
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            this.context.setTintHex(lightColors[meta & 0xF]);
            this.context.setLocalLights(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            this.context.setSize(-0.05, -0.05, -0.05, 1.05, 1.05, 1.05);
            this.context.setupBox();
            this.context.transform();
            this.context.setSize(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            this.context.doMappingBox(0);
            this.context.doLightLocal(63);
            tess.func_78382_b();
            this.context.renderAlpha(63, 0.5f);
            tess.func_78381_a();
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
            GL11.glBlendFunc((int)770, (int)771);
        }
    }

    @Override
    public IIcon getParticleIconForSide(World world, int x, int y, int z, TileEntity tile, int side, int meta) {
        if (tile instanceof TileLamp) {
            TileLamp lamp = (TileLamp)tile;
            return lamp.Powered != lamp.Inverted ? RedPowerLighting.lampOn[lamp.Color] : RedPowerLighting.lampOff[lamp.Color];
        }
        return super.getParticleIconForSide(world, x, y, z, tile, side, meta);
    }

    static {
        for (int i = 0; i < 16; ++i) {
            int r = lightColors[i] & 0xFF;
            int g = lightColors[i] >> 8 & 0xFF;
            int b = lightColors[i] >> 16 & 0xFF;
            int v = (r + g + b) / 3;
            r = (r + 2 * v) / 5;
            g = (g + 2 * v) / 5;
            b = (b + 2 * v) / 5;
            RenderLamp.lightColorsOff[i] = r | g << 8 | b << 16;
        }
    }
}

