/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.lighting;

import com.eloraam.redpower.RedPowerLighting;
import com.eloraam.redpower.core.RenderContext;
import com.eloraam.redpower.core.RenderCustomBlock;
import com.eloraam.redpower.core.RenderModel;
import com.eloraam.redpower.lighting.BlockShapedLamp;
import com.eloraam.redpower.lighting.RenderLamp;
import com.eloraam.redpower.lighting.TileShapedLamp;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderShapedLamp
extends RenderCustomBlock {
    private RenderContext context = new RenderContext();
    private RenderModel modelLamp1 = RenderModel.loadModel("rplighting:models/shlamp1.obj");
    private RenderModel modelLamp2 = RenderModel.loadModel("rplighting:models/shlamp2.obj");
    private ResourceLocation lampRes = new ResourceLocation("rplighting", "models/shlamp.png");

    public RenderShapedLamp(BlockShapedLamp lamp) {
        super((Block)lamp);
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTicks) {
        TileShapedLamp shapedLamp = (TileShapedLamp)tile;
        World world = shapedLamp.func_145831_w();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        Tessellator tess = Tessellator.field_78398_a;
        boolean lit = shapedLamp.Powered != shapedLamp.Inverted;
        this.context.setDefaults();
        this.context.setPos(x, y, z);
        this.context.setOrientation(shapedLamp.Rotation, 0);
        this.context.readGlobalLights((IBlockAccess)world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        switch (shapedLamp.Style) {
            case 0: {
                this.context.bindModelOffset(this.modelLamp1, 0.5, 0.5, 0.5);
                break;
            }
            case 1: {
                this.context.bindModelOffset(this.modelLamp2, 0.5, 0.5, 0.5);
            }
        }
        this.context.bindTexture(this.lampRes);
        this.context.setBrightness(this.getMixedBrightness(tile));
        if (MinecraftForgeClient.getRenderPass() == 0) {
            tess.func_78382_b();
            this.context.renderModelGroup(0, 0);
            if (lit) {
                this.context.setTintHex(RenderLamp.lightColors[shapedLamp.Color & 0xF]);
                this.context.setBrightness(0xF000F0);
            } else {
                this.context.setTintHex(RenderLamp.lightColorsOff[shapedLamp.Color & 0xF]);
            }
            this.context.renderModelGroup(1, 0);
            tess.func_78381_a();
        }
        if (MinecraftForgeClient.getRenderPass() == 1 && lit) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glDisable((int)2884);
            this.context.setTintHex(RenderLamp.lightColors[shapedLamp.Color & 0xF]);
            this.context.setAlpha(0.3f);
            tess.func_78382_b();
            this.context.renderModelGroup(2, 0);
            tess.func_78381_a();
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
        }
        GL11.glEnable((int)2896);
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        int meta = item.func_77960_j();
        Tessellator tess = Tessellator.field_78398_a;
        this.block.func_149683_g();
        this.context.setDefaults();
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.context.setPos(-0.5, -0.5, -0.5);
        } else {
            this.context.setPos(0.0, 0.0, 0.0);
        }
        this.context.bindTexture(this.lampRes);
        tess.func_78382_b();
        this.context.useNormal = true;
        switch (meta >> 5) {
            case 0: {
                this.context.bindModelOffset(this.modelLamp1, 0.5, 0.5, 0.5);
                break;
            }
            case 1: {
                this.context.bindModelOffset(this.modelLamp2, 0.5, 0.5, 0.5);
            }
        }
        this.context.renderModelGroup(0, 0);
        if ((meta & 0x10) > 0) {
            this.context.setTintHex(RenderLamp.lightColors[meta & 0xF]);
        } else {
            this.context.setTintHex(RenderLamp.lightColorsOff[meta & 0xF]);
        }
        this.context.renderModelGroup(1, 0);
        this.context.useNormal = false;
        tess.func_78381_a();
        if ((meta & 0x10) > 0) {
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            this.context.setTintHex(RenderLamp.lightColors[meta & 0xF]);
            this.context.setAlpha(0.3f);
            tess.func_78382_b();
            this.context.renderModelGroup(2, 0);
            tess.func_78381_a();
            GL11.glDisable((int)3008);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3553);
            GL11.glBlendFunc((int)770, (int)771);
        }
    }

    @Override
    public IIcon getParticleIconForSide(World world, int x, int y, int z, TileEntity tile, int side, int meta) {
        if (tile instanceof TileShapedLamp) {
            TileShapedLamp lamp = (TileShapedLamp)tile;
            return lamp.Powered != lamp.Inverted ? RedPowerLighting.lampOn[lamp.Color] : RedPowerLighting.lampOff[lamp.Color];
        }
        return super.getParticleIconForSide(world, x, y, z, tile, side, meta);
    }

    @Override
    public int getParticleColorForSide(World world, int x, int y, int z, TileEntity tile, int side, int meta) {
        if (tile instanceof TileShapedLamp) {
            TileShapedLamp lamp = (TileShapedLamp)tile;
            return (lamp.Powered != lamp.Inverted ? RenderLamp.lightColors : RenderLamp.lightColorsOff)[lamp.Color];
        }
        return super.getParticleColorForSide(world, x, y, z, tile, side, meta);
    }
}

