/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.lighting;

import com.eloraam.redpower.RedPowerLighting;
import com.eloraam.redpower.core.IConnectable;
import com.eloraam.redpower.core.IFrameSupport;
import com.eloraam.redpower.core.RedPowerLib;
import com.eloraam.redpower.core.TileExtended;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;

public class TileShapedLamp
extends TileExtended
implements IFrameSupport,
IConnectable {
    public int Rotation = 0;
    public boolean Powered = false;
    public boolean Inverted = false;
    public int Style = 0;
    public int Color = 0;

    private void updateLight() {
        this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public int getConnectableMask() {
        return 0x1000000 << this.Rotation | 15 << (this.Rotation << 2);
    }

    @Override
    public int getConnectClass(int side) {
        return 1;
    }

    @Override
    public int getCornerPowerMode() {
        return 0;
    }

    @Override
    public void onBlockPlaced(ItemStack ist, int side, EntityLivingBase ent) {
        this.Rotation = side ^ 1;
        this.onBlockNeighborChange(Blocks.field_150350_a);
        this.Inverted = (ist.func_77960_j() & 0x10) > 0;
        this.Color = ist.func_77960_j() & 0xF;
        this.Style = (ist.func_77960_j() & 0x3FF) >> 5;
        if (ent instanceof EntityPlayer) {
            this.Owner = ((EntityPlayer)ent).func_146103_bH();
        }
    }

    public Block func_145838_q() {
        return RedPowerLighting.blockShapedLamp;
    }

    @Override
    public int getExtendedID() {
        return 0;
    }

    @Override
    public void onBlockNeighborChange(Block block) {
        int mask = this.getConnectableMask();
        if (RedPowerLib.isPowered((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, mask & 0xFFFFFF, mask >> 24)) {
            if (this.Powered) {
                return;
            }
            this.Powered = true;
            this.updateLight();
            this.updateBlock();
        } else {
            if (!this.Powered) {
                return;
            }
            this.Powered = false;
            this.updateLight();
            this.updateBlock();
        }
    }

    public int getLightValue() {
        return this.Powered != this.Inverted ? 15 : 0;
    }

    @Override
    public void addHarvestContents(List<ItemStack> ist) {
        ItemStack is = new ItemStack(this.func_145838_q(), 1, (this.Style << 5) + (this.Inverted ? 16 : 0) + this.Color);
        ist.add(is);
    }

    @Override
    public void writeFramePacket(NBTTagCompound tag) {
        int ps = (this.Powered ? 1 : 0) | (this.Inverted ? 2 : 0);
        tag.func_74774_a("ps", (byte)ps);
        tag.func_74774_a("rot", (byte)this.Rotation);
        tag.func_74774_a("color", (byte)this.Color);
        tag.func_74774_a("style", (byte)this.Style);
    }

    @Override
    public void readFramePacket(NBTTagCompound tag) {
        byte ps = tag.func_74771_c("ps");
        this.Rotation = tag.func_74771_c("rot");
        this.Powered = (ps & 1) > 0;
        this.Inverted = (ps & 2) > 0;
        this.Color = tag.func_74771_c("color");
        this.Style = tag.func_74771_c("style");
    }

    @Override
    public void onFrameRefresh(IBlockAccess iba) {
    }

    @Override
    public void onFramePickup(IBlockAccess iba) {
    }

    @Override
    public void onFrameDrop() {
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        byte ps = data.func_74771_c("ps");
        this.Rotation = data.func_74771_c("rot");
        this.Powered = (ps & 1) > 0;
        this.Inverted = (ps & 2) > 0;
        this.Color = data.func_74771_c("color");
        this.Style = data.func_74771_c("style");
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        int ps = (this.Powered ? 1 : 0) | (this.Inverted ? 2 : 0);
        data.func_74774_a("ps", (byte)ps);
        data.func_74774_a("rot", (byte)this.Rotation);
        data.func_74774_a("color", (byte)this.Color);
        data.func_74774_a("style", (byte)this.Style);
    }

    @Override
    protected void readFromPacket(NBTTagCompound tag) {
        byte ps = tag.func_74771_c("ps");
        this.Rotation = tag.func_74771_c("rot");
        this.Powered = (ps & 1) > 0;
        this.Inverted = (ps & 2) > 0;
        this.Color = tag.func_74771_c("color");
        this.Style = tag.func_74771_c("style");
        this.updateBlock();
        this.updateLight();
    }

    @Override
    protected void writeToPacket(NBTTagCompound tag) {
        int ps = (this.Powered ? 1 : 0) | (this.Inverted ? 2 : 0);
        tag.func_74774_a("ps", (byte)ps);
        tag.func_74774_a("rot", (byte)this.Rotation);
        tag.func_74774_a("color", (byte)this.Color);
        tag.func_74774_a("style", (byte)this.Style);
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }
}

