/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.logic;

import com.eloraam.redpower.RedPowerLogic;
import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.RenderCovers;
import com.eloraam.redpower.core.Vector3;
import com.eloraam.redpower.logic.TileLogic;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class RenderLogic
extends RenderCovers {
    public RenderLogic(Block block) {
        super(block);
    }

    public void renderCovers(IBlockAccess iba, TileLogic tileLogic) {
        if (tileLogic.Cover != 255) {
            this.context.readGlobalLights(iba, tileLogic.field_145851_c, tileLogic.field_145848_d, tileLogic.field_145849_e);
            this.renderCover(tileLogic.Rotation, tileLogic.Cover);
        }
    }

    public TileLogic getTileEntity(IBlockAccess iba, int i, int j, int k) {
        TileEntity te = iba.func_147438_o(i, j, k);
        return !(te instanceof TileLogic) ? null : (TileLogic)te;
    }

    public void setMatrixDisplayTick(int i, int j, int k, int rot, Random random) {
        float x = (float)i + 0.5f + (random.nextFloat() - 0.5f) * 0.2f;
        float y = (float)j + 0.7f + (random.nextFloat() - 0.5f) * 0.2f;
        float z = (float)k + 0.5f + (random.nextFloat() - 0.5f) * 0.2f;
        this.context.setOrientation(0, rot);
        this.context.setPos(x, y, z);
    }

    public void setMatrixInv(IItemRenderer.ItemRenderType type) {
        this.context.setOrientation(0, 3);
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.context.setPos(-0.5, -0.5, -0.5);
        } else {
            this.context.setPos(0.0, 0.0, 0.0);
        }
    }

    public void renderWafer(int tx) {
        IIcon[] icons;
        switch (tx >> 8) {
            case 1: {
                icons = RedPowerLogic.logicTwo;
                break;
            }
            case 2: {
                icons = RedPowerLogic.logicSensor;
                break;
            }
            default: {
                icons = RedPowerLogic.logicOne;
            }
        }
        this.context.setRelPos(0.0, 0.0, 0.0);
        this.context.setTint(1.0f, 1.0f, 1.0f);
        this.context.setTexFlags(0);
        this.context.setSize(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
        this.context.setIcon(icons[0], icons[tx & 0xFF], icons[0], icons[0], icons[0], icons[0]);
        this.context.calcBounds();
        this.context.setLocalLights(0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f);
        this.context.renderFaces(62);
    }

    public void renderInvWafer(int tx) {
        IIcon[] icons;
        this.context.useNormal = true;
        switch (tx >> 8) {
            case 1: {
                icons = RedPowerLogic.logicTwo;
                break;
            }
            case 2: {
                icons = RedPowerLogic.logicSensor;
                break;
            }
            default: {
                icons = RedPowerLogic.logicOne;
            }
        }
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        this.context.setTint(1.0f, 1.0f, 1.0f);
        this.context.setTexFlags(0);
        this.context.setSize(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
        this.context.setIcon(icons[0], icons[tx & 0xFF], icons[0], icons[0], icons[0], icons[0]);
        this.context.calcBounds();
        this.context.setLocalLights(0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f);
        this.context.renderFaces(63);
        tess.func_78381_a();
        this.context.useNormal = false;
    }

    public void renderCover(int rot, int cov) {
        if (cov != 255) {
            rot >>= 2;
            short[] rs = new short[]{0, 0, 0, 0, 0, 0};
            rs[rot ^= 1] = (short)cov;
            this.context.setTint(1.0f, 1.0f, 1.0f);
            this.renderCovers(1 << rot, rs);
        }
    }

    public void renderRedstoneTorch(double x, double y, double z, double h, boolean state) {
        this.context.setTexFlags(0);
        this.context.setRelPos(x, y, z);
        this.context.setIcon(state ? RedPowerLogic.torchOn : RedPowerLogic.torch);
        this.context.setLocalLights(1.0f);
        this.context.setTint(1.0f, 1.0f, 1.0f);
        this.context.setSize(0.4375, 1.0 - h, 0.0, 0.5625, 1.0, 1.0);
        this.context.calcBounds();
        this.context.renderFaces(48);
        this.context.setSize(0.0, 1.0 - h, 0.4375, 1.0, 1.0, 0.5625);
        this.context.calcBounds();
        this.context.renderFaces(12);
        this.context.setSize(0.375, 0.0, 0.4375, 0.5, 1.0, 0.5625);
        this.context.setRelPos(x + 0.0625, y - 0.375, z);
        this.context.calcBounds();
        this.context.setTexFlags(24);
        this.context.renderFaces(2);
        this.context.setRelPos(0.0, 0.0, 0.0);
    }

    public void renderTorchPuff(World world, String name, double x, double y, double z) {
        Vector3 v = new Vector3(x, y, z);
        this.context.basis.rotate(v);
        v.add(this.context.globalOrigin);
        world.func_72869_a(name, v.x, v.y, v.z, 0.0, 0.0, 0.0);
    }

    public void renderChip(double x, double y, double z, int tex) {
        this.context.setTexFlags(0);
        this.context.setRelPos(x, y, z);
        this.context.setIcon(RedPowerLogic.logicOne[tex]);
        this.context.setLocalLights(0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f);
        this.context.renderBox(62, 0.375, 0.0625, 0.375, 0.625, 0.1875, 0.625);
    }

    protected int getTorchState(TileLogic tileLogic) {
        return 0;
    }

    protected int getInvTorchState(int metadata) {
        return 0;
    }

    protected TorchPos[] getTorchVectors(TileLogic tileLogic) {
        return null;
    }

    protected TorchPos[] getInvTorchVectors(int metadata) {
        return null;
    }

    protected void renderWorldPart(IBlockAccess iba, TileLogic tileLogic, double x, double y, double z, float partialTicks) {
    }

    protected void renderInvPart(int metadata) {
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random random) {
        int ts;
        TileLogic logic = CoreLib.getTileEntity((IBlockAccess)world, x, y, z, TileLogic.class);
        if (logic != null && (ts = this.getTorchState(logic)) != 0) {
            int rv;
            this.setMatrixDisplayTick(x, y, z, logic.Rotation, random);
            TorchPos[] tpv = this.getTorchVectors(logic);
            if (tpv != null && (ts & 1 << (rv = random.nextInt(tpv.length))) != 0) {
                this.renderTorchPuff(world, "reddust", tpv[rv].x, tpv[rv].y, tpv[rv].z);
            }
        }
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTicks) {
        TileLogic logic = (TileLogic)tile;
        World world = logic.func_145831_w();
        GL11.glDisable((int)2896);
        Tessellator tess = Tessellator.field_78398_a;
        this.context.bindBlockTexture();
        this.context.setDefaults();
        this.context.setPos(x, y, z);
        tess.func_78382_b();
        this.renderCovers((IBlockAccess)world, logic);
        tess.func_78381_a();
        this.context.setBrightness(this.getMixedBrightness(logic));
        this.context.setOrientation(logic.Rotation >> 2, logic.Rotation & 3);
        this.context.setPos(x, y, z);
        tess.func_78382_b();
        this.renderWorldPart((IBlockAccess)world, logic, x, y, z, partialTicks);
        tess.func_78381_a();
        this.context.bindBlockTexture();
        int ts = this.getTorchState(logic);
        TorchPos[] tpv = this.getTorchVectors(logic);
        if (tpv != null) {
            tess.func_78382_b();
            for (int n = 0; n < tpv.length; ++n) {
                this.renderRedstoneTorch(tpv[n].x, tpv[n].y, tpv[n].z, tpv[n].h, (ts & 1 << n) > 0);
            }
            tess.func_78381_a();
        }
        GL11.glEnable((int)2896);
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        int meta = item.func_77960_j();
        this.block.func_149683_g();
        this.context.setDefaults();
        this.setMatrixInv(type);
        this.renderInvPart(meta);
        GL11.glDisable((int)2896);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        int ts = this.getInvTorchState(meta);
        TorchPos[] tpv = this.getInvTorchVectors(meta);
        if (tpv != null) {
            for (int n = 0; n < tpv.length; ++n) {
                this.renderRedstoneTorch(tpv[n].x, tpv[n].y, tpv[n].z, tpv[n].h, (ts & 1 << n) > 0);
            }
        }
        tess.func_78381_a();
        GL11.glEnable((int)2896);
    }

    @Override
    protected IIcon getParticleIconForSide(World world, int x, int y, int z, TileEntity tile, int side, int meta) {
        return Blocks.field_150333_U.func_149691_a(0, 0);
    }

    public static class TorchPos {
        double x;
        double y;
        double z;
        double h;

        public TorchPos(double x, double y, double z, double h) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.h = h;
        }
    }
}

