/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.logic;

import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.RedPowerLib;
import com.eloraam.redpower.core.RenderModel;
import com.eloraam.redpower.core.WorldCoord;
import com.eloraam.redpower.logic.RenderLogic;
import com.eloraam.redpower.logic.TileLogic;
import com.eloraam.redpower.logic.TileLogicArray;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;

@SideOnly(value=Side.CLIENT)
public class RenderLogicArray
extends RenderLogic {
    private RenderModel model = RenderModel.loadModel("rplogic:models/arraycells.obj");
    private ResourceLocation modelRes = new ResourceLocation("rplogic", "models/arraytex.png");
    private static RenderLogic.TorchPos[] torchMapInvert = new RenderLogic.TorchPos[]{new RenderLogic.TorchPos(0.0, -0.25, 0.0, 0.7)};
    private static RenderLogic.TorchPos[] torchMapNonInv = new RenderLogic.TorchPos[]{new RenderLogic.TorchPos(0.0, -0.25, 0.0, 0.7), new RenderLogic.TorchPos(-0.188, -0.25, 0.219, 0.7)};

    public RenderLogicArray(Block block) {
        super(block);
    }

    @Override
    protected int getTorchState(TileLogic tileLogic) {
        int md = tileLogic.getExtendedMetadata();
        switch (md) {
            case 1: {
                return tileLogic.Powered ? 1 : 0;
            }
            case 2: {
                return tileLogic.Powered ? 1 : 2;
            }
        }
        return 0;
    }

    @Override
    protected int getInvTorchState(int metadata) {
        return metadata == 514 ? 2 : 0;
    }

    @Override
    protected RenderLogic.TorchPos[] getTorchVectors(TileLogic tileLogic) {
        int md = tileLogic.getExtendedMetadata();
        switch (md) {
            case 1: {
                return torchMapInvert;
            }
            case 2: {
                return torchMapNonInv;
            }
        }
        return null;
    }

    @Override
    protected RenderLogic.TorchPos[] getInvTorchVectors(int metadata) {
        switch (metadata) {
            case 513: {
                return torchMapInvert;
            }
            case 514: {
                return torchMapNonInv;
            }
        }
        return null;
    }

    public static int getFacingDir(int rot, int rel) {
        int n;
        switch (rot >> 2) {
            case 0: {
                n = 13604;
                break;
            }
            case 1: {
                n = 13349;
                break;
            }
            case 2: {
                n = 20800;
                break;
            }
            case 3: {
                n = 16720;
                break;
            }
            case 4: {
                n = 8496;
                break;
            }
            default: {
                n = 12576;
            }
        }
        int n1 = n >> ((rot + rel & 3) << 2);
        return n1 & 7;
    }

    private boolean isArrayTopwire(IBlockAccess iba, WorldCoord wc, int mask, int dir) {
        TileLogicArray logicArray = CoreLib.getTileEntity(iba, wc = wc.coordStep(dir), TileLogicArray.class);
        if (logicArray == null) {
            return false;
        }
        int m = logicArray.getTopwireMask();
        m &= RedPowerLib.getConDirMask(dir);
        m = (m & 0x55555555) << 1 | (m & 0x2AAAAAAA) >> 1;
        return (m &= mask) > 0;
    }

    @Override
    protected void renderWorldPart(IBlockAccess iba, TileLogic tileLogic, double x, double y, double z, float partialTicks) {
        TileLogicArray logicArray = (TileLogicArray)tileLogic;
        Tessellator tess = Tessellator.field_78398_a;
        int md = tileLogic.getExtendedMetadata();
        this.context.bindTexture(this.modelRes);
        tess.func_78381_a();
        tess.func_78382_b();
        this.context.bindModelOffset(this.model, 0.5, 0.5, 0.5);
        this.context.setTint(1.0f, 1.0f, 1.0f);
        this.context.renderModelGroup(0, 0);
        switch (md) {
            case 0: {
                this.context.renderModelGroup(1, 1);
                this.context.setTint(0.3f + 0.7f * ((float)logicArray.PowerVal1 / 255.0f), 0.0f, 0.0f);
                this.context.renderModelGroup(2, 1);
                this.context.setTint(0.3f + 0.7f * ((float)logicArray.PowerVal2 / 255.0f), 0.0f, 0.0f);
                this.context.renderModelGroup(3, 1);
                break;
            }
            case 1: {
                this.context.renderModelGroup(1, 2 + (logicArray.PowerVal1 > 0 ? 1 : 0));
                this.context.renderModelGroup(5, 0);
                this.context.setTint(0.3f + 0.7f * ((float)logicArray.PowerVal1 / 255.0f), 0.0f, 0.0f);
                this.context.renderModelGroup(2, 2);
                this.context.setTint(0.3f + 0.7f * ((float)logicArray.PowerVal2 / 255.0f), 0.0f, 0.0f);
                this.context.renderModelGroup(3, 2);
                break;
            }
            case 2: {
                this.context.renderModelGroup(1, 4 + (logicArray.PowerVal1 > 0 ? 1 : 0) + (logicArray.Powered ? 0 : 2));
                this.context.renderModelGroup(5, 0);
                this.context.setTint(0.3f + 0.7f * ((float)logicArray.PowerVal1 / 255.0f), 0.0f, 0.0f);
                this.context.renderModelGroup(2, 2);
                this.context.setTint(0.3f + 0.7f * ((float)logicArray.PowerVal2 / 255.0f), 0.0f, 0.0f);
                this.context.renderModelGroup(3, 2);
            }
        }
        int fd = RenderLogicArray.getFacingDir(logicArray.Rotation, 1);
        int fm = logicArray.getTopwireMask();
        WorldCoord wc = new WorldCoord(tileLogic);
        this.context.renderModelGroup(4, (this.isArrayTopwire(iba, wc, fm, fd) ? 0 : 1) + (this.isArrayTopwire(iba, wc, fm, fd ^ 1) ? 0 : 2));
        tess.func_78381_a();
        tess.func_78382_b();
    }

    @Override
    protected void renderInvPart(int metadata) {
        Tessellator tess = Tessellator.field_78398_a;
        this.context.bindTexture(this.modelRes);
        tess.func_78382_b();
        this.context.useNormal = true;
        this.context.bindModelOffset(this.model, 0.5, 0.5, 0.5);
        this.context.setTint(1.0f, 1.0f, 1.0f);
        this.context.renderModelGroup(0, 0);
        switch (metadata) {
            case 512: {
                this.context.renderModelGroup(1, 1);
                this.context.setTint(0.3f, 0.0f, 0.0f);
                this.context.renderModelGroup(2, 1);
                this.context.renderModelGroup(3, 1);
                this.context.renderModelGroup(4, 3);
                break;
            }
            case 513: {
                this.context.renderModelGroup(1, 2);
                this.context.renderModelGroup(5, 0);
                this.context.setTint(0.3f, 0.0f, 0.0f);
                this.context.renderModelGroup(2, 2);
                this.context.renderModelGroup(3, 2);
                this.context.renderModelGroup(4, 3);
                break;
            }
            case 514: {
                this.context.renderModelGroup(1, 6);
                this.context.renderModelGroup(5, 0);
                this.context.setTint(0.3f, 0.0f, 0.0f);
                this.context.renderModelGroup(2, 2);
                this.context.renderModelGroup(3, 2);
                this.context.renderModelGroup(4, 3);
            }
        }
        this.context.useNormal = false;
        tess.func_78381_a();
    }
}

