/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.logic;

import com.eloraam.redpower.RedPowerLogic;
import com.eloraam.redpower.core.BlockMultipart;
import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.CoverLib;
import com.eloraam.redpower.core.IFrameSupport;
import com.eloraam.redpower.core.IRedPowerConnectable;
import com.eloraam.redpower.core.IRotatable;
import com.eloraam.redpower.core.RedPowerLib;
import com.eloraam.redpower.core.TileCoverable;
import com.eloraam.redpower.logic.BlockLogic;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;

public class TileLogic
extends TileCoverable
implements IRedPowerConnectable,
IRotatable,
IFrameSupport {
    public int SubId = 0;
    public int Rotation = 0;
    public boolean Powered = false;
    public boolean Disabled = false;
    public boolean Active = false;
    public int PowerState = 0;
    public int Deadmap = 0;
    public int Cover = 255;

    @Override
    public int getPartMaxRotation(int part, boolean sec) {
        return sec ? 0 : (part != this.Rotation >> 2 ? 0 : 3);
    }

    @Override
    public int getPartRotation(int part, boolean sec) {
        return sec ? 0 : (part != this.Rotation >> 2 ? 0 : this.Rotation & 3);
    }

    @Override
    public void setPartRotation(int part, boolean sec, int rot) {
        if (!sec && part == this.Rotation >> 2) {
            this.Rotation = rot & 3 | this.Rotation & 0xFFFFFFFC;
            this.updateBlockChange();
        }
    }

    @Override
    public int getConnectableMask() {
        return 15 << (this.Rotation & 0xFFFFFFFC);
    }

    @Override
    public int getConnectClass(int side) {
        return 0;
    }

    @Override
    public int getCornerPowerMode() {
        return 0;
    }

    @Override
    public int getPoweringMask(int ch) {
        return ch != 0 ? 0 : (this.Powered ? RedPowerLib.mapRotToCon(8, this.Rotation) : 0);
    }

    @Override
    public boolean canAddCover(int side, int cover) {
        return this.Cover == 255 && (side ^ 1) == this.Rotation >> 2 && cover <= 254;
    }

    @Override
    public boolean tryAddCover(int side, int cover) {
        if (!this.canAddCover(side, cover)) {
            return false;
        }
        this.Cover = cover;
        this.updateBlock();
        return true;
    }

    @Override
    public int tryRemoveCover(int side) {
        if (this.Cover == 255) {
            return -1;
        }
        if ((side ^ 1) != this.Rotation >> 2) {
            return -1;
        }
        int tr = this.Cover;
        this.Cover = 255;
        this.updateBlock();
        return tr;
    }

    @Override
    public int getCover(int side) {
        return this.Cover == 255 ? -1 : ((side ^ 1) != this.Rotation >> 2 ? -1 : this.Cover);
    }

    @Override
    public int getCoverMask() {
        return this.Cover == 255 ? 0 : 1 << (this.Rotation >> 2 ^ 1);
    }

    @Override
    public boolean blockEmpty() {
        return false;
    }

    @Override
    public void addHarvestContents(List<ItemStack> drops) {
        super.addHarvestContents(drops);
        drops.add(new ItemStack(this.func_145838_q(), 1, this.getExtendedID() * 256 + this.SubId));
    }

    private void replaceWithCovers(boolean shouldDrop) {
        if (this.Cover != 255) {
            short[] covers = new short[26];
            covers[this.Rotation >> 2 ^ 1] = (short)this.Cover;
            CoverLib.replaceWithCovers(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1 << (this.Rotation >> 2 ^ 1), covers);
            if (shouldDrop) {
                CoreLib.dropItem(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, new ItemStack(this.func_145838_q(), 1, this.getExtendedID() * 256 + this.SubId));
            }
            this.markForUpdate();
        } else {
            this.breakBlock(shouldDrop);
            RedPowerLib.updateIndirectNeighbors(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    public boolean tryDropBlock() {
        if (RedPowerLib.canSupportWire((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.Rotation >> 2)) {
            return false;
        }
        this.replaceWithCovers(true);
        return true;
    }

    @Override
    public void onHarvestPart(EntityPlayer player, int part, boolean willHarvest) {
        if (part == this.Rotation >> 2) {
            this.replaceWithCovers(willHarvest);
        } else {
            super.onHarvestPart(player, part, willHarvest);
        }
    }

    @Override
    public float getPartStrength(EntityPlayer player, int part) {
        BlockLogic bl = RedPowerLogic.blockLogic;
        return part == this.Rotation >> 2 ? player.getBreakSpeed((Block)bl, false, 0) / (bl.getHardness() * 30.0f) : super.getPartStrength(player, part);
    }

    @Override
    public void setPartBounds(BlockMultipart block, int part) {
        if (part != this.Rotation >> 2) {
            super.setPartBounds(block, part);
        } else {
            switch (part) {
                case 0: {
                    block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
                    break;
                }
                case 1: {
                    block.func_149676_a(0.0f, 0.875f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 2: {
                    block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.125f);
                    break;
                }
                case 3: {
                    block.func_149676_a(0.0f, 0.0f, 0.875f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 4: {
                    block.func_149676_a(0.0f, 0.0f, 0.0f, 0.125f, 1.0f, 1.0f);
                    break;
                }
                case 5: {
                    block.func_149676_a(0.875f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        }
    }

    @Override
    public int getPartsMask() {
        int pm = 1 << (this.Rotation >> 2);
        if (this.Cover != 255) {
            pm |= 1 << (this.Rotation >> 2 ^ 1);
        }
        return pm;
    }

    @Override
    public int getSolidPartsMask() {
        return this.getPartsMask();
    }

    @Override
    public boolean isBlockStrongPoweringTo(int l) {
        return (this.getPoweringMask(0) & RedPowerLib.getConDirMask(l ^ 1)) > 0;
    }

    @Override
    public boolean isBlockWeakPoweringTo(int l) {
        return (this.getPoweringMask(0) & RedPowerLib.getConDirMask(l ^ 1)) > 0;
    }

    public Block func_145838_q() {
        return RedPowerLogic.blockLogic;
    }

    @Override
    public int getExtendedMetadata() {
        return this.SubId;
    }

    @Override
    public void setExtendedMetadata(int md) {
        this.SubId = md;
    }

    public void playSound(String name, float f, float f2, boolean always) {
        if (always || RedPowerLogic.soundsEnabled) {
            this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), name, f, f2);
        }
    }

    public void initSubType(int st) {
        this.SubId = st;
        if (!this.field_145850_b.field_72995_K && this.getLightValue() != 9) {
            CoreLib.updateAllLightTypes(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int getLightValue() {
        return 9;
    }

    @Override
    public void writeFramePacket(NBTTagCompound tag) {
        tag.func_74774_a("sid", (byte)this.SubId);
        tag.func_74774_a("rot", (byte)this.Rotation);
        int ps = this.PowerState | (this.Powered ? 16 : 0) | (this.Disabled ? 32 : 0) | (this.Active ? 64 : 0) | (this.Deadmap > 0 ? 128 : 0);
        tag.func_74774_a("ps", (byte)ps);
        if (this.Deadmap > 0) {
            tag.func_74774_a("dm", (byte)this.Deadmap);
        }
        tag.func_74777_a("cov", (short)this.Cover);
    }

    @Override
    public void readFramePacket(NBTTagCompound tag) {
        this.SubId = tag.func_74771_c("sid");
        this.Rotation = tag.func_74771_c("rot");
        byte ps = tag.func_74771_c("ps");
        if (this.field_145850_b.field_72995_K) {
            this.PowerState = ps & 0xF;
            this.Powered = (ps & 0x10) > 0;
            this.Disabled = (ps & 0x20) > 0;
            this.Active = (ps & 0x40) > 0;
        }
        this.Deadmap = (ps & 0x80) > 0 ? (int)tag.func_74771_c("dm") : 0;
        this.Cover = tag.func_74765_d("cov");
    }

    @Override
    public void onFrameRefresh(IBlockAccess iba) {
    }

    @Override
    public void onFramePickup(IBlockAccess iba) {
    }

    @Override
    public void onFrameDrop() {
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.SubId = data.func_74771_c("sid") & 0xFF;
        this.Rotation = data.func_74771_c("rot") & 0xFF;
        int ps = data.func_74771_c("ps") & 0xFF;
        this.Deadmap = data.func_74771_c("dm") & 0xFF;
        this.Cover = data.func_74771_c("cov") & 0xFF;
        this.PowerState = ps & 0xF;
        this.Powered = (ps & 0x10) > 0;
        this.Disabled = (ps & 0x20) > 0;
        this.Active = (ps & 0x40) > 0;
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74774_a("sid", (byte)this.SubId);
        data.func_74774_a("rot", (byte)this.Rotation);
        int ps = this.PowerState | (this.Powered ? 16 : 0) | (this.Disabled ? 32 : 0) | (this.Active ? 64 : 0);
        data.func_74774_a("ps", (byte)ps);
        data.func_74774_a("dm", (byte)this.Deadmap);
        data.func_74774_a("cov", (byte)this.Cover);
    }

    @Override
    protected void readFromPacket(NBTTagCompound tag) {
        this.SubId = tag.func_74771_c("sid");
        this.Rotation = tag.func_74771_c("rot");
        byte ps = tag.func_74771_c("ps");
        if (this.field_145850_b.field_72995_K) {
            this.PowerState = ps & 0xF;
            this.Powered = (ps & 0x10) > 0;
            this.Disabled = (ps & 0x20) > 0;
            this.Active = (ps & 0x40) > 0;
        }
        this.Deadmap = (ps & 0x80) > 0 ? (int)tag.func_74771_c("dm") : 0;
        this.Cover = tag.func_74765_d("cov");
    }

    @Override
    protected void writeToPacket(NBTTagCompound tag) {
        tag.func_74774_a("sid", (byte)this.SubId);
        tag.func_74774_a("rot", (byte)this.Rotation);
        int ps = this.PowerState | (this.Powered ? 16 : 0) | (this.Disabled ? 32 : 0) | (this.Active ? 64 : 0) | (this.Deadmap > 0 ? 128 : 0);
        tag.func_74774_a("ps", (byte)ps);
        if (this.Deadmap > 0) {
            tag.func_74774_a("dm", (byte)this.Deadmap);
        }
        tag.func_74777_a("cov", (short)this.Cover);
    }

    @Override
    protected ItemStack getBasePickStack() {
        return new ItemStack(this.func_145838_q(), 1, this.getExtendedID() * 256 + this.SubId);
    }
}

