/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.logic;

import com.eloraam.redpower.core.BlockMultipart;
import com.eloraam.redpower.core.IRedPowerWiring;
import com.eloraam.redpower.core.RedPowerLib;
import com.eloraam.redpower.logic.TileLogic;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;

public class TileLogicArray
extends TileLogic
implements IRedPowerWiring {
    public short PowerVal1 = 0;
    public short PowerVal2 = 0;

    @Override
    public int getPoweringMask(int ch) {
        if (ch != 0) {
            return 0;
        }
        int tr = 0;
        if (this.PowerVal1 > 0) {
            tr |= RedPowerLib.mapRotToCon(10, this.Rotation);
        }
        if (this.PowerVal2 > 0) {
            tr |= RedPowerLib.mapRotToCon(5, this.Rotation);
        }
        return tr;
    }

    @Override
    public void updateCurrentStrength() {
        this.PowerVal2 = (short)RedPowerLib.updateBlockCurrentStrength(this.field_145850_b, this, this.field_145851_c, this.field_145848_d, this.field_145849_e, RedPowerLib.mapRotToCon(5, this.Rotation), 1);
        this.PowerVal1 = (short)RedPowerLib.updateBlockCurrentStrength(this.field_145850_b, this, this.field_145851_c, this.field_145848_d, this.field_145849_e, RedPowerLib.mapRotToCon(10, this.Rotation), 1);
        this.updateBlock();
    }

    @Override
    public int getCurrentStrength(int cons, int ch) {
        return ch != 0 ? -1 : ((RedPowerLib.mapRotToCon(5, this.Rotation) & cons) > 0 ? (int)this.PowerVal2 : ((RedPowerLib.mapRotToCon(10, this.Rotation) & cons) > 0 ? (int)this.PowerVal1 : -1));
    }

    @Override
    public int scanPoweringStrength(int cons, int ch) {
        if (ch != 0) {
            return 0;
        }
        int r1 = RedPowerLib.mapRotToCon(5, this.Rotation);
        int r2 = RedPowerLib.mapRotToCon(10, this.Rotation);
        return (r1 & cons) > 0 ? (this.Powered ? 255 : (RedPowerLib.isPowered((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, r1 & cons, 0) ? 255 : 0)) : ((r2 & cons) > 0 ? (RedPowerLib.isPowered((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, r2 & cons, 0) ? 255 : 0) : 0);
    }

    @Override
    public int getConnectionMask() {
        return RedPowerLib.mapRotToCon(15, this.Rotation);
    }

    @Override
    public int getExtConnectionMask() {
        return 0;
    }

    public int getTopwireMask() {
        return RedPowerLib.mapRotToCon(5, this.Rotation);
    }

    private boolean cellWantsPower() {
        return this.SubId == 1 ? this.PowerState == 0 : this.PowerState != 0;
    }

    private void updatePowerState() {
        int n = this.PowerState = this.PowerVal1 > 0 ? 1 : 0;
        if (this.cellWantsPower() != this.Powered) {
            this.scheduleTick(2);
        }
    }

    @Override
    public int getExtendedID() {
        return 2;
    }

    @Override
    public void onBlockNeighborChange(Block block) {
        if (!this.tryDropBlock()) {
            RedPowerLib.updateCurrent(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.SubId != 0 && !this.isTickRunnable()) {
                this.updatePowerState();
            }
        }
    }

    @Override
    public boolean isBlockStrongPoweringTo(int l) {
        return !RedPowerLib.isSearching() && (this.getPoweringMask(0) & RedPowerLib.getConDirMask(l ^ 1)) > 0;
    }

    @Override
    public boolean isBlockWeakPoweringTo(int l) {
        return !RedPowerLib.isSearching() && (this.getPoweringMask(0) & RedPowerLib.getConDirMask(l ^ 1)) > 0;
    }

    @Override
    public void onTileTick() {
        if (this.Powered != this.cellWantsPower()) {
            this.Powered = !this.Powered;
            this.updateBlockChange();
            this.updatePowerState();
        }
    }

    @Override
    public void setPartBounds(BlockMultipart block, int part) {
        if (part != this.Rotation >> 2) {
            super.setPartBounds(block, part);
        } else {
            switch (part) {
                case 0: {
                    block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
                    break;
                }
                case 1: {
                    block.func_149676_a(0.0f, 0.15f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 2: {
                    block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.75f);
                    break;
                }
                case 3: {
                    block.func_149676_a(0.0f, 0.0f, 0.15f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 4: {
                    block.func_149676_a(0.0f, 0.0f, 0.0f, 0.75f, 1.0f, 1.0f);
                    break;
                }
                case 5: {
                    block.func_149676_a(0.15f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.PowerVal1 = (short)(data.func_74771_c("pv1") & 0xFF);
        this.PowerVal2 = (short)(data.func_74771_c("pv2") & 0xFF);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74774_a("pv1", (byte)this.PowerVal1);
        data.func_74774_a("pv2", (byte)this.PowerVal2);
    }

    @Override
    protected void readFromPacket(NBTTagCompound buffer) {
        this.PowerVal1 = buffer.func_74765_d("pv1");
        this.PowerVal2 = buffer.func_74765_d("pv2");
        super.readFromPacket(buffer);
    }

    @Override
    protected void writeToPacket(NBTTagCompound data) {
        data.func_74777_a("pv1", this.PowerVal1);
        data.func_74777_a("pv2", this.PowerVal2);
        super.writeToPacket(data);
    }
}

