/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.logic;

import com.eloraam.redpower.RedPowerLogic;
import com.eloraam.redpower.core.MathLib;
import com.eloraam.redpower.core.Quat;
import com.eloraam.redpower.core.RedPowerLib;
import com.eloraam.redpower.core.Vector3;
import com.eloraam.redpower.logic.IPointerTile;
import com.eloraam.redpower.logic.TileLogic;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;

public class TileLogicPointer
extends TileLogic
implements IPointerTile {
    private long timestart = 0L;
    public long interval = 40L;

    @Override
    public void initSubType(int st) {
        super.initSubType(st);
        switch (st) {
            case 0: {
                this.interval = 38L;
                break;
            }
            case 2: {
                this.Disabled = true;
            }
        }
    }

    @Override
    public int getPartMaxRotation(int part, boolean sec) {
        return !sec || this.SubId != 1 && this.SubId != 2 ? super.getPartMaxRotation(part, sec) : 1;
    }

    @Override
    public int getPartRotation(int part, boolean sec) {
        return !sec || this.SubId != 1 && this.SubId != 2 ? super.getPartRotation(part, sec) : this.Deadmap;
    }

    @Override
    public void setPartRotation(int part, boolean sec, int rot) {
        if (!sec || this.SubId != 1 && this.SubId != 2) {
            super.setPartRotation(part, sec, rot);
        } else {
            this.Deadmap = rot;
            this.updateBlockChange();
        }
    }

    private void timerChange() {
        int ps = RedPowerLib.getRotPowerState((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 7, this.Rotation, 0);
        if (ps != this.PowerState) {
            this.updateBlock();
        }
        this.PowerState = ps;
        if (this.Powered) {
            if (!this.Disabled) {
                return;
            }
            if (ps > 0) {
                return;
            }
            this.Powered = false;
            this.Disabled = false;
            this.timestart = this.field_145850_b.func_82737_E();
            this.updateBlock();
        } else if (this.Disabled) {
            if (ps > 0) {
                return;
            }
            this.timestart = this.field_145850_b.func_82737_E();
            this.Disabled = false;
            this.updateBlock();
        } else {
            if (ps == 0) {
                return;
            }
            this.Disabled = true;
            this.updateBlock();
        }
    }

    private void timerTick() {
        int ps = RedPowerLib.getRotPowerState((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 7, this.Rotation, 0);
        if (ps != this.PowerState) {
            this.updateBlock();
        }
        this.PowerState = ps;
        if (this.Powered) {
            if (this.Disabled) {
                if (ps > 0) {
                    this.Powered = false;
                    this.updateBlock();
                    return;
                }
                this.Disabled = false;
                this.Powered = false;
                this.timestart = this.field_145850_b.func_82737_E();
                this.updateBlock();
                return;
            }
            if (ps == 0) {
                this.Powered = false;
            } else {
                this.Disabled = true;
                this.scheduleTick(2);
            }
            this.timestart = this.field_145850_b.func_82737_E();
            this.updateBlockChange();
        } else if (this.Disabled) {
            if (ps > 0) {
                return;
            }
            this.timestart = this.field_145850_b.func_82737_E();
            this.Disabled = false;
            this.updateBlock();
        } else {
            if (ps == 0) {
                return;
            }
            this.Disabled = true;
            this.updateBlock();
        }
    }

    private void timerUpdate() {
        if (!(this.field_145850_b.field_72995_K || this.Powered || this.Disabled)) {
            long wt = this.field_145850_b.func_82737_E();
            if (this.interval < 2L) {
                this.interval = 2L;
            }
            if (this.timestart > wt) {
                this.timestart = wt;
            }
            if (this.timestart + this.interval <= wt) {
                this.playSound("random.click", 0.3f, 0.5f, false);
                this.Powered = true;
                this.scheduleTick(2);
                this.updateBlockChange();
            }
        }
    }

    private void sequencerUpdate() {
        long wt = this.field_145850_b.func_82737_E() + 6000L;
        float f = (float)wt / (float)(this.interval * 4L);
        int i = (int)Math.floor(f * 4.0f);
        i = this.Deadmap == 1 ? 3 - i & 3 : i + 3 & 3;
        if (this.PowerState != i && !this.field_145850_b.field_72995_K) {
            this.playSound("random.click", 0.3f, 0.5f, false);
            this.PowerState = i;
            this.updateBlockChange();
        }
    }

    private void stateCellChange() {
        boolean ps3;
        int ps = RedPowerLib.getRotPowerState((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 7, this.Rotation, 0);
        if (ps != this.PowerState) {
            this.updateBlock();
        }
        this.PowerState = ps;
        boolean bl = this.Deadmap == 0 ? (ps & 3) > 0 : (ps3 = (ps & 6) > 0);
        if (this.Disabled && !ps3) {
            this.Disabled = false;
            this.timestart = this.field_145850_b.func_82737_E();
            this.updateBlock();
        } else if (!this.Disabled && ps3) {
            this.Disabled = true;
            this.updateBlock();
        }
        if (!this.Active && !this.Powered && (ps & 2) > 0) {
            this.Powered = true;
            this.updateBlock();
            this.scheduleTick(2);
        }
    }

    private void stateCellTick() {
        if (!this.Active && this.Powered) {
            this.Powered = false;
            this.Active = true;
            this.timestart = this.field_145850_b.func_82737_E();
            this.updateBlockChange();
        } else if (this.Active && this.Powered) {
            this.Powered = false;
            this.Active = false;
            this.updateBlockChange();
        }
    }

    private void stateCellUpdate() {
        if (!this.field_145850_b.field_72995_K && this.Active && !this.Powered && !this.Disabled) {
            long wt = this.field_145850_b.func_82737_E();
            if (this.interval < 2L) {
                this.interval = 2L;
            }
            if (this.timestart > wt) {
                this.timestart = wt;
            }
            if (this.timestart + this.interval <= wt) {
                this.playSound("random.click", 0.3f, 0.5f, false);
                this.Powered = true;
                this.scheduleTick(2);
                this.updateBlockChange();
            }
        }
    }

    @Override
    public void onBlockNeighborChange(Block block) {
        if (!this.tryDropBlock()) {
            switch (this.SubId) {
                case 0: {
                    this.timerChange();
                    break;
                }
                case 2: {
                    this.stateCellChange();
                }
            }
        }
    }

    @Override
    public void onTileTick() {
        switch (this.SubId) {
            case 0: {
                this.timerTick();
                break;
            }
            case 2: {
                this.stateCellTick();
            }
        }
    }

    @Override
    public int getPoweringMask(int ch) {
        if (ch != 0) {
            return 0;
        }
        switch (this.SubId) {
            case 0: {
                if (!this.Disabled && this.Powered) {
                    return RedPowerLib.mapRotToCon(13, this.Rotation);
                }
                return 0;
            }
            case 1: {
                return RedPowerLib.mapRotToCon(1 << this.PowerState, this.Rotation);
            }
            case 2: {
                int ps = (this.Active && this.Powered ? 8 : 0) | (this.Active && !this.Powered ? (this.Deadmap == 0 ? 4 : 1) : 0);
                return RedPowerLib.mapRotToCon(ps, this.Rotation);
            }
        }
        return 0;
    }

    @Override
    public boolean onPartActivateSide(EntityPlayer player, int part, int side) {
        if (part == this.Rotation >> 2 && !player.func_70093_af() && !this.field_145850_b.field_72995_K) {
            player.openGui((Object)RedPowerLogic.instance, 2, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        switch (this.SubId) {
            case 0: {
                this.timerUpdate();
                break;
            }
            case 1: {
                this.sequencerUpdate();
                break;
            }
            case 2: {
                this.stateCellUpdate();
            }
        }
    }

    @Override
    public float getPointerDirection(float partialTicks) {
        if (this.SubId == 0) {
            if (!this.Powered && !this.Disabled) {
                long wt = this.field_145850_b.func_82737_E();
                float ivt = ((float)wt + partialTicks - (float)this.timestart) / (float)this.interval;
                if (ivt > 1.0f) {
                    ivt = 1.0f;
                }
                return ivt + 0.75f;
            }
            return 0.75f;
        }
        if (this.SubId == 1) {
            long wt = this.field_145850_b.func_82737_E() + 6000L;
            float ivt = ((float)wt + partialTicks) / (float)(this.interval * 4L);
            ivt = this.Deadmap == 1 ? 0.75f - ivt : (ivt += 0.75f);
            return ivt;
        }
        if (this.SubId != 2) {
            return 0.0f;
        }
        if (this.Deadmap > 0) {
            if (!this.Active || this.Disabled) {
                return 1.0f;
            }
            if (this.Active && this.Powered) {
                return 0.8f;
            }
        } else {
            if (!this.Active || this.Disabled) {
                return 0.5f;
            }
            if (this.Active && this.Powered) {
                return 0.7f;
            }
        }
        long wt = this.field_145850_b.func_82737_E();
        float ivt = ((float)wt + partialTicks - (float)this.timestart) / (float)this.interval;
        return this.Deadmap > 0 ? 1.0f - 0.2f * ivt : 0.5f + 0.2f * ivt;
    }

    @Override
    public Quat getOrientationBasis() {
        return MathLib.orientQuat(this.Rotation >> 2, this.Rotation & 3);
    }

    public Vector3 getPointerOrigin() {
        return this.SubId == 2 ? (this.Deadmap > 0 ? new Vector3(0.0, -0.1, -0.25) : new Vector3(0.0, -0.1, 0.25)) : new Vector3(0.0, -0.1, 0.0);
    }

    public void setInterval(long iv) {
        this.interval = this.SubId == 0 ? iv - 2L : iv;
    }

    public long getInterval() {
        return this.SubId == 0 ? this.interval + 2L : this.interval;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return !this.func_145837_r() && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    @Override
    public int getExtendedID() {
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.interval = data.func_74763_f("iv");
        if (this.SubId == 0 || this.SubId == 2) {
            this.timestart = data.func_74763_f("ts");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74772_a("iv", this.interval);
        if (this.SubId == 0 || this.SubId == 2) {
            data.func_74772_a("ts", this.timestart);
        }
    }

    @Override
    protected void readFromPacket(NBTTagCompound tag) {
        this.interval = tag.func_74763_f("iv");
        super.readFromPacket(tag);
        if (this.SubId == 0 || this.SubId == 2) {
            this.timestart = tag.func_74763_f("ts");
        }
    }

    @Override
    protected void writeToPacket(NBTTagCompound tag) {
        tag.func_74772_a("iv", this.interval);
        super.writeToPacket(tag);
        if (this.SubId == 0 || this.SubId == 2) {
            tag.func_74772_a("ts", this.timestart);
        }
    }
}

