/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.logic;

import com.eloraam.redpower.core.RedPowerLib;
import com.eloraam.redpower.logic.TileLogic;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;

public class TileLogicSimple
extends TileLogic {
    private static final int[] toDead = new int[]{0, 1, 2, 4, 6, 5, 3};
    private static final int[] fromDead = new int[]{0, 1, 2, 6, 3, 5, 4};
    private static final int[] toDeadNot = new int[]{0, 1, 8, 4, 12, 5, 9};
    private static final int[] fromDeadNot = new int[]{0, 1, 0, 0, 3, 5, 0, 0, 2, 6, 0, 0, 4};
    private static final int[] toDeadBuf = new int[]{0, 1, 4, 5};
    private static final int[] fromDeadBuf = new int[]{0, 1, 0, 0, 2, 3};
    private static int[] tickSchedule = new int[]{2, 4, 6, 8, 16, 32, 64, 128, 256};

    @Override
    public void initSubType(int st) {
        super.initSubType(st);
    }

    @Override
    public int getPartMaxRotation(int part, boolean sec) {
        if (sec) {
            switch (this.SubId) {
                case 0: {
                    return 3;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 9: {
                    return 6;
                }
                default: {
                    break;
                }
                case 10: {
                    return 3;
                }
                case 11: 
                case 15: {
                    return 1;
                }
                case 16: {
                    return 3;
                }
            }
        }
        return super.getPartMaxRotation(part, sec);
    }

    @Override
    public int getPartRotation(int part, boolean sec) {
        if (sec) {
            switch (this.SubId) {
                case 0: {
                    return this.Deadmap;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return fromDead[this.Deadmap];
                }
                default: {
                    break;
                }
                case 9: {
                    return fromDeadNot[this.Deadmap];
                }
                case 10: {
                    return fromDeadBuf[this.Deadmap];
                }
                case 11: 
                case 15: 
                case 16: {
                    return this.Deadmap;
                }
            }
        }
        return super.getPartRotation(part, sec);
    }

    @Override
    public void setPartRotation(int part, boolean sec, int rot) {
        if (sec) {
            switch (this.SubId) {
                case 0: {
                    this.Deadmap = rot;
                    this.PowerState = 0;
                    this.Active = false;
                    this.Powered = false;
                    this.updateBlockChange();
                    return;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.Deadmap = toDead[rot];
                    this.updateBlockChange();
                    return;
                }
                default: {
                    break;
                }
                case 9: {
                    this.Deadmap = toDeadNot[rot];
                    this.updateBlockChange();
                    return;
                }
                case 10: {
                    this.Deadmap = toDeadBuf[rot];
                    this.updateBlockChange();
                    return;
                }
                case 11: 
                case 15: 
                case 16: {
                    this.Deadmap = rot;
                    this.updateBlockChange();
                    return;
                }
            }
        }
        super.setPartRotation(part, sec, rot);
    }

    private void latchUpdatePowerState() {
        if (!this.Disabled || this.Active) {
            int ps = RedPowerLib.getRotPowerState((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, this.Rotation, 0);
            if (ps != this.PowerState) {
                this.updateBlock();
            }
            this.PowerState = ps;
            if (!this.isTickRunnable()) {
                if (this.Active) {
                    this.Disabled = ps == 5;
                } else if (!(ps == 1 && this.Powered || ps == 4 && !this.Powered)) {
                    if (ps == 5) {
                        this.Active = true;
                        this.Disabled = true;
                        this.Powered = !this.Powered;
                        this.scheduleTick(2);
                        this.updateBlockChange();
                    }
                } else {
                    this.Powered = !this.Powered;
                    this.Active = true;
                    this.playSound("random.click", 0.3f, 0.5f, false);
                    this.scheduleTick(2);
                    this.updateBlockChange();
                }
            }
        }
    }

    private void latchTick() {
        if (this.Active) {
            this.Active = false;
            if (this.Disabled) {
                this.updateBlockChange();
                this.scheduleTick(2);
            } else {
                this.updateBlockChange();
            }
        } else if (this.Disabled) {
            int ps = RedPowerLib.getRotPowerState((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, this.Rotation, 0);
            if (ps != this.PowerState) {
                this.updateBlock();
            }
            this.PowerState = ps;
            switch (ps) {
                case 0: {
                    this.Disabled = false;
                    this.Powered = this.field_145850_b.field_73012_v.nextInt(2) == 0;
                    this.updateBlockChange();
                    break;
                }
                case 1: {
                    this.Disabled = false;
                    this.Powered = false;
                    this.updateBlockChange();
                    this.playSound("random.click", 0.3f, 0.5f, false);
                }
                default: {
                    break;
                }
                case 4: {
                    this.Disabled = false;
                    this.Powered = true;
                    this.updateBlockChange();
                    this.playSound("random.click", 0.3f, 0.5f, false);
                    break;
                }
                case 5: {
                    this.scheduleTick(4);
                }
            }
        }
    }

    private int latch2NextState() {
        if ((this.PowerState & 5) == 0) {
            return this.PowerState;
        }
        int ps = this.PowerState & 5 | 0xA;
        if (this.Deadmap == 2) {
            if ((ps & 1) > 0) {
                ps &= 0xFFFFFFF7;
            }
            if ((ps & 4) > 0) {
                ps &= 0xFFFFFFFD;
            }
        } else {
            if ((ps & 1) > 0) {
                ps &= 0xFFFFFFFD;
            }
            if ((ps & 4) > 0) {
                ps &= 0xFFFFFFF7;
            }
        }
        return ps;
    }

    private void latch2UpdatePowerState() {
        int p2;
        int ps = RedPowerLib.getRotPowerState((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, this.Rotation, 0);
        boolean upd = false;
        if (ps != (this.PowerState & 5)) {
            this.PowerState = this.PowerState & 0xA | ps;
            upd = true;
        }
        if ((p2 = this.latch2NextState()) != this.PowerState || (this.PowerState & 5) == 0) {
            this.scheduleTick(2);
            upd = true;
        }
        if (upd) {
            this.updateBlock();
        }
    }

    private void latchChange() {
        if (this.Deadmap < 2) {
            this.latchUpdatePowerState();
        } else {
            if (this.isTickRunnable()) {
                return;
            }
            this.latch2UpdatePowerState();
        }
    }

    private void latch2Tick() {
        int ps;
        boolean upd = false;
        if (this.PowerState == 0) {
            this.PowerState |= this.field_145850_b.field_73012_v.nextInt(2) == 0 ? 1 : 4;
            upd = true;
        }
        if ((ps = this.latch2NextState()) != this.PowerState) {
            this.PowerState = ps;
            upd = true;
        }
        if (upd) {
            this.updateBlockChange();
        }
        this.latch2UpdatePowerState();
    }

    private void pulseChange() {
        int ps;
        if (this.Active) {
            int ps2 = RedPowerLib.getRotPowerState((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, this.Rotation, 0);
            if (ps2 == 0) {
                this.Active = false;
                this.updateBlock();
            }
        } else if (!this.Powered && (ps = RedPowerLib.getRotPowerState((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, this.Rotation, 0)) > 0) {
            this.Powered = true;
            this.updateBlockChange();
            this.scheduleTick(2);
        }
    }

    private void pulseTick() {
        if (this.Powered) {
            this.Powered = false;
            int ps = RedPowerLib.getRotPowerState((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, this.Rotation, 0);
            if (ps > 0) {
                this.Active = true;
            }
            this.updateBlockChange();
        }
    }

    private void toggleUpdatePowerState() {
        int ps = RedPowerLib.getRotPowerState((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, this.Rotation, 0);
        if (ps != this.PowerState) {
            int t = 5 & ps & ~this.PowerState;
            if (t == 1 || t == 4) {
                this.Active = true;
            }
            this.PowerState = ps;
            this.updateBlock();
            if (this.Active) {
                this.scheduleTick(2);
            }
        }
    }

    private void toggleTick() {
        if (this.Active) {
            this.playSound("random.click", 0.3f, 0.5f, false);
            this.Powered = !this.Powered;
            this.Active = false;
            this.updateBlockChange();
        }
        this.toggleUpdatePowerState();
    }

    private void repUpdatePowerState() {
        if (!this.Active) {
            boolean pwr;
            int ps = RedPowerLib.getRotPowerState((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, this.Rotation, 0);
            if (ps != this.PowerState) {
                this.updateBlock();
            }
            this.PowerState = ps;
            boolean bl = pwr = this.PowerState > 0;
            if (pwr != this.Powered) {
                this.Active = true;
                this.scheduleTick(tickSchedule[this.Deadmap]);
            }
        }
    }

    private void repTick() {
        if (this.Active) {
            this.Powered = !this.Powered;
            this.Active = false;
            this.updateBlockChange();
            this.repUpdatePowerState();
        }
    }

    private void syncChange() {
        int ps = RedPowerLib.getRotPowerState((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 7, this.Rotation, 0);
        int psc = ps & ~this.PowerState;
        if (ps != this.PowerState) {
            this.updateBlock();
        }
        this.PowerState = ps;
        boolean upd = false;
        if ((ps & 2) == 2) {
            if (!this.Powered && (this.Active || this.Disabled)) {
                this.Active = false;
                this.Disabled = false;
                upd = true;
            }
        } else {
            if ((psc & 1) > 0 && !this.Active) {
                this.Active = true;
                upd = true;
            }
            if ((psc & 4) > 0 && !this.Disabled) {
                this.Disabled = true;
                upd = true;
            }
        }
        if (upd) {
            this.updateBlock();
            this.scheduleTick(2);
        }
    }

    private void syncTick() {
        if (this.Active && this.Disabled && !this.Powered) {
            this.Powered = true;
            this.Active = false;
            this.Disabled = false;
            this.scheduleTick(2);
            this.updateBlockChange();
        } else if (this.Powered) {
            this.Powered = false;
            this.updateBlockChange();
        }
    }

    private void randUpdatePowerState() {
        int ps = RedPowerLib.getRotPowerState((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 15, this.Rotation, 0);
        int psc = ps & ~this.PowerState;
        if (ps != this.PowerState) {
            this.updateBlock();
        }
        this.PowerState = ps;
        if ((psc & 2) > 0) {
            this.scheduleTick(2);
        }
    }

    private void randTick() {
        if ((this.PowerState & 2) != 0) {
            int rv = this.field_145850_b.field_73012_v.nextInt(8);
            this.Disabled = (rv & 1) > 0;
            this.Active = (rv & 2) > 0;
            this.Powered = (rv & 4) > 0;
            this.updateBlockChange();
            this.randUpdatePowerState();
            if ((this.PowerState & 2) > 0) {
                this.scheduleTick(4);
            }
        }
    }

    private void lightTick() {
        int lb = this.field_145850_b.func_72957_l(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        boolean bl = this.Active = lb > this.Deadmap * 4;
        if (this.Cover != 7 && this.Cover != 255) {
            this.Active = false;
        }
        if (this.Active != this.Powered) {
            this.scheduleTick(2);
        }
        this.simpleTick();
    }

    private boolean simpleWantsPower() {
        switch (this.SubId) {
            case 1: {
                return (this.PowerState & 7 & ~this.Deadmap) == 0;
            }
            case 2: {
                return (this.PowerState & ~this.Deadmap) > 0;
            }
            case 3: {
                return (this.PowerState & 7 | this.Deadmap) < 7;
            }
            case 4: {
                return (this.PowerState | this.Deadmap) == 7;
            }
            case 5: {
                return this.PowerState == 5 || this.PowerState == 0;
            }
            case 6: {
                int t = this.PowerState & 5;
                return t == 4 || t == 1;
            }
            default: {
                return false;
            }
            case 9: {
                return (this.PowerState & 2) == 0;
            }
            case 10: {
                return (this.PowerState & 2) > 0;
            }
            case 11: {
                if (this.Deadmap == 0) {
                    return (this.PowerState & 3) == 1 || (this.PowerState & 6) == 6;
                }
                return (this.PowerState & 3) == 3 || (this.PowerState & 6) == 4;
            }
            case 15: {
                if ((this.PowerState & 2) == 0) {
                    return this.Powered;
                }
                if (this.Deadmap == 0) {
                    return (this.PowerState & 4) == 4;
                }
                return (this.PowerState & 1) == 1;
            }
            case 16: 
        }
        return this.Active;
    }

    private void simpleUpdatePowerState() {
        int sides = 15;
        switch (this.SubId) {
            case 2: {
                sides = 7;
            }
            default: {
                break;
            }
            case 4: {
                sides = 7;
                break;
            }
            case 5: {
                sides = 5;
                break;
            }
            case 6: {
                sides = 13;
                break;
            }
            case 10: {
                sides = 7;
                break;
            }
            case 11: {
                sides = 7;
                break;
            }
            case 12: {
                sides = 2;
                break;
            }
            case 15: {
                sides = this.Deadmap == 0 ? 6 : 3;
                break;
            }
            case 16: {
                sides = 8;
            }
        }
        int ps = RedPowerLib.getRotPowerState((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, sides, this.Rotation, 0);
        if (ps != this.PowerState) {
            this.updateBlock();
        }
        this.PowerState = ps;
        boolean pwr = this.simpleWantsPower();
        if (pwr != this.Powered) {
            this.scheduleTick(2);
        }
    }

    private void simpleTick() {
        boolean pwr = this.simpleWantsPower();
        if (this.Powered && !pwr) {
            this.Powered = false;
            this.updateBlockChange();
        } else if (!this.Powered && pwr) {
            this.Powered = true;
            this.updateBlockChange();
        }
        this.simpleUpdatePowerState();
    }

    @Override
    public void onBlockNeighborChange(Block block) {
        if (!this.tryDropBlock()) {
            switch (this.SubId) {
                case 0: {
                    this.latchChange();
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 15: 
                case 16: {
                    if (this.isTickRunnable()) break;
                    this.simpleUpdatePowerState();
                    break;
                }
                case 7: {
                    this.pulseChange();
                    break;
                }
                case 8: {
                    if (this.isTickRunnable()) break;
                    this.toggleUpdatePowerState();
                    break;
                }
                case 12: {
                    if (this.isTickRunnable()) break;
                    this.repUpdatePowerState();
                    break;
                }
                case 13: {
                    this.syncChange();
                    break;
                }
                case 14: {
                    if (this.isTickRunnable()) break;
                    this.randUpdatePowerState();
                }
            }
        }
    }

    @Override
    public void onTileTick() {
        switch (this.SubId) {
            case 0: {
                if (this.Deadmap < 2) {
                    this.latchTick();
                    break;
                }
                this.latch2Tick();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                this.simpleTick();
                break;
            }
            case 7: {
                this.pulseTick();
                break;
            }
            case 8: {
                this.toggleTick();
                break;
            }
            case 12: {
                this.repTick();
                break;
            }
            case 13: {
                this.syncTick();
                break;
            }
            case 14: {
                this.randTick();
                break;
            }
            case 16: {
                this.lightTick();
            }
        }
    }

    @Override
    public int getPoweringMask(int ch) {
        if (ch != 0) {
            return 0;
        }
        switch (this.SubId) {
            case 0: {
                int ps = this.Deadmap > 1 ? this.PowerState & 0xA : (this.Disabled && !this.Active ? 0 : (this.Active ? (this.Powered ? 4 : 1) : (this.Deadmap == 1 ? (this.Powered ? 6 : 9) : (this.Powered ? 12 : 3))));
                return RedPowerLib.mapRotToCon(ps, this.Rotation);
            }
            default: {
                return super.getPoweringMask(ch);
            }
            case 8: {
                if (this.Powered) {
                    return RedPowerLib.mapRotToCon(2, this.Rotation);
                }
                return RedPowerLib.mapRotToCon(8, this.Rotation);
            }
            case 9: 
            case 10: {
                if (this.Powered) {
                    return RedPowerLib.mapRotToCon(0xD & ~this.Deadmap, this.Rotation);
                }
                return 0;
            }
            case 14: {
                return RedPowerLib.mapRotToCon((this.Active ? 1 : 0) | (this.Disabled ? 4 : 0) | (this.Powered ? 8 : 0), this.Rotation);
            }
            case 15: 
        }
        return RedPowerLib.mapRotToCon(this.Deadmap == 0 ? (this.Powered ? 9 : 0) : (this.Powered ? 12 : 0), this.Rotation);
    }

    @Override
    public boolean onPartActivateSide(EntityPlayer player, int part, int side) {
        switch (this.SubId) {
            case 8: {
                if (part != this.Rotation >> 2) {
                    return false;
                }
                this.playSound("random.click", 0.3f, 0.5f, false);
                this.Powered = !this.Powered;
                this.updateBlockChange();
                return true;
            }
            case 12: {
                if (part != this.Rotation >> 2) {
                    return false;
                }
                ++this.Deadmap;
                if (this.Deadmap > 8) {
                    this.Deadmap = 0;
                }
                this.updateBlockChange();
                return true;
            }
        }
        return false;
    }

    @Override
    public int getConnectableMask() {
        switch (this.SubId) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return RedPowerLib.mapRotToCon(8 | 7 & ~this.Deadmap, this.Rotation);
            }
            case 5: 
            case 6: {
                return RedPowerLib.mapRotToCon(13, this.Rotation);
            }
            case 7: {
                return RedPowerLib.mapRotToCon(10, this.Rotation);
            }
            default: {
                return super.getConnectableMask();
            }
            case 9: {
                return RedPowerLib.mapRotToCon(2 | 0xD & ~this.Deadmap, this.Rotation);
            }
            case 10: {
                return RedPowerLib.mapRotToCon(0xA | 5 & ~this.Deadmap, this.Rotation);
            }
            case 12: 
        }
        return RedPowerLib.mapRotToCon(10, this.Rotation);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.SubId == 16 && !this.isTickScheduled()) {
            this.scheduleTick(8);
        }
    }

    @Override
    public int getLightValue() {
        return this.SubId == 16 ? 0 : super.getLightValue();
    }

    @Override
    public int getExtendedID() {
        return 1;
    }
}

