/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.logic;

import com.eloraam.redpower.RedPowerLogic;
import com.eloraam.redpower.core.RedPowerLib;
import com.eloraam.redpower.logic.TileLogic;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;

public class TileLogicStorage
extends TileLogic {
    LogicStorageModule storage = null;

    @Override
    public int getExtendedID() {
        return 3;
    }

    @Override
    public void initSubType(int st) {
        super.initSubType(st);
        this.initStorage();
    }

    public LogicStorageModule getLogicStorage(Class cl) {
        if (!cl.isInstance(this.storage)) {
            this.initStorage();
        }
        return this.storage;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return (this.func_145837_r() || this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this) && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    @Override
    public int getPartMaxRotation(int part, boolean sec) {
        if (sec) {
            switch (this.SubId) {
                case 0: {
                    return 1;
                }
            }
        }
        return super.getPartMaxRotation(part, sec);
    }

    @Override
    public int getPartRotation(int part, boolean sec) {
        if (sec) {
            switch (this.SubId) {
                case 0: {
                    return this.Deadmap;
                }
            }
        }
        return super.getPartRotation(part, sec);
    }

    @Override
    public void setPartRotation(int part, boolean sec, int rot) {
        if (sec) {
            switch (this.SubId) {
                case 0: {
                    this.Deadmap = rot;
                    this.updateBlockChange();
                    return;
                }
            }
        }
        super.setPartRotation(part, sec, rot);
    }

    void initStorage() {
        if (this.storage == null || this.storage.getSubType() != this.SubId) {
            switch (this.SubId) {
                case 0: {
                    this.storage = new LogicStorageCounter();
                    break;
                }
                default: {
                    this.storage = null;
                }
            }
        }
    }

    @Override
    public void onBlockNeighborChange(Block block) {
        if (!this.tryDropBlock()) {
            this.initStorage();
            switch (this.SubId) {
                case 0: {
                    if (this.isTickRunnable()) {
                        return;
                    }
                    this.storage.updatePowerState();
                }
            }
        }
    }

    @Override
    public void onTileTick() {
        this.initStorage();
        this.storage.tileTick();
    }

    @Override
    public int getPoweringMask(int ch) {
        this.initStorage();
        return this.storage.getPoweringMask(ch);
    }

    @Override
    public boolean onPartActivateSide(EntityPlayer player, int part, int side) {
        if (part == this.Rotation >> 2 && !player.func_70093_af()) {
            if (!this.field_145850_b.field_72995_K) {
                switch (this.SubId) {
                    case 0: {
                        player.openGui((Object)RedPowerLogic.instance, 1, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.initStorage();
        this.storage.readFromNBT(data);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.storage.writeToNBT(data);
    }

    @Override
    protected void readFromPacket(NBTTagCompound tag) {
        this.initStorage();
        this.storage.readFromPacket(tag);
        super.readFromPacket(tag);
    }

    @Override
    protected void writeToPacket(NBTTagCompound tag) {
        this.storage.writeToPacket(tag);
        super.writeToPacket(tag);
    }

    public abstract class LogicStorageModule {
        public abstract void updatePowerState();

        public abstract void tileTick();

        public abstract int getSubType();

        public abstract int getPoweringMask(int var1);

        public abstract void readFromNBT(NBTTagCompound var1);

        public abstract void writeToNBT(NBTTagCompound var1);

        public void readFromPacket(NBTTagCompound tag) {
        }

        public void writeToPacket(NBTTagCompound tag) {
        }
    }

    public class LogicStorageCounter
    extends LogicStorageModule {
        public int Count = 0;
        public int CountMax = 10;
        public int Inc = 1;
        public int Dec = 1;

        @Override
        public void updatePowerState() {
            int ps = RedPowerLib.getRotPowerState((IBlockAccess)TileLogicStorage.this.field_145850_b, TileLogicStorage.this.field_145851_c, TileLogicStorage.this.field_145848_d, TileLogicStorage.this.field_145849_e, 5, TileLogicStorage.this.Rotation, 0);
            if (ps != TileLogicStorage.this.PowerState) {
                if ((ps & ~TileLogicStorage.this.PowerState & 1) > 0) {
                    TileLogicStorage.this.Active = true;
                }
                if ((ps & ~TileLogicStorage.this.PowerState & 4) > 0) {
                    TileLogicStorage.this.Disabled = true;
                }
                TileLogicStorage.this.PowerState = ps;
                TileLogicStorage.this.updateBlock();
                if (TileLogicStorage.this.Active || TileLogicStorage.this.Disabled) {
                    TileLogicStorage.this.scheduleTick(2);
                }
            }
        }

        @Override
        public void tileTick() {
            int co = this.Count;
            if (TileLogicStorage.this.Deadmap > 0) {
                if (TileLogicStorage.this.Active) {
                    this.Count -= this.Dec;
                    TileLogicStorage.this.Active = false;
                }
                if (TileLogicStorage.this.Disabled) {
                    this.Count += this.Inc;
                    TileLogicStorage.this.Disabled = false;
                }
            } else {
                if (TileLogicStorage.this.Active) {
                    this.Count += this.Inc;
                    TileLogicStorage.this.Active = false;
                }
                if (TileLogicStorage.this.Disabled) {
                    this.Count -= this.Dec;
                    TileLogicStorage.this.Disabled = false;
                }
            }
            if (this.Count < 0) {
                this.Count = 0;
            }
            if (this.Count > this.CountMax) {
                this.Count = this.CountMax;
            }
            if (co != this.Count) {
                TileLogicStorage.this.updateBlockChange();
                TileLogicStorage.this.playSound("random.click", 0.3f, 0.5f, false);
            }
            this.updatePowerState();
        }

        @Override
        public int getSubType() {
            return 0;
        }

        @Override
        public int getPoweringMask(int ch) {
            int ps = 0;
            if (ch != 0) {
                return 0;
            }
            if (this.Count == 0) {
                ps |= 2;
            }
            if (this.Count == this.CountMax) {
                ps |= 8;
            }
            return RedPowerLib.mapRotToCon(ps, TileLogicStorage.this.Rotation);
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            this.Count = tag.func_74762_e("cnt");
            this.CountMax = tag.func_74762_e("max");
            this.Inc = tag.func_74762_e("inc");
            this.Dec = tag.func_74762_e("dec");
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("cnt", this.Count);
            tag.func_74768_a("max", this.CountMax);
            tag.func_74768_a("inc", this.Inc);
            tag.func_74768_a("dec", this.Dec);
        }

        @Override
        public void readFromPacket(NBTTagCompound tag) {
            this.Count = tag.func_74762_e("cnt");
            this.CountMax = tag.func_74762_e("max");
        }

        @Override
        public void writeToPacket(NBTTagCompound tag) {
            tag.func_74768_a("cnt", this.Count);
            tag.func_74768_a("max", this.CountMax);
        }
    }
}

