/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.nei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ComboGenerator {
    public static List<LinkedList<Integer>> generate(int sum) {
        if (sum < 2) {
            return null;
        }
        ArrayList<LinkedList<Integer>> combos = new ArrayList<LinkedList<Integer>>();
        if (sum == 2) {
            combos.add(new LinkedList<Integer>(Arrays.asList(1, 1)));
            return combos;
        }
        for (int base = 1; base <= sum / 2; ++base) {
            block1: for (LinkedList<Integer> combo : ComboGenerator.generate(sum - base)) {
                for (Integer i : combo) {
                    if (i >= base) continue;
                    continue block1;
                }
                combo.addFirst(base);
                combos.add(combo);
            }
            combos.add(new LinkedList<Integer>(Arrays.asList(base, sum - base)));
        }
        return combos;
    }

    public static void print(List<LinkedList<Integer>> combos) {
        System.out.println("Combinations summing to: " + ComboGenerator.sum(combos.get(0)));
        for (LinkedList<Integer> combo : combos) {
            StringBuilder line = new StringBuilder();
            boolean comma = false;
            for (Integer i : combo) {
                if (!comma) {
                    comma = true;
                } else {
                    line.append(',');
                }
                line.append(i);
            }
            System.out.println(line);
        }
    }

    public static List<LinkedList<Integer>> removeNotContaining(List<LinkedList<Integer>> combos, int required) {
        Iterator<LinkedList<Integer>> iterator = combos.iterator();
        block0: while (iterator.hasNext()) {
            LinkedList<Integer> combo = iterator.next();
            for (Integer i : combo) {
                if (i != required) continue;
                continue block0;
            }
            iterator.remove();
        }
        return combos;
    }

    private static int sum(LinkedList<Integer> combo) {
        int sum = 0;
        for (Integer i : combo) {
            sum += i.intValue();
        }
        return sum;
    }
}

