/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.eloraam.redpower.RedPowerBase;
import com.eloraam.redpower.base.ItemHandsaw;
import com.eloraam.redpower.core.CoverLib;
import com.eloraam.redpower.nei.ComboGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class MicroRecipeHandler
extends ShapedRecipeHandler {
    public static int[] covers = new int[]{0, 16, 27, 17, 28, 29, 30};
    public static int[] strips = new int[]{21, 22, 39, 23, 40, 41, 42};
    public static int[] corners = new int[]{18, 19, 35, 20, 36, 37, 38};
    public static int[] posts = new int[]{-1, 43, -1, 44, -1, 45, -1};
    public static int[] hollow = new int[]{24, 25, 31, 26, 32, 33, 34};
    public static ItemHandsaw[] saws;
    public static int[] materials;
    public static Random rand;

    public MicroRecipeHandler() {
        MicroRecipeHandler.load();
    }

    public static void load() {
        if (materials == null) {
            int i;
            ArrayList<Integer> amaterial = new ArrayList<Integer>();
            for (i = 0; i < 256; ++i) {
                if (CoverLib.getItemStack(i) == null) continue;
                amaterial.add(i);
            }
            materials = new int[amaterial.size()];
            for (i = 0; i < amaterial.size(); ++i) {
                MicroRecipeHandler.materials[i] = (Integer)amaterial.get(i);
            }
        }
    }

    public static PositionedStack position(ItemStack item, int row, int col) {
        return new PositionedStack((Object)item, 25 + col * 18, 6 + row * 18);
    }

    public String getRecipeName() {
        return "Microblocks";
    }

    public void loadCraftingRecipes(ItemStack ingred) {
        ingred = ingred.func_77946_l();
        ingred.field_77994_a = 1;
        if (CoverLib.getMaterial(ingred) != null) {
            this.arecipes.add(new GluingRecipe(covers, ingred, -1));
            this.arecipes.add(new GluingRecipe(hollow, ingred, -1));
        } else if (ingred.func_77973_b() == ItemHandsaw.func_150898_a((Block)RedPowerBase.blockMicro) && MicroRecipeHandler.isValidMicroType(ingred.func_77960_j() >> 8)) {
            int type = ingred.func_77960_j() >> 8;
            int material = ingred.func_77960_j() & 0xFF;
            this.addCuttingRecipe(type, material);
            this.addGluingRecipe(type, material);
            this.addPostRecipe(type, material);
        }
    }

    private void addPostRecipe(int type, int material) {
        int thickness = MicroRecipeHandler.getThickness(type);
        int[] microclass = MicroRecipeHandler.getMicroClass(type);
        if (thickness % 2 == 0 && (microclass == posts || microclass == strips)) {
            this.arecipes.add(new PostRecipe(MicroRecipeHandler.getMicro(type, material, 1)));
        }
    }

    private void addGluingRecipe(int type, int material) {
        int thickness = MicroRecipeHandler.getThickness(type);
        int[] microclass = MicroRecipeHandler.getMicroClass(type);
        if ((microclass == covers || microclass == hollow) && thickness > 1) {
            this.arecipes.add(new GluingRecipe(MicroRecipeHandler.getMicroClass(type), MicroRecipeHandler.getMicro(type, material, 1), -1));
        }
        if (MicroRecipeHandler.thicknessPow2(thickness) && (microclass == covers || microclass == strips)) {
            int[] subclass = MicroRecipeHandler.getNextMicroClass(MicroRecipeHandler.getMicroClass(type), false);
            if (microclass == covers) {
                this.arecipes.add(new GluingRecipe(MicroRecipeHandler.getMicro(MicroRecipeHandler.getNextMicroClass(subclass, false)[thickness - 1], material, 4), MicroRecipeHandler.getMicro(type, material, 1)));
            }
            this.arecipes.add(new GluingRecipe(MicroRecipeHandler.getMicro(subclass[thickness - 1], material, 2), MicroRecipeHandler.getMicro(type, material, 1)));
        }
    }

    private void addCuttingRecipe(int type, int material) {
        int thickness = MicroRecipeHandler.getThickness(type);
        int[] microclass = MicroRecipeHandler.getMicroClass(type);
        if (microclass != covers && microclass != hollow) {
            if (microclass == strips || microclass == corners) {
                this.arecipes.add(new CuttingRecipe(MicroRecipeHandler.getMicro(type, material, 2), MicroRecipeHandler.getMicro(MicroRecipeHandler.getNextMicroClass(microclass, true)[thickness - 1], material, 1), null));
            }
        } else if (thickness <= 3 || microclass == covers && thickness == 4) {
            this.arecipes.add(new CuttingRecipe(MicroRecipeHandler.getMicro(type, material, 2), MicroRecipeHandler.getMicro(MicroRecipeHandler.setThickness(type, thickness * 2), material, 1), null));
        }
    }

    public void loadUsageRecipes(ItemStack result) {
        result = result.func_77946_l();
        result.field_77994_a = 1;
        if (CoverLib.getMaterial(result) != null) {
            this.arecipes.add(new CuttingRecipe(MicroRecipeHandler.getMicro(covers[3], MicroRecipeHandler.getMaterial(result), 2), result, null));
        } else if (result.func_77973_b() instanceof ItemHandsaw) {
            this.addSawUsage(result);
        } else if (result.func_77973_b() == Item.func_150898_a((Block)RedPowerBase.blockMicro) && MicroRecipeHandler.isValidMicroType(result.func_77960_j() >> 8)) {
            int type = result.func_77960_j() >> 8;
            int material = result.func_77960_j() & 0xFF;
            this.addCuttingUsage(type, material);
            this.addGluingUsage(type, material);
            this.addPostUsage(type, material);
        }
    }

    private void addSawSplitting(int[] microclass, int thicknesses, ItemStack handsaw) {
        for (int i = thicknesses; i >= 0; --i) {
            this.arecipes.add(new CuttingRecipe(MicroRecipeHandler.setThickness(microclass[i], (i + 1) * 2), microclass[i], handsaw));
        }
    }

    private void addSawCutting(int[] microclass, ItemStack handsaw) {
        int[] superclass = MicroRecipeHandler.getNextMicroClass(microclass, true);
        for (int i = 6; i >= 0; --i) {
            this.arecipes.add(new CuttingRecipe(superclass[i], microclass[i], handsaw));
        }
    }

    private void addPostUsage(int type, int material) {
        int thickness = MicroRecipeHandler.getThickness(type);
        int[] microclass = MicroRecipeHandler.getMicroClass(type);
        if (thickness % 2 == 0 && (microclass == posts || microclass == strips)) {
            this.arecipes.add(new PostRecipe(MicroRecipeHandler.getMicro(MicroRecipeHandler.swapPostType(type), material, 1)));
        }
    }

    private void addGluingUsage(int type, int material) {
        int thickness = MicroRecipeHandler.getThickness(type);
        int[] microclass = MicroRecipeHandler.getMicroClass(type);
        if (MicroRecipeHandler.thicknessPow2(thickness) && (microclass == corners || microclass == strips)) {
            int[] superclass = MicroRecipeHandler.getNextMicroClass(microclass, true);
            if (microclass == corners) {
                this.arecipes.add(new GluingRecipe(MicroRecipeHandler.getMicro(type, material, 4), MicroRecipeHandler.getMicro(MicroRecipeHandler.getNextMicroClass(superclass, true)[thickness - 1], material, 1)));
            }
            this.arecipes.add(new GluingRecipe(MicroRecipeHandler.getMicro(type, material, 2), MicroRecipeHandler.getMicro(superclass[thickness - 1], material, 1)));
        }
        if (microclass == covers || microclass == hollow) {
            for (int i = thickness + 1; i <= 8; ++i) {
                this.arecipes.add(new GluingRecipe(microclass, MicroRecipeHandler.getMicro(MicroRecipeHandler.setThickness(type, i), material, 1), thickness));
            }
        }
    }

    private void addCuttingUsage(int type, int material) {
        int thickness = MicroRecipeHandler.getThickness(type);
        int[] microclass = MicroRecipeHandler.getMicroClass(type);
        if (thickness % 2 == 0 && (microclass == covers || microclass == hollow)) {
            this.arecipes.add(new CuttingRecipe(MicroRecipeHandler.getMicro(MicroRecipeHandler.setThickness(type, MicroRecipeHandler.getThickness(type) / 2), material, 2), MicroRecipeHandler.getMicro(type, material, 1), null));
        }
        if (microclass == covers || microclass == strips) {
            this.arecipes.add(new CuttingRecipe(MicroRecipeHandler.getMicro(MicroRecipeHandler.getNextMicroClass(microclass, false)[MicroRecipeHandler.getThickness(type) - 1], material, 2), MicroRecipeHandler.getMicro(type, material, 1), null));
        }
    }

    private void addSawUsage(ItemStack ingredient) {
        this.addSawSplitting(covers, 3, ingredient);
        this.addSawSplitting(hollow, 2, ingredient);
        this.addSawCutting(strips, ingredient);
        this.addSawCutting(corners, ingredient);
    }

    public static int swapPostType(int type) {
        return MicroRecipeHandler.containsInt(posts, type) ? strips[MicroRecipeHandler.getThickness(type) - 1] : posts[MicroRecipeHandler.getThickness(type) - 1];
    }

    public static boolean isValidMicroType(int type) {
        return type == 0 || type >= 16 && type <= 45;
    }

    public static int[] getNextMicroClass(int[] microclass, boolean higher) {
        if (higher) {
            if (microclass == corners) {
                return strips;
            }
            if (microclass == strips) {
                return covers;
            }
        } else {
            if (microclass == strips) {
                return corners;
            }
            if (microclass == covers) {
                return strips;
            }
        }
        return null;
    }

    public static int getMaterial(ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)CoverLib.blockCoverPlate) ? stack.func_77960_j() & 0xFF : CoverLib.getMaterial(stack);
    }

    public static int getThickness(int type) {
        return type == -1 ? 8 : MicroRecipeHandler.getIndex(MicroRecipeHandler.getMicroClass(type), type) + 1;
    }

    public static int[] getMicroClass(int type) {
        return MicroRecipeHandler.containsInt(covers, type) ? covers : (MicroRecipeHandler.containsInt(strips, type) ? strips : (MicroRecipeHandler.containsInt(corners, type) ? corners : (MicroRecipeHandler.containsInt(hollow, type) ? hollow : posts)));
    }

    public static int setThickness(int type, int thickness) {
        return thickness == 8 ? -1 : MicroRecipeHandler.getMicroClass(type)[thickness - 1];
    }

    public static ItemStack getMicro(int type, int material, int quantity) {
        if (type == -1) {
            ItemStack stack = CoverLib.getItemStack(material).func_77946_l();
            stack.field_77994_a = quantity;
            return stack;
        }
        return new ItemStack(CoverLib.blockCoverPlate, quantity, type << 8 | material);
    }

    public static int getType(ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)CoverLib.blockCoverPlate) ? stack.func_77960_j() >> 8 : -1;
    }

    public static boolean thicknessPow2(int thickness) {
        return thickness == 1 || thickness == 2 || thickness == 4;
    }

    public static boolean containsInt(int[] array, int i) {
        return MicroRecipeHandler.getIndex(array, i) != -1;
    }

    public static int getIndex(int[] arr, int i) {
        for (int j = 0; j < arr.length; ++j) {
            if (arr[j] != i) continue;
            return j;
        }
        return -1;
    }

    static {
        rand = new Random();
    }

    public class PostRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        int type;
        int material;

        public PostRecipe(ItemStack result) {
            super((TemplateRecipeHandler)MicroRecipeHandler.this);
            this.type = MicroRecipeHandler.getType(result);
            this.material = MicroRecipeHandler.getMaterial(result);
        }

        public List<PositionedStack> getIngredients() {
            return new ArrayList<PositionedStack>(Collections.singletonList(MicroRecipeHandler.position(MicroRecipeHandler.getMicro(MicroRecipeHandler.swapPostType(this.type), this.material, 1), 1, 1)));
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)MicroRecipeHandler.getMicro(this.type, this.material, 1), 119, 24);
        }
    }

    public class GluingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        ItemStack result;
        int[] microclass;
        List<LinkedList<Integer>> gluingcombos;
        List<PositionedStack> ingreds;
        int cycletype;

        public GluingRecipe(int[] microclass, ItemStack result, int usedthickness) {
            super((TemplateRecipeHandler)MicroRecipeHandler.this);
            this.ingreds = new ArrayList<PositionedStack>();
            this.result = result;
            this.microclass = microclass;
            this.gluingcombos = ComboGenerator.generate(MicroRecipeHandler.getThickness(MicroRecipeHandler.getType(result)));
            if (usedthickness != -1) {
                ComboGenerator.removeNotContaining(this.gluingcombos, usedthickness);
            }
            this.cycletype = 0;
        }

        public GluingRecipe(ItemStack micro, ItemStack result) {
            super((TemplateRecipeHandler)MicroRecipeHandler.this);
            this.ingreds = new ArrayList<PositionedStack>();
            this.result = result;
            ItemStack m = micro.func_77946_l();
            m.field_77994_a = 1;
            for (int i = 0; i < micro.field_77994_a; ++i) {
                int pos = i >= 2 ? i + 1 : i;
                this.ingreds.add(MicroRecipeHandler.position(m, pos / 3, pos % 3));
            }
            this.cycletype = -1;
        }

        public List<PositionedStack> getIngredients() {
            if (this.cycletype == 0) {
                this.ingreds.clear();
                int cycle = MicroRecipeHandler.this.cycleticks / 20 % this.gluingcombos.size();
                int material = MicroRecipeHandler.getMaterial(this.result);
                LinkedList<Integer> combo = this.gluingcombos.get(cycle);
                this.ingreds = new ArrayList<PositionedStack>(combo.size());
                for (int i = 0; i < combo.size(); ++i) {
                    this.ingreds.add(MicroRecipeHandler.position(MicroRecipeHandler.getMicro(this.microclass[combo.get(i) - 1], material, 1), i / 3, i % 3));
                }
            }
            return this.ingreds;
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.result, 119, 24);
        }
    }

    public class CuttingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        ItemStack saw;
        ItemStack ingred;
        ItemStack result;
        int cycletype;
        List<Integer> cyclemap;

        public CuttingRecipe(ItemStack result, ItemStack ingred, ItemStack saw) {
            super((TemplateRecipeHandler)MicroRecipeHandler.this);
            this.cyclemap = new ArrayList<Integer>();
            this.result = result;
            this.ingred = ingred;
            this.saw = saw;
            this.cycletype = 0;
            this.mapSharpSaws();
        }

        public CuttingRecipe(int typeingred, int typeresult, ItemStack saw) {
            super((TemplateRecipeHandler)MicroRecipeHandler.this);
            this.cyclemap = new ArrayList<Integer>();
            this.result = MicroRecipeHandler.getMicro(typeingred, 0, 1);
            this.ingred = MicroRecipeHandler.getMicro(typeresult, 0, 2);
            this.saw = saw;
            this.cycletype = 1;
            this.mapSoftMaterials();
        }

        public void mapSharpSaws() {
            for (int i = 0; i < saws.length; ++i) {
                if (saws[i].getSharpness() < CoverLib.getHardness(MicroRecipeHandler.getMaterial(this.ingred))) continue;
                this.cyclemap.add(i);
            }
        }

        public void mapSoftMaterials() {
            for (int i = 0; i < materials.length; ++i) {
                if (((ItemHandsaw)this.saw.func_77973_b()).getSharpness() < CoverLib.getHardness(materials[i])) continue;
                this.cyclemap.add(i);
            }
        }

        public List<PositionedStack> getIngredients() {
            int index = this.cyclemap.get(MicroRecipeHandler.this.cycleticks / 20 % this.cyclemap.size());
            if (this.cycletype == 0) {
                this.saw = new ItemStack((Item)saws[index]);
            } else {
                this.ingred = MicroRecipeHandler.getMicro(MicroRecipeHandler.getType(this.ingred), materials[index], 1);
            }
            ArrayList<PositionedStack> ingreds = new ArrayList<PositionedStack>();
            int type = this.result.func_77960_j() >> 8;
            if (!MicroRecipeHandler.containsInt(covers, type) && !MicroRecipeHandler.containsInt(hollow, type)) {
                ingreds.add(MicroRecipeHandler.position(this.saw, 1, 0));
            } else {
                ingreds.add(MicroRecipeHandler.position(this.saw, 0, 1));
            }
            ingreds.add(MicroRecipeHandler.position(this.ingred, 1, 1));
            return ingreds;
        }

        public PositionedStack getResult() {
            int index = this.cyclemap.get(MicroRecipeHandler.this.cycleticks / 20 % this.cyclemap.size());
            if (this.cycletype == 1) {
                this.result = MicroRecipeHandler.getMicro(MicroRecipeHandler.getType(this.result), materials[index], 2);
            }
            return new PositionedStack((Object)this.result, 119, 24);
        }
    }
}

