/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.wiring;

import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.CoverLib;
import com.eloraam.redpower.core.CreativeExtraTabs;
import com.eloraam.redpower.core.IMicroPlacement;
import com.eloraam.redpower.core.RedPowerLib;
import com.eloraam.redpower.core.WorldCoord;
import com.eloraam.redpower.wiring.TileWiring;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MicroPlacementJacket
implements IMicroPlacement {
    private void blockUsed(World world, WorldCoord wc, ItemStack ist, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            --ist.field_77994_a;
        }
        CoreLib.placeNoise(world, wc.x, wc.y, wc.z, Block.func_149634_a((Item)ist.func_77973_b()));
        world.func_147471_g(wc.x, wc.y, wc.z);
        RedPowerLib.updateIndirectNeighbors(world, wc.x, wc.y, wc.z, Block.func_149634_a((Item)ist.func_77973_b()));
    }

    private int getWireMeta(int md) {
        switch (md) {
            case 64: {
                return 1;
            }
            case 65: {
                return 3;
            }
        }
        return 0;
    }

    private boolean initialPlace(ItemStack ist, EntityPlayer player, World world, WorldCoord wc, int l) {
        int md = ist.func_77960_j() >> 8;
        Block bid = Block.func_149634_a((Item)ist.func_77973_b());
        md = this.getWireMeta(md);
        if (!world.func_147472_a(bid, wc.x, wc.y, wc.z, false, l, (Entity)player, null)) {
            return false;
        }
        if (!world.func_147465_d(wc.x, wc.y, wc.z, bid, md, 3)) {
            return true;
        }
        TileWiring tw = CoreLib.getTileEntity((IBlockAccess)world, wc, TileWiring.class);
        if (tw == null) {
            return false;
        }
        tw.CenterPost = (short)(ist.func_77960_j() & 0xFF);
        tw.ConSides |= 0x40;
        this.blockUsed(world, wc, ist, player);
        return true;
    }

    private boolean tryAddingJacket(World world, WorldCoord wc, ItemStack ist, EntityPlayer player) {
        TileWiring tw = CoreLib.getTileEntity((IBlockAccess)world, wc, TileWiring.class);
        if (tw == null) {
            return false;
        }
        if ((tw.ConSides & 0x40) > 0) {
            return false;
        }
        if (!CoverLib.checkPlacement(tw.CoverSides, tw.Covers, tw.ConSides, true)) {
            return false;
        }
        tw.CenterPost = (short)(ist.func_77960_j() & 0xFF);
        tw.ConSides |= 0x40;
        tw.uncache();
        this.blockUsed(world, wc, ist, player);
        return true;
    }

    @Override
    public boolean onPlaceMicro(ItemStack ist, EntityPlayer player, World world, WorldCoord wc, int size) {
        int hb = ist.func_77960_j();
        hb >>= 8;
        hb = this.getWireMeta(hb);
        int dmg = hb << 8;
        if (CoverLib.tryMakeCompatible(world, wc, Block.func_149634_a((Item)ist.func_77973_b()), dmg) && this.tryAddingJacket(world, wc, ist, player)) {
            return true;
        }
        wc.step(size);
        Block bid = world.func_147439_a(wc.x, wc.y, wc.z);
        return bid != Block.func_149634_a((Item)ist.func_77973_b()) ? this.initialPlace(ist, player, world, wc, size) : CoverLib.tryMakeCompatible(world, wc, Block.func_149634_a((Item)ist.func_77973_b()), dmg) && this.tryAddingJacket(world, wc, ist, player);
    }

    @Override
    public String getMicroName(int hb, int lb) {
        switch (hb) {
            case 64: {
                String nm = CoverLib.getName(lb);
                if (nm == null) {
                    return null;
                }
                if (CoverLib.isTransparent(lb)) {
                    return null;
                }
                return "tile.rparmwire." + nm;
            }
            case 65: {
                String nm = CoverLib.getName(lb);
                if (nm == null) {
                    return null;
                }
                if (CoverLib.isTransparent(lb)) {
                    return null;
                }
                return "tile.rparmcable." + nm;
            }
        }
        return null;
    }

    @Override
    public void addCreativeItems(int hb, CreativeTabs tab, List<ItemStack> itemList) {
        if (tab == null || tab == CreativeExtraTabs.tabWires || tab == CreativeTabs.field_78027_g) {
            switch (hb) {
                case 64: {
                    itemList.add(new ItemStack(CoverLib.blockCoverPlate, 1, 16386));
                    break;
                }
                case 65: {
                    itemList.add(new ItemStack(CoverLib.blockCoverPlate, 1, 16666));
                }
            }
        }
    }
}

