/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.wiring;

import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.CoverLib;
import com.eloraam.redpower.core.CreativeExtraTabs;
import com.eloraam.redpower.core.IMicroPlacement;
import com.eloraam.redpower.core.RedPowerLib;
import com.eloraam.redpower.core.TileCovered;
import com.eloraam.redpower.core.WorldCoord;
import com.eloraam.redpower.wiring.TileWiring;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MicroPlacementWire
implements IMicroPlacement {
    private void blockUsed(World world, WorldCoord wc, ItemStack ist) {
        --ist.field_77994_a;
        CoreLib.placeNoise(world, wc.x, wc.y, wc.z, Block.func_149634_a((Item)ist.func_77973_b()));
        world.func_147471_g(wc.x, wc.y, wc.z);
        RedPowerLib.updateIndirectNeighbors(world, wc.x, wc.y, wc.z, Block.func_149634_a((Item)ist.func_77973_b()));
    }

    private boolean initialPlace(ItemStack ist, EntityPlayer player, World world, WorldCoord wc, int l) {
        int md = ist.func_77960_j() >> 8;
        Block bid = Block.func_149634_a((Item)ist.func_77973_b());
        if (!world.func_147472_a(bid, wc.x, wc.y, wc.z, false, l, (Entity)player, null)) {
            return false;
        }
        if (!RedPowerLib.canSupportWire((IBlockAccess)world, wc.x, wc.y, wc.z, l ^ 1)) {
            return false;
        }
        if (!world.func_147465_d(wc.x, wc.y, wc.z, bid, md, 3)) {
            return true;
        }
        TileWiring tw = CoreLib.getTileEntity((IBlockAccess)world, wc, TileWiring.class);
        if (tw == null) {
            return false;
        }
        tw.ConSides = 1 << (l ^ 1);
        tw.Metadata = ist.func_77960_j() & 0xFF;
        this.blockUsed(world, wc, ist);
        return true;
    }

    @Override
    public boolean onPlaceMicro(ItemStack ist, EntityPlayer player, World world, WorldCoord wc, int size) {
        wc.step(size);
        Block bid = world.func_147439_a(wc.x, wc.y, wc.z);
        if (bid != Block.func_149634_a((Item)ist.func_77973_b())) {
            return this.initialPlace(ist, player, world, wc, size);
        }
        TileCovered tc = CoreLib.getTileEntity((IBlockAccess)world, wc, TileCovered.class);
        if (tc == null) {
            return false;
        }
        int d = 1 << (size ^ 1);
        if ((tc.CoverSides & d) > 0) {
            return false;
        }
        int hb = ist.func_77960_j();
        if (!CoverLib.tryMakeCompatible(world, wc, Block.func_149634_a((Item)ist.func_77973_b()), hb)) {
            return false;
        }
        TileWiring tw = CoreLib.getTileEntity((IBlockAccess)world, wc, TileWiring.class);
        if (tw == null) {
            return false;
        }
        if (!RedPowerLib.canSupportWire((IBlockAccess)world, wc.x, wc.y, wc.z, size ^ 1)) {
            return false;
        }
        if (((tw.ConSides | tw.CoverSides) & d) > 0) {
            return false;
        }
        int t = (d |= tw.ConSides) & 0x3F;
        if (t == 3 || t == 12 || t == 48) {
            return false;
        }
        if (!CoverLib.checkPlacement(tw.CoverSides, tw.Covers, t, (tw.ConSides & 0x40) > 0)) {
            return false;
        }
        tw.ConSides = d;
        tw.uncache();
        this.blockUsed(world, wc, ist);
        return true;
    }

    @Override
    public String getMicroName(int hb, int lb) {
        switch (hb) {
            case 1: {
                switch (lb) {
                    case 0: {
                        return "tile.rpwire";
                    }
                }
                return null;
            }
            case 2: {
                return "tile.rpinsulated." + CoreLib.rawColorNames[lb];
            }
            case 3: {
                switch (lb) {
                    case 0: {
                        return "tile.rpcable";
                    }
                }
                return "tile.rpcable." + CoreLib.rawColorNames[lb - 1];
            }
        }
        return null;
    }

    @Override
    public void addCreativeItems(int hb, CreativeTabs tab, List<ItemStack> items) {
        if (tab == null || tab == CreativeExtraTabs.tabWires || tab == CreativeTabs.field_78027_g) {
            switch (hb) {
                case 1: {
                    items.add(new ItemStack(CoverLib.blockCoverPlate, 1, 256));
                    break;
                }
                case 2: {
                    for (int i = 0; i < 16; ++i) {
                        items.add(new ItemStack(CoverLib.blockCoverPlate, 1, 512 + i));
                    }
                    return;
                }
                case 3: {
                    for (int i = 0; i < 17; ++i) {
                        items.add(new ItemStack(CoverLib.blockCoverPlate, 1, 768 + i));
                    }
                    break;
                }
            }
        }
    }
}

