/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.wiring;

import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.IRedPowerWiring;
import com.eloraam.redpower.core.RedPowerLib;
import com.eloraam.redpower.wiring.TileWiring;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;

public class TileRedwire
extends TileWiring
implements IRedPowerWiring {
    public short PowerState = 0;

    @Override
    public int getExtendedID() {
        return 1;
    }

    @Override
    public boolean isBlockStrongPoweringTo(int side) {
        if (RedPowerLib.isSearching()) {
            return false;
        }
        int dir = 15 << ((side ^ 1) << 2);
        return (dir &= this.getConnectableMask()) != 0 && this.PowerState > 0;
    }

    @Override
    public boolean isBlockWeakPoweringTo(int side) {
        if (RedPowerLib.isSearching()) {
            return false;
        }
        int dir = 15 << ((side ^ 1) << 2);
        dir |= RedPowerLib.getConDirMask(side ^ 1);
        return (dir &= this.getConnectableMask()) != 0 && (RedPowerLib.isBlockRedstone((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, side ^ 1) ? this.PowerState > 15 : this.PowerState > 0);
    }

    @Override
    public int getConnectClass(int side) {
        return 1;
    }

    @Override
    public int getConnectableMask() {
        if (this.ConaMask >= 0) {
            return this.ConaMask;
        }
        int tr = super.getConnectableMask();
        if ((this.ConSides & 1) > 0) {
            tr |= 0x1000000;
        }
        if ((this.ConSides & 2) > 0) {
            tr |= 0x2000000;
        }
        if ((this.ConSides & 4) > 0) {
            tr |= 0x4000000;
        }
        if ((this.ConSides & 8) > 0) {
            tr |= 0x8000000;
        }
        if ((this.ConSides & 0x10) > 0) {
            tr |= 0x10000000;
        }
        if ((this.ConSides & 0x20) > 0) {
            tr |= 0x20000000;
        }
        this.ConaMask = tr;
        return tr;
    }

    @Override
    public int getCurrentStrength(int cons, int ch) {
        return ch != 0 ? -1 : ((cons & this.getConnectableMask()) == 0 ? -1 : (int)this.PowerState);
    }

    @Override
    public int scanPoweringStrength(int cons, int ch) {
        return ch != 0 ? 0 : (RedPowerLib.isPowered((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, cons, this.ConSides) ? 255 : 0);
    }

    @Override
    public void updateCurrentStrength() {
        this.PowerState = (short)RedPowerLib.updateBlockCurrentStrength(this.field_145850_b, this, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0x3FFFFFFF, 1);
        CoreLib.markBlockDirty(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public int getPoweringMask(int ch) {
        return ch == 0 && this.PowerState != 0 ? this.getConnectableMask() : 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.PowerState = (short)(data.func_74771_c("pwr") & 0xFF);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74774_a("pwr", (byte)this.PowerState);
    }

    @Override
    protected void readFromPacket(NBTTagCompound data) {
        super.readFromPacket(data);
        this.PowerState = (short)(data.func_74771_c("pwr") & 0xFF);
    }

    @Override
    protected void writeToPacket(NBTTagCompound data) {
        super.writeToPacket(data);
        data.func_74774_a("pwr", (byte)this.PowerState);
    }
}

