/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.wiring;

import com.eloraam.redpower.RedPowerBase;
import com.eloraam.redpower.base.BlockMicro;
import com.eloraam.redpower.core.BlockMultipart;
import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.CoverLib;
import com.eloraam.redpower.core.IWiring;
import com.eloraam.redpower.core.RedPowerLib;
import com.eloraam.redpower.core.TileCovered;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;

public abstract class TileWiring
extends TileCovered
implements IWiring {
    public int ConSides = 0;
    public int Metadata = 0;
    public short CenterPost = 0;
    public int ConMask = -1;
    public int EConMask = -1;
    public int EConEMask = -1;
    public int ConaMask = -1;

    public float getWireHeight() {
        return 0.125f;
    }

    public void uncache0() {
        this.EConMask = -1;
        this.EConEMask = -1;
        this.ConMask = -1;
    }

    public void uncache() {
        if (this.ConaMask >= 0 || this.EConMask >= 0 || this.ConMask >= 0) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.ConaMask = -1;
        this.EConMask = -1;
        this.EConEMask = -1;
        this.ConMask = -1;
    }

    private static int stripBlockConMask(int side) {
        switch (side) {
            case 0: {
                return 257;
            }
            case 1: {
                return 4098;
            }
            case 2: {
                return 65540;
            }
            case 3: {
                return 0x100008;
            }
            case 4: {
                return 263168;
            }
            case 5: {
                return 540672;
            }
            case 6: {
                return 0x400800;
            }
            case 7: {
                return 0x808000;
            }
            case 8: {
                return 528;
            }
            case 9: {
                return 8224;
            }
            case 10: {
                return 131136;
            }
        }
        return 0x200080;
    }

    @Override
    public int getConnectableMask() {
        if (this.ConaMask >= 0) {
            return this.ConaMask;
        }
        int tr = 0;
        if ((this.ConSides & 1) > 0) {
            tr |= 0xF;
        }
        if ((this.ConSides & 2) > 0) {
            tr |= 0xF0;
        }
        if ((this.ConSides & 4) > 0) {
            tr |= 0xF00;
        }
        if ((this.ConSides & 8) > 0) {
            tr |= 0xF000;
        }
        if ((this.ConSides & 0x10) > 0) {
            tr |= 0xF0000;
        }
        if ((this.ConSides & 0x20) > 0) {
            tr |= 0xF00000;
        }
        if ((this.CoverSides & 1) > 0) {
            tr &= 0xFFEEEEFF;
        }
        if ((this.CoverSides & 2) > 0) {
            tr &= 0xFFDDDDFF;
        }
        if ((this.CoverSides & 4) > 0) {
            tr &= 0xFFBBFFEE;
        }
        if ((this.CoverSides & 8) > 0) {
            tr &= 0xFF77FFDD;
        }
        if ((this.CoverSides & 0x10) > 0) {
            tr &= 0xFFFFBBBB;
        }
        if ((this.CoverSides & 0x20) > 0) {
            tr &= 0xFFFF7777;
        }
        for (int i = 0; i < 12; ++i) {
            if ((this.CoverSides & 16384 << i) <= 0) continue;
            tr &= ~TileWiring.stripBlockConMask(i);
        }
        if ((this.ConSides & 0x40) > 0) {
            tr |= 0x3F000000;
            for (int var4 = 0; var4 < 6; ++var4) {
                if ((this.CoverSides & 1 << var4) <= 0) continue;
                int j = this.Covers[var4] >> 8;
                if (j < 3) {
                    tr &= ~(1 << var4 + 24);
                }
                if (j != 5) continue;
                tr &= 3 << (var4 & 0xFFFFFFFE) + 24;
            }
        }
        this.ConaMask = tr;
        return tr;
    }

    @Override
    public int getConnectionMask() {
        if (this.ConMask >= 0) {
            return this.ConMask;
        }
        this.ConMask = RedPowerLib.getConnections((IBlockAccess)this.field_145850_b, this, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.ConMask;
    }

    @Override
    public int getExtConnectionMask() {
        if (this.EConMask >= 0) {
            return this.EConMask;
        }
        this.EConMask = RedPowerLib.getExtConnections((IBlockAccess)this.field_145850_b, this, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.EConEMask = RedPowerLib.getExtConnectionExtras((IBlockAccess)this.field_145850_b, this, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.EConMask;
    }

    @Override
    public int getCornerPowerMode() {
        return 1;
    }

    @Override
    public void onFrameRefresh(IBlockAccess iba) {
        if (this.ConMask < 0) {
            this.ConMask = RedPowerLib.getConnections(iba, this, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.EConMask < 0) {
            this.EConMask = RedPowerLib.getExtConnections(iba, this, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.EConEMask = RedPowerLib.getExtConnectionExtras(iba, this, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void onBlockNeighborChange(Block block) {
        if (this.EConMask >= 0 || this.ConMask >= 0) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.ConMask = -1;
        this.EConMask = -1;
        this.EConEMask = -1;
        this.refreshBlockSupport();
        RedPowerLib.updateCurrent(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.updateBlock();
    }

    @Override
    public int getExtendedMetadata() {
        return this.Metadata;
    }

    @Override
    public void setExtendedMetadata(int md) {
        this.Metadata = md;
    }

    @Override
    public boolean canAddCover(int side, int cover) {
        if (side < 6 && (this.ConSides & 1 << side) > 0) {
            return false;
        }
        if ((this.CoverSides & 1 << side) > 0) {
            return false;
        }
        short[] test = Arrays.copyOf(this.Covers, 29);
        test[side] = (short)cover;
        return CoverLib.checkPlacement(this.CoverSides | 1 << side, test, this.ConSides, (this.ConSides & 0x40) > 0);
    }

    @Override
    public boolean tryAddCover(int side, int cover) {
        if (!this.canAddCover(side, cover)) {
            return false;
        }
        this.CoverSides |= 1 << side;
        this.Covers[side] = (short)cover;
        this.uncache();
        this.updateBlockChange();
        return true;
    }

    @Override
    public int tryRemoveCover(int side) {
        int tr = super.tryRemoveCover(side);
        if (tr < 0) {
            return -1;
        }
        this.uncache();
        this.updateBlockChange();
        return tr;
    }

    @Override
    public boolean blockEmpty() {
        return this.CoverSides == 0 && this.ConSides == 0;
    }

    @Override
    public void addHarvestContents(List<ItemStack> ist) {
        super.addHarvestContents(ist);
        for (int s = 0; s < 6; ++s) {
            if ((this.ConSides & 1 << s) == 0) continue;
            ist.add(new ItemStack((Block)RedPowerBase.blockMicro, 1, this.getExtendedID() * 256 + this.Metadata));
        }
        if ((this.ConSides & 0x40) > 0) {
            int td = 16384 + this.CenterPost;
            if (this.getExtendedID() == 3) {
                td += 256;
            }
            if (this.getExtendedID() == 5) {
                td += 512;
            }
            ist.add(new ItemStack((Block)RedPowerBase.blockMicro, 1, td));
        }
    }

    @Override
    public int getPartsMask() {
        return this.CoverSides | this.ConSides & 0x3F | (this.ConSides & 0x40) << 23;
    }

    @Override
    public int getSolidPartsMask() {
        return this.CoverSides | (this.ConSides & 0x40) << 23;
    }

    public boolean refreshBlockSupport() {
        boolean all = false;
        int s = this.ConSides & 0x3F;
        if (s == 3 || s == 12 || s == 48) {
            all = true;
        }
        for (int var3 = 0; var3 < 6; ++var3) {
            if ((this.ConSides & 1 << var3) == 0 || !all && RedPowerLib.canSupportWire((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, var3)) continue;
            this.uncache();
            CoreLib.markBlockDirty(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            CoreLib.dropItem(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, new ItemStack((Block)RedPowerBase.blockMicro, 1, this.getExtendedID() * 256 + this.Metadata));
            this.ConSides &= ~(1 << var3);
        }
        if (this.ConSides == 0) {
            if (this.CoverSides > 0) {
                this.replaceWithCovers();
            } else {
                this.deleteBlock();
            }
            return false;
        }
        return true;
    }

    @Override
    public void onHarvestPart(EntityPlayer player, int part, boolean willHarvest) {
        if (part == 29 && (this.ConSides & 0x40) > 0) {
            int td = 16384 + this.CenterPost;
            if (this.getExtendedID() == 3) {
                td += 256;
            }
            if (this.getExtendedID() == 5) {
                td += 512;
            }
            if (willHarvest) {
                CoreLib.dropItem(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, new ItemStack((Block)RedPowerBase.blockMicro, 1, td));
            }
            this.ConSides &= 0x3F;
        } else {
            if ((this.ConSides & 1 << part) <= 0) {
                super.onHarvestPart(player, part, willHarvest);
                return;
            }
            if (willHarvest) {
                CoreLib.dropItem(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, new ItemStack((Block)RedPowerBase.blockMicro, 1, this.getExtendedID() * 256 + this.Metadata));
            }
            this.ConSides &= ~(1 << part);
        }
        this.uncache();
        if (this.ConSides == 0) {
            if (this.CoverSides > 0) {
                this.replaceWithCovers();
            } else {
                this.deleteBlock();
            }
        }
        CoreLib.markBlockDirty(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        RedPowerLib.updateIndirectNeighbors(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)RedPowerBase.blockMicro);
    }

    @Override
    public float getPartStrength(EntityPlayer player, int part) {
        BlockMicro bl = RedPowerBase.blockMicro;
        return part == 29 && (this.ConSides & 0x40) > 0 ? player.getBreakSpeed((Block)bl, false, 0) / (bl.getHardness() * 30.0f) : ((this.ConSides & 1 << part) > 0 ? player.getBreakSpeed((Block)bl, false, 0) / (bl.getHardness() * 30.0f) : super.getPartStrength(player, part));
    }

    @Override
    public void setPartBounds(BlockMultipart block, int part) {
        if (part == 29) {
            if ((this.ConSides & 0x40) == 0) {
                super.setPartBounds(block, part);
                return;
            }
        } else if ((this.ConSides & 1 << part) == 0) {
            super.setPartBounds(block, part);
            return;
        }
        float wh = this.getWireHeight();
        switch (part) {
            case 0: {
                block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, wh, 1.0f);
                break;
            }
            case 1: {
                block.func_149676_a(0.0f, 1.0f - wh, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 2: {
                block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, wh);
                break;
            }
            case 3: {
                block.func_149676_a(0.0f, 0.0f, 1.0f - wh, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 4: {
                block.func_149676_a(0.0f, 0.0f, 0.0f, wh, 1.0f, 1.0f);
                break;
            }
            case 5: {
                block.func_149676_a(1.0f - wh, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 29: {
                block.func_149676_a(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.ConSides = data.func_74771_c("cons") & 0xFF;
        this.Metadata = data.func_74771_c("md") & 0xFF;
        this.CenterPost = (short)(data.func_74771_c("post") & 0xFF);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74774_a("cons", (byte)this.ConSides);
        data.func_74774_a("md", (byte)this.Metadata);
        data.func_74777_a("post", this.CenterPost);
    }

    @Override
    public void writeFramePacket(NBTTagCompound tag) {
        tag.func_74768_a("md", this.Metadata);
        tag.func_74768_a("cons", this.ConSides);
        if ((this.ConSides & 0x40) > 0) {
            tag.func_74777_a("post", this.CenterPost);
        }
        super.writeFramePacket(tag);
    }

    @Override
    public void readFramePacket(NBTTagCompound tag) {
        this.Metadata = tag.func_74762_e("md");
        this.ConSides = tag.func_74762_e("cons");
        if ((this.ConSides & 0x40) > 0) {
            this.CenterPost = tag.func_74765_d("post");
        }
        this.ConaMask = -1;
        this.EConMask = -1;
        this.EConEMask = -1;
        this.ConMask = -1;
        super.readFramePacket(tag);
    }

    @Override
    protected void readFromPacket(NBTTagCompound data) {
        this.Metadata = data.func_74762_e("md");
        this.ConSides = data.func_74762_e("cons");
        if ((this.ConSides & 0x40) > 0) {
            this.CenterPost = data.func_74765_d("post");
        }
        this.ConaMask = -1;
        this.EConMask = -1;
        this.EConEMask = -1;
        this.ConMask = -1;
        super.readFromPacket(data);
    }

    @Override
    protected void writeToPacket(NBTTagCompound data) {
        data.func_74768_a("md", this.Metadata);
        data.func_74768_a("cons", this.ConSides);
        if ((this.ConSides & 0x40) > 0) {
            data.func_74777_a("post", this.CenterPost);
        }
        super.writeToPacket(data);
    }

    @Override
    protected ItemStack getBasePickStack() {
        if ((this.ConSides & 0x40) > 0) {
            int td = 16384 + this.CenterPost;
            if (this.getExtendedID() == 3) {
                td += 256;
            }
            if (this.getExtendedID() == 5) {
                td += 512;
            }
            return new ItemStack((Block)RedPowerBase.blockMicro, 1, td);
        }
        return new ItemStack((Block)RedPowerBase.blockMicro, 1, this.getExtendedID() * 256 + this.Metadata);
    }
}

