/*
 * Decompiled with CFR 0.152.
 */
package swixy.miningdimension;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.DimensionManager;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import swixy.miningdimension.CreativeTabDW;
import swixy.miningdimension.DimensionalWorldBlocks;
import swixy.miningdimension.DimensionalWorldItems;
import swixy.miningdimension.EventListener;
import swixy.miningdimension.ModConfig;
import swixy.miningdimension.dimension.BiomeGenMining;
import swixy.miningdimension.dimension.WorldProviderMiner;
import swixy.miningdimension.proxy.CommonProxy;
import swixy.miningdimension.util.AromaRegistry;

@Mod(modid="MiningDimension", name="Mining Dimensional World")
public class DimensionalWorld {
    @Mod.Instance(value="MiningDimension")
    public static DimensionalWorld instance;
    @SidedProxy(clientSide="swixy.miningdimension.proxy.ClientProxy", serverSide="swixy.miningdimension.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs creativeTabDW;
    public static final Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModConfig.init(event.getSuggestedConfigurationFile());
        AromaRegistry.register(DimensionalWorldBlocks.class);
        AromaRegistry.register(DimensionalWorldItems.class);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        BiomeGenMining.instance = new BiomeGenMining(ModConfig.biomeID);
        ItemStack igniter = new ItemStack((Item)DimensionalWorldItems.portalIgniter, 1, Short.MAX_VALUE);
        if (DimensionManager.isDimensionRegistered((int)ModConfig.dimensionID)) {
            logger.log(Level.ERROR, "Failed to register the Mining Dimension with the ID " + ModConfig.dimensionID + ". Please pick another one!");
        }
        DimensionManager.registerProviderType((int)ModConfig.dimensionID, WorldProviderMiner.class, (boolean)false);
        DimensionManager.registerDimension((int)ModConfig.dimensionID, (int)ModConfig.dimensionID);
        WorldProvider provider = DimensionManager.createProviderFor((int)ModConfig.dimensionID);
        if (provider == null || !WorldProviderMiner.class.isInstance(provider)) {
            throw new RuntimeException("The Mining World was registered, but wasn't. This is a severe issue!");
        }
        FMLInterModComms.sendMessage((String)"BuildCraft|Energy", (String)"oil-gen-exclude", (String)(ModConfig.biomeID + ""));
        FMLInterModComms.sendMessage((String)"Thaumcraft", (String)"dimensionBlacklist", (String)(ModConfig.dimensionID + ":1"));
        FMLInterModComms.sendMessage((String)"Thaumcraft", (String)"biomeBlacklist", (String)(ModConfig.biomeID + ":1"));
        new EventListener();
        BiomeManager.addStrongholdBiome((BiomeGenBase)BiomeGenMining.instance);
        BiomeDictionary.registerBiomeType((BiomeGenBase)BiomeGenMining.instance, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN});
        logger.log(Level.INFO, "Loaded.");
        logger.log(Level.TRACE, "Dimension registered with ID: " + ModConfig.dimensionID + ".");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void worldloaded(FMLServerStartedEvent event) {
        DimensionManager.init();
    }

    static {
        logger = LogManager.getLogger((String)"SwixyLogger");
        creativeTabDW = new CreativeTabDW("MiningDimension".toLowerCase() + ":creativeTabDW");
    }
}

