/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import mcp.mobius.waila.api.IWailaCommonAccessor;
import mcp.mobius.waila.api.IWailaTooltipRenderer;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import mcp.mobius.waila.overlay.IconUI;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import ml.luxinfine.waila.PlayerWatchHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import org.lwjgl.opengl.GL11;

public class DisplayUtil {
    private static FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
    private static TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
    private static RenderItem renderItem = new RenderItem();

    public static int getDisplayWidth(String s) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        int width = 0;
        Matcher renderMatcher = SpecialChars.patternRender.matcher(s);
        while (renderMatcher.find()) {
            IWailaTooltipRenderer renderer = ModuleRegistrar.instance().getTooltipRenderer(renderMatcher.group("name"));
            if (renderer == null) continue;
            RayTracing trace = RayTracing.instance();
            trace.fire();
            width += renderer.getSize((String[])renderMatcher.group((String)"args").split((String)","), (IWailaCommonAccessor)PlayerWatchHandler.INSTANCE.getAccessor((MovingObjectPosition)trace.getTarget())).width;
        }
        Matcher iconMatcher = SpecialChars.patternIcon.matcher(s);
        while (iconMatcher.find()) {
            width += 8;
        }
        return width += fontRenderer.func_78256_a(DisplayUtil.stripSymbols(s));
    }

    public static Dimension displaySize() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        return new Dimension(res.func_78326_a(), res.func_78328_b());
    }

    public static String stripSymbols(String s) {
        String result = SpecialChars.patternRender.matcher(s).replaceAll("");
        result = SpecialChars.patternMinecraft.matcher(result).replaceAll("");
        result = SpecialChars.patternWaila.matcher(result).replaceAll("");
        return result;
    }

    public static String stripWailaSymbols(String s) {
        String result = SpecialChars.patternRender.matcher(s).replaceAll("");
        result = SpecialChars.patternWaila.matcher(result).replaceAll("");
        return result;
    }

    public static void renderStack(int x, int y, ItemStack stack) {
        DisplayUtil.enable3DRender();
        try {
            renderItem.func_82406_b(fontRenderer, textureManager, stack, x, y);
            renderItem.func_77021_b(fontRenderer, textureManager, stack, x, y);
        }
        catch (Exception e) {
            String stackStr = stack != null ? stack.toString() : "NullStack";
            WailaExceptionHandler.handleErr(e, "renderStack | " + stackStr, null);
        }
        DisplayUtil.enable2DRender();
    }

    public static void enable3DRender() {
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public static void enable2DRender() {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    public static void drawGradientRect(int x, int y, int w, int h, int grad1, int grad2) {
        float zLevel = 0.0f;
        float f = (float)(grad1 >> 24 & 0xFF) / 255.0f;
        float f2 = (float)(grad1 >> 16 & 0xFF) / 255.0f;
        float f3 = (float)(grad1 >> 8 & 0xFF) / 255.0f;
        float f4 = (float)(grad1 & 0xFF) / 255.0f;
        float f5 = (float)(grad2 >> 24 & 0xFF) / 255.0f;
        float f6 = (float)(grad2 >> 16 & 0xFF) / 255.0f;
        float f7 = (float)(grad2 >> 8 & 0xFF) / 255.0f;
        float f8 = (float)(grad2 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(f2, f3, f4, f);
        tessellator.func_78377_a((double)(x + w), (double)y, 0.0);
        tessellator.func_78377_a((double)x, (double)y, 0.0);
        tessellator.func_78369_a(f6, f7, f8, f5);
        tessellator.func_78377_a((double)x, (double)(y + h), 0.0);
        tessellator.func_78377_a((double)(x + w), (double)(y + h), 0.0);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int w, int h, int tw, int th) {
        float f = 0.00390625f;
        float f2 = 0.00390625f;
        float zLevel = 0.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        tessellator.func_78374_a((double)(x + 0), (double)(y + h), 0.0, (double)((float)(u + 0) * 0.00390625f), (double)((float)(v + th) * 0.00390625f));
        tessellator.func_78374_a((double)(x + w), (double)(y + h), 0.0, (double)((float)(u + tw) * 0.00390625f), (double)((float)(v + th) * 0.00390625f));
        tessellator.func_78374_a((double)(x + w), (double)(y + 0), 0.0, (double)((float)(u + tw) * 0.00390625f), (double)((float)(v + 0) * 0.00390625f));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), 0.0, (double)((float)(u + 0) * 0.00390625f), (double)((float)(v + 0) * 0.00390625f));
        tessellator.func_78381_a();
    }

    public static void drawString(String text, int x, int y, int colour, boolean shadow) {
        if (shadow) {
            fontRenderer.func_78261_a(text, x, y, colour);
        } else {
            fontRenderer.func_78276_b(text, x, y, colour);
        }
    }

    public static List<String> itemDisplayNameMultiline(ItemStack itemstack) {
        ArrayList<String> namelist = null;
        try {
            namelist = itemstack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (namelist == null) {
            namelist = new ArrayList<String>();
        }
        if (namelist.size() == 0) {
            namelist.add("Unnamed");
        }
        if (namelist.get(0) == null || ((String)namelist.get(0)).equals("")) {
            namelist.set(0, "Unnamed");
        }
        namelist.set(0, itemstack.func_77953_t().field_77937_e.toString() + (String)namelist.get(0));
        for (int i = 1; i < namelist.size(); ++i) {
            namelist.set(i, "\u00a77" + (String)namelist.get(i));
        }
        return namelist;
    }

    public static String itemDisplayNameShort(ItemStack itemstack) {
        List<String> list = DisplayUtil.itemDisplayNameMultiline(itemstack);
        return list.get(0);
    }

    public static void renderIcon(int x, int y, int sx, int sy, IconUI icon) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
        if (icon == null) {
            return;
        }
        if (icon.bu != -1) {
            DisplayUtil.drawTexturedModalRect(x, y, icon.bu, icon.bv, sx, sy, icon.bsu, icon.bsv);
        }
        DisplayUtil.drawTexturedModalRect(x, y, icon.u, icon.v, sx, sy, icon.su, icon.sv);
    }
}

