/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.handlers;

import codechicken.nei.api.API;
import codechicken.nei.api.ItemInfo;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.p455w0rd.wirelesscraftingterminal.common.WirelessCraftingTerminal;
import net.p455w0rd.wirelesscraftingterminal.handlers.LocaleHandler;
import net.p455w0rd.wirelesscraftingterminal.handlers.RecipeHandler;
import net.p455w0rd.wirelesscraftingterminal.items.ItemEnum;
import net.p455w0rd.wirelesscraftingterminal.reference.Reference;

public class ConfigHandler {
    public static Configuration config;
    public static boolean enableInfinityBooster;
    public static boolean enableEasyMode;
    public static int ae2wctMaxPower;
    public static int boosterDropChance;
    public static boolean boosterDropsEnabled;
    public static boolean mineTweakerOverride;
    public static boolean doVersionCheck;
    public static boolean firstLoad;
    private static boolean doSave;
    private static int pwrInCfgFile;
    private static int boosterDropInCfgFile;
    private static boolean mtChanged;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
        }
        doSave = false;
        ConfigHandler.loadConfig();
    }

    private static void loadConfig() {
        String pwrDesc = LocaleHandler.MaxPowerDesc.getLocal() + " [default: 1600000, min: 800000, max:6400000]";
        String boosterDesc = LocaleHandler.InfinityBoosterCfgDesc.getLocal();
        String easyModeDesc = LocaleHandler.EasyModeDesc.getLocal();
        String boosterDropDesc = LocaleHandler.BoosterDropChance.getLocal();
        String boosterDropEnabledDesc = LocaleHandler.DisableBoosterDrop.getLocal();
        String mineTweakerOverrideDesc = LocaleHandler.MineTweakerOverride.getLocal();
        String doVersionCheckDesc = LocaleHandler.DoVersionCheck.getLocal();
        enableInfinityBooster = config.getBoolean("enableInfinityBooster", "general", true, boosterDesc);
        enableEasyMode = config.getBoolean("enableEasyMode", "general", false, easyModeDesc);
        boosterDropsEnabled = config.getBoolean("boosterDropsEnabled", "general", true, boosterDropEnabledDesc);
        mineTweakerOverride = config.getBoolean("mineTweakerOverride", "general", false, mineTweakerOverrideDesc);
        doVersionCheck = config.getBoolean("doVersionCheck", "general", true, doVersionCheckDesc);
        Property pwrCfgKey = config.get("general", "ae2wctMaxPower", Reference.WCT_MAX_POWER);
        pwrCfgKey.comment = pwrDesc;
        pwrCfgKey.setDefaultValue(Reference.WCT_MAX_POWER);
        ae2wctMaxPower = pwrInCfgFile = pwrCfgKey.getInt();
        if (pwrInCfgFile > 6400000) {
            ae2wctMaxPower = 6400000;
            pwrCfgKey.setValue(6400000);
            pwrCfgKey.comment = pwrDesc;
            doSave = true;
        } else if (pwrInCfgFile < 800000) {
            ae2wctMaxPower = 800000;
            pwrCfgKey.setValue(800000);
            pwrCfgKey.comment = pwrDesc;
            doSave = true;
        }
        Property boosterDropKey = config.get("general", "boosterDropChance", Reference.WCT_BOOSTER_DROPCHANCE);
        boosterDropKey.comment = boosterDropDesc;
        boosterDropKey.setDefaultValue(Reference.WCT_BOOSTER_DROPCHANCE);
        boosterDropChance = boosterDropInCfgFile = boosterDropKey.getInt();
        if (boosterDropInCfgFile > 100) {
            boosterDropChance = 100;
            boosterDropKey.setValue(100);
            boosterDropKey.comment = boosterDropDesc;
            doSave = true;
        } else if (boosterDropInCfgFile < 1) {
            boosterDropChance = 1;
            boosterDropKey.setValue(1);
            boosterDropKey.comment = boosterDropDesc;
            doSave = true;
        }
        if (Reference.WCT_MINETWEAKER_OVERRIDE != mineTweakerOverride) {
            mtChanged = true;
        }
        Reference.WCT_BOOSTER_ENABLED = enableInfinityBooster;
        Reference.WCT_EASYMODE_ENABLED = enableEasyMode;
        Reference.WCT_MAX_POWER = ae2wctMaxPower;
        Reference.WCT_BOOSTER_DROPCHANCE = boosterDropChance;
        Reference.WCT_BOOSTERDROP_ENABLED = boosterDropsEnabled;
        Reference.WCT_MINETWEAKER_OVERRIDE = mineTweakerOverride;
        Reference.WCT_DOVERSIONCHECK = doVersionCheck;
        if (config.hasChanged() || doSave) {
            config.save();
            ConfigHandler.reloadRecipes();
            ConfigHandler.removeBooster();
            ConfigHandler.removeBoosterIcon();
            doSave = false;
        }
    }

    public static void reloadRecipes() {
        RecipeHandler.loadRecipes(mtChanged);
        mtChanged = false;
    }

    public static void removeBoosterIcon() {
        if (Loader.isModLoaded((String)"NotEnoughItems") && !ItemInfo.hiddenItems.contains(ItemEnum.BOOSTER_ICON.getStack())) {
            API.hideItem((ItemStack)ItemEnum.BOOSTER_ICON.getStack());
        }
    }

    public static void removeBooster() {
        if (Reference.WCT_BOOSTER_ENABLED) {
            if (Loader.isModLoaded((String)"NotEnoughItems") && ItemInfo.hiddenItems.contains(ItemEnum.BOOSTER_CARD.getStack())) {
                ItemInfo.hiddenItems.remove(ItemEnum.BOOSTER_CARD.getStack());
            }
            ItemEnum.BOOSTER_CARD.getItem().func_77637_a(WirelessCraftingTerminal.creativeTab);
        } else {
            if (Loader.isModLoaded((String)"NotEnoughItems")) {
                API.hideItem((ItemStack)ItemEnum.BOOSTER_CARD.getStack());
            }
            ItemEnum.BOOSTER_CARD.getItem().func_77637_a(null);
        }
        ItemEnum.WIRELESS_CRAFTING_TERMINAL.getItem().func_77637_a(WirelessCraftingTerminal.creativeTab);
        ItemEnum.MAGNET_CARD.getItem().func_77637_a(WirelessCraftingTerminal.creativeTab);
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("ae2wct")) {
            ConfigHandler.loadConfig();
        }
    }

    static {
        ae2wctMaxPower = Reference.WCT_MAX_POWER;
        boosterDropChance = Reference.WCT_BOOSTER_DROPCHANCE;
        boosterDropsEnabled = Reference.WCT_BOOSTERDROP_ENABLED;
        mineTweakerOverride = Reference.WCT_MINETWEAKER_OVERRIDE;
        doVersionCheck = Reference.WCT_DOVERSIONCHECK;
        firstLoad = true;
        mtChanged = false;
    }
}

