/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import appeng.api.features.IInscriberRecipe;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerUpgradeable;
import appeng.container.interfaces.IProgressProvider;
import appeng.container.slot.SlotOutput;
import appeng.container.slot.SlotRestrictedInput;
import appeng.tile.misc.TileInscriber;
import appeng.util.Platform;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerInscriber
extends ContainerUpgradeable
implements IProgressProvider {
    private final TileInscriber ti;
    private final Slot top;
    private final Slot middle;
    private final Slot bottom;
    @GuiSync(value=2)
    public int maxProcessingTime = -1;
    @GuiSync(value=3)
    public int processingTime = -1;

    public ContainerInscriber(InventoryPlayer ip, TileInscriber te) {
        super(ip, te);
        this.ti = te;
        this.top = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.INSCRIBER_PLATE, (IInventory)this.ti, 0, 45, 16, this.getInventoryPlayer());
        this.func_75146_a(this.top);
        this.bottom = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.INSCRIBER_PLATE, (IInventory)this.ti, 1, 45, 62, this.getInventoryPlayer());
        this.func_75146_a(this.bottom);
        this.middle = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.INSCRIBER_INPUT, (IInventory)this.ti, 2, 63, 39, this.getInventoryPlayer());
        this.func_75146_a(this.middle);
        this.func_75146_a(new SlotOutput((IInventory)this.ti, 3, 113, 40, -1));
    }

    @Override
    protected int getHeight() {
        return 176;
    }

    @Override
    protected void setupConfig() {
        this.setupUpgrades();
    }

    @Override
    protected boolean supportCapacity() {
        return false;
    }

    @Override
    public int availableUpgrades() {
        return 3;
    }

    @Override
    public void func_75142_b() {
        this.standardDetectAndSendChanges();
        if (Platform.isServer()) {
            this.maxProcessingTime = this.ti.getMaxProcessingTime();
            this.processingTime = this.ti.getProcessingTime();
        }
    }

    @Override
    public boolean isValidForSlot(Slot s, ItemStack is) {
        ItemStack top = this.ti.func_70301_a(0);
        ItemStack bot = this.ti.func_70301_a(1);
        if (s == this.middle) {
            for (ItemStack optional : AEApi.instance().registries().inscriber().getOptionals()) {
                if (!TileInscriber.isRecipeEqual(is, optional)) continue;
                return false;
            }
            boolean matches = false;
            boolean found = false;
            for (IInscriberRecipe recipe : AEApi.instance().registries().inscriber().getRecipes()) {
                boolean matchB;
                boolean matchA;
                boolean bl = top == null && !recipe.getTopOptional().isPresent() || TileInscriber.isRecipeEqual(top, (ItemStack)recipe.getTopOptional().orNull()) && (bot == null && !recipe.getBottomOptional().isPresent()) | TileInscriber.isRecipeEqual(bot, (ItemStack)recipe.getBottomOptional().orNull()) ? true : (matchA = false);
                boolean bl2 = bot == null && !recipe.getTopOptional().isPresent() || TileInscriber.isRecipeEqual(bot, (ItemStack)recipe.getTopOptional().orNull()) && (top == null && !recipe.getBottomOptional().isPresent()) | TileInscriber.isRecipeEqual(top, (ItemStack)recipe.getBottomOptional().orNull()) ? true : (matchB = false);
                if (!matchA && !matchB) continue;
                matches = true;
                for (ItemStack option : recipe.getInputs()) {
                    if (!TileInscriber.isRecipeEqual(is, option)) continue;
                    found = true;
                }
            }
            if (matches && !found) {
                return false;
            }
        }
        if (s == this.top && bot != null || s == this.bottom && top != null) {
            ItemStack otherSlot = s == this.top ? this.bottom.func_75211_c() : this.top.func_75211_c();
            IItemDefinition namePress = AEApi.instance().definitions().materials().namePress();
            if (namePress.isSameAs(otherSlot)) {
                return namePress.isSameAs(is);
            }
            boolean isValid = false;
            for (IInscriberRecipe recipe : AEApi.instance().registries().inscriber().getRecipes()) {
                if (TileInscriber.isRecipeEqual(otherSlot, (ItemStack)recipe.getTopOptional().orNull())) {
                    isValid = TileInscriber.isRecipeEqual(is, (ItemStack)recipe.getBottomOptional().orNull());
                } else if (TileInscriber.isRecipeEqual(otherSlot, (ItemStack)recipe.getBottomOptional().orNull())) {
                    isValid = TileInscriber.isRecipeEqual(is, (ItemStack)recipe.getTopOptional().orNull());
                }
                if (!isValid) continue;
                break;
            }
            return isValid;
        }
        return true;
    }

    @Override
    public int getCurrentProgress() {
        return this.processingTime;
    }

    @Override
    public int getMaxProgress() {
        return this.maxProcessingTime;
    }
}

