/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Upgrades;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.ITileDefinition;
import appeng.api.features.IInscriberRecipe;
import appeng.api.features.InscriberProcessType;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.core.features.registries.entries.InscriberRecipe;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.parts.automation.DefinitionUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkPowerTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.WrapperInventoryRange;
import appeng.util.item.AEItemStack;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileInscriber
extends AENetworkPowerTile
implements IGridTickable,
IUpgradeableHost,
IConfigManagerHost {
    private final int maxProcessingTime = 100;
    private final int[] top = new int[]{0};
    private final int[] bottom = new int[]{1};
    private final int[] sides = new int[]{2, 3};
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 4);
    private final IConfigManager settings;
    private final UpgradeInventory upgrades;
    private int processingTime = 0;
    private boolean smash;
    private int finalStep;
    private long clientStart;

    public TileInscriber() {
        this.getProxy().setValidSides(EnumSet.noneOf(ForgeDirection.class));
        this.setInternalMaxPower(1500.0);
        this.getProxy().setIdlePowerUsage(0.0);
        this.settings = new ConfigManager(this);
        ITileDefinition inscriberDefinition = AEApi.instance().definitions().blocks().inscriber();
        this.upgrades = new DefinitionUpgradeInventory(inscriberDefinition, this, this.getUpgradeSlots());
    }

    private int getUpgradeSlots() {
        return 3;
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileInscriber(NBTTagCompound data) {
        this.inv.writeToNBT(data, "inscriberInv");
        this.upgrades.writeToNBT(data, "upgrades");
        this.settings.writeToNBT(data);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileInscriber(NBTTagCompound data) {
        this.inv.readFromNBT(data, "inscriberInv");
        this.upgrades.readFromNBT(data, "upgrades");
        this.settings.readFromNBT(data);
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileInscriber(ByteBuf data) throws IOException {
        boolean newSmash;
        byte slot = data.readByte();
        boolean oldSmash = this.isSmash();
        boolean bl = newSmash = (slot & 0x40) == 64;
        if (oldSmash != newSmash && newSmash) {
            this.setSmash(true);
            this.setClientStart(System.currentTimeMillis());
        }
        for (int num = 0; num < this.inv.func_70302_i_(); ++num) {
            if ((slot & 1 << num) > 0) {
                this.inv.func_70299_a(num, AEItemStack.loadItemStackFromPacket(data).getItemStack());
                continue;
            }
            this.inv.func_70299_a(num, null);
        }
        return false;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileInscriber(ByteBuf data) throws IOException {
        int num;
        int slot = this.isSmash() ? 64 : 0;
        for (num = 0; num < this.inv.func_70302_i_(); ++num) {
            if (this.inv.func_70301_a(num) == null) continue;
            slot |= 1 << num;
        }
        data.writeByte(slot);
        for (num = 0; num < this.inv.func_70302_i_(); ++num) {
            if ((slot & 1 << num) <= 0) continue;
            AEItemStack st = AEItemStack.create(this.inv.func_70301_a(num));
            st.writeToPacket(data);
        }
    }

    @Override
    public void setOrientation(ForgeDirection inForward, ForgeDirection inUp) {
        super.setOrientation(inForward, inUp);
        this.getProxy().setValidSides(EnumSet.complementOf(EnumSet.of(this.getForward())));
        this.setPowerSides(EnumSet.complementOf(EnumSet.of(this.getForward())));
    }

    @Override
    public void getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        super.getDrops(w, x, y, z, drops);
        for (int h = 0; h < this.upgrades.func_70302_i_(); ++h) {
            ItemStack is = this.upgrades.func_70301_a(h);
            if (is == null) continue;
            drops.add(is);
        }
    }

    @Override
    public boolean requiresTESR() {
        return true;
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (this.isSmash()) {
            return false;
        }
        if (i == 0 || i == 1) {
            if (AEApi.instance().definitions().materials().namePress().isSameAs(itemstack)) {
                return true;
            }
            for (ItemStack optionals : AEApi.instance().registries().inscriber().getOptionals()) {
                if (!TileInscriber.isRecipeEqual(itemstack, optionals)) continue;
                return true;
            }
        }
        return i == 2;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        try {
            if (mc != InvOperation.markDirty) {
                if (slot != 3) {
                    this.setProcessingTime(0);
                }
                if (!this.isSmash()) {
                    this.markForUpdate();
                }
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public boolean func_102008_b(int slotIndex, ItemStack extractedItem, int side) {
        if (this.isSmash()) {
            return false;
        }
        return slotIndex == 0 || slotIndex == 1 || slotIndex == 3;
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection d) {
        if (d == ForgeDirection.UP) {
            return this.top;
        }
        return d == ForgeDirection.DOWN ? this.bottom : this.sides;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Inscriber.getMin(), TickRates.Inscriber.getMax(), !this.hasWork(), false);
    }

    private boolean hasWork() {
        if (this.getTask() != null) {
            return true;
        }
        this.setProcessingTime(0);
        return this.isSmash();
    }

    @Nullable
    public IInscriberRecipe getTask() {
        ItemStack plateA = this.func_70301_a(0);
        ItemStack plateB = this.func_70301_a(1);
        ItemStack renamedItem = this.func_70301_a(2);
        if (plateA != null && plateA.field_77994_a > 1) {
            return null;
        }
        if (plateB != null && plateB.field_77994_a > 1) {
            return null;
        }
        if (renamedItem != null && renamedItem.field_77994_a > 1) {
            return null;
        }
        IItemDefinition namePress = AEApi.instance().definitions().materials().namePress();
        boolean isNameA = namePress.isSameAs(plateA);
        boolean isNameB = namePress.isSameAs(plateB);
        if ((isNameA || isNameB) && (isNameA || plateA == null) && (isNameB || plateB == null) && renamedItem != null) {
            NBTTagCompound tag;
            String name = "";
            if (plateA != null) {
                tag = Platform.openNbtData(plateA);
                name = name + tag.func_74779_i("InscribeName");
            }
            if (plateB != null) {
                tag = Platform.openNbtData(plateB);
                if (name.length() > 0) {
                    name = name + " ";
                }
                name = name + tag.func_74779_i("InscribeName");
            }
            ItemStack startingItem = renamedItem.func_77946_l();
            renamedItem = renamedItem.func_77946_l();
            NBTTagCompound tag2 = Platform.openNbtData(renamedItem);
            NBTTagCompound display = tag2.func_74775_l("display");
            tag2.func_74782_a("display", (NBTBase)display);
            if (name.length() > 0) {
                display.func_74778_a("Name", name);
            } else {
                display.func_82580_o("Name");
            }
            ArrayList inputs = Lists.newArrayList((Object[])new ItemStack[]{startingItem});
            InscriberProcessType type = InscriberProcessType.Inscribe;
            return new InscriberRecipe(inputs, renamedItem, plateA, plateB, type);
        }
        for (IInscriberRecipe recipe : AEApi.instance().registries().inscriber().getRecipes()) {
            boolean matchB;
            boolean matchA;
            boolean bl = plateA == null && !recipe.getTopOptional().isPresent() || TileInscriber.isRecipeEqual(plateA, (ItemStack)recipe.getTopOptional().orNull()) && (plateB == null && !recipe.getBottomOptional().isPresent()) | TileInscriber.isRecipeEqual(plateB, (ItemStack)recipe.getBottomOptional().orNull()) ? true : (matchA = false);
            boolean bl2 = plateB == null && !recipe.getTopOptional().isPresent() || TileInscriber.isRecipeEqual(plateB, (ItemStack)recipe.getTopOptional().orNull()) && (plateA == null && !recipe.getBottomOptional().isPresent()) | TileInscriber.isRecipeEqual(plateA, (ItemStack)recipe.getBottomOptional().orNull()) ? true : (matchB = false);
            if (!matchA && !matchB) continue;
            for (ItemStack option : recipe.getInputs()) {
                if (!TileInscriber.isRecipeEqual(this.func_70301_a(2), option)) continue;
                return recipe;
            }
        }
        return null;
    }

    public static boolean isRecipeEqual(ItemStack suggestedItem, ItemStack recipeItem) {
        if (recipeItem == null) {
            return suggestedItem == null;
        }
        if (suggestedItem == null) {
            return false;
        }
        if (recipeItem.func_77973_b() != suggestedItem.func_77973_b()) {
            return false;
        }
        int requiredDmg = recipeItem.func_77960_j();
        if (requiredDmg != Short.MAX_VALUE && requiredDmg != suggestedItem.func_77960_j()) {
            return false;
        }
        return recipeItem.field_77990_d == null || recipeItem.field_77990_d.equals((Object)suggestedItem.field_77990_d);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.isSmash()) {
            ++this.finalStep;
            if (this.finalStep == 8) {
                IInscriberRecipe out = this.getTask();
                if (out != null) {
                    ItemStack outputCopy = out.getOutput().func_77946_l();
                    InventoryAdaptor ad = InventoryAdaptor.getAdaptor(new WrapperInventoryRange(this.inv, 3, 1, true), ForgeDirection.UNKNOWN);
                    if (ad.addItems(outputCopy) == null) {
                        this.setProcessingTime(0);
                        if (out.getProcessType() == InscriberProcessType.Press) {
                            this.func_70299_a(0, null);
                            this.func_70299_a(1, null);
                        }
                        this.func_70299_a(2, null);
                    }
                }
                this.func_70296_d();
            } else if (this.finalStep == 16) {
                this.finalStep = 0;
                this.setSmash(false);
                this.markForUpdate();
            }
        } else {
            try {
                IEnergyGrid eg = this.getProxy().getEnergy();
                IEnergySource src = this;
                int speedFactor = 1 + this.upgrades.getInstalledUpgrades(Upgrades.SPEED);
                int powerConsumption = 10 * speedFactor;
                double powerThreshold = (double)powerConsumption - 0.01;
                double powerReq = this.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                if (powerReq <= powerThreshold) {
                    src = eg;
                    powerReq = eg.extractAEPower((double)powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                }
                if (powerReq > powerThreshold) {
                    src.extractAEPower(powerConsumption, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    if (this.getProcessingTime() == 0) {
                        this.setProcessingTime(this.getProcessingTime() + speedFactor);
                    } else {
                        this.setProcessingTime(this.getProcessingTime() + ticksSinceLastCall * speedFactor);
                    }
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            if (this.getProcessingTime() > this.getMaxProcessingTime()) {
                this.setProcessingTime(this.getMaxProcessingTime());
                IInscriberRecipe out = this.getTask();
                if (out != null) {
                    ItemStack outputCopy = out.getOutput().func_77946_l();
                    InventoryAdaptor ad = InventoryAdaptor.getAdaptor(new WrapperInventoryRange(this.inv, 3, 1, true), ForgeDirection.UNKNOWN);
                    if (ad.simulateAdd(outputCopy) == null) {
                        this.setSmash(true);
                        this.finalStep = 0;
                        this.markForUpdate();
                    }
                }
            }
        }
        return this.hasWork() ? TickRateModulation.URGENT : TickRateModulation.SLEEP;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.settings;
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("inv")) {
            return this.inv;
        }
        return name.equals("upgrades") ? this.upgrades : null;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    public long getClientStart() {
        return this.clientStart;
    }

    private void setClientStart(long clientStart) {
        this.clientStart = clientStart;
    }

    public boolean isSmash() {
        return this.smash;
    }

    public void setSmash(boolean smash) {
        this.smash = smash;
    }

    public int getMaxProcessingTime() {
        return 100;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    private void setProcessingTime(int processingTime) {
        this.processingTime = processingTime;
    }
}

