/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.render;

import buildcraft.api.core.Position;
import buildcraft.core.EntityLaser;
import buildcraft.core.LaserData;
import buildcraft.core.lib.render.RenderEntityBlock;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderLaser
extends Render {
    public static final float STEP = 0.04f;
    protected static ModelBase model = new ModelBase(){};
    private static ModelRenderer[] box;
    private static int[][][] scaledBoxes;

    public static void onTextureReload() {
        scaledBoxes = null;
    }

    private static ModelRenderer getBox(int index) {
        if (box == null) {
            box = new ModelRenderer[40];
            for (int j = 0; j < box.length; ++j) {
                RenderLaser.box[j] = new ModelRenderer(model, box.length - j, 0);
                box[j].func_78789_a(0.0f, -0.5f, -0.5f, 16, 1, 1);
                RenderLaser.box[j].field_78800_c = 0.0f;
                RenderLaser.box[j].field_78797_d = 0.0f;
                RenderLaser.box[j].field_78798_e = 0.0f;
            }
        }
        return box[index];
    }

    private static void initScaledBoxes() {
        if (scaledBoxes == null) {
            scaledBoxes = new int[2][100][20];
            for (int flags = 0; flags < 2; ++flags) {
                for (int size = 0; size < 100; ++size) {
                    for (int i = 0; i < 20; ++i) {
                        RenderLaser.scaledBoxes[flags][size][i] = GLAllocation.func_74526_a((int)1);
                        GL11.glNewList((int)scaledBoxes[flags][size][i], (int)4864);
                        RenderEntityBlock.RenderInfo block = new RenderEntityBlock.RenderInfo();
                        float minSize = 0.2f * (float)size / 100.0f;
                        float maxSize = 0.4f * (float)size / 100.0f;
                        float range = maxSize - minSize;
                        float diff = MathHelper.func_76134_b((float)((float)i / 20.0f * 2.0f * (float)Math.PI)) * range / 2.0f;
                        block.minX = 0.0;
                        block.minY = -maxSize / 2.0f + diff;
                        block.minZ = -maxSize / 2.0f + diff;
                        block.maxX = 0.04f;
                        block.maxY = maxSize / 2.0f - diff;
                        block.maxZ = maxSize / 2.0f - diff;
                        if (flags == 1) {
                            block.brightness = 15;
                        }
                        RenderEntityBlock.INSTANCE.renderBlock(block);
                        GL11.glEndList();
                    }
                }
            }
        }
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float f, float f1) {
        this.doRender((EntityLaser)entity, x, y, z, f, f1);
    }

    private void doRender(EntityLaser laser, double x, double y, double z, float f, float f1) {
        if (!laser.isVisible() || laser.getTexture() == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        Position offset = laser.renderOffset();
        GL11.glTranslated((double)(x + offset.x), (double)(y + offset.y), (double)(z + offset.z));
        RenderLaser.doRenderLaser(this.field_76990_c.field_78724_e, laser.data, laser.getTexture());
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public static void doRenderLaserWave(TextureManager textureManager, LaserData laser, ResourceLocation texture) {
        if (!laser.isVisible || texture == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)laser.head.x, (double)laser.head.y, (double)laser.head.z);
        laser.update();
        GL11.glRotatef((float)((float)laser.angleZ), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)laser.angleY), (float)0.0f, (float)0.0f, (float)1.0f);
        textureManager.func_110577_a(texture);
        int indexList = 0;
        RenderLaser.initScaledBoxes();
        double x1 = laser.wavePosition;
        double x2 = x1 + (double)((float)scaledBoxes[0][0].length * 0.04f);
        double x3 = laser.renderSize;
        RenderLaser.doRenderLaserLine(x1, laser.laserTexAnimation);
        for (double i = x1; i <= x2 && i <= laser.renderSize; i += (double)0.04f) {
            GL11.glCallList((int)scaledBoxes[laser.isGlowing ? 1 : 0][(int)(laser.waveSize * 99.0f)][indexList]);
            indexList = (indexList + 1) % scaledBoxes[0][0].length;
            GL11.glTranslated((double)0.04f, (double)0.0, (double)0.0);
        }
        if (x2 < x3) {
            RenderLaser.doRenderLaserLine(x3 - x2, laser.laserTexAnimation);
        }
        GL11.glPopMatrix();
    }

    public static void doRenderLaser(TextureManager textureManager, LaserData laser, ResourceLocation texture) {
        if (!laser.isVisible || texture == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)laser.head.x, (double)laser.head.y, (double)laser.head.z);
        laser.update();
        GL11.glRotatef((float)((float)laser.angleZ), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)laser.angleY), (float)0.0f, (float)0.0f, (float)1.0f);
        textureManager.func_110577_a(texture);
        RenderLaser.initScaledBoxes();
        if (laser.isGlowing) {
            float lastBrightnessX = OpenGlHelper.lastBrightnessX;
            float lastBrightnessY = OpenGlHelper.lastBrightnessY;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glDisable((int)2896);
            RenderLaser.doRenderLaserLine(laser.renderSize, laser.laserTexAnimation);
            GL11.glEnable((int)2896);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
        } else {
            RenderLaser.doRenderLaserLine(laser.renderSize, laser.laserTexAnimation);
        }
        GL11.glPopMatrix();
    }

    private static void doRenderLaserLine(double len, int texId) {
        float lasti = 0.0f;
        if (len - 1.0 > 0.0) {
            float i = 0.0f;
            while ((double)i <= len - 1.0) {
                RenderLaser.getBox(texId).func_78785_a(0.0625f);
                GL11.glTranslated((double)1.0, (double)0.0, (double)0.0);
                lasti = i;
                i += 1.0f;
            }
            lasti += 1.0f;
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)((float)len - lasti), (float)1.0f, (float)1.0f);
        RenderLaser.getBox(texId).func_78785_a(0.0625f);
        GL11.glPopMatrix();
        GL11.glTranslated((double)((float)(len - (double)lasti)), (double)0.0, (double)0.0);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return ((EntityLaser)entity).getTexture();
    }
}

