/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.containers.IRedstoneStatementContainer;
import buildcraft.api.statements.containers.ISidedStatementContainer;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.statements.BCStatement;
import buildcraft.core.statements.StatementParameterRedstoneGateSideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerRedstoneInput
extends BCStatement
implements ITriggerInternal {
    boolean active;

    public TriggerRedstoneInput(boolean active) {
        super("buildcraft:redstone.input." + (active ? "active" : "inactive"), active ? "buildcraft.redtone.input.active" : "buildcraft.redtone.input.inactive");
        this.active = active;
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.trigger.redstone.input." + (this.active ? "active" : "inactive"));
    }

    @Override
    public IStatementParameter createParameter(int index) {
        StatementParameterRedstoneGateSideOnly param = null;
        if (index == 0) {
            param = new StatementParameterRedstoneGateSideOnly();
        }
        return param;
    }

    @Override
    public int maxParameters() {
        return 1;
    }

    @Override
    public boolean isTriggerActive(IStatementContainer container, IStatementParameter[] parameters) {
        if (container instanceof IRedstoneStatementContainer) {
            int level = ((IRedstoneStatementContainer)((Object)container)).getRedstoneInput(ForgeDirection.UNKNOWN);
            if (parameters.length > 0 && parameters[0] instanceof StatementParameterRedstoneGateSideOnly && ((StatementParameterRedstoneGateSideOnly)parameters[0]).isOn && container instanceof ISidedStatementContainer) {
                level = ((IRedstoneStatementContainer)((Object)container)).getRedstoneInput(((ISidedStatementContainer)container).getSide());
            }
            return this.active ? level > 0 : level == 0;
        }
        return false;
    }

    @Override
    public void registerIcons(IIconRegister register) {
        this.icon = register.func_94245_a("buildcraftcore:triggers/trigger_redstoneinput_" + (this.active ? "active" : "inactive"));
    }
}

