/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.map;

import buildcraft.core.lib.utils.Utils;
import buildcraft.robotics.map.MapWorld;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.Date;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class MapManager
implements Runnable {
    private static final int UPDATE_DELAY = 60000;
    private final HashBiMap<World, MapWorld> worldMap = HashBiMap.create();
    private final File location;
    private boolean stop = false;
    private long lastSaveTime;

    public MapManager(File location) {
        this.location = location;
    }

    public void stop() {
        this.stop = true;
        this.saveAllWorlds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapWorld getWorld(World world) {
        if (world == null || world.field_72995_K) {
            return null;
        }
        if (!this.worldMap.containsKey((Object)world)) {
            HashBiMap<World, MapWorld> hashBiMap = this.worldMap;
            synchronized (hashBiMap) {
                this.worldMap.put((Object)world, (Object)new MapWorld(world, this.location));
            }
        }
        return (MapWorld)this.worldMap.get((Object)world);
    }

    private boolean doUpdate(MapWorld world, Chunk chunk) {
        int x = chunk.field_76635_g;
        int z = chunk.field_76647_h;
        long updateTime = new Date().getTime() - 60000L;
        return world.getUpdateTime(x, z) < updateTime || !world.hasChunk(x, z);
    }

    private void updateChunk(World rworld, Chunk chunk, boolean force) {
        MapWorld world = this.getWorld(rworld);
        if (world != null && (force || this.doUpdate(world, chunk))) {
            world.updateChunk(chunk);
        }
    }

    private void updateChunkDelayed(World rworld, Chunk chunk, boolean force, byte time) {
        MapWorld world = this.getWorld(rworld);
        if (world != null && (force || this.doUpdate(world, chunk))) {
            world.updateChunkDelayed(chunk, time);
        }
    }

    @SubscribeEvent
    public void tickDelayedWorlds(TickEvent.WorldTickEvent event) {
        MapWorld w;
        if (event.phase == TickEvent.Phase.END && event.side == Side.SERVER && (w = (MapWorld)this.worldMap.get((Object)event.world)) != null) {
            w.tick();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void worldUnloaded(WorldEvent.Unload event) {
        if (this.worldMap.containsKey((Object)event.world)) {
            ((MapWorld)this.worldMap.get((Object)event.world)).save();
            HashBiMap<World, MapWorld> hashBiMap = this.worldMap;
            synchronized (hashBiMap) {
                this.worldMap.remove((Object)event.world);
            }
        }
    }

    @SubscribeEvent
    public void chunkLoaded(ChunkEvent.Load event) {
        this.updateChunkDelayed(event.world, event.getChunk(), false, (byte)(40 + Utils.RANDOM.nextInt(20)));
    }

    @SubscribeEvent
    public void chunkUnloaded(ChunkEvent.Unload event) {
        this.updateChunk(event.world, event.getChunk(), false);
    }

    @SubscribeEvent
    public void blockPlaced(BlockEvent.PlaceEvent placeEvent) {
        int hv;
        Chunk chunk = placeEvent.world.func_72938_d(placeEvent.x, placeEvent.z);
        MapWorld world = this.getWorld(placeEvent.world);
        if (world != null && this.doUpdate(world, chunk) && placeEvent.y >= (hv = placeEvent.world.func_72976_f(placeEvent.x, placeEvent.z)) - 3) {
            world.updateChunk(chunk);
        }
    }

    @SubscribeEvent
    public void blockBroken(BlockEvent.BreakEvent placeEvent) {
        int hv;
        Chunk chunk = placeEvent.world.func_72938_d(placeEvent.x, placeEvent.z);
        MapWorld world = this.getWorld(placeEvent.world);
        if (world != null && this.doUpdate(world, chunk) && placeEvent.y >= (hv = placeEvent.world.func_72976_f(placeEvent.x, placeEvent.z)) - 3) {
            world.updateChunk(chunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAllWorlds() {
        HashBiMap<World, MapWorld> hashBiMap = this.worldMap;
        synchronized (hashBiMap) {
            for (MapWorld world : this.worldMap.values()) {
                world.save();
            }
        }
    }

    @Override
    public void run() {
        this.lastSaveTime = new Date().getTime();
        while (!this.stop) {
            long now = new Date().getTime();
            if (now - this.lastSaveTime > 120000L) {
                this.saveAllWorlds();
                this.lastSaveTime = now;
            }
            try {
                Thread.sleep(4000L);
            }
            catch (Exception exception) {}
        }
    }

    public void initialize() {
        for (WorldServer ws : DimensionManager.getWorlds()) {
            MapWorld mw = this.getWorld((World)ws);
            IChunkProvider provider = ws.func_72863_F();
            if (!(provider instanceof ChunkProviderServer)) continue;
            for (Object o : ((ChunkProviderServer)provider).func_152380_a()) {
                if (o == null || !(o instanceof Chunk)) continue;
                Chunk c = (Chunk)o;
                if (mw.hasChunk(c.field_76635_g, c.field_76647_h)) continue;
                mw.updateChunkDelayed(c, (byte)(40 + Utils.RANDOM.nextInt(20)));
            }
        }
    }
}

