/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.inventory.ITransactor;
import buildcraft.core.lib.inventory.Transactor;
import buildcraft.core.lib.inventory.filters.StackFilter;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TransportProxy;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.utils.TransportUtils;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsObsidian
extends Pipe<PipeTransportItems>
implements IEnergyHandler {
    private final RFBattery battery = new RFBattery(2560, 640, 0);
    private final WeakHashMap<Entity, Long> entityDropTime = new WeakHashMap();

    public PipeItemsObsidian(Item item) {
        super(new PipeTransportItems(), item);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return PipeIconProvider.TYPE.PipeItemsObsidian.ordinal();
    }

    @Override
    public void onEntityCollidedWithBlock(Entity entity) {
        super.onEntityCollidedWithBlock(entity);
        if (entity.field_70128_L) {
            return;
        }
        if (this.canSuck(entity, 0)) {
            this.pullItemIntoPipe(entity, 0);
        }
    }

    private AxisAlignedBB getSuckingBox(ForgeDirection orientation, int distance) {
        if (orientation == ForgeDirection.UNKNOWN) {
            return null;
        }
        Position p1 = new Position(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, orientation);
        Position p2 = new Position(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, orientation);
        switch (orientation) {
            case EAST: {
                p1.x += (double)distance;
                p2.x += (double)(1 + distance);
                break;
            }
            case WEST: {
                p1.x -= (double)(distance - 1);
                p2.x -= (double)distance;
                break;
            }
            case UP: 
            case DOWN: {
                p1.x += (double)(distance + 1);
                p2.x -= (double)distance;
                p1.z += (double)(distance + 1);
                p2.z -= (double)distance;
                break;
            }
            case SOUTH: {
                p1.z += (double)distance;
                p2.z += (double)(distance + 1);
                break;
            }
            default: {
                p1.z -= (double)(distance - 1);
                p2.z -= (double)distance;
            }
        }
        switch (orientation) {
            case EAST: 
            case WEST: {
                p1.y += (double)(distance + 1);
                p2.y -= (double)distance;
                p1.z += (double)(distance + 1);
                p2.z -= (double)distance;
                break;
            }
            case UP: {
                p1.y += (double)(distance + 1);
                p2.y += (double)distance;
                break;
            }
            case DOWN: {
                p1.y -= (double)(distance - 1);
                p2.y -= (double)distance;
                break;
            }
            default: {
                p1.y += (double)(distance + 1);
                p2.y -= (double)distance;
                p1.x += (double)(distance + 1);
                p2.x -= (double)distance;
            }
        }
        Position min = p1.min(p2);
        Position max = p1.max(p2);
        return AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.battery.getEnergyStored() > 0) {
            for (int j = 1; j < 5; ++j) {
                if (!this.suckItem(j)) continue;
                return;
            }
            this.battery.useEnergy(0, 5, false);
        }
    }

    private boolean suckItem(int distance) {
        AxisAlignedBB box = this.getSuckingBox(this.getOpenOrientation(), distance);
        if (box == null) {
            return false;
        }
        List discoveredEntities = this.container.func_145831_w().func_72872_a(Entity.class, box);
        for (Entity entity : discoveredEntities) {
            ForgeDirection openOrientation;
            ITransactor trans;
            ItemStack stack;
            if (this.canSuck(entity, distance)) {
                this.pullItemIntoPipe(entity, distance);
                return true;
            }
            if (distance != 1 || !(entity instanceof EntityMinecart) || !(entity instanceof IInventory)) continue;
            EntityMinecart cart = (EntityMinecart)entity;
            if (cart.field_70128_L || (stack = (trans = Transactor.getTransactorFor(cart)).remove(StackFilter.ALL, openOrientation = this.getOpenOrientation(), false)) == null || this.battery.useEnergy(10, 10, false) <= 0) continue;
            stack = trans.remove(StackFilter.ALL, openOrientation, true);
            if (stack != null) {
                TravelingItem item = TravelingItem.make((double)this.container.field_145851_c + 0.5, (float)this.container.field_145848_d + TransportUtils.getPipeFloorOf(stack), (double)this.container.field_145849_e + 0.5, stack);
                ((PipeTransportItems)this.transport).injectItem(item, openOrientation.getOpposite());
            }
            return true;
        }
        return false;
    }

    public void pullItemIntoPipe(Entity entity, int distance) {
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        ForgeDirection orientation = this.getOpenOrientation().getOpposite();
        if (orientation != ForgeDirection.UNKNOWN) {
            ItemStack stack;
            Object item;
            this.container.func_145831_w().func_72956_a(entity, "random.pop", 0.2f, ((this.container.func_145831_w().field_73012_v.nextFloat() - this.container.func_145831_w().field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            double speed = 0.01f;
            if (entity instanceof EntityItem) {
                item = (EntityItem)entity;
                ItemStack contained = item.func_92059_d();
                if (contained == null) {
                    return;
                }
                TransportProxy.proxy.obsidianPipePickup(this.container.func_145831_w(), (EntityItem)item, this.container);
                int energyUsed = Math.min(10 * contained.field_77994_a * distance, this.battery.getEnergyStored());
                if (distance == 0 || energyUsed / distance / 10 == contained.field_77994_a) {
                    stack = contained;
                    CoreProxy.proxy.removeEntity(entity);
                } else {
                    stack = contained.func_77979_a(energyUsed / distance / 10);
                }
                this.battery.useEnergy(energyUsed, energyUsed, false);
                speed = Math.sqrt(((EntityItem)item).field_70159_w * ((EntityItem)item).field_70159_w + ((EntityItem)item).field_70181_x * ((EntityItem)item).field_70181_x + ((EntityItem)item).field_70179_y * ((EntityItem)item).field_70179_y);
                speed = speed / 2.0 - 0.05;
                if (speed < 0.01) {
                    speed = 0.01;
                }
            } else if (entity instanceof EntityArrow && this.battery.useEnergy(distance * 10, distance * 10, false) > 0) {
                stack = new ItemStack(Items.field_151032_g, 1);
                CoreProxy.proxy.removeEntity(entity);
            } else {
                return;
            }
            if (stack == null) {
                return;
            }
            item = TravelingItem.make((double)this.container.field_145851_c + 0.5, (float)this.container.field_145848_d + TransportUtils.getPipeFloorOf(stack), (double)this.container.field_145849_e + 0.5, stack);
            ((TravelingItem)item).setSpeed((float)speed);
            ((PipeTransportItems)this.transport).injectItem((TravelingItem)item, orientation);
        }
    }

    public void eventHandler(PipeEventItem.DropItem event) {
        this.entityDropTime.put((Entity)event.entity, event.entity.field_70170_p.func_82737_E() + 200L);
    }

    public boolean canSuck(Entity entity, int distance) {
        if (!entity.func_70089_S()) {
            return false;
        }
        if (entity instanceof EntityItem) {
            EntityItem item = (EntityItem)entity;
            if (item.func_92059_d().field_77994_a <= 0) {
                return false;
            }
            long wt = entity.field_70170_p.func_82737_E();
            if (this.entityDropTime.containsKey(entity) && this.entityDropTime.get(entity) >= wt) {
                return false;
            }
            return this.battery.getEnergyStored() >= distance * 10;
        }
        if (entity instanceof EntityArrow) {
            EntityArrow arrow = (EntityArrow)entity;
            return arrow.field_70251_a == 1 && this.battery.getEnergyStored() >= distance * 10;
        }
        return false;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.battery.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.battery.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.battery.getMaxEnergyStored();
    }
}

