/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBeeIconProvider;
import forestry.core.render.TextureManager;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import org.apache.logging.log4j.Level;

public class DefaultBeeIconProvider
implements IBeeIconProvider {
    public static final DefaultBeeIconProvider instance = new DefaultBeeIconProvider();
    private static final IIcon[][] icons = new IIcon[EnumBeeType.values().length][3];

    private DefaultBeeIconProvider() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        String beeIconDir = "bees/default/";
        IIcon body1 = TextureManager.registerTex(register, beeIconDir + "body1");
        for (int i = 0; i < EnumBeeType.values().length; ++i) {
            EnumBeeType beeType = EnumBeeType.values()[i];
            if (beeType == EnumBeeType.NONE) continue;
            String beeTypeNameBase = beeIconDir + beeType.toString().toLowerCase(Locale.ENGLISH);
            DefaultBeeIconProvider.icons[i][0] = TextureManager.registerTex(register, beeTypeNameBase + ".outline");
            DefaultBeeIconProvider.icons[i][1] = beeType == EnumBeeType.LARVAE ? TextureManager.registerTex(register, beeTypeNameBase + ".body") : body1;
            DefaultBeeIconProvider.icons[i][2] = TextureManager.registerTex(register, beeTypeNameBase + ".body2");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(EnumBeeType type, int renderPass) {
        try {
            return icons[type.ordinal()][renderPass];
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (String)"\u041f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0442\u0435\u043a\u0441\u0442\u0443\u0440\u044b \u043f\u0447\u0435\u043b\u044b \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430, \u0432\u044b\u0434\u0430\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e. EnumBeeType: %s, renderPass: %s", (Object[])new Object[]{type.toString(), renderPass});
            return icons[0][0];
        }
    }
}

