/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpeciesCustom;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.lepidopterology.genetics.Butterfly;
import forestry.lepidopterology.genetics.ButterflyBranchDefinition;
import forestry.lepidopterology.genetics.IButterflyDefinition;
import java.awt.Color;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.item.ItemStack;

public enum MothDefinition implements IButterflyDefinition
{
    Brimstone(ButterflyBranchDefinition.Opisthograptis, "brimstone", "luteolata", new Color(16771648), true, 1.0f),
    LatticedHeath(ButterflyBranchDefinition.Chiasmia, "latticeHeath", "clathrata", new Color(15921342), true, 0.5f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.SMALLEST);
        }
    }
    ,
    Atlas(ButterflyBranchDefinition.Attacus, "atlas", "atlas", new Color(14249533), false, 0.1f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.LARGEST);
        }
    };

    private final IAlleleButterflySpeciesCustom species;
    private final ButterflyBranchDefinition branch;
    private IAllele[] template;
    private IButterflyGenome genome;

    private MothDefinition(ButterflyBranchDefinition branchDefinition, String speciesName, String binomial, Color serumColor, boolean dominant, float rarity) {
        this.branch = branchDefinition;
        String uid = "moth" + this.name();
        IClassification parent = this.branch.getBranch().getParent();
        String unlocalizedName = "for.butterflies.species." + parent.getUID().substring(parent.getLevel().name().toLowerCase(Locale.ENGLISH).length() + 1) + '.' + speciesName;
        String unlocalizedDescription = "for.description." + uid;
        String texture = "forestry:textures/entity/butterflies/" + uid + ".png";
        this.species = ButterflyManager.butterflyFactory.createSpecies("forestry." + uid, unlocalizedName, "Sengir", unlocalizedDescription, texture, dominant, branchDefinition.getBranch(), binomial, serumColor);
        this.species.setRarity(rarity);
        this.species.setNocturnal();
    }

    public static void initMoths() {
        for (MothDefinition butterfly : MothDefinition.values()) {
            butterfly.init();
        }
    }

    private void init() {
        this.setSpeciesProperties(this.species);
        this.template = this.branch.getTemplate();
        AlleleHelper.instance.set(this.template, EnumButterflyChromosome.SPECIES, this.species);
        this.setAlleles(this.template);
        this.genome = ButterflyManager.butterflyRoot.templateAsGenome(this.template);
        ButterflyManager.butterflyRoot.registerTemplate(this.template);
    }

    protected void setSpeciesProperties(IAlleleButterflySpeciesCustom species) {
    }

    protected void setAlleles(IAllele[] alleles) {
    }

    @Override
    public final IAllele[] getTemplate() {
        return Arrays.copyOf(this.template, this.template.length);
    }

    @Override
    public final IButterflyGenome getGenome() {
        return this.genome;
    }

    @Override
    public final IButterfly getIndividual() {
        return new Butterfly(this.genome);
    }

    @Override
    public final ItemStack getMemberStack(EnumFlutterType flutterType) {
        IButterfly butterfly = this.getIndividual();
        return ButterflyManager.butterflyRoot.getMemberStack(butterfly, flutterType.ordinal());
    }
}

