/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.enums;

import gregtech.api.util.GT_Utility;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;

public enum DamageSources {
    ELECTRIC(null, GT_Utility::isWearingFullElectroHazmat, "track.electric"),
    GAS(null, GT_Utility::isWearingFullGasHazmat, new String[0]),
    BIO(tag -> tag.startsWith("bee."), GT_Utility::isWearingFullBioHazmat, new String[0]),
    HEAT(null, GT_Utility::isWearingFullHeatHazmat, new String[0]),
    FROST(null, GT_Utility::isWearingFullFrostHazmat, new String[0]),
    RADIO(null, GT_Utility::isWearingFullRadioHazmat, new String[0]),
    TRAINS(null, GT_Utility::isWearingFullQuantumArmor, "train"),
    DUMMY(null, null, new String[0]);

    static HashMap<String, DamageSources> sources;
    public Set<String> tags;
    DamageSourceInterpreter interpreter;
    DamageSourceApplier applier;

    private DamageSources(DamageSourceInterpreter interpreter, DamageSourceApplier applier, String ... tags) {
        if (interpreter == null) {
            interpreter = tag -> false;
        }
        if (applier == null) {
            applier = entity -> false;
        }
        this.tags = new HashSet<String>();
        this.tags.addAll(Arrays.asList(tags));
        this.applier = applier;
        this.interpreter = interpreter;
    }

    public boolean corresponds(String tag) {
        return this.tags.contains(tag) || this.interpreter.isSource(tag);
    }

    public boolean isProtected(EntityLivingBase entity) {
        return this.applier.isProtected(entity);
    }

    public static DamageSources determineSource(String tag) {
        DamageSources source = sources.get(tag);
        if (source == null) {
            for (DamageSources s : DamageSources.values()) {
                if (!s.corresponds(tag)) continue;
                sources.put(tag, s);
                return s;
            }
            sources.put(tag, DUMMY);
            return DUMMY;
        }
        return source;
    }

    public static boolean isProtected(String source, EntityLivingBase entity) {
        return DamageSources.determineSource(source).isProtected(entity);
    }

    static {
        sources = new HashMap();
    }

    protected static interface DamageSourceApplier {
        public boolean isProtected(EntityLivingBase var1);
    }

    protected static interface DamageSourceInterpreter {
        public boolean isSource(String var1);
    }
}

