/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui;

import gregtech.api.gui.GT_Container_MultiMachine;
import gregtech.api.gui.GT_GUIContainerMetaTile_Machine;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_DrillerBase;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_LargeTurbine;
import java.util.Arrays;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;

public class GT_GUIContainer_MultiMachine
extends GT_GUIContainerMetaTile_Machine {
    String mName = "";
    ResourceLocation mProgressIcon = new ResourceLocation("gregtech:textures/gui/multimachines/Progress.png");

    public GT_GUIContainer_MultiMachine(InventoryPlayer aInventoryPlayer, IGregTechTileEntity aTileEntity, String aName, String aTextureFile) {
        super(new GT_Container_MultiMachine(aInventoryPlayer, aTileEntity), "gregtech:textures/gui/multimachines/" + (aTextureFile == null ? "MultiblockDisplay" : aTextureFile));
        this.mName = aName;
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        int x = par1 - xStart;
        int y = par2 - yStart;
        if (this.field_147002_h.func_75139_a(1) != null && this.isTheMouseOverSlot(this.field_147002_h.func_75139_a(1), x, y)) {
            this.drawHoveringText(Arrays.asList(this.getButtonToolTip()), par1, par2, this.field_146289_q);
            RenderHelper.func_74520_c();
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        this.field_146289_q.func_78276_b(this.mName, 10, 8, 0xFAFAFF);
        if (this.mContainer != null) {
            if ((this.mContainer.mDisplayErrorCode & 1) != 0) {
                this.field_146289_q.func_78276_b(this.transGui("132"), 10, 16, 0xFAFAFF);
            }
            if ((this.mContainer.mDisplayErrorCode & 2) != 0) {
                this.field_146289_q.func_78276_b(this.transGui("133"), 10, 24, 0xFAFAFF);
            }
            if ((this.mContainer.mDisplayErrorCode & 4) != 0) {
                this.field_146289_q.func_78276_b(this.transGui("134"), 10, 32, 0xFAFAFF);
            }
            if ((this.mContainer.mDisplayErrorCode & 8) != 0) {
                this.field_146289_q.func_78276_b(this.transGui("135"), 10, 40, 0xFAFAFF);
            }
            if ((this.mContainer.mDisplayErrorCode & 0x10) != 0) {
                this.field_146289_q.func_78276_b(this.transGui("136"), 10, 56, 0xFAFAFF);
            }
            if ((this.mContainer.mDisplayErrorCode & 0x20) != 0) {
                this.field_146289_q.func_78276_b(this.transGui("137"), 10, 48, 0xFAFAFF);
            }
            if ((this.mContainer.mDisplayErrorCode & 0x40) != 0) {
                this.field_146289_q.func_78276_b(this.transGui("138"), 10, 64, 0xFAFAFF);
            }
            if (this.mContainer.mDisplayErrorCode == 0) {
                ItemStack tItem;
                if (this.mContainer.mActive == 0) {
                    this.field_146289_q.func_78276_b(this.transGui("139"), 10, 16, 0xFAFAFF);
                    this.field_146289_q.func_78276_b(this.transGui("140"), 10, 24, 0xFAFAFF);
                    this.field_146289_q.func_78276_b(this.transGui("141"), 10, 32, 0xFAFAFF);
                } else {
                    this.field_146289_q.func_78276_b(this.transGui("142"), 10, 18, 0xFAFAFF);
                    this.field_146289_q.func_78276_b(this.transGui("145") + " " + EnumChatFormatting.GREEN + this.mContainer.mProgressTime / 20 + EnumChatFormatting.RESET + " / " + EnumChatFormatting.YELLOW + this.mContainer.mMaxProgressTime / 20 + EnumChatFormatting.RESET + " s", 10, 28, 0xFAFAFF);
                }
                if (this.mContainer.mTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_DrillerBase && this.mContainer.mActive == 0) {
                    ItemStack tItem2 = this.mContainer.mTileEntity.getMetaTileEntity().func_70301_a(1);
                    if (tItem2 == null || !GT_Utility.areStacksEqual(tItem2, GT_ModHandler.getIC2Item("miningPipe", 1L))) {
                        this.field_146289_q.func_78276_b(this.transGui("143"), 10, 40, 0xFAFAFF);
                    }
                } else if (this.mContainer.mTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_LargeTurbine && ((tItem = this.mContainer.mTileEntity.getMetaTileEntity().func_70301_a(1)) == null || tItem.func_77973_b() != GT_MetaGenerated_Tool_01.INSTANCE || tItem.func_77960_j() < 170 || tItem.func_77960_j() > 177)) {
                    this.field_146289_q.func_78276_b(this.transGui("144"), 10, this.mContainer.mActive == 0 ? 40 : 24, 0xFAFAFF);
                }
            }
        }
    }

    protected int getMode() {
        if (this.mContainer.mTileEntity != null) {
            if (this.mContainer.mAllowedToWork == 1) {
                if (this.mContainer.mProgressTime > 0) {
                    return 3;
                }
                return 2;
            }
            if (this.mContainer.mProgressTime > 0) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    protected String[] getButtonToolTip() {
        switch (this.getMode()) {
            case 3: {
                return new String[]{this.transGui("142")};
            }
            case 2: {
                return new String[]{this.transGui("201")};
            }
            case 1: {
                return new String[]{this.transGui("202")};
            }
            case 0: {
                return new String[]{this.transGui("203")};
            }
        }
        return new String[0];
    }

    public String transGui(String aKey) {
        return GT_LanguageManager.getTranslation("machine.multi.gui_" + aKey);
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        super.func_146976_a(par1, par2, par3);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_146297_k.field_71446_o.func_110577_a(this.mProgressIcon);
        if (this.mContainer != null) {
            if (this.mContainer.mDisplayErrorCode == 0) {
                double tBarLength = (double)this.mContainer.mProgressTime / (double)this.mContainer.mMaxProgressTime;
                if (this.mContainer.mMaxProgressTime != 0) {
                    this.func_73729_b(x + 12, y + 61, 0, 226, Math.min(113, (int)(tBarLength * 113.0)), 13);
                    this.func_73729_b(x + 10, y + 59, 0, 239, 119, 17);
                }
                if (this.mContainer.mActive == 0) {
                    this.func_73729_b(x + 136, y + 9, 238, 0, 9, 9);
                } else {
                    this.func_73729_b(x + 136, y + 9, 247, 0, 9, 9);
                }
            }
            switch (this.getMode()) {
                case 3: {
                    this.func_73729_b(x + 133, y + 61, 238, 41, 14, 14);
                    break;
                }
                case 1: 
                case 2: {
                    this.func_73729_b(x + 133, y + 61, 238, 26, 14, 14);
                    break;
                }
                case 0: {
                    this.func_73729_b(x + 133, y + 61, 238, 11, 14, 14);
                }
            }
        }
    }
}

