/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.interfaces.internal;

import gregtech.api.interfaces.internal.GT_Config;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public interface IGT_Config {
    default public void load(Configuration configuration) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        this.loadAll(this.getClass(), configuration);
    }

    public String getName();

    default public void loadAll(Class<? extends IGT_Config> loadAll, Configuration configuration) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        for (Field field : loadAll.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(GT_Config.class)) continue;
            field.setAccessible(true);
            GT_Config config = field.getAnnotation(GT_Config.class);
            String category = config.category();
            String name = config.configName().equals("") ? field.getName() : config.configName();
            String comment = config.configComment();
            field.set(null, IGT_Config.getWithType(field.getType(), IGT_Config.getProperty(category, name, comment, field, configuration)));
        }
    }

    public static Property getProperty(String category, String name, String comment, Field field, Configuration configuration) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (comment.equals("")) {
            return (Property)Configuration.class.getMethod("get", String.class, String.class, field.getType()).invoke((Object)configuration, category, name, field.get(null));
        }
        return (Property)Configuration.class.getMethod("get", String.class, String.class, field.getType(), String.class).invoke((Object)configuration, category, name, field.get(null), comment);
    }

    public static Object getWithType(Class type, Property property) {
        if (String.class.equals((Object)type)) {
            return property.getString();
        }
        if (Integer.TYPE.equals(type)) {
            return property.getInt();
        }
        if (Double.TYPE.equals(type)) {
            return property.getDouble();
        }
        if (String[].class.equals((Object)type)) {
            return property.getStringList();
        }
        if (Boolean.TYPE.equals(type)) {
            return property.getBoolean();
        }
        throw new IllegalStateException("type: " + type.getName() + " handling is not implemented yet");
    }
}

