/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.GT_MetaGenerated_Item;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public abstract class GT_MetaGenerated_Item_X01
extends GT_MetaGenerated_Item {
    protected final OrePrefixes mPrefix;
    protected final int mIconSetIndex;

    public GT_MetaGenerated_Item_X01(String aUnlocalized, OrePrefixes aGeneratedPrefix, int aIconSetIndex) {
        super(aUnlocalized, (short)32000, (short)766);
        this.mPrefix = aGeneratedPrefix;
        this.mIconSetIndex = aIconSetIndex >= 0 ? aIconSetIndex : (aGeneratedPrefix.mTextureIndex >= 0 ? (int)aGeneratedPrefix.mTextureIndex : 0);
        for (int i = 0; i < GregTech_API.sGeneratedMaterials.length; ++i) {
            Materials tMaterial;
            OrePrefixes tPrefix = this.mPrefix;
            if (tPrefix == null || (tMaterial = GregTech_API.sGeneratedMaterials[i]) == null || !this.mPrefix.doGenerateItem(tMaterial)) continue;
            ItemStack tStack = new ItemStack((Item)this, 1, i);
            GT_LanguageManager.addStringLocalization(this.func_77667_c(tStack) + ".name", GT_LanguageManager.i18nPlaceholder ? this.getDefaultLocalizationFormat(tPrefix, tMaterial, i) : this.getDefaultLocalization(tPrefix, tMaterial, i));
            GT_LanguageManager.addStringLocalization(this.func_77667_c(tStack) + ".tooltip", tMaterial.getToolTip(tPrefix.mMaterialAmount / 3628800L));
            String tOreName = this.getOreDictString(tPrefix, tMaterial);
            tPrefix = OrePrefixes.getOrePrefix(tOreName);
            if (tPrefix != null && tPrefix.mIsUnificatable) {
                GT_OreDictUnificator.set(tPrefix, OrePrefixes.getMaterial(tOreName, tPrefix), tStack);
                continue;
            }
            GT_OreDictUnificator.registerOre(tOreName, tStack);
        }
    }

    public String getDefaultLocalization(OrePrefixes aPrefix, Materials aMaterial, int aMetaData) {
        return aPrefix.getDefaultLocalNameForItem(aMaterial);
    }

    public String getDefaultLocalizationFormat(OrePrefixes aPrefix, Materials aMaterial, int aMetaData) {
        return aPrefix.getDefaultLocalNameFormatForItem(aMaterial);
    }

    public boolean doesShowInCreative(OrePrefixes aPrefix, Materials aMaterial, boolean aDoShowAllItems) {
        return true;
    }

    public String getOreDictString(OrePrefixes aPrefix, Materials aMaterial) {
        return aPrefix.get(aMaterial).toString();
    }

    public IIconContainer getIconContainer(int aMetaData, Materials aMaterial) {
        return aMaterial.mIconSet.mTextures[this.mIconSetIndex];
    }

    public String func_77653_i(ItemStack aStack) {
        String aName = super.func_77653_i(aStack);
        int aDamage = this.getDamage(aStack);
        if (aDamage < 32000 && aDamage >= 0) {
            return Materials.getLocalizedNameForItem(aName, aDamage % 1000);
        }
        return aName;
    }

    @Override
    public ItemStack getContainerItem(ItemStack aStack) {
        Materials aMaterial;
        int aMetaData = aStack.func_77960_j();
        if (aMetaData < GregTech_API.sGeneratedMaterials.length && aMetaData >= 0 && (aMaterial = GregTech_API.sGeneratedMaterials[aMetaData]) != null && aMaterial != Materials.Empty && aMaterial != Materials._NULL) {
            return GT_Utility.copyAmount(1L, this.mPrefix.mContainerItem);
        }
        return null;
    }

    @Override
    public short[] getRGBa(ItemStack aStack) {
        int aMetaData = this.getDamage(aStack);
        return aMetaData < GregTech_API.sGeneratedMaterials.length && GregTech_API.sGeneratedMaterials[aMetaData] != null ? GregTech_API.sGeneratedMaterials[aMetaData].mRGBa : Materials._NULL.mRGBa;
    }

    @Override
    public final IIconContainer getIconContainer(int aMetaData) {
        return aMetaData < GregTech_API.sGeneratedMaterials.length && GregTech_API.sGeneratedMaterials[aMetaData] != null ? this.getIconContainer(aMetaData, GregTech_API.sGeneratedMaterials[aMetaData]) : null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void func_150895_a(Item var1, CreativeTabs aCreativeTab, List aList) {
        for (int i = 0; i < GregTech_API.sGeneratedMaterials.length; ++i) {
            if (!this.mPrefix.doGenerateItem(GregTech_API.sGeneratedMaterials[i]) || !this.doesShowInCreative(this.mPrefix, GregTech_API.sGeneratedMaterials[i], GregTech_API.sDoShowAllItemsInCreative)) continue;
            ItemStack tStack = new ItemStack((Item)this, 1, i);
            this.isItemStackUsable(tStack);
            aList.add(tStack);
        }
        super.func_150895_a(var1, aCreativeTab, aList);
    }

    @Override
    public final IIcon func_77617_a(int aMetaData) {
        if (aMetaData < 0) {
            return null;
        }
        if (aMetaData < GregTech_API.sGeneratedMaterials.length) {
            Materials tMaterial = GregTech_API.sGeneratedMaterials[aMetaData];
            if (tMaterial == null) {
                return null;
            }
            IIconContainer tIcon = this.getIconContainer(aMetaData, tMaterial);
            if (tIcon != null) {
                return tIcon.getIcon();
            }
            return null;
        }
        return aMetaData >= this.mOffset && aMetaData - this.mOffset < this.mIconList.length ? this.mIconList[aMetaData - this.mOffset][0] : null;
    }

    @Override
    public int getItemStackLimit(ItemStack aStack) {
        return this.getDamage(aStack) < this.mOffset ? Math.min(super.getItemStackLimit(aStack), this.mPrefix.mDefaultStackSize) : super.getItemStackLimit(aStack);
    }

    @Override
    public int func_77619_b() {
        return 0;
    }

    @Override
    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }

    @Override
    public boolean func_82789_a(ItemStack aStack, ItemStack aMaterial) {
        return false;
    }
}

