/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.net.GT_Packet_Key;
import gregtech.api.net.GT_Packet_TileEntity;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Pollution;
import ic2.api.Direction;
import ic2.api.info.Info;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import org.lwjgl.input.Keyboard;

public class BaseMetaTileEntity
extends BaseTileEntity
implements IGregTechTileEntity {
    private final GT_CoverBehavior[] mCoverBehaviors = new GT_CoverBehavior[]{GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior};
    protected MetaTileEntity mMetaTileEntity;
    protected long mStoredEnergy = 0L;
    protected long mStoredSteam = 0L;
    protected int mAverageEUInputIndex = 0;
    protected int mAverageEUOutputIndex = 0;
    protected boolean mReleaseEnergy = false;
    protected int[] mAverageEUInput = new int[11];
    protected int[] mAverageEUOutput = new int[11];
    private boolean[] mActiveEUInputs = new boolean[]{false, false, false, false, false, false};
    private boolean[] mActiveEUOutputs = new boolean[]{false, false, false, false, false, false};
    private byte[] mSidedRedstone = new byte[]{15, 15, 15, 15, 15, 15};
    private int[] mCoverSides = new int[]{0, 0, 0, 0, 0, 0};
    private int[] mCoverData = new int[]{0, 0, 0, 0, 0, 0};
    private int[] mTimeStatistics = new int[GregTech_API.TICKS_FOR_LAG_AVERAGING];
    private boolean mHasEnoughEnergy = true;
    private boolean mRunningThroughTick = false;
    private boolean mInputDisabled = false;
    private boolean mOutputDisabled = false;
    private boolean mMuffler = false;
    private boolean mLockUpgrade = false;
    private boolean mActive = false;
    private boolean mRedstone = false;
    private boolean mWorkUpdate = false;
    private boolean mSteamConverter = false;
    private boolean mInventoryChanged = false;
    private boolean mWorks = true;
    private boolean mNeedsUpdate = true;
    private boolean mNeedsBlockUpdate = true;
    private boolean mSendClientData = false;
    private boolean oRedstone = false;
    private byte mColor = 0;
    private byte oColor = 0;
    private byte oStrongRedstone = 0;
    private byte mStrongRedstone = 0;
    private byte oRedstoneData = (byte)63;
    private byte oTextureData = 0;
    private byte oUpdateData = 0;
    private byte oTexturePage = 0;
    private byte oLightValueClient = (byte)-1;
    private byte oLightValue = (byte)-1;
    private byte mLightValue = 0;
    private byte mOtherUpgrades = 0;
    private byte mFacing = 0;
    private byte oFacing = 0;
    private byte mFluidFacing = 0;
    private byte oFluidFacing = 0;
    private byte mWorkData = 0;
    private int mDisplayErrorCode = 0;
    private int oX = 0;
    private int oY = 0;
    private int oZ = 0;
    private int mTimeStatisticsIndex = 0;
    private int mLagWarningCount = 0;
    private int extraInfo = 0;
    private short mID = 0;
    private long mTickTimer = 0L;
    private long oOutput = 0L;
    private long mAcceptedAmperes = Long.MAX_VALUE;
    private String mOwnerName = "";
    private NBTTagCompound mRecipeStuff = new NBTTagCompound();
    public boolean mWaterProof = false;
    public boolean allowFluidAutoOutput = false;
    private static final Field ENTITY_ITEM_HEALTH_FIELD;
    private static final int[] EMPTY;
    public ITexture[][][][] mTextures = new ITexture[2][17][6][];

    @Override
    public void func_145841_b(NBTTagCompound aNBT) {
        try {
            super.func_145841_b(aNBT);
        }
        catch (Throwable e) {
            GT_Log.err.println("Encountered CRITICAL ERROR while saving MetaTileEntity, the Chunk whould've been corrupted by now, but I prevented that. Please report immidietly to GregTech Intergalactical!!!");
            e.printStackTrace(GT_Log.err);
        }
        try {
            aNBT.func_74768_a("mID", (int)this.mID);
            aNBT.func_74772_a("mStoredSteam", this.mStoredSteam);
            aNBT.func_74772_a("mStoredEnergy", this.mStoredEnergy);
            aNBT.func_74783_a("mCoverData", this.mCoverData);
            aNBT.func_74783_a("mCoverSides", this.mCoverSides);
            aNBT.func_74773_a("mRedstoneSided", this.mSidedRedstone);
            aNBT.func_74774_a("mColor", this.mColor);
            aNBT.func_74774_a("mLightValue", this.mLightValue);
            aNBT.func_74774_a("mOtherUpgrades", this.mOtherUpgrades);
            aNBT.func_74774_a("mWorkData", this.mWorkData);
            aNBT.func_74774_a("mStrongRedstone", this.mStrongRedstone);
            aNBT.func_74777_a("mFacing", (short)this.mFacing);
            aNBT.func_74774_a("mFluidFacing", this.mFluidFacing);
            aNBT.func_74778_a("mOwnerName", this.mOwnerName);
            aNBT.func_74757_a("mLockUpgrade", this.mLockUpgrade);
            aNBT.func_74757_a("mMuffler", this.mMuffler);
            aNBT.func_74757_a("mSteamConverter", this.mSteamConverter);
            aNBT.func_74757_a("mActive", this.mActive);
            aNBT.func_74757_a("mRedstone", this.mRedstone);
            aNBT.func_74757_a("mWorks", !this.mWorks);
            aNBT.func_74757_a("mWaterProof", this.mWaterProof);
            aNBT.func_74757_a("mInputDisabled", this.mInputDisabled);
            aNBT.func_74757_a("mOutputDisabled", this.mOutputDisabled);
            aNBT.func_74782_a("GT.CraftingComponents", (NBTBase)this.mRecipeStuff);
            aNBT.func_74768_a("nbtVersion", GT_Mod.TOTAL_VERSION);
        }
        catch (Throwable e) {
            GT_Log.err.println("Encountered CRITICAL ERROR while saving MetaTileEntity, the Chunk whould've been corrupted by now, but I prevented that. Please report immidietly to GregTech Intergalactical!!!");
            e.printStackTrace(GT_Log.err);
        }
        try {
            if (this.hasValidMetaTileEntity()) {
                NBTTagList tItemList = new NBTTagList();
                for (int i = 0; i < this.mMetaTileEntity.getRealInventory().length; ++i) {
                    ItemStack tStack = this.mMetaTileEntity.getRealInventory()[i];
                    if (tStack == null) continue;
                    NBTTagCompound tTag = new NBTTagCompound();
                    tTag.func_74768_a("IntSlot", i);
                    tStack.func_77955_b(tTag);
                    tItemList.func_74742_a((NBTBase)tTag);
                }
                aNBT.func_74782_a("Inventory", (NBTBase)tItemList);
                try {
                    this.mMetaTileEntity.saveNBTData(aNBT);
                }
                catch (Throwable e) {
                    GT_Log.err.println("Encountered CRITICAL ERROR while saving MetaTileEntity, the Chunk whould've been corrupted by now, but I prevented that. Please report immidietly to GregTech Intergalactical!!!");
                    e.printStackTrace(GT_Log.err);
                }
            }
        }
        catch (Throwable e) {
            GT_Log.err.println("Encountered CRITICAL ERROR while saving MetaTileEntity, the Chunk whould've been corrupted by now, but I prevented that. Please report immidietly to GregTech Intergalactical!!!");
            e.printStackTrace(GT_Log.err);
        }
    }

    public void func_145839_a(NBTTagCompound aNBT) {
        super.func_145839_a(aNBT);
        this.setInitialValuesAsNBT(aNBT, (short)0);
    }

    @Override
    public void setInitialValuesAsNBT(NBTTagCompound aNBT, short aID) {
        if (aNBT == null) {
            byte[] byArray;
            if (aID > 0) {
                this.mID = aID;
            } else {
                short s = this.mID = this.mID > 0 ? this.mID : (short)0;
            }
            if (this.mID != 0) {
                this.createNewMetatileEntity(this.mID);
            }
            if (this.hasValidMetaTileEntity() && this.mMetaTileEntity.hasSidedRedstoneOutputBehavior()) {
                byte[] byArray2 = new byte[6];
                byArray2[0] = 0;
                byArray2[1] = 0;
                byArray2[2] = 0;
                byArray2[3] = 0;
                byArray2[4] = 0;
                byArray = byArray2;
                byArray2[5] = 0;
            } else {
                byte[] byArray3 = new byte[6];
                byArray3[0] = 15;
                byArray3[1] = 15;
                byArray3[2] = 15;
                byArray3[3] = 15;
                byArray3[4] = 15;
                byArray = byArray3;
                byArray3[5] = 15;
            }
            this.mSidedRedstone = byArray;
        } else {
            this.mID = aID <= 0 ? (short)aNBT.func_74762_e("mID") : aID;
            this.mStoredSteam = aNBT.func_74763_f("mStoredSteam");
            this.mStoredEnergy = aNBT.func_74763_f("mStoredEnergy");
            this.mColor = aNBT.func_74771_c("mColor");
            this.mLightValue = aNBT.func_74771_c("mLightValue");
            this.mWorkData = aNBT.func_74771_c("mWorkData");
            this.mStrongRedstone = aNBT.func_74771_c("mStrongRedstone");
            this.mFacing = this.oFacing = (byte)aNBT.func_74765_d("mFacing");
            this.mFluidFacing = aNBT.func_74764_b("mFluidFacing") ? (this.oFluidFacing = aNBT.func_74771_c("mFluidFacing")) : (this.oFluidFacing = this.mFacing);
            this.mOwnerName = aNBT.func_74779_i("mOwnerName");
            this.mLockUpgrade = aNBT.func_74767_n("mLockUpgrade");
            this.mMuffler = aNBT.func_74767_n("mMuffler");
            this.mSteamConverter = aNBT.func_74767_n("mSteamConverter");
            this.mActive = aNBT.func_74767_n("mActive");
            this.mRedstone = aNBT.func_74767_n("mRedstone");
            this.mWorks = !aNBT.func_74767_n("mWorks");
            this.mInputDisabled = aNBT.func_74767_n("mInputDisabled");
            this.mOutputDisabled = aNBT.func_74767_n("mOutputDisabled");
            this.mOtherUpgrades = (byte)(aNBT.func_74771_c("mOtherUpgrades") + aNBT.func_74771_c("mBatteries") + aNBT.func_74771_c("mLiBatteries"));
            this.mCoverSides = aNBT.func_74759_k("mCoverSides");
            this.mCoverData = aNBT.func_74759_k("mCoverData");
            this.mSidedRedstone = aNBT.func_74770_j("mRedstoneSided");
            this.mRecipeStuff = aNBT.func_74775_l("GT.CraftingComponents");
            this.mWaterProof = aNBT.func_74767_n("mWaterProof");
            int nbtVersion = aNBT.func_74762_e("nbtVersion");
            if (this.mCoverData.length != 6) {
                this.mCoverData = new int[]{0, 0, 0, 0, 0, 0};
            }
            if (this.mCoverSides.length != 6) {
                this.mCoverSides = new int[]{0, 0, 0, 0, 0, 0};
            }
            if (this.mSidedRedstone.length != 6) {
                this.mSidedRedstone = this.hasValidMetaTileEntity() && this.mMetaTileEntity.hasSidedRedstoneOutputBehavior() ? new byte[]{0, 0, 0, 0, 0, 0} : new byte[]{15, 15, 15, 15, 15, 15};
            }
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                this.mCoverBehaviors[i] = GregTech_API.getCoverBehavior(this.mCoverSides[i]);
            }
            if (this.mID != 0 && this.createNewMetatileEntity(this.mID)) {
                NBTTagList tItemList = aNBT.func_150295_c("Inventory", 10);
                for (int i = 0; i < tItemList.func_74745_c(); ++i) {
                    NBTTagCompound tTag = tItemList.func_150305_b(i);
                    int tSlot = tTag.func_74762_e("IntSlot");
                    if ((tSlot = this.shiftInventoryIndex(tSlot, nbtVersion)) < 0 || tSlot >= this.mMetaTileEntity.getRealInventory().length) continue;
                    this.mMetaTileEntity.getRealInventory()[tSlot] = GT_Utility.loadItem(tTag);
                }
                try {
                    this.mMetaTileEntity.loadNBTData(aNBT);
                }
                catch (Throwable e) {
                    GT_Log.err.println("Encountered Exception while loading MetaTileEntity, the Server should've crashed now, but I prevented that. Please report immidietly to GregTech Intergalactical!!!");
                    e.printStackTrace(GT_Log.err);
                }
            }
        }
        if (this.mCoverData.length != 6) {
            this.mCoverData = new int[]{0, 0, 0, 0, 0, 0};
        }
        if (this.mCoverSides.length != 6) {
            this.mCoverSides = new int[]{0, 0, 0, 0, 0, 0};
        }
        if (this.mSidedRedstone.length != 6) {
            this.mSidedRedstone = this.hasValidMetaTileEntity() && this.mMetaTileEntity.hasSidedRedstoneOutputBehavior() ? new byte[]{0, 0, 0, 0, 0, 0} : new byte[]{15, 15, 15, 15, 15, 15};
        }
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            this.mCoverBehaviors[i] = GregTech_API.getCoverBehavior(this.mCoverSides[i]);
        }
    }

    private boolean createNewMetatileEntity(short aID) {
        if (aID > 0 && aID < GregTech_API.METATILEENTITIES.length && GregTech_API.METATILEENTITIES[aID] != null) {
            if (this.hasValidMetaTileEntity()) {
                this.mMetaTileEntity.setBaseMetaTileEntity(null);
            }
            GregTech_API.METATILEENTITIES[aID].newMetaEntity(this).setBaseMetaTileEntity(this);
            this.mTickTimer = 0L;
            this.mID = aID;
            return true;
        }
        GT_Log.err.println("MetaID " + aID + " not loadable => locking TileEntity!");
        return false;
    }

    public void updateStatus() {
    }

    public void chargeItem(ItemStack aStack) {
        this.decreaseStoredEU(GT_ModHandler.chargeElectricItem(aStack, (int)Math.min(Integer.MAX_VALUE, this.getStoredEU()), (int)Math.min(Integer.MAX_VALUE, this.mMetaTileEntity.getOutputTier()), false, false), true);
    }

    public void dischargeItem(ItemStack aStack) {
        this.increaseStoredEnergyUnits(GT_ModHandler.dischargeElectricItem(aStack, (int)Math.min(Integer.MAX_VALUE, this.getEUCapacity() - this.getStoredEU()), (int)Math.min(Integer.MAX_VALUE, this.mMetaTileEntity.getInputTier()), false, false, false), true);
    }

    private boolean isRainPossible() {
        BiomeGenBase biome = this.getBiome();
        return biome.field_76751_G > 0.0f && (biome.func_76738_d() || biome.func_76746_c());
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.hasValidMetaTileEntity()) {
            if (this.mMetaTileEntity == null) {
                return;
            }
            this.mMetaTileEntity.setBaseMetaTileEntity(this);
        }
        this.mRunningThroughTick = true;
        long tTime = System.currentTimeMillis();
        int tCode = 0;
        boolean aSideServer = this.isServerSide();
        boolean aSideClient = this.isClientSide();
        try {
            tCode = 0;
            while (this.hasValidMetaTileEntity() && tCode >= 0) {
                switch (tCode) {
                    case 0: {
                        byte i;
                        ++tCode;
                        if (this.mTickTimer++ == 0L) {
                            this.oX = this.field_145851_c;
                            this.oY = this.field_145848_d;
                            this.oZ = this.field_145849_e;
                            if (aSideServer) {
                                for (i = 0; i < 6; i = (byte)(i + 1)) {
                                    if (this.getCoverIDAtSide(i) == 0 || this.mMetaTileEntity.allowCoverOnSide(i, new GT_ItemStack(this.getCoverIDAtSide(i)))) continue;
                                    this.dropCover(i, i, true);
                                }
                            }
                            this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
                            this.mMetaTileEntity.onFirstTick(this);
                            if (aSideClient) {
                                this.rebakeMap();
                            }
                            if (!this.hasValidMetaTileEntity()) {
                                this.mRunningThroughTick = false;
                                return;
                            }
                        }
                    }
                    case 1: {
                        ++tCode;
                        if (aSideClient) {
                            if (this.mColor != this.oColor) {
                                this.oColor = this.mColor;
                                this.mMetaTileEntity.onColorChangeClient(this.oColor);
                                this.issueTextureUpdate();
                            }
                            if (this.mLightValue != this.oLightValueClient) {
                                this.field_145850_b.func_72915_b(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e, (int)this.mLightValue);
                                this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                                this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
                                this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
                                this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                                this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
                                this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
                                this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
                                this.oLightValueClient = this.mLightValue;
                                this.issueTextureUpdate();
                            }
                            if (this.mNeedsUpdate) {
                                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                                this.mNeedsUpdate = false;
                            }
                        }
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        byte i;
                        if (aSideServer && this.mTickTimer > 10L) {
                            for (i = (byte)(tCode - 2); i < 6; i = (byte)(i + 1)) {
                                if (this.getCoverIDAtSide(i) == 0) continue;
                                ++tCode;
                                GT_CoverBehavior tCover = this.getCoverBehaviorAtSide(i);
                                int tCoverTickRate = tCover.getTickRate(i, this.getCoverIDAtSide(i), this.mCoverData[i], this);
                                if (tCoverTickRate <= 0 || this.mTickTimer % (long)tCoverTickRate != 0L) continue;
                                this.mCoverData[i] = tCover.doCoverThings(i, this.getInputRedstoneSignal(i), this.getCoverIDAtSide(i), this.mCoverData[i], this, this.mTickTimer);
                                if (this.hasValidMetaTileEntity()) continue;
                                this.mRunningThroughTick = false;
                                return;
                            }
                        }
                    }
                    case 8: {
                        tCode = 9;
                        if (aSideServer) {
                            if (++this.mAverageEUInputIndex >= this.mAverageEUInput.length) {
                                this.mAverageEUInputIndex = 0;
                            }
                            if (++this.mAverageEUOutputIndex >= this.mAverageEUOutput.length) {
                                this.mAverageEUOutputIndex = 0;
                            }
                            this.mAverageEUInput[this.mAverageEUInputIndex] = 0;
                            this.mAverageEUOutput[this.mAverageEUOutputIndex] = 0;
                        }
                    }
                    case 9: {
                        ++tCode;
                        this.mMetaTileEntity.onPreTick(this, this.mTickTimer);
                        if (!this.hasValidMetaTileEntity()) {
                            this.mRunningThroughTick = false;
                            return;
                        }
                    }
                    case 10: {
                        byte i;
                        ++tCode;
                        if (aSideServer) {
                            if (this.mRedstone != this.oRedstone || this.mTickTimer == 10L) {
                                for (i = 0; i < 6; i = (byte)(i + 1)) {
                                    this.mCoverBehaviors[i] = GregTech_API.getCoverBehavior(this.mCoverSides[i]);
                                }
                                this.oRedstone = this.mRedstone;
                                this.issueBlockUpdate();
                            }
                            if (this.field_145851_c != this.oX || this.field_145848_d != this.oY || this.field_145849_e != this.oZ) {
                                this.oX = this.field_145851_c;
                                this.oY = this.field_145848_d;
                                this.oZ = this.field_145849_e;
                                this.issueClientUpdate();
                                this.clearTileEntityBuffer();
                            }
                            if (this.mFacing != this.oFacing) {
                                this.oFacing = this.mFacing;
                                for (i = 0; i < 6; i = (byte)(i + 1)) {
                                    if (this.getCoverIDAtSide(i) == 0 || this.mMetaTileEntity.allowCoverOnSide(i, new GT_ItemStack(this.getCoverIDAtSide(i)))) continue;
                                    this.dropCover(i, i, true);
                                }
                                this.issueBlockUpdate();
                            }
                            if (this.mTickTimer > 20L && this.mMetaTileEntity.isElectric()) {
                                this.mAcceptedAmperes = 0L;
                                if (this.getOutputVoltage() != this.oOutput) {
                                    this.oOutput = this.getOutputVoltage();
                                }
                                if (this.mMetaTileEntity.isEnetOutput() || this.mMetaTileEntity.isEnetInput()) {
                                    for (i = 0; i < 6; i = (byte)(i + 1)) {
                                        boolean temp = this.isEnergyInputSide(i);
                                        if (temp != this.mActiveEUInputs[i]) {
                                            this.mActiveEUInputs[i] = temp;
                                        }
                                        if ((temp = this.isEnergyOutputSide(i)) == this.mActiveEUOutputs[i]) continue;
                                        this.mActiveEUOutputs[i] = temp;
                                    }
                                }
                                if (this.mMetaTileEntity.isEnetOutput() && this.oOutput > 0L) {
                                    long tOutputVoltage = Math.max(this.oOutput, this.oOutput + (long)(1 << GT_Utility.getTier(this.oOutput)));
                                    long tUsableAmperage = Math.min(this.getOutputAmperage(), (this.getStoredEU() - this.mMetaTileEntity.getMinimumStoredEU()) / tOutputVoltage);
                                    if (tUsableAmperage > 0L) {
                                        long tEU = tOutputVoltage * IEnergyConnected.Util.emitEnergyToNetwork(this.oOutput, tUsableAmperage, this);
                                        int n = this.mAverageEUOutputIndex;
                                        this.mAverageEUOutput[n] = (int)((long)this.mAverageEUOutput[n] + tEU);
                                        this.decreaseStoredEU(tEU, true);
                                    }
                                }
                                if (this.getEUCapacity() > 0L) {
                                    Block tBlock2;
                                    if (GregTech_API.sMachineFireExplosions && this.getRandomNumber(1000) == 0 && (tBlock2 = this.getBlockAtSide((byte)this.getRandomNumber(6))) instanceof BlockFire) {
                                        this.doEnergyExplosion();
                                    }
                                    if (!this.hasValidMetaTileEntity()) {
                                        this.mRunningThroughTick = false;
                                        return;
                                    }
                                    if (!this.mWaterProof && !this.getMetaTileEntity().isWaterProofByDefault() && (this.mTickTimer & 0x200L) == 512L && this.getRandomNumber(3) == 0) {
                                        if (Arrays.stream(new Block[]{this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e), this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e), this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e), this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1), this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)}).anyMatch(b -> b == Blocks.field_150355_j || b == Blocks.field_150358_i || b == Blocks.field_150353_l || b == Blocks.field_150356_k || b instanceof IFluidBlock)) {
                                            this.doEnergyExplosion();
                                        }
                                        if (this.field_145850_b.func_72874_g(this.field_145851_c, this.field_145849_e) - 2 < this.field_145848_d || this.field_145850_b.func_72874_g(this.field_145851_c, this.field_145849_e - 1) - 1 < this.field_145848_d || this.field_145850_b.func_72874_g(this.field_145851_c, this.field_145849_e + 1) - 1 < this.field_145848_d || this.field_145850_b.func_72874_g(this.field_145851_c - 1, this.field_145849_e) - 1 < this.field_145848_d || this.field_145850_b.func_72874_g(this.field_145851_c + 1, this.field_145849_e) - 1 < this.field_145848_d) {
                                            if (GregTech_API.sMachineRainExplosions && this.field_145850_b.func_72896_J() && this.isRainPossible()) {
                                                if (this.getRandomNumber(10) == 0) {
                                                    try {
                                                        GT_Mod.achievements.issueAchievement(this.func_145831_w().func_72924_a(this.mOwnerName), "badweather");
                                                    }
                                                    catch (Exception tBlock2) {
                                                        // empty catch block
                                                    }
                                                    this.doEnergyExplosion();
                                                } else {
                                                    this.setOnFire();
                                                }
                                            }
                                            if (!this.hasValidMetaTileEntity()) {
                                                this.mRunningThroughTick = false;
                                                return;
                                            }
                                            if (GregTech_API.sMachineThunderExplosions && this.field_145850_b.func_72911_I() && this.isRainPossible() && this.getRandomNumber(3) == 0) {
                                                try {
                                                    GT_Mod.achievements.issueAchievement(this.func_145831_w().func_72924_a(this.mOwnerName), "badweather");
                                                }
                                                catch (Exception tBlock2) {
                                                    // empty catch block
                                                }
                                                this.doEnergyExplosion();
                                            }
                                        }
                                    }
                                }
                            }
                            if (!this.hasValidMetaTileEntity()) {
                                this.mRunningThroughTick = false;
                                return;
                            }
                        }
                    }
                    case 11: {
                        int k;
                        ++tCode;
                        if (aSideServer && this.mMetaTileEntity.dechargerSlotCount() > 0 && this.getStoredEU() < this.getEUCapacity()) {
                            int i;
                            k = this.mMetaTileEntity.dechargerSlotCount() + i;
                            for (i = this.mMetaTileEntity.dechargerSlotStartIndex(); i < k; ++i) {
                                if (this.mMetaTileEntity.mInventory[i] == null || this.getStoredEU() >= this.getEUCapacity()) continue;
                                this.dischargeItem(this.mMetaTileEntity.mInventory[i]);
                                if (Info.itemEnergy.getEnergyValue(this.mMetaTileEntity.mInventory[i]) > 0.0 && (double)this.getStoredEU() + Info.itemEnergy.getEnergyValue(this.mMetaTileEntity.mInventory[i]) < (double)this.getEUCapacity()) {
                                    this.increaseStoredEnergyUnits((long)Info.itemEnergy.getEnergyValue(this.mMetaTileEntity.mInventory[i]), false);
                                    --this.mMetaTileEntity.mInventory[i].field_77994_a;
                                    this.mInventoryChanged = true;
                                }
                                if (this.mMetaTileEntity.mInventory[i].field_77994_a > 0) continue;
                                this.mMetaTileEntity.mInventory[i] = null;
                                this.mInventoryChanged = true;
                            }
                        }
                    }
                    case 12: {
                        int k;
                        ++tCode;
                        if (aSideServer && this.mMetaTileEntity.rechargerSlotCount() > 0 && this.getStoredEU() > 0L) {
                            int i;
                            k = this.mMetaTileEntity.rechargerSlotCount() + i;
                            for (i = this.mMetaTileEntity.rechargerSlotStartIndex(); i < k; ++i) {
                                if (this.getStoredEU() <= 0L || this.mMetaTileEntity.mInventory[i] == null) continue;
                                this.chargeItem(this.mMetaTileEntity.mInventory[i]);
                                if (this.mMetaTileEntity.mInventory[i].field_77994_a > 0) continue;
                                this.mMetaTileEntity.mInventory[i] = null;
                                this.mInventoryChanged = true;
                            }
                        }
                    }
                    case 13: {
                        ++tCode;
                        this.updateStatus();
                        if (!this.hasValidMetaTileEntity()) {
                            this.mRunningThroughTick = false;
                            return;
                        }
                    }
                    case 14: {
                        ++tCode;
                        this.mMetaTileEntity.onPostTick(this, this.mTickTimer);
                        if (!this.hasValidMetaTileEntity()) {
                            this.mRunningThroughTick = false;
                            return;
                        }
                    }
                    case 15: {
                        ++tCode;
                        if (!aSideServer) break;
                        if (this.mTickTimer % 10L == 0L && this.mSendClientData) {
                            this.oTextureData = (byte)(this.mFacing & 7 | (this.mActive ? 8 : 0) | (this.mRedstone ? 16 : 0) | (this.mLockUpgrade ? 32 : 0));
                            this.oTexturePage = this.hasValidMetaTileEntity() && this.mMetaTileEntity instanceof GT_MetaTileEntity_Hatch ? ((GT_MetaTileEntity_Hatch)this.mMetaTileEntity).getTexturePage() : (byte)0;
                            this.oUpdateData = this.hasValidMetaTileEntity() ? this.mMetaTileEntity.getUpdateData() : (byte)0;
                            this.oRedstoneData = (byte)((this.mSidedRedstone[0] > 0 ? 1 : 0) | (this.mSidedRedstone[1] > 0 ? 2 : 0) | (this.mSidedRedstone[2] > 0 ? 4 : 0) | (this.mSidedRedstone[3] > 0 ? 8 : 0) | (this.mSidedRedstone[4] > 0 ? 16 : 0) | (this.mSidedRedstone[5] > 0 ? 32 : 0));
                            this.oColor = this.mColor;
                            GT_Values.NW.sendPacketToAllPlayersInRange(this.field_145850_b, new GT_Packet_TileEntity(this.field_145851_c, (short)this.field_145848_d, this.field_145849_e, this.mID, this.mCoverSides[0], this.mCoverSides[1], this.mCoverSides[2], this.mCoverSides[3], this.mCoverSides[4], this.mCoverSides[5], this.oTextureData, this.oTexturePage, this.oUpdateData, this.oRedstoneData, this.oColor, this.mWaterProof, this.mFluidFacing), this.field_145851_c, this.field_145849_e);
                            this.mMetaTileEntity.sendClientData();
                            this.mSendClientData = false;
                        }
                        if (this.mTickTimer > 10L) {
                            byte tData = (byte)(this.mFacing & 7 | (this.mActive ? 8 : 0) | (this.mRedstone ? 16 : 0) | (this.mLockUpgrade ? 32 : 0));
                            if (tData != this.oTextureData) {
                                this.oTextureData = tData;
                                this.sendBlockEvent((byte)0, this.oTextureData);
                            }
                            if (this.oFluidFacing != (tData = this.mFluidFacing)) {
                                this.oFluidFacing = tData;
                                this.sendBlockEvent((byte)9, this.oFluidFacing);
                            }
                            if ((tData = this.mMetaTileEntity.getUpdateData()) != this.oUpdateData) {
                                this.oUpdateData = tData;
                                this.sendBlockEvent((byte)1, this.oUpdateData);
                            }
                            if (this.mMetaTileEntity instanceof GT_MetaTileEntity_Hatch && (tData = ((GT_MetaTileEntity_Hatch)this.mMetaTileEntity).getTexturePage()) != this.oTexturePage) {
                                this.oTexturePage = tData;
                                this.sendBlockEvent((byte)1, (byte)(this.oTexturePage | 0x80));
                            }
                            if (this.mColor != this.oColor) {
                                this.oColor = this.mColor;
                                this.sendBlockEvent((byte)2, this.oColor);
                            }
                            if ((tData = (byte)((this.mSidedRedstone[0] > 0 ? 1 : 0) | (this.mSidedRedstone[1] > 0 ? 2 : 0) | (this.mSidedRedstone[2] > 0 ? 4 : 0) | (this.mSidedRedstone[3] > 0 ? 8 : 0) | (this.mSidedRedstone[4] > 0 ? 16 : 0) | (this.mSidedRedstone[5] > 0 ? 32 : 0))) != this.oRedstoneData) {
                                this.oRedstoneData = tData;
                                this.sendBlockEvent((byte)3, this.oRedstoneData);
                            }
                            if (this.mLightValue != this.oLightValue) {
                                this.field_145850_b.func_72915_b(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e, (int)this.mLightValue);
                                this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                                this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
                                this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
                                this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                                this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
                                this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
                                this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
                                this.issueTextureUpdate();
                                this.oLightValue = this.mLightValue;
                                this.sendBlockEvent((byte)7, this.oLightValue);
                            }
                        }
                        if (!this.mNeedsBlockUpdate) break;
                        this.updateNeighbours(this.mStrongRedstone, this.oStrongRedstone);
                        this.oStrongRedstone = this.mStrongRedstone;
                        this.mNeedsBlockUpdate = false;
                    }
                }
                tCode = -1;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
        if (aSideServer && this.hasValidMetaTileEntity()) {
            tTime = System.currentTimeMillis() - tTime;
            if (this.mTimeStatistics.length > 0) {
                this.mTimeStatisticsIndex = (this.mTimeStatisticsIndex + 1) % this.mTimeStatistics.length;
                this.mTimeStatistics[this.mTimeStatisticsIndex] = (int)tTime;
            }
            if (tTime > 0L && tTime > (long)GregTech_API.MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING && this.mTickTimer > 1000L && this.getMetaTileEntity().doTickProfilingMessageDuringThisTick() && this.mLagWarningCount++ < 10) {
                System.out.println("WARNING: Possible Lag Source at [" + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + "] in Dimension " + this.field_145850_b.field_73011_w.field_76574_g + " with " + tTime + "ms caused by an instance of " + this.getMetaTileEntity().getClass());
            }
        }
        this.mRunningThroughTick = false;
        this.mInventoryChanged = false;
        this.mWorkUpdate = false;
    }

    public Packet func_145844_m() {
        this.issueClientUpdate();
        return null;
    }

    public final void receiveMetaTileEntityData(short aID, int aCover0, int aCover1, int aCover2, int aCover3, int aCover4, int aCover5, byte aTextureData, byte aTexturePage, byte aUpdateData, byte aRedstoneData, byte aColorData, boolean aWaterProof, byte aFluidFacing) {
        this.issueTextureUpdate();
        if (this.mID != aID && aID > 0) {
            this.mID = aID;
            this.createNewMetatileEntity(this.mID);
        }
        this.mCoverSides[0] = aCover0;
        this.mCoverSides[1] = aCover1;
        this.mCoverSides[2] = aCover2;
        this.mCoverSides[3] = aCover3;
        this.mCoverSides[4] = aCover4;
        this.mCoverSides[5] = aCover5;
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            this.mCoverBehaviors[i] = GregTech_API.getCoverBehavior(this.mCoverSides[i]);
        }
        this.func_145842_c(0, aTextureData);
        this.func_145842_c(1, aUpdateData & 0x7F);
        this.func_145842_c(1, aTexturePage | 0x80);
        this.func_145842_c(2, aColorData);
        this.func_145842_c(3, aRedstoneData);
        this.func_145842_c(9, aFluidFacing);
        this.mWaterProof = aWaterProof;
        this.rebakeMap();
    }

    @Deprecated
    public final void receiveMetaTileEntityData(short aID, int aCover0, int aCover1, int aCover2, int aCover3, int aCover4, int aCover5, byte aTextureData, byte aUpdateData, byte aRedstoneData, byte aColorData) {
        this.issueTextureUpdate();
        if (this.mID != aID && aID > 0) {
            this.mID = aID;
            this.createNewMetatileEntity(this.mID);
        }
        this.mCoverSides[0] = aCover0;
        this.mCoverSides[1] = aCover1;
        this.mCoverSides[2] = aCover2;
        this.mCoverSides[3] = aCover3;
        this.mCoverSides[4] = aCover4;
        this.mCoverSides[5] = aCover5;
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            this.mCoverBehaviors[i] = GregTech_API.getCoverBehavior(this.mCoverSides[i]);
        }
        this.func_145842_c(0, aTextureData);
        this.func_145842_c(1, aUpdateData & 0x7F);
        this.func_145842_c(1, 128);
        this.func_145842_c(2, aColorData);
        this.func_145842_c(3, aRedstoneData);
        this.rebakeMap();
    }

    public boolean func_145842_c(int aEventID, int aValue) {
        super.func_145842_c(aEventID, aValue);
        if (this.hasValidMetaTileEntity()) {
            try {
                if (aEventID > 128) {
                    this.mMetaTileEntity.receiveExtendedBlockEvent(aEventID, aValue);
                } else {
                    this.mMetaTileEntity.receiveClientEvent((byte)aEventID, (byte)aValue);
                }
            }
            catch (Throwable e) {
                GT_Log.err.println("Encountered Exception while receiving Data from the Server, the Client should've been crashed by now, but I prevented that. Please report immidietly to GregTech Intergalactical!!!");
                e.printStackTrace(GT_Log.err);
            }
        }
        if (this.isClientSide()) {
            this.issueTextureUpdate();
            switch (aEventID) {
                case 0: {
                    if (this.mFacing != (aValue & 7)) {
                        this.mFacing = (byte)(aValue & 7);
                        this.rebakeMap();
                    }
                    this.mActive = (aValue & 8) != 0;
                    this.mRedstone = (aValue & 0x10) != 0;
                    break;
                }
                case 1: {
                    if (!this.hasValidMetaTileEntity()) break;
                    if ((aValue & 0x80) == 0) {
                        this.mMetaTileEntity.onValueUpdate((byte)(aValue & 0x7F));
                    } else if (this.mMetaTileEntity instanceof GT_MetaTileEntity_Hatch) {
                        ((GT_MetaTileEntity_Hatch)this.mMetaTileEntity).onTexturePageUpdate((byte)(aValue & 0x7F));
                    }
                    this.rebakeMap();
                    break;
                }
                case 2: {
                    if (aValue > 16 || aValue < 0) {
                        aValue = 0;
                    }
                    this.mColor = (byte)aValue;
                    break;
                }
                case 3: {
                    this.mSidedRedstone[0] = (byte)((aValue & 1) == 1 ? 15 : 0);
                    this.mSidedRedstone[1] = (byte)((aValue & 2) == 2 ? 15 : 0);
                    this.mSidedRedstone[2] = (byte)((aValue & 4) == 4 ? 15 : 0);
                    this.mSidedRedstone[3] = (byte)((aValue & 8) == 8 ? 15 : 0);
                    this.mSidedRedstone[4] = (byte)((aValue & 0x10) == 16 ? 15 : 0);
                    this.mSidedRedstone[5] = (byte)((aValue & 0x20) == 32 ? 15 : 0);
                    break;
                }
                case 4: {
                    if (!this.hasValidMetaTileEntity() || this.mTickTimer <= 20L) break;
                    this.mMetaTileEntity.doSound((byte)aValue, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                    break;
                }
                case 5: {
                    if (!this.hasValidMetaTileEntity() || this.mTickTimer <= 20L) break;
                    this.mMetaTileEntity.startSoundLoop((byte)aValue, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                    break;
                }
                case 6: {
                    if (!this.hasValidMetaTileEntity() || this.mTickTimer <= 20L) break;
                    this.mMetaTileEntity.stopSoundLoop((byte)aValue, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                    break;
                }
                case 7: {
                    this.mLightValue = (byte)aValue;
                    break;
                }
                case 8: {
                    this.mWaterProof = aValue == 1;
                    this.rebakeMap();
                    break;
                }
                case 9: {
                    if (this.mFluidFacing == (byte)aValue) break;
                    this.mFluidFacing = (byte)aValue;
                    this.rebakeMap();
                }
            }
        }
        return true;
    }

    public ArrayList<String> getDebugInfo(EntityPlayer aPlayer, int aLogLevel) {
        ArrayList<String> tList = new ArrayList<String>();
        if (aLogLevel > 2) {
            tList.add("Meta-ID: " + this.mID + (this.canAccessData() ? " valid" : " invalid") + (this.mMetaTileEntity == null ? " MetaTileEntity == null!" : " "));
        }
        if (aLogLevel > 1) {
            if (this.mTimeStatistics.length > 0) {
                double tAverageTime = 0.0;
                for (int tTime : this.mTimeStatistics) {
                    tAverageTime += (double)tTime;
                }
                tList.add("This particular TileEntity has caused an average CPU-load of ~" + tAverageTime / (double)this.mTimeStatistics.length + "ms over the last " + this.mTimeStatistics.length + " ticks.");
            }
            if (this.mLagWarningCount > 0) {
                tList.add("This TileEntity has also caused " + (this.mLagWarningCount >= 10 ? "more than 10" : Integer.valueOf(this.mLagWarningCount)) + " Lag Spike Warnings (anything taking longer than " + GregTech_API.MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING + "ms) on the Server.");
            }
            tList.add("Is" + (this.mMetaTileEntity.isAccessAllowed(aPlayer) ? " " : " not ") + "accessible for you");
        }
        if (aLogLevel > 0) {
            if (this.getSteamCapacity() > 0L && this.hasSteamEngineUpgrade()) {
                tList.add(this.getStoredSteam() + " of " + this.getSteamCapacity() + " Steam");
            }
            tList.add("Machine is " + (this.mActive ? "active" : "inactive"));
            if (!this.mHasEnoughEnergy) {
                tList.add("ATTENTION: This Device consumes Energy at a higher Rate than you input. You could insert more to speed up the process.");
            }
        }
        return this.mMetaTileEntity.getSpecialDebugInfo(this, aPlayer, aLogLevel, tList);
    }

    @Override
    public void issueTextureUpdate() {
        this.mNeedsUpdate = true;
    }

    @Override
    public void issueBlockUpdate() {
        this.mNeedsBlockUpdate = true;
    }

    @Override
    public void issueClientUpdate() {
        this.mSendClientData = true;
    }

    @Override
    public void issueCoverUpdate(byte aSide) {
        this.issueClientUpdate();
    }

    @Override
    public void receiveCoverData(byte coverSide, int coverID, int coverData) {
        if (coverSide >= 0 && coverSide < 6 && this.mCoverSides[coverSide] == coverID) {
            this.setCoverDataAtSide(coverSide, coverData);
        }
    }

    @Override
    public byte getStrongestRedstone() {
        return (byte)Math.max(this.getInternalInputRedstoneSignal((byte)0), Math.max(this.getInternalInputRedstoneSignal((byte)1), Math.max(this.getInternalInputRedstoneSignal((byte)2), Math.max(this.getInternalInputRedstoneSignal((byte)3), Math.max(this.getInternalInputRedstoneSignal((byte)4), this.getInternalInputRedstoneSignal((byte)5))))));
    }

    @Override
    public boolean getRedstone() {
        return this.getRedstone((byte)0) || this.getRedstone((byte)1) || this.getRedstone((byte)2) || this.getRedstone((byte)3) || this.getRedstone((byte)4) || this.getRedstone((byte)5);
    }

    @Override
    public boolean getRedstone(byte aSide) {
        return this.getInternalInputRedstoneSignal(aSide) > 0;
    }

    public ITexture getCoverTexture(byte aSide) {
        return GregTech_API.sCovers.get(new GT_ItemStack(this.getCoverIDAtSide(aSide)));
    }

    @Override
    public boolean isGivingInformation() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.isGivingInformation();
        }
        return false;
    }

    @Override
    public boolean isValidFacing(byte aSide) {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.isFacingValid(aSide);
        }
        return false;
    }

    @Override
    public byte getBackFacing() {
        return GT_Utility.getOppositeSide(this.mFacing);
    }

    @Override
    public byte getFrontFacing() {
        return this.mFacing;
    }

    @Override
    public void setFrontFacing(byte aFacing) {
        if (this.isValidFacing(aFacing)) {
            this.mFacing = aFacing;
            this.mFluidFacing = aFacing;
            if (this.isClientSide()) {
                this.rebakeMap();
            }
            this.mMetaTileEntity.onFacingChange();
            this.onMachineBlockUpdate();
        }
    }

    @Override
    public byte getFluidFacing() {
        return this.mFluidFacing;
    }

    @SideOnly(value=Side.CLIENT)
    public void sendPressedKeys(EntityPlayer aPlayer, World aWorld) {
        boolean isCtrl = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        boolean isAlt = Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
        GT_Values.NW.sendToServer(new GT_Packet_Key(aPlayer.func_145782_y(), aWorld.field_73011_w.field_76574_g, isAlt, isCtrl));
    }

    @Override
    public void setFrontFacingByWrench(byte aFacing, EntityPlayer aPlayer) {
        if (this.isValidFacing(aFacing)) {
            if (this.mMetaTileEntity.isElectric()) {
                if (GT_Packet_Key.isCtrlPressed(aPlayer)) {
                    this.mFluidFacing = aFacing;
                } else {
                    this.mFacing = aFacing;
                }
            } else {
                this.mFluidFacing = aFacing;
                this.mFacing = aFacing;
            }
            if (this.isClientSide()) {
                this.rebakeMap();
            }
            this.mMetaTileEntity.onFacingChange();
            this.onMachineBlockUpdate();
        }
    }

    public int func_70302_i_() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70301_a(int aIndex) {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.func_70301_a(aIndex);
        }
        return null;
    }

    public void func_70299_a(int aIndex, ItemStack aStack) {
        this.mInventoryChanged = true;
        if (this.canAccessData()) {
            this.mMetaTileEntity.func_70299_a(aIndex, this.field_145850_b.field_72995_K ? aStack : GT_OreDictUnificator.setStack(true, aStack));
        }
    }

    public String func_145825_b() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.func_145825_b();
        }
        if (GregTech_API.METATILEENTITIES[this.mID] != null) {
            return GregTech_API.METATILEENTITIES[this.mID].func_145825_b();
        }
        return "";
    }

    public int func_70297_j_() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.func_70297_j_();
        }
        return 64;
    }

    public void func_70295_k_() {
        if (this.canAccessData()) {
            this.mMetaTileEntity.onOpenGUI();
        }
    }

    public void func_70305_f() {
        if (this.canAccessData()) {
            this.mMetaTileEntity.onCloseGUI();
        }
    }

    public boolean func_70300_a(EntityPlayer aPlayer) {
        return this.canAccessData() && this.playerOwnsThis(aPlayer, false) && this.mTickTimer > 40L && this.getTileEntityOffset(0, 0, 0) == this && aPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0 && this.mMetaTileEntity.isAccessAllowed(aPlayer);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.mTickTimer = 0L;
    }

    @Override
    public void func_145843_s() {
        this.field_145846_f = false;
        if (this.canAccessData()) {
            this.mMetaTileEntity.onRemoval();
            this.mMetaTileEntity.setBaseMetaTileEntity(null);
        }
        super.func_145843_s();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.mMetaTileEntity != null) {
            this.mMetaTileEntity.onChunkUnload();
        }
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    @Override
    public void onMachineBlockUpdate() {
        if (this.canAccessData()) {
            this.mMetaTileEntity.onMachineBlockUpdate();
        }
    }

    @Override
    public int getProgress() {
        return this.canAccessData() ? this.mMetaTileEntity.getProgresstime() : 0;
    }

    @Override
    public int getMaxProgress() {
        return this.canAccessData() ? this.mMetaTileEntity.maxProgresstime() : 0;
    }

    @Override
    public boolean increaseProgress(int aProgressAmountInTicks) {
        return this.canAccessData() ? this.mMetaTileEntity.increaseProgress(aProgressAmountInTicks) != aProgressAmountInTicks : false;
    }

    @Override
    public boolean hasThingsToDo() {
        return this.getMaxProgress() > 0;
    }

    @Override
    public void enableWorking() {
        if (!this.mWorks) {
            this.mWorkUpdate = true;
        }
        this.mWorks = true;
    }

    @Override
    public void disableWorking() {
        this.mWorks = false;
    }

    @Override
    public boolean isAllowedToWork() {
        return this.mWorks;
    }

    @Override
    public boolean hasWorkJustBeenEnabled() {
        return this.mWorkUpdate;
    }

    @Override
    public byte getWorkDataValue() {
        return this.mWorkData;
    }

    @Override
    public void setWorkDataValue(byte aValue) {
        this.mWorkData = aValue;
    }

    @Override
    public int getMetaTileID() {
        return this.mID;
    }

    @Override
    public int setMetaTileID(short aID) {
        this.mID = aID;
        return this.mID;
    }

    @Override
    public boolean isActive() {
        return this.mActive;
    }

    @Override
    public void setActive(boolean aActive) {
        this.mActive = aActive;
    }

    @Override
    public long getTimer() {
        return this.mTickTimer;
    }

    @Override
    public boolean decreaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooLessEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        this.mHasEnoughEnergy = this.decreaseStoredEU(aEnergy, aIgnoreTooLessEnergy) || this.decreaseStoredSteam(aEnergy, false) || aIgnoreTooLessEnergy && this.decreaseStoredSteam(aEnergy, true);
        return this.mHasEnoughEnergy;
    }

    @Override
    public boolean increaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooMuchEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (this.getStoredEU() < this.getEUCapacity() || aIgnoreTooMuchEnergy) {
            this.setStoredEU(this.mMetaTileEntity.getEUVar() + aEnergy);
            return true;
        }
        return false;
    }

    @Override
    public boolean inputEnergyFrom(byte aSide) {
        return this.inputEnergyFrom(aSide, true);
    }

    @Override
    public boolean inputEnergyFrom(byte aSide, boolean waitForActive) {
        if (aSide == 6) {
            return true;
        }
        if (this.isServerSide() && waitForActive) {
            return aSide >= 0 && aSide < 6 && this.mActiveEUInputs[aSide] && !this.mReleaseEnergy;
        }
        return this.isEnergyInputSide(aSide);
    }

    @Override
    public boolean outputsEnergyTo(byte aSide) {
        return this.outputsEnergyTo(aSide, true);
    }

    @Override
    public boolean outputsEnergyTo(byte aSide, boolean waitForActive) {
        if (aSide == 6) {
            return true;
        }
        if (this.isServerSide() && waitForActive) {
            return aSide >= 0 && aSide < 6 && this.mActiveEUOutputs[aSide] || this.mReleaseEnergy;
        }
        return this.isEnergyOutputSide(aSide);
    }

    @Override
    public long getOutputAmperage() {
        if (this.canAccessData() && this.mMetaTileEntity.isElectric()) {
            return this.mMetaTileEntity.maxAmperesOut();
        }
        return 0L;
    }

    @Override
    public long getOutputVoltage() {
        if (this.canAccessData() && this.mMetaTileEntity.isElectric() && this.mMetaTileEntity.isEnetOutput()) {
            return this.mMetaTileEntity.maxEUOutput();
        }
        return 0L;
    }

    @Override
    public long getInputAmperage() {
        if (this.canAccessData() && this.mMetaTileEntity.isElectric()) {
            return this.mMetaTileEntity.maxAmperesIn();
        }
        return 0L;
    }

    @Override
    public long getInputVoltage() {
        if (this.canAccessData() && this.mMetaTileEntity.isElectric()) {
            return this.mMetaTileEntity.maxEUInput();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean increaseStoredSteam(long aEnergy, boolean aIgnoreTooMuchEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (this.mMetaTileEntity.getSteamVar() < this.getSteamCapacity() || aIgnoreTooMuchEnergy) {
            this.setStoredSteam(this.mMetaTileEntity.getSteamVar() + aEnergy);
            return true;
        }
        return false;
    }

    @Override
    public String[] getDescription() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getDescription();
        }
        return new String[0];
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.isValidSlot(aIndex);
        }
        return false;
    }

    @Override
    public long getUniversalEnergyStored() {
        return Math.max(this.getStoredEU(), this.getStoredSteam());
    }

    @Override
    public long getUniversalEnergyCapacity() {
        return Math.max(this.getEUCapacity(), this.getSteamCapacity());
    }

    @Override
    public long getStoredEU() {
        if (this.canAccessData()) {
            return Math.min(this.mMetaTileEntity.getEUVar(), this.getEUCapacity());
        }
        return 0L;
    }

    @Override
    public long getEUCapacity() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.maxEUStore();
        }
        return 0L;
    }

    @Override
    public long getStoredSteam() {
        if (this.canAccessData()) {
            return Math.min(this.mMetaTileEntity.getSteamVar(), this.getSteamCapacity());
        }
        return 0L;
    }

    @Override
    public long getSteamCapacity() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.maxSteamStore();
        }
        return 0L;
    }

    @Override
    public ITexture[] getTexture(Block aBlock, byte aSide) {
        if (this.getCoverIDAtSide(aSide) != 0) {
            return new ITexture[]{this.getCoverTexture(aSide)};
        }
        if (this.hasValidMetaTileEntity()) {
            if (this.mWaterProof || this.mMetaTileEntity.isWaterProofByDefault()) {
                ITexture[] textures = this.mMetaTileEntity.getTexture(this, aSide, this.mFacing, (byte)(this.mColor - 1), this.mActive, this.getOutputRedstoneSignal(aSide) > 0, this.mFluidFacing);
                ITexture[] out = new ITexture[textures.length + 1];
                System.arraycopy(textures, 0, out, 0, textures.length);
                out[out.length - 1] = new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_WATERPROOF);
                return out;
            }
            return this.mMetaTileEntity.getTexture(this, aSide, this.mFacing, (byte)(this.mColor - 1), this.mActive, this.getOutputRedstoneSignal(aSide) > 0, this.mFluidFacing);
        }
        return Textures.BlockIcons.ERROR_RENDERING;
    }

    @Override
    public ITexture[][] getTextures() {
        return this.mTextures[this.mActive ? 1 : 0][this.mColor];
    }

    @Override
    public ITexture[][] getTextures(ItemStack aStack, byte aFacing, boolean aActive, boolean aRedstone, boolean placeCovers, byte aFluidFacing) {
        byte i;
        ITexture[][] tOut = new ITexture[6][];
        boolean cActive = this.mActive;
        boolean cWaterProof = this.mWaterProof;
        this.mActive = aActive;
        NBTTagCompound tNBT = aStack.func_77978_p();
        byte cColorIndex = this.mColor;
        byte cFacing = this.mFacing;
        byte cFluidFacing = this.mFluidFacing;
        int[] cCoverSides = this.mCoverSides;
        int[] cCoverData = this.mCoverData;
        this.mFacing = aFacing;
        this.mFluidFacing = aFluidFacing;
        if (tNBT != null) {
            this.mColor = tNBT.func_74771_c("mColor");
            this.mCoverSides = tNBT.func_74759_k("mCoverSides");
            this.mCoverData = tNBT.func_74759_k("mCoverData");
            this.mWaterProof = tNBT.func_74767_n("mWaterProof");
        }
        if (this.mCoverSides.length == 0) {
            this.mCoverSides = EMPTY;
            this.mCoverData = EMPTY;
        } else {
            this.mCoverSides = (int[])this.mCoverSides.clone();
            this.mCoverData = (int[])this.mCoverData.clone();
        }
        if (placeCovers) {
            this.mCoverSides[this.mFacing + 1] = this.mCoverSides[this.mFacing];
            this.mCoverSides[this.mFacing] = 0;
            int cover = 0;
            for (byte i2 = 2; i2 < 6; i2 = (byte)(i2 + 1)) {
                if (i2 == aFacing || this.mCoverSides[i2] == 0) continue;
                cover = this.mCoverSides[i2];
                break;
            }
            this.mCoverSides[3] = cover;
        } else {
            for (i = 2; i < 6; ++i) {
                if (this.mCoverSides[i] != 0) continue;
                this.mFacing = i;
                break;
            }
        }
        for (i = 0; i < 6; i = (byte)(i + 1)) {
            tOut[i] = this.getTexture(null, i);
        }
        this.mFacing = cFacing;
        this.mFluidFacing = cFluidFacing;
        this.mActive = cActive;
        this.mColor = cColorIndex;
        this.mWaterProof = cWaterProof;
        this.mCoverSides = cCoverSides;
        this.mCoverData = cCoverData;
        return tOut;
    }

    @Override
    public ITexture[][] getTextures(boolean tCovered) {
        return this.getTextures();
    }

    public void bakeTextureMap() {
        Block b = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        byte q = this.mColor;
        boolean a = this.mActive;
        for (int s = 0; s < 2; ++s) {
            this.mActive = s == 1;
            for (int c = 0; c < 17; c = (int)((byte)(c + 1))) {
                this.mColor = (byte)c;
                for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                    this.mTextures[s][c][i] = this.getTexture(b, i);
                }
            }
        }
        this.mColor = q;
        this.mActive = a;
    }

    @Override
    public void rebakeMap() {
        this.mTextures = new ITexture[2][17][6][];
        this.bakeTextureMap();
    }

    private boolean isEnergyInputSide(byte aSide) {
        if (aSide >= 0 && aSide < 6) {
            if (!this.getCoverBehaviorAtSide(aSide).letsEnergyIn(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this)) {
                return false;
            }
            if (this.func_145837_r() || this.mReleaseEnergy) {
                return false;
            }
            if (this.canAccessData() && this.mMetaTileEntity.isElectric() && this.mMetaTileEntity.isEnetInput()) {
                return this.mMetaTileEntity.isInputFacing(aSide);
            }
        }
        return false;
    }

    private boolean isEnergyOutputSide(byte aSide) {
        if (aSide >= 0 && aSide < 6) {
            if (!this.getCoverBehaviorAtSide(aSide).letsEnergyOut(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this)) {
                return false;
            }
            if (this.func_145837_r() || this.mReleaseEnergy) {
                return this.mReleaseEnergy;
            }
            if (this.canAccessData() && this.mMetaTileEntity.isElectric() && this.mMetaTileEntity.isEnetOutput()) {
                return this.mMetaTileEntity.isOutputFacing(aSide);
            }
        }
        return false;
    }

    protected boolean hasValidMetaTileEntity() {
        return this.mMetaTileEntity != null && this.mMetaTileEntity.getBaseMetaTileEntity() == this;
    }

    protected boolean canAccessData() {
        return !this.isDead && this.hasValidMetaTileEntity();
    }

    public boolean setStoredEU(long aEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (aEnergy < 0L) {
            aEnergy = 0L;
        }
        this.mMetaTileEntity.setEUVar(aEnergy);
        return true;
    }

    public boolean setStoredSteam(long aEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (aEnergy < 0L) {
            aEnergy = 0L;
        }
        this.mMetaTileEntity.setSteamVar(aEnergy);
        return true;
    }

    public boolean decreaseStoredEU(long aEnergy, boolean aIgnoreTooLessEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (this.mMetaTileEntity.getEUVar() - aEnergy >= 0L || aIgnoreTooLessEnergy) {
            this.setStoredEU(this.mMetaTileEntity.getEUVar() - aEnergy);
            if (this.mMetaTileEntity.getEUVar() < 0L) {
                this.setStoredEU(0L);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean decreaseStoredSteam(long aEnergy, boolean aIgnoreTooLessEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (this.mMetaTileEntity.getSteamVar() - aEnergy >= 0L || aIgnoreTooLessEnergy) {
            this.setStoredSteam(this.mMetaTileEntity.getSteamVar() - aEnergy);
            if (this.mMetaTileEntity.getSteamVar() < 0L) {
                this.setStoredSteam(0L);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean playerOwnsThis(EntityPlayer aPlayer, boolean aCheckPrecicely) {
        if (!this.canAccessData()) {
            return false;
        }
        if (aCheckPrecicely || this.privateAccess() || this.mOwnerName.length() == 0) {
            if (this.mOwnerName.length() == 0 && this.isServerSide()) {
                this.setOwnerName(aPlayer.getDisplayName());
            } else if (this.privateAccess() && !aPlayer.getDisplayName().equals("Player") && !this.mOwnerName.equals("Player") && !this.mOwnerName.equals(aPlayer.getDisplayName())) {
                return false;
            }
        }
        return true;
    }

    public boolean privateAccess() {
        if (!this.canAccessData()) {
            return this.mLockUpgrade;
        }
        return this.mLockUpgrade || this.mMetaTileEntity.ownerControl();
    }

    public void doEnergyExplosion() {
        if (this.getUniversalEnergyCapacity() > 0L && this.getUniversalEnergyStored() >= this.getUniversalEnergyCapacity() / 5L) {
            this.doExplosion(this.oOutput * (long)(this.getUniversalEnergyStored() >= this.getUniversalEnergyCapacity() ? 4 : (this.getUniversalEnergyStored() >= this.getUniversalEnergyCapacity() / 2L ? 2 : 1)));
            GT_Mod.achievements.issueAchievement(this.func_145831_w().func_72924_a(this.mOwnerName), "electricproblems");
        }
    }

    @Override
    public void doExplosion(long aAmount) {
        if (this.canAccessData()) {
            if (GregTech_API.sMachineWireFire && this.mMetaTileEntity.isElectric()) {
                try {
                    this.mReleaseEnergy = true;
                    IEnergyConnected.Util.emitEnergyToNetwork(GT_Values.V[5], Math.max(1L, this.getStoredEU() / GT_Values.V[5]), this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mReleaseEnergy = false;
            this.mMetaTileEntity.onExplosion();
            if (GT_Mod.gregtechproxy.mExplosionItemDrop) {
                for (int i = 0; i < this.func_70302_i_(); ++i) {
                    ItemStack tItem = this.func_70301_a(i);
                    if (tItem == null || tItem.field_77994_a <= 0 || !this.isValidSlot(i)) continue;
                    this.dropItems(tItem);
                    this.func_70299_a(i, null);
                }
            }
            if (GT_Mod.gregtechproxy.disassemblerRecipeMapOn) {
                GT_Recipe recipe;
                if (this.mMetaTileEntity != null && (recipe = GT_Recipe.GT_Recipe_Map.sDisassemblerRecipes.findRecipe((IHasWorldObjectAndCoords)this, (GT_Recipe)null, false, (long)Integer.MAX_VALUE, new FluidStack[0], (ItemStack)null, new ItemStack[]{this.mMetaTileEntity.getStackForm(1L)})) != null && recipe.mOutputs != null) {
                    for (int i = 0; i < recipe.mOutputs.length; ++i) {
                        if (recipe.mOutputs[i] == null || this.getRandomNumber(100) >= 50) continue;
                        this.dropItems(recipe.mOutputs[i].func_77946_l());
                    }
                }
            } else if (this.mRecipeStuff != null) {
                for (int i = 0; i < 9; ++i) {
                    if (this.getRandomNumber(100) >= 50) continue;
                    this.dropItems(GT_Utility.loadItem(this.mRecipeStuff, "Ingredient." + i));
                }
            }
            GT_Pollution.addPollution(this, 100000);
            this.mMetaTileEntity.doExplosion(aAmount);
        }
    }

    public void dropItems(ItemStack tItem) {
        if (tItem == null) {
            return;
        }
        Random tRandom = new Random();
        EntityItem tItemEntity = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + tRandom.nextFloat() * 0.8f + 0.1f), (double)((float)this.field_145848_d + tRandom.nextFloat() * 0.8f + 0.1f), (double)((float)this.field_145849_e + tRandom.nextFloat() * 0.8f + 0.1f), new ItemStack(tItem.func_77973_b(), tItem.field_77994_a, tItem.func_77960_j()));
        if (tItem.func_77942_o()) {
            tItemEntity.func_92059_d().func_77982_d((NBTTagCompound)tItem.func_77978_p().func_74737_b());
        }
        tItemEntity.field_70159_w = tRandom.nextGaussian() * 0.0500000007450581;
        tItemEntity.field_70181_x = tRandom.nextGaussian() * 0.0500000007450581 + 0.2000000029802322;
        tItemEntity.field_70179_y = tRandom.nextGaussian() * 0.0500000007450581;
        tItemEntity.field_70172_ad = 999999;
        tItemEntity.lifespan = 60000;
        try {
            if (ENTITY_ITEM_HEALTH_FIELD != null) {
                ENTITY_ITEM_HEALTH_FIELD.setInt(tItemEntity, 99999999);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.field_145850_b.func_72838_d((Entity)tItemEntity);
        tItem.field_77994_a = 0;
    }

    @Override
    public ArrayList<ItemStack> getDrops() {
        ItemStack rStack = new ItemStack(GregTech_API.sBlockMachines, 1, (int)this.mID);
        NBTTagCompound tNBT = new NBTTagCompound();
        if (this.mRecipeStuff != null && !this.mRecipeStuff.func_82582_d()) {
            tNBT.func_74782_a("GT.CraftingComponents", (NBTBase)this.mRecipeStuff);
        }
        if (this.mMuffler) {
            tNBT.func_74757_a("mMuffler", this.mMuffler);
        }
        if (this.mLockUpgrade) {
            tNBT.func_74757_a("mLockUpgrade", this.mLockUpgrade);
        }
        if (this.mSteamConverter) {
            tNBT.func_74757_a("mSteamConverter", this.mSteamConverter);
        }
        if (this.mColor > 0) {
            tNBT.func_74774_a("mColor", this.mColor);
        }
        if (this.mOtherUpgrades > 0) {
            tNBT.func_74774_a("mOtherUpgrades", this.mOtherUpgrades);
        }
        if (this.mStrongRedstone > 0) {
            tNBT.func_74774_a("mStrongRedstone", this.mStrongRedstone);
        }
        if (this.mWaterProof) {
            tNBT.func_74757_a("mWaterProof", this.mWaterProof);
        }
        for (int i = 0; i < this.mCoverSides.length; i = (int)((byte)(i + 1))) {
            if (this.mCoverSides[i] == 0) continue;
            tNBT.func_74783_a("mCoverData", this.mCoverData);
            tNBT.func_74783_a("mCoverSides", this.mCoverSides);
            break;
        }
        if (this.hasValidMetaTileEntity()) {
            this.mMetaTileEntity.setItemNBT(tNBT);
        }
        if (!tNBT.func_82582_d()) {
            rStack.func_77982_d(tNBT);
        }
        return new ArrayList<ItemStack>(Arrays.asList(rStack));
    }

    public int getUpgradeCount() {
        return (this.mMuffler ? 1 : 0) + (this.mLockUpgrade ? 1 : 0) + (this.mSteamConverter ? 1 : 0) + this.mOtherUpgrades;
    }

    @Override
    public boolean onRightclick(EntityPlayer aPlayer, byte aSide, float aX, float aY, float aZ) {
        if (this.isClientSide()) {
            this.sendPressedKeys(aPlayer, aPlayer.field_70170_p);
            if (aPlayer.func_70093_af()) {
                byte tSide = this.getCoverIDAtSide(aSide) == 0 ? GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ) : aSide;
                return this.getCoverBehaviorAtSide(tSide).hasCoverGUI();
            }
            if (this.getCoverBehaviorAtSide(aSide).onCoverRightclickClient(aSide, this, aPlayer, aX, aY, aZ)) {
                return true;
            }
            if (!this.getCoverBehaviorAtSide(aSide).isGUIClickable(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this)) {
                return false;
            }
        }
        if (this.isServerSide() && (!this.privateAccess() || aPlayer.getDisplayName().equalsIgnoreCase(this.getOwnerName()))) {
            ItemStack tCurrentItem = aPlayer.field_71071_by.func_70448_g();
            if (tCurrentItem != null) {
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sWrenchList)) {
                    if (aPlayer.func_70093_af() && this.mMetaTileEntity instanceof GT_MetaTileEntity_BasicMachine && ((GT_MetaTileEntity_BasicMachine)this.mMetaTileEntity).setMainFacing(GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ))) {
                        GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer);
                        GT_Utility.sendSoundToPlayers(this.field_145850_b, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    } else if (this.mMetaTileEntity.onWrenchRightClick(aSide, GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ), aPlayer, aX, aY, aZ)) {
                        GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer);
                        GT_Utility.sendSoundToPlayers(this.field_145850_b, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sScrewdriverList)) {
                    if (GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 200, (EntityLivingBase)aPlayer)) {
                        if (this.getCoverIDAtSide(aSide) == 0) {
                            aSide = GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ);
                        }
                        this.setCoverDataAtSide(aSide, this.getCoverBehaviorAtSide(aSide).onCoverScrewdriverclick(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this, aPlayer, aX, aY, aZ));
                        this.mMetaTileEntity.onScrewdriverRightClick(aSide, aPlayer, aX, aY, aZ);
                        GT_Utility.sendSoundToPlayers(this.field_145850_b, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sHardHammerList)) {
                    if (GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                        boolean bl = this.mInputDisabled = !this.mInputDisabled;
                        if (this.mInputDisabled) {
                            this.mOutputDisabled = !this.mOutputDisabled;
                        }
                        aPlayer.func_146105_b(new ChatComponentTranslation("Interaction_DESCRIPTION_Index_086", new Object[0]).func_150257_a(new ChatComponentTranslation(this.mInputDisabled ? "Interaction_DESCRIPTION_Index_087" : "Interaction_DESCRIPTION_Index_088", new Object[0]).func_150257_a(new ChatComponentTranslation("Interaction_DESCRIPTION_Index_089", new Object[0]).func_150257_a((IChatComponent)new ChatComponentTranslation(this.mOutputDisabled ? "Interaction_DESCRIPTION_Index_087" : "Interaction_DESCRIPTION_Index_088", new Object[0])))));
                        GT_Utility.sendSoundToPlayers(this.field_145850_b, GregTech_API.sSoundList.get(1), 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sSoftHammerList)) {
                    if (GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                        String tChat;
                        if (this.mWorks) {
                            this.disableWorking();
                        } else {
                            this.enableWorking();
                        }
                        String string = tChat = this.isAllowedToWork() ? "Interaction_DESCRIPTION_Index_088" : "Interaction_DESCRIPTION_Index_087";
                        if (this.getMetaTileEntity() != null && this.getMetaTileEntity().hasAlternativeModeText()) {
                            tChat = this.getMetaTileEntity().getAlternativeModeText();
                        }
                        aPlayer.func_146105_b(new ChatComponentTranslation("Interaction_DESCRIPTION_Index_090", new Object[0]).func_150257_a((IChatComponent)new ChatComponentTranslation(tChat, new Object[0])));
                        GT_Utility.sendSoundToPlayers(this.field_145850_b, GregTech_API.sSoundList.get(101), 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sSolderingToolList)) {
                    byte tSide = GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ);
                    if (this.mMetaTileEntity.onSolderingToolRightClick(aSide, tSide, aPlayer, aX, aY, aZ)) {
                        GT_Utility.sendSoundToPlayers(this.field_145850_b, GregTech_API.sSoundList.get(103), 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    } else if (GT_ModHandler.useSolderingIron(tCurrentItem, (EntityLivingBase)aPlayer)) {
                        this.mStrongRedstone = (byte)(this.mStrongRedstone ^ 1 << tSide);
                        aPlayer.func_146105_b(new ChatComponentTranslation("Interaction_DESCRIPTION_Index_091", new Object[]{tSide}).func_150257_a(new ChatComponentTranslation("Interaction_DESCRIPTION_Index_092", new Object[0]).func_150257_a((IChatComponent)new ChatComponentTranslation((this.mStrongRedstone & 1 << tSide) != 0 ? "Interaction_DESCRIPTION_Index_093" : "Interaction_DESCRIPTION_Index_094", new Object[0]))));
                        GT_Utility.sendSoundToPlayers(this.field_145850_b, GregTech_API.sSoundList.get(103), 3.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        this.issueBlockUpdate();
                    }
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sWireCutterList)) {
                    byte tSide = GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ);
                    if (this.mMetaTileEntity.onWireCutterRightClick(aSide, tSide, aPlayer, aX, aY, aZ)) {
                        GT_Utility.sendSoundToPlayers(this.field_145850_b, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    return true;
                }
                byte tSide = GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ);
                if (this.getCoverIDAtSide(tSide) == 0) {
                    if (GregTech_API.sCovers.containsKey(new GT_ItemStack(tCurrentItem))) {
                        if (GregTech_API.getCoverBehavior(tCurrentItem).isCoverPlaceable(tSide, new GT_ItemStack(tCurrentItem), this) && this.mMetaTileEntity.allowCoverOnSide(tSide, new GT_ItemStack(tCurrentItem))) {
                            this.setCoverItemAtSide(tSide, tCurrentItem);
                            if (!aPlayer.field_71075_bZ.field_75098_d) {
                                --tCurrentItem.field_77994_a;
                            }
                            GT_Utility.sendSoundToPlayers(this.field_145850_b, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                        return true;
                    }
                } else if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sCrowbarList)) {
                    if (GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                        GT_Utility.sendSoundToPlayers(this.field_145850_b, GregTech_API.sSoundList.get(0), 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        this.dropCover(tSide, aSide, false);
                    }
                    return true;
                }
                if (GT_Utility.isItemCell(tCurrentItem)) {
                    aSide = this.getCoverIDAtSide(aSide) == 0 ? GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ) : aSide;
                    return this.getCoverIDAtSide(aSide) > 0 && this.getCoverBehaviorAtSide(aSide).onCoverRightclick(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this, aPlayer, aX, aY, aZ);
                }
            } else if (aPlayer.func_70093_af()) {
                aSide = this.getCoverIDAtSide(aSide) == 0 ? GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ) : aSide;
                return this.getCoverIDAtSide(aSide) > 0 && this.getCoverBehaviorAtSide(aSide).onCoverShiftRightclick(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this, aPlayer);
            }
            if (this.getCoverBehaviorAtSide(aSide).onCoverRightclick(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this, aPlayer, aX, aY, aZ)) {
                return true;
            }
            if (!this.getCoverBehaviorAtSide(aSide).isGUIClickable(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this)) {
                return false;
            }
            if (this.isUpgradable() && tCurrentItem != null) {
                if (ItemList.Upgrade_Muffler.isStackEqual(aPlayer.field_71071_by.func_70448_g())) {
                    if (this.addMufflerUpgrade()) {
                        GT_Utility.sendSoundToPlayers(this.field_145850_b, GregTech_API.sSoundList.get(3), 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        if (!aPlayer.field_71075_bZ.field_75098_d) {
                            --aPlayer.field_71071_by.func_70448_g().field_77994_a;
                        }
                    }
                    return true;
                }
                if (ItemList.Upgrade_Lock.isStackEqual(aPlayer.field_71071_by.func_70448_g())) {
                    if (this.isUpgradable() && !this.mLockUpgrade) {
                        this.mLockUpgrade = true;
                        this.setOwnerName(aPlayer.getDisplayName());
                        GT_Utility.sendSoundToPlayers(this.field_145850_b, GregTech_API.sSoundList.get(3), 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        if (!aPlayer.field_71075_bZ.field_75098_d) {
                            --aPlayer.field_71071_by.func_70448_g().field_77994_a;
                        }
                    }
                    return true;
                }
            }
        }
        try {
            if (!aPlayer.func_70093_af() && this.hasValidMetaTileEntity()) {
                return this.mMetaTileEntity.onRightclick(this, aPlayer, aSide, aX, aY, aZ);
            }
        }
        catch (Throwable e) {
            GT_Log.err.println("Encountered Exception while rightclicking TileEntity, the Game should've crashed now, but I prevented that. Please report immediately  to GregTech Intergalactical!!!");
            e.printStackTrace(GT_Log.err);
        }
        return false;
    }

    @Override
    public void onLeftclick(EntityPlayer aPlayer) {
        try {
            if (aPlayer != null && this.hasValidMetaTileEntity()) {
                this.mMetaTileEntity.onLeftclick(this, aPlayer);
            }
        }
        catch (Throwable e) {
            GT_Log.err.println("Encountered Exception while leftclicking TileEntity, the Game should've crashed now, but I prevented that. Please report immidietly to GregTech Intergalactical!!!");
            e.printStackTrace(GT_Log.err);
        }
    }

    @Override
    public boolean isDigitalChest() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.isDigitalChest();
        }
        return false;
    }

    @Override
    public ItemStack[] getStoredItemData() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getStoredItemData();
        }
        return null;
    }

    @Override
    public void setItemCount(int aCount) {
        if (this.canAccessData()) {
            this.mMetaTileEntity.setItemCount(aCount);
        }
    }

    @Override
    public int getMaxItemCount() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getMaxItemCount();
        }
        return 0;
    }

    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        return this.canAccessData() && this.mMetaTileEntity.func_94041_b(aIndex, aStack);
    }

    public int[] func_94128_d(int aSide) {
        if (this.canAccessData() && (this.getCoverBehaviorAtSide((byte)aSide).letsItemsOut((byte)aSide, this.getCoverIDAtSide((byte)aSide), this.getCoverDataAtSide((byte)aSide), -1, this) || this.getCoverBehaviorAtSide((byte)aSide).letsItemsIn((byte)aSide, this.getCoverIDAtSide((byte)aSide), this.getCoverDataAtSide((byte)aSide), -1, this))) {
            return this.mMetaTileEntity.func_94128_d(aSide);
        }
        return new int[0];
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int aSide) {
        return this.canAccessData() && (this.mRunningThroughTick || !this.mInputDisabled) && this.getCoverBehaviorAtSide((byte)aSide).letsItemsIn((byte)aSide, this.getCoverIDAtSide((byte)aSide), this.getCoverDataAtSide((byte)aSide), aIndex, this) && this.mMetaTileEntity.func_102007_a(aIndex, aStack, aSide);
    }

    public boolean func_102008_b(int aIndex, ItemStack aStack, int aSide) {
        return this.canAccessData() && (this.mRunningThroughTick || !this.mOutputDisabled) && this.getCoverBehaviorAtSide((byte)aSide).letsItemsOut((byte)aSide, this.getCoverIDAtSide((byte)aSide), this.getCoverDataAtSide((byte)aSide), aIndex, this) && this.mMetaTileEntity.func_102008_b(aIndex, aStack, aSide);
    }

    @Override
    public boolean isUpgradable() {
        return this.canAccessData() && this.getUpgradeCount() < 8;
    }

    @Override
    public byte getInternalInputRedstoneSignal(byte aSide) {
        return (byte)(this.getCoverBehaviorAtSide(aSide).getRedstoneInput(aSide, this.getInputRedstoneSignal(aSide), this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this) & 0xF);
    }

    @Override
    public byte getInputRedstoneSignal(byte aSide) {
        return (byte)(this.field_145850_b.func_72878_l(this.getOffsetX(aSide, 1), (int)this.getOffsetY(aSide, 1), this.getOffsetZ(aSide, 1), (int)aSide) & 0xF);
    }

    @Override
    public byte getOutputRedstoneSignal(byte aSide) {
        return this.getCoverBehaviorAtSide(aSide).manipulatesSidedRedstoneOutput(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this) ? this.mSidedRedstone[aSide] : this.getGeneralRS(aSide);
    }

    public byte getGeneralRS(byte aSide) {
        if (this.mMetaTileEntity == null) {
            return 0;
        }
        return this.mMetaTileEntity.allowGeneralRedstoneOutput() ? this.mSidedRedstone[aSide] : (byte)0;
    }

    @Override
    public void setInternalOutputRedstoneSignal(byte aSide, byte aStrength) {
        if (!this.getCoverBehaviorAtSide(aSide).manipulatesSidedRedstoneOutput(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this)) {
            this.setOutputRedstoneSignal(aSide, aStrength);
        }
    }

    @Override
    public void setOutputRedstoneSignal(byte aSide, byte aStrength) {
        aStrength = (byte)Math.min(Math.max(0, aStrength), 15);
        if (aSide >= 0 && aSide < 6 && this.mSidedRedstone[aSide] != aStrength) {
            this.mSidedRedstone[aSide] = aStrength;
            this.issueBlockUpdate();
        }
    }

    @Override
    public boolean isSteamEngineUpgradable() {
        return this.isUpgradable() && !this.hasSteamEngineUpgrade() && this.getSteamCapacity() > 0L;
    }

    @Override
    public boolean addSteamEngineUpgrade() {
        if (this.isSteamEngineUpgradable()) {
            this.issueBlockUpdate();
            this.mSteamConverter = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSteamEngineUpgrade() {
        if (this.canAccessData() && this.mMetaTileEntity.isSteampowered()) {
            return true;
        }
        return this.mSteamConverter;
    }

    @Override
    public boolean hasMufflerUpgrade() {
        return this.mMuffler;
    }

    @Override
    public boolean isMufflerUpgradable() {
        return this.isUpgradable() && !this.hasMufflerUpgrade();
    }

    @Override
    public boolean addMufflerUpgrade() {
        if (this.isMufflerUpgradable()) {
            this.mMuffler = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasInventoryBeenModified() {
        return this.mInventoryChanged;
    }

    @Override
    public void setGenericRedstoneOutput(boolean aOnOff) {
        this.mRedstone = aOnOff;
    }

    @Override
    public int getErrorDisplayID() {
        return this.mDisplayErrorCode;
    }

    @Override
    public void setErrorDisplayID(int aErrorID) {
        this.mDisplayErrorCode = aErrorID;
    }

    @Override
    public int getExtraInfo() {
        return this.extraInfo;
    }

    @Override
    public void setExtraInfo(int eInfo) {
        this.extraInfo = eInfo;
    }

    public boolean isFluidAutoOutputAllowed() {
        return this.allowFluidAutoOutput;
    }

    @Override
    public IMetaTileEntity getMetaTileEntity() {
        return this.hasValidMetaTileEntity() ? this.mMetaTileEntity : null;
    }

    @Override
    public void setMetaTileEntity(IMetaTileEntity aMetaTileEntity) {
        this.mMetaTileEntity = (MetaTileEntity)aMetaTileEntity;
    }

    @Override
    public GT_CoverBehavior getCoverBehaviorAtSide(byte aSide) {
        return aSide >= 0 && aSide < this.mCoverBehaviors.length ? this.mCoverBehaviors[aSide] : GregTech_API.sNoBehavior;
    }

    @Override
    public void setCoverIDAtSide(byte aSide, int aID) {
        if (aSide >= 0 && aSide < 6) {
            this.mCoverSides[aSide] = aID;
            this.mCoverData[aSide] = 0;
            this.mCoverBehaviors[aSide] = GregTech_API.getCoverBehavior(aID);
            this.issueCoverUpdate(aSide);
            this.issueBlockUpdate();
        }
    }

    @Override
    public void setCoverItemAtSide(byte aSide, ItemStack aCover) {
        GregTech_API.getCoverBehavior(aCover).placeCover(aSide, aCover, this);
    }

    @Override
    public int getCoverIDAtSide(byte aSide) {
        if (aSide >= 0 && aSide < 6) {
            return this.mCoverSides[aSide];
        }
        return 0;
    }

    @Override
    public ItemStack getCoverItemAtSide(byte aSide) {
        return GT_Utility.intToStack(this.getCoverIDAtSide(aSide));
    }

    @Override
    public boolean canPlaceCoverIDAtSide(byte aSide, int aID) {
        return this.getCoverIDAtSide(aSide) == 0;
    }

    @Override
    public boolean canPlaceCoverItemAtSide(byte aSide, ItemStack aCover) {
        return this.getCoverIDAtSide(aSide) == 0;
    }

    @Override
    public void setCoverDataAtSide(byte aSide, int aData) {
        if (aSide >= 0 && aSide < 6) {
            this.mCoverData[aSide] = aData;
        }
    }

    @Override
    public int getCoverDataAtSide(byte aSide) {
        if (aSide >= 0 && aSide < 6) {
            return this.mCoverData[aSide];
        }
        return 0;
    }

    public byte getLightValue() {
        return this.mLightValue;
    }

    @Override
    public void setLightValue(byte aLightValue) {
        this.mLightValue = (byte)(aLightValue & 0xF);
    }

    @Override
    public long getAverageElectricInput() {
        int rEU = 0;
        for (int i = 0; i < this.mAverageEUInput.length; ++i) {
            if (i == this.mAverageEUInputIndex) continue;
            rEU += this.mAverageEUInput[i];
        }
        return rEU / (this.mAverageEUInput.length - 1);
    }

    @Override
    public long getAverageElectricOutput() {
        int rEU = 0;
        for (int i = 0; i < this.mAverageEUOutput.length; ++i) {
            if (i == this.mAverageEUOutputIndex) continue;
            rEU += this.mAverageEUOutput[i];
        }
        return rEU / (this.mAverageEUOutput.length - 1);
    }

    @Override
    public boolean dropCover(byte aSide, byte aDroppedSide, boolean aForced) {
        if (this.getCoverBehaviorAtSide(aSide).onCoverRemoval(aSide, this.getCoverIDAtSide(aSide), this.mCoverData[aSide], this, aForced) || aForced) {
            ItemStack tStack = this.getCoverBehaviorAtSide(aSide).getDrop(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this);
            if (tStack != null) {
                tStack.func_77982_d(null);
                EntityItem tEntity = new EntityItem(this.field_145850_b, (double)this.getOffsetX(aDroppedSide, 1) + 0.5, (double)this.getOffsetY(aDroppedSide, 1) + 0.5, (double)this.getOffsetZ(aDroppedSide, 1) + 0.5, tStack);
                tEntity.field_70159_w = 0.0;
                tEntity.field_70181_x = 0.0;
                tEntity.field_70179_y = 0.0;
                this.field_145850_b.func_72838_d((Entity)tEntity);
            }
            this.setCoverIDAtSide(aSide, 0);
            if (this.mMetaTileEntity.hasSidedRedstoneOutputBehavior()) {
                this.setOutputRedstoneSignal(aSide, (byte)0);
            } else {
                this.setOutputRedstoneSignal(aSide, (byte)15);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getOwnerName() {
        if (GT_Utility.isStringInvalid(this.mOwnerName)) {
            return "Player";
        }
        return this.mOwnerName;
    }

    @Override
    public String setOwnerName(String aName) {
        if (GT_Utility.isStringInvalid(aName)) {
            this.mOwnerName = "Player";
            return "Player";
        }
        this.mOwnerName = aName;
        return this.mOwnerName;
    }

    @Override
    public byte getComparatorValue(byte aSide) {
        return this.canAccessData() ? this.mMetaTileEntity.getComparatorValue(aSide) : (byte)0;
    }

    @Override
    public byte getStrongOutputRedstoneSignal(byte aSide) {
        return aSide >= 0 && aSide < 6 && (this.mStrongRedstone & 1 << aSide) != 0 ? (byte)(this.mSidedRedstone[aSide] & 0xF) : (byte)0;
    }

    @Override
    public void setStrongOutputRedstoneSignal(byte aSide, byte aStrength) {
        this.mStrongRedstone = (byte)(this.mStrongRedstone | 1 << aSide);
        this.setOutputRedstoneSignal(aSide, aStrength);
    }

    public ItemStack func_70298_a(int aIndex, int aAmount) {
        if (this.canAccessData()) {
            this.mInventoryChanged = true;
            return this.mMetaTileEntity.func_70298_a(aIndex, aAmount);
        }
        return null;
    }

    @Override
    public long injectEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        if (!(this.canAccessData() && this.mMetaTileEntity.isElectric() && this.inputEnergyFrom(aSide) && aAmperage > 0L && aVoltage > 0L && this.getStoredEU() < this.getEUCapacity() && this.mMetaTileEntity.maxAmperesIn() > this.mAcceptedAmperes)) {
            return 0L;
        }
        if (aVoltage > this.getInputVoltage()) {
            this.doExplosion(aVoltage);
            return 0L;
        }
        if (this.increaseStoredEnergyUnits(aVoltage * (aAmperage = Math.min(aAmperage, Math.min(this.mMetaTileEntity.maxAmperesIn() - this.mAcceptedAmperes, 1L + (this.getEUCapacity() - this.getStoredEU()) / aVoltage))), true)) {
            int n = this.mAverageEUInputIndex;
            this.mAverageEUInput[n] = (int)((long)this.mAverageEUInput[n] + aVoltage * aAmperage);
            this.mAcceptedAmperes += aAmperage;
            return aAmperage;
        }
        return 0L;
    }

    @Override
    public boolean drainEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        if (!(this.canAccessData() && this.mMetaTileEntity.isElectric() && this.outputsEnergyTo(aSide) && this.getStoredEU() - aVoltage * aAmperage >= this.mMetaTileEntity.getMinimumStoredEU())) {
            return false;
        }
        if (this.decreaseStoredEU(aVoltage * aAmperage, false)) {
            int n = this.mAverageEUOutputIndex;
            this.mAverageEUOutput[n] = (int)((long)this.mAverageEUOutput[n] + aVoltage * aAmperage);
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsRotationalEnergy(byte aSide) {
        if (!this.canAccessData() || this.getCoverIDAtSide(aSide) != 0) {
            return false;
        }
        return this.mMetaTileEntity.acceptsRotationalEnergy(aSide);
    }

    @Override
    public boolean injectRotationalEnergy(byte aSide, long aSpeed, long aEnergy) {
        if (!this.canAccessData() || this.getCoverIDAtSide(aSide) != 0) {
            return false;
        }
        return this.mMetaTileEntity.injectRotationalEnergy(aSide, aSpeed, aEnergy);
    }

    public int fill(ForgeDirection aSide, FluidStack aFluid, boolean doFill) {
        if (this.mTickTimer > 5L && this.canAccessData() && (this.mRunningThroughTick || !this.mInputDisabled) && (aSide == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidInput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidIn((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), aFluid == null ? null : aFluid.getFluid(), this))) {
            return this.mMetaTileEntity.fill(aSide, aFluid, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection aSide, int maxDrain, boolean doDrain) {
        if (this.mTickTimer > 5L && this.canAccessData() && (this.mRunningThroughTick || !this.mOutputDisabled) && (aSide == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidOutput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidOut((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), this.mMetaTileEntity.getFluid() == null ? null : this.mMetaTileEntity.getFluid().getFluid(), this))) {
            return this.mMetaTileEntity.drain(aSide, maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection aSide, FluidStack aFluid, boolean doDrain) {
        if (this.mTickTimer > 5L && this.canAccessData() && (this.mRunningThroughTick || !this.mOutputDisabled) && (aSide == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidOutput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidOut((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), aFluid == null ? null : aFluid.getFluid(), this))) {
            return this.mMetaTileEntity.drain(aSide, aFluid, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection aSide, Fluid aFluid) {
        if (this.mTickTimer > 5L && this.canAccessData() && (this.mRunningThroughTick || !this.mInputDisabled) && (aSide == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidInput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidIn((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), aFluid, this))) {
            return this.mMetaTileEntity.canFill(aSide, aFluid);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection aSide, Fluid aFluid) {
        if (this.mTickTimer > 5L && this.canAccessData() && (this.mRunningThroughTick || !this.mOutputDisabled) && (aSide == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidOutput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidOut((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), aFluid, this))) {
            return this.mMetaTileEntity.canDrain(aSide, aFluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection aSide) {
        if (this.canAccessData() && (aSide == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidInput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidIn((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), null, this) || this.mMetaTileEntity.isLiquidOutput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidOut((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), null, this))) {
            return this.mMetaTileEntity.getTankInfo(aSide);
        }
        return new FluidTankInfo[0];
    }

    public double getOutputEnergyUnitsPerTick() {
        return this.oOutput;
    }

    public boolean isTeleporterCompatible(ForgeDirection aSide) {
        return this.canAccessData() && this.mMetaTileEntity.isTeleporterCompatible();
    }

    public double demandedEnergyUnits() {
        if (this.mReleaseEnergy || !this.canAccessData() || !this.mMetaTileEntity.isEnetInput()) {
            return 0.0;
        }
        return this.getEUCapacity() - this.getStoredEU();
    }

    public double injectEnergyUnits(ForgeDirection aDirection, double aAmount) {
        return this.injectEnergyUnits((byte)aDirection.ordinal(), (int)aAmount, 1L) > 0L ? 0.0 : aAmount;
    }

    public boolean acceptsEnergyFrom(TileEntity aEmitter, ForgeDirection aDirection) {
        return this.inputEnergyFrom((byte)aDirection.ordinal());
    }

    public boolean emitsEnergyTo(TileEntity aReceiver, ForgeDirection aDirection) {
        return this.outputsEnergyTo((byte)aDirection.ordinal());
    }

    public double getOfferedEnergy() {
        return this.canAccessData() && this.getStoredEU() - this.mMetaTileEntity.getMinimumStoredEU() >= this.oOutput ? (double)Math.max(0L, this.oOutput) : 0.0;
    }

    public void drawEnergy(double amount) {
        int n = this.mAverageEUOutputIndex;
        this.mAverageEUOutput[n] = (int)((double)this.mAverageEUOutput[n] + amount);
        this.decreaseStoredEU((int)amount, true);
    }

    public int injectEnergy(ForgeDirection aForgeDirection, int aAmount) {
        return this.injectEnergyUnits((byte)aForgeDirection.ordinal(), aAmount, 1L) > 0L ? 0 : aAmount;
    }

    public int addEnergy(int aEnergy) {
        if (!this.canAccessData()) {
            return 0;
        }
        if (aEnergy > 0) {
            this.increaseStoredEnergyUnits(aEnergy, true);
        } else {
            this.decreaseStoredEU(-aEnergy, true);
        }
        return (int)Math.min(Integer.MAX_VALUE, this.mMetaTileEntity.getEUVar());
    }

    public boolean isAddedToEnergyNet() {
        return false;
    }

    public int demandsEnergy() {
        if (this.mReleaseEnergy || !this.canAccessData() || !this.mMetaTileEntity.isEnetInput()) {
            return 0;
        }
        return this.getCapacity() - this.getStored();
    }

    public int getCapacity() {
        return (int)Math.min(Integer.MAX_VALUE, this.getEUCapacity());
    }

    public int getStored() {
        return (int)Math.min(Integer.MAX_VALUE, Math.min(this.getStoredEU(), (long)this.getCapacity()));
    }

    public void setStored(int aEU) {
        if (this.canAccessData()) {
            this.setStoredEU(aEU);
        }
    }

    public int getMaxSafeInput() {
        return (int)Math.min(Integer.MAX_VALUE, this.getInputVoltage());
    }

    public int getMaxEnergyOutput() {
        if (this.mReleaseEnergy) {
            return Integer.MAX_VALUE;
        }
        return this.getOutput();
    }

    public int getOutput() {
        return (int)Math.min(Integer.MAX_VALUE, this.oOutput);
    }

    public int injectEnergy(Direction aDirection, int aAmount) {
        return this.injectEnergyUnits((byte)aDirection.toSideValue(), aAmount, 1L) > 0L ? 0 : aAmount;
    }

    public boolean isTeleporterCompatible(Direction aSide) {
        return this.canAccessData() && this.mMetaTileEntity.isTeleporterCompatible();
    }

    public boolean acceptsEnergyFrom(TileEntity aReceiver, Direction aDirection) {
        return this.inputEnergyFrom((byte)aDirection.toSideValue());
    }

    public boolean emitsEnergyTo(TileEntity aReceiver, Direction aDirection) {
        return this.outputsEnergyTo((byte)aDirection.toSideValue());
    }

    @Override
    public boolean isInvalidTileEntity() {
        return this.func_145837_r();
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return true;
        }
        if (aIndex < 0 || aIndex >= this.func_70302_i_()) {
            return false;
        }
        ItemStack tStack = this.func_70301_a(aIndex);
        if (GT_Utility.isStackInvalid(tStack)) {
            this.func_70299_a(aIndex, aStack);
            return true;
        }
        if (GT_Utility.areStacksEqual(tStack, aStack = GT_OreDictUnificator.get(aStack)) && tStack.field_77994_a + aStack.field_77994_a <= Math.min(aStack.func_77976_d(), this.func_70297_j_())) {
            tStack.field_77994_a += aStack.field_77994_a;
            return true;
        }
        return false;
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack, int aAmount) {
        return this.addStackToSlot(aIndex, GT_Utility.copyAmount(aAmount, aStack));
    }

    @Override
    public byte getColorization() {
        return (byte)(this.mColor - 1);
    }

    @Override
    public byte setColorization(byte aColor) {
        if (aColor > 15 || aColor < -1) {
            aColor = (byte)-1;
        }
        this.mColor = (byte)(aColor + 1);
        if (this.canAccessData()) {
            this.mMetaTileEntity.onColorChangeServer(aColor);
        }
        return this.mColor;
    }

    @Override
    public float getBlastResistance(byte aSide) {
        return this.canAccessData() ? Math.max(0.0f, this.getMetaTileEntity().getExplosionResistance(aSide)) : 10.0f;
    }

    @Override
    public boolean isUniversalEnergyStored(long aEnergyAmount) {
        if (this.getUniversalEnergyStored() >= aEnergyAmount) {
            return true;
        }
        this.mHasEnoughEnergy = false;
        return false;
    }

    @Override
    public String[] getInfoData() {
        if (this.canAccessData()) {
            return this.getMetaTileEntity().getInfoData();
        }
        return new String[0];
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        this.mInventoryChanged = true;
    }

    @Override
    public int getLightOpacity() {
        return this.mMetaTileEntity == null ? (this.getLightValue() > 0 ? 0 : 255) : this.mMetaTileEntity.getLightOpacity();
    }

    @Override
    public void addCollisionBoxesToList(World aWorld, int aX, int aY, int aZ, AxisAlignedBB inputAABB, List<AxisAlignedBB> outputAABB, Entity collider) {
        this.mMetaTileEntity.addCollisionBoxesToList(aWorld, aX, aY, aZ, inputAABB, outputAABB, collider);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        return this.mMetaTileEntity.getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
    }

    @Override
    public void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity collider) {
        this.mMetaTileEntity.onEntityCollidedWithBlock(aWorld, aX, aY, aZ, collider);
    }

    private int shiftInventoryIndex(int slotIndex, int nbtVersion) {
        int newOutputSize;
        int newInputSize;
        int oldOutputSize;
        int oldInputSize;
        int chemistryUpdateVersion = GT_Mod.calculateTotalGTVersion(509, 31);
        if (this.mID >= 211 && this.mID <= 218) {
            if (nbtVersion >= chemistryUpdateVersion) {
                return slotIndex;
            }
            oldInputSize = 2;
            oldOutputSize = 1;
            newInputSize = 6;
            newOutputSize = 1;
        } else if (this.mID >= 421 && this.mID <= 428) {
            if (nbtVersion >= chemistryUpdateVersion) {
                return slotIndex;
            }
            oldInputSize = 2;
            oldOutputSize = 1;
            newInputSize = 2;
            newOutputSize = 2;
        } else if (this.mID >= 531 && this.mID <= 538) {
            if (nbtVersion >= chemistryUpdateVersion) {
                return slotIndex;
            }
            oldInputSize = 1;
            oldOutputSize = 0;
            newInputSize = 1;
            newOutputSize = 1;
        } else {
            return slotIndex;
        }
        int indexShift = 0;
        if (slotIndex >= 4 + oldInputSize) {
            indexShift += newInputSize - oldInputSize;
        }
        if (slotIndex >= 4 + oldInputSize + oldOutputSize) {
            indexShift += newOutputSize - oldOutputSize;
        }
        return slotIndex + indexShift;
    }

    static {
        Field f = null;
        try {
            f = EntityItem.class.getDeclaredField("field_70291_e");
            f.setAccessible(true);
        }
        catch (Exception e1) {
            try {
                f = EntityItem.class.getDeclaredField("health");
                f.setAccessible(true);
            }
            catch (Exception e2) {
                e1.printStackTrace();
                e2.printStackTrace();
            }
        }
        ENTITY_ITEM_HEALTH_FIELD = f;
        EMPTY = new int[]{0, 0, 0, 0, 0, 0};
    }
}

