/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import appeng.api.parts.IPartHost;
import appeng.tile.powersink.IC2;
import cofh.api.energy.IEnergyReceiver;
import com.google.common.collect.Sets;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.metatileentity.IMetaTileEntityCable;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Client;
import gregtech.common.covers.GT_Cover_SolarPanel;
import gregtech.loaders.postload.PartP2PGTPower;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.reactor.IReactorChamber;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import micdoodle8.mods.galacticraft.api.power.EnergySource;
import micdoodle8.mods.galacticraft.api.power.IEnergyHandlerGC;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaPipeEntity_Cable
extends MetaPipeEntity
implements IMetaTileEntityCable {
    public final float mThickNess;
    public final Materials mMaterial;
    public final long mCableLossPerMeter;
    public final long mAmperage;
    public final long mVoltage;
    public final boolean mInsulated;
    public final boolean mCanShock;
    public long mTransferredAmperage = 0L;
    public long mTransferredAmperageLast20 = 0L;
    public long mTransferredVoltageLast20 = 0L;
    public long mRestRF;
    public short mOverheat;
    private boolean mCheckConnections;
    private byte[] IC2RectorAtSide;

    public GT_MetaPipeEntity_Cable(int aID, String aName, String aNameRegional, float aThickNess, Materials aMaterial, long aCableLossPerMeter, long aAmperage, long aVoltage, boolean aInsulated, boolean aCanShock) {
        super(aID, aName, aNameRegional, 0);
        this.mCheckConnections = !GT_Mod.gregtechproxy.gt6Cable;
        this.IC2RectorAtSide = new byte[]{-1, -1, -1, -1, -1};
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mAmperage = aAmperage;
        this.mVoltage = aVoltage;
        this.mInsulated = aInsulated;
        this.mCanShock = aCanShock;
        this.mCableLossPerMeter = aCableLossPerMeter;
    }

    public GT_MetaPipeEntity_Cable(String aName, float aThickNess, Materials aMaterial, long aCableLossPerMeter, long aAmperage, long aVoltage, boolean aInsulated, boolean aCanShock) {
        super(aName, 0);
        this.mCheckConnections = !GT_Mod.gregtechproxy.gt6Cable;
        this.IC2RectorAtSide = new byte[]{-1, -1, -1, -1, -1};
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mAmperage = aAmperage;
        this.mVoltage = aVoltage;
        this.mInsulated = aInsulated;
        this.mCanShock = aCanShock;
        this.mCableLossPerMeter = aCableLossPerMeter;
    }

    @Override
    public byte getTileEntityBaseType() {
        return (byte)(this.mInsulated ? 9 : 8);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaPipeEntity_Cable(this.mName, this.mThickNess, this.mMaterial, this.mCableLossPerMeter, this.mAmperage, this.mVoltage, this.mInsulated, this.mCanShock);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aConnections, byte aColorIndex, boolean aConnected, boolean aRedstone) {
        if (!this.mInsulated) {
            return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
        }
        if (aConnected) {
            float tThickNess = this.getThickNess();
            if (tThickNess < 0.124f) {
                return new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.INSULATION_FULL, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.374f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture(Textures.BlockIcons.INSULATION_TINY, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.499f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture(Textures.BlockIcons.INSULATION_SMALL, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.624f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture(Textures.BlockIcons.INSULATION_MEDIUM, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.749f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture(Textures.BlockIcons.INSULATION_MEDIUM_PLUS, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.874f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture(Textures.BlockIcons.INSULATION_LARGE, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), new GT_RenderedTexture(Textures.BlockIcons.INSULATION_HUGE, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
        }
        return new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.INSULATION_FULL, Dyes.getModulation(aColorIndex, Dyes.CABLE_INSULATION.mRGBa))};
    }

    @Override
    public void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity aEntity) {
        if (this.mCanShock && (((BaseMetaPipeEntity)this.getBaseMetaTileEntity()).mConnections & 0xFFFFFF80) == 0 && aEntity instanceof EntityLivingBase && !this.isCoverOnSide((BaseMetaPipeEntity)this.getBaseMetaTileEntity(), (EntityLivingBase)aEntity)) {
            GT_Utility.applyElectricityDamage((EntityLivingBase)aEntity, this.mTransferredVoltageLast20, this.mTransferredAmperageLast20);
        }
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public final boolean renderInside(byte aSide) {
        return false;
    }

    @Override
    public int getProgresstime() {
        return (int)this.mTransferredAmperage * 64;
    }

    @Override
    public int maxProgresstime() {
        return (int)this.mAmperage * 64;
    }

    private void pullFromIc2EnergySources(IGregTechTileEntity aBaseMetaTileEntity, byte[] aSides) {
        if (!GT_Mod.gregtechproxy.ic2EnergySourceCompat) {
            return;
        }
        for (int i = 0; i < aSides.length; i = (int)((byte)(i + 1))) {
            long tEU;
            TileEntity tEmitter;
            TileEntity tTileEntity = aBaseMetaTileEntity.getTileEntityAtSide(aSides[i]);
            if (tTileEntity instanceof IReactorChamber) {
                tEmitter = (TileEntity)((IReactorChamber)tTileEntity).getReactor();
            } else {
                TileEntity tileEntity = tEmitter = tTileEntity == null || tTileEntity instanceof IEnergyTile || EnergyNet.instance == null ? tTileEntity : EnergyNet.instance.getTileEntity(tTileEntity.func_145831_w(), tTileEntity.field_145851_c, tTileEntity.field_145848_d, tTileEntity.field_145849_e);
            }
            if (!(tEmitter instanceof IEnergySource)) continue;
            GT_CoverBehavior coverBehavior = aBaseMetaTileEntity.getCoverBehaviorAtSide(aSides[i]);
            int coverId = aBaseMetaTileEntity.getCoverIDAtSide(aSides[i]);
            int coverData = aBaseMetaTileEntity.getCoverDataAtSide(aSides[i]);
            ForgeDirection tDirection = ForgeDirection.getOrientation((int)GT_Utility.getOppositeSide(aSides[i]));
            if (!((IEnergySource)tEmitter).emitsEnergyTo((TileEntity)aBaseMetaTileEntity, tDirection) || !coverBehavior.letsEnergyIn(aSides[i], coverId, coverData, aBaseMetaTileEntity) || this.transferElectricity(aSides[i], tEU = (long)((IEnergySource)tEmitter).getOfferedEnergy(), 1L, Sets.newHashSet((Object[])new TileEntity[]{(TileEntity)aBaseMetaTileEntity})) <= 0L) continue;
            ((IEnergySource)tEmitter).drawEnergy((double)tEU);
        }
    }

    @Override
    public long injectEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        if (!this.isConnectedAtSide(aSide) && aSide != 6) {
            return 0L;
        }
        if (!this.getBaseMetaTileEntity().getCoverBehaviorAtSide(aSide).letsEnergyIn(aSide, this.getBaseMetaTileEntity().getCoverIDAtSide(aSide), this.getBaseMetaTileEntity().getCoverDataAtSide(aSide), this.getBaseMetaTileEntity())) {
            return 0L;
        }
        return this.transferElectricity(aSide, aVoltage, aAmperage, Sets.newHashSet((Object[])new TileEntity[]{(TileEntity)this.getBaseMetaTileEntity()}));
    }

    @Override
    @Deprecated
    public long transferElectricity(byte aSide, long aVoltage, long aAmperage, ArrayList<TileEntity> aAlreadyPassedTileEntityList) {
        return this.transferElectricity(aSide, aVoltage, aAmperage, new HashSet<TileEntity>(aAlreadyPassedTileEntityList));
    }

    @Override
    public long transferElectricity(byte aSide, long aVoltage, long aAmperage, HashSet<TileEntity> aAlreadyPassedSet) {
        if (!this.isConnectedAtSide(aSide) && aSide != 6) {
            return 0L;
        }
        long rUsedAmperes = 0L;
        IGregTechTileEntity baseMetaTile = this.getBaseMetaTileEntity();
        if ((aVoltage -= this.mCableLossPerMeter) > 0L) {
            for (byte i = 0; i < 6 && aAmperage > rUsedAmperes; i = (byte)(i + 1)) {
                IMetaTileEntity tMeta;
                TileEntity tTileEntity;
                if (i == aSide || !this.isConnectedAtSide(i) || !baseMetaTile.getCoverBehaviorAtSide(i).letsEnergyOut(i, baseMetaTile.getCoverIDAtSide(i), baseMetaTile.getCoverDataAtSide(i), baseMetaTile) || (tTileEntity = baseMetaTile.getTileEntityAtSide(i)) == null || !aAlreadyPassedSet.add(tTileEntity)) continue;
                byte tSide = GT_Utility.getOppositeSide(i);
                IGregTechTileEntity tBaseMetaTile = tTileEntity instanceof IGregTechTileEntity ? (IGregTechTileEntity)tTileEntity : null;
                IMetaTileEntity iMetaTileEntity = tMeta = tBaseMetaTile != null ? tBaseMetaTile.getMetaTileEntity() : null;
                if (tMeta instanceof IMetaTileEntityCable) {
                    if (!tBaseMetaTile.getCoverBehaviorAtSide(tSide).letsEnergyIn(tSide, tBaseMetaTile.getCoverIDAtSide(tSide), tBaseMetaTile.getCoverDataAtSide(tSide), tBaseMetaTile) || ((IGregTechTileEntity)tTileEntity).getTimer() <= 50L) continue;
                    rUsedAmperes += ((IMetaTileEntityCable)((IGregTechTileEntity)tTileEntity).getMetaTileEntity()).transferElectricity(tSide, aVoltage, aAmperage - rUsedAmperes, aAlreadyPassedSet);
                    continue;
                }
                rUsedAmperes += this.insertEnergyInto(tTileEntity, tSide, aVoltage, aAmperage - rUsedAmperes);
            }
        }
        this.mTransferredAmperage += rUsedAmperes;
        this.mTransferredVoltageLast20 = Math.max(this.mTransferredVoltageLast20, aVoltage);
        this.mTransferredAmperageLast20 = Math.max(this.mTransferredAmperageLast20, this.mTransferredAmperage);
        if (aVoltage > this.mVoltage || this.mTransferredAmperage > this.mAmperage) {
            if (this.mOverheat > GT_Mod.gregtechproxy.mWireHeatingTicks * 100) {
                this.getBaseMetaTileEntity().setToFire();
            } else {
                this.mOverheat = (short)(this.mOverheat + 100);
            }
            return aAmperage;
        }
        return rUsedAmperes;
    }

    private long insertEnergyInto(TileEntity tTileEntity, byte tSide, long aVoltage, long aAmperage) {
        TileEntity tIc2Acceptor;
        if (aAmperage == 0L || tTileEntity == null) {
            return 0L;
        }
        IGregTechTileEntity baseMetaTile = this.getBaseMetaTileEntity();
        ForgeDirection tDirection = ForgeDirection.getOrientation((int)tSide);
        if (tTileEntity instanceof IEnergyConnected) {
            return ((IEnergyConnected)tTileEntity).injectEnergyUnits(tSide, aVoltage, aAmperage);
        }
        if (GT_Mod.gregtechproxy.mAE2Integration && tTileEntity instanceof IC2) {
            if (((IC2)tTileEntity).acceptsEnergyFrom((TileEntity)baseMetaTile, tDirection)) {
                long rUsedAmperes;
                for (rUsedAmperes = 0L; aAmperage > rUsedAmperes && ((IC2)tTileEntity).getDemandedEnergy() > 0.0 && ((IC2)tTileEntity).injectEnergy(tDirection, (double)aVoltage, (double)aVoltage) <= (double)aVoltage; ++rUsedAmperes) {
                }
                return rUsedAmperes;
            }
            return 0L;
        }
        if (GregTech_API.mGalacticraft && tTileEntity instanceof IEnergyHandlerGC) {
            float tReceived;
            EnergySource eSource;
            float tStored;
            float tSizeToReceive;
            if ((!(tTileEntity instanceof IConnector) || ((IConnector)tTileEntity).canConnect(tDirection, NetworkType.POWER)) && ((tSizeToReceive = (float)aVoltage * EnergyConfigHandler.IC2_RATIO) >= (tStored = ((IEnergyHandlerGC)tTileEntity).getEnergyStoredGC(eSource = (EnergySource)GT_Utility.callConstructor("micdoodle8.mods.galacticraft.api.power.EnergySource.EnergySourceAdjacent", 0, null, false, tDirection))) || tSizeToReceive <= ((IEnergyHandlerGC)tTileEntity).getMaxEnergyStoredGC(eSource) - tStored) && (tReceived = ((IEnergyHandlerGC)tTileEntity).receiveEnergyGC(eSource, tSizeToReceive, false)) > 0.0f) {
                tSizeToReceive -= tReceived;
                while (tSizeToReceive > 0.0f && !((tReceived = ((IEnergyHandlerGC)tTileEntity).receiveEnergyGC(eSource, tSizeToReceive, false)) < 1.0f)) {
                    tSizeToReceive -= tReceived;
                }
                return 1L;
            }
            return 0L;
        }
        TileEntity tileEntity = tIc2Acceptor = tTileEntity instanceof IEnergyTile || EnergyNet.instance == null ? tTileEntity : EnergyNet.instance.getTileEntity(tTileEntity.func_145831_w(), tTileEntity.field_145851_c, tTileEntity.field_145848_d, tTileEntity.field_145849_e);
        if (tIc2Acceptor instanceof IEnergySink && ((IEnergySink)tIc2Acceptor).acceptsEnergyFrom((TileEntity)baseMetaTile, tDirection)) {
            long rUsedAmperes;
            for (rUsedAmperes = 0L; aAmperage > rUsedAmperes && ((IEnergySink)tIc2Acceptor).getDemandedEnergy() > 0.0 && ((IEnergySink)tIc2Acceptor).injectEnergy(tDirection, (double)aVoltage, (double)aVoltage) <= (double)aVoltage; ++rUsedAmperes) {
            }
            return rUsedAmperes;
        }
        if (GregTech_API.mOutputRF && tTileEntity instanceof IEnergyReceiver) {
            int rfOut;
            IEnergyReceiver rfReceiver = (IEnergyReceiver)tTileEntity;
            long rfOUT = aVoltage * (long)GregTech_API.mEUtoRF / 100L;
            long rUsedAmperes = 0L;
            int n = rfOut = rfOUT > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)rfOUT;
            if (rfReceiver.receiveEnergy(tDirection, rfOut, true) == rfOut) {
                rfReceiver.receiveEnergy(tDirection, rfOut, false);
                ++rUsedAmperes;
            } else if (rfReceiver.receiveEnergy(tDirection, rfOut, true) > 0) {
                if (this.mRestRF == 0L) {
                    int RFtrans = rfReceiver.receiveEnergy(tDirection, rfOut, false);
                    ++rUsedAmperes;
                    this.mRestRF = rfOut - RFtrans;
                } else {
                    int RFtrans = rfReceiver.receiveEnergy(tDirection, (int)this.mRestRF, false);
                    this.mRestRF -= (long)RFtrans;
                }
            }
            if (GregTech_API.mRFExplosions && rfReceiver.getMaxEnergyStored(tDirection) < rfOut * 600 && rfOut > 32 * GregTech_API.mEUtoRF / 100) {
                this.doExplosion(rfOut);
            }
            return rUsedAmperes;
        }
        return 0L;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (GT_Mod.gregtechproxy.ic2EnergySourceCompat && this.IC2RectorAtSide[0] >= 0) {
                this.pullFromIc2EnergySources(aBaseMetaTileEntity, this.IC2RectorAtSide);
            }
            this.mTransferredAmperage = 0L;
            if (this.mOverheat > 0) {
                this.mOverheat = (short)(this.mOverheat - 1);
            }
            if (aTick % 20L == 0L) {
                this.mTransferredVoltageLast20 = 0L;
                this.mTransferredAmperageLast20 = 0L;
                if (!GT_Mod.gregtechproxy.gt6Cable || this.mCheckConnections) {
                    this.checkConnections();
                }
            }
        } else if (aBaseMetaTileEntity.isClientSide() && GT_Client.changeDetected == 4) {
            aBaseMetaTileEntity.issueTextureUpdate();
        }
    }

    @Override
    public boolean onWireCutterRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (GT_Mod.gregtechproxy.gt6Cable && GT_ModHandler.damageOrDechargeItem(aPlayer.field_71071_by.func_70448_g(), 1, 500, (EntityLivingBase)aPlayer)) {
            if (this.isConnectedAtSide(aWrenchingSide)) {
                this.disconnect(aWrenchingSide);
                aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_215", new Object[0]));
            } else if (!GT_Mod.gregtechproxy.costlyCableConnection && this.connect(aWrenchingSide) > 0) {
                aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_214", new Object[0]));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onSolderingToolRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (GT_Mod.gregtechproxy.gt6Cable && GT_ModHandler.damageOrDechargeItem(aPlayer.field_71071_by.func_70448_g(), 1, 500, (EntityLivingBase)aPlayer)) {
            if (this.isConnectedAtSide(aWrenchingSide)) {
                this.disconnect(aWrenchingSide);
                aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_215", new Object[0]));
            } else if ((!GT_Mod.gregtechproxy.costlyCableConnection || GT_ModHandler.consumeSolderingMaterial(aPlayer)) && this.connect(aWrenchingSide) > 0) {
                aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_214", new Object[0]));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean letsIn(GT_CoverBehavior coverBehavior, byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return coverBehavior.letsEnergyIn(aSide, aCoverID, aCoverVariable, aTileEntity);
    }

    @Override
    public boolean letsOut(GT_CoverBehavior coverBehavior, byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return coverBehavior.letsEnergyOut(aSide, aCoverID, aCoverVariable, aTileEntity);
    }

    @Override
    public boolean canConnect(byte aSide, TileEntity tTileEntity) {
        TileEntity ic2Energy;
        IGregTechTileEntity baseMetaTile = this.getBaseMetaTileEntity();
        GT_CoverBehavior coverBehavior = baseMetaTile.getCoverBehaviorAtSide(aSide);
        byte tSide = GT_Utility.getOppositeSide(aSide);
        ForgeDirection tDir = ForgeDirection.getOrientation((int)tSide);
        if (tTileEntity instanceof IEnergyConnected && (((IEnergyConnected)tTileEntity).inputEnergyFrom(tSide, false) || ((IEnergyConnected)tTileEntity).outputsEnergyTo(tSide, false))) {
            return true;
        }
        if (coverBehavior instanceof GT_Cover_SolarPanel) {
            return true;
        }
        if (GregTech_API.mGalacticraft && tTileEntity instanceof IEnergyHandlerGC && (!(tTileEntity instanceof IConnector) || ((IConnector)tTileEntity).canConnect(tDir, NetworkType.POWER))) {
            return true;
        }
        if (GT_Mod.gregtechproxy.mAE2Integration) {
            if (tTileEntity instanceof IEnergySource && tTileEntity instanceof IPartHost && ((IPartHost)tTileEntity).getPart(tDir) instanceof PartP2PGTPower && ((IEnergySource)tTileEntity).emitsEnergyTo((TileEntity)baseMetaTile, tDir)) {
                return true;
            }
            if (tTileEntity instanceof IC2 && ((IC2)tTileEntity).acceptsEnergyFrom((TileEntity)baseMetaTile, tDir)) {
                return true;
            }
        }
        if (tTileEntity instanceof IReactorChamber) {
            ic2Energy = (TileEntity)((IReactorChamber)tTileEntity).getReactor();
        } else {
            TileEntity tileEntity = ic2Energy = tTileEntity == null || tTileEntity instanceof IEnergyTile || EnergyNet.instance == null ? tTileEntity : EnergyNet.instance.getTileEntity(tTileEntity.func_145831_w(), tTileEntity.field_145851_c, tTileEntity.field_145848_d, tTileEntity.field_145849_e);
        }
        if (ic2Energy instanceof IEnergySink && ((IEnergySink)ic2Energy).acceptsEnergyFrom((TileEntity)baseMetaTile, tDir)) {
            return true;
        }
        if (GT_Mod.gregtechproxy.ic2EnergySourceCompat && ic2Energy instanceof IEnergySource && ((IEnergySource)ic2Energy).emitsEnergyTo((TileEntity)baseMetaTile, tDir)) {
            for (int i = 0; i < 5; i = (int)((byte)(i + 1))) {
                if (this.IC2RectorAtSide[i] >= 0) continue;
                this.IC2RectorAtSide[i] = aSide;
                break;
            }
            return true;
        }
        if (GregTech_API.mOutputRF && tTileEntity instanceof IEnergyReceiver && ((IEnergyReceiver)tTileEntity).canConnectEnergy(tDir)) {
            return true;
        }
        return GregTech_API.mInputRF && tTileEntity instanceof IEnergyEmitter && ((IEnergyEmitter)tTileEntity).emitsEnergyTo((TileEntity)baseMetaTile, tDir);
    }

    @Override
    public boolean getGT6StyleConnection() {
        return GT_Mod.gregtechproxy.gt6Cable;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Max Voltage: %%%" + EnumChatFormatting.GREEN + this.mVoltage + " (" + GT_Values.VN[GT_Utility.getTier(this.mVoltage)] + ")" + EnumChatFormatting.GRAY, "Max Amperage: %%%" + EnumChatFormatting.YELLOW + this.mAmperage + EnumChatFormatting.GRAY, "Loss/Meter/Ampere: %%%" + EnumChatFormatting.RED + this.mCableLossPerMeter + EnumChatFormatting.GRAY + "%%% EU-Volt"};
    }

    @Override
    public float getThickNess() {
        if (GT_Mod.instance.isClientSide() && (GT_Client.hideValue & 1) != 0) {
            return 0.0625f;
        }
        return this.mThickNess;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        if (GT_Mod.gregtechproxy.gt6Cable) {
            aNBT.func_74774_a("mConnections", this.mConnections);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (GT_Mod.gregtechproxy.gt6Cable) {
            this.mConnections = aNBT.func_74771_c("mConnections");
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        if (GT_Mod.instance.isClientSide() && (GT_Client.hideValue & 2) != 0) {
            return AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1));
        }
        return this.getActualCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
    }

    private AxisAlignedBB getActualCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        byte tConn;
        float tSpace;
        float tSide0 = tSpace = (1.0f - this.mThickNess) / 2.0f;
        float tSide1 = 1.0f - tSpace;
        float tSide2 = tSpace;
        float tSide3 = 1.0f - tSpace;
        float tSide4 = tSpace;
        float tSide5 = 1.0f - tSpace;
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)0) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)1) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)2) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)3) != 0) {
            tSide4 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)4) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide((byte)5) != 0) {
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (((tConn = ((BaseMetaPipeEntity)this.getBaseMetaTileEntity()).mConnections) & 1 << ForgeDirection.DOWN.ordinal()) != 0) {
            tSide0 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.UP.ordinal()) != 0) {
            tSide1 = 1.0f;
        }
        if ((tConn & 1 << ForgeDirection.NORTH.ordinal()) != 0) {
            tSide2 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.SOUTH.ordinal()) != 0) {
            tSide3 = 1.0f;
        }
        if ((tConn & 1 << ForgeDirection.WEST.ordinal()) != 0) {
            tSide4 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.EAST.ordinal()) != 0) {
            tSide5 = 1.0f;
        }
        return AxisAlignedBB.func_72330_a((double)((float)aX + tSide4), (double)((float)aY + tSide0), (double)((float)aZ + tSide2), (double)((float)aX + tSide5), (double)((float)aY + tSide1), (double)((float)aZ + tSide3));
    }

    @Override
    public void addCollisionBoxesToList(World aWorld, int aX, int aY, int aZ, AxisAlignedBB inputAABB, List<AxisAlignedBB> outputAABB, Entity collider) {
        AxisAlignedBB aabb;
        super.addCollisionBoxesToList(aWorld, aX, aY, aZ, inputAABB, outputAABB, collider);
        if (GT_Mod.instance.isClientSide() && (GT_Client.hideValue & 2) != 0 && inputAABB.func_72326_a(aabb = this.getActualCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ))) {
            outputAABB.add(aabb);
        }
    }
}

