/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_Container_2by2;
import gregtech.api.gui.GT_Container_MaintenanceHatch;
import gregtech.api.gui.GT_GUIContainer_2by2;
import gregtech.api.gui.GT_GUIContainer_MaintenanceHatch;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import ic2.core.IHasGui;
import ic2.core.item.ItemToolbox;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GT_MetaTileEntity_Hatch_Maintenance
extends GT_MetaTileEntity_Hatch {
    private static final ItemStack autoRepairKit = ItemList.AutoRepairKit.get(1L, new Object[0]);
    private static final ItemStack[] oldRepairItems = new ItemStack[]{ItemList.Duct_Tape.get(4L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.cell, Materials.Lubricant, 2L), GT_OreDictUnificator.get(OrePrefixes.screw, Materials.Steel, 4L), GT_OreDictUnificator.get(OrePrefixes.circuit, Materials.Advanced, 2L)};
    public boolean mWrench = false;
    public boolean mScrewdriver = false;
    public boolean mSoftHammer = false;
    public boolean mHardHammer = false;
    public boolean mSolderingTool = false;
    public boolean mCrowbar = false;
    private final RepairMethod mMethod;

    public static GT_MetaTileEntity_Hatch_Maintenance Manual(int aID, String aName, String aNameRegional, int aTier) {
        return new GT_MetaTileEntity_Hatch_Maintenance(aID, aName, aNameRegional, aTier, RepairMethod.Manual);
    }

    public static GT_MetaTileEntity_Hatch_Maintenance AutoKit(int aID, String aName, String aNameRegional, int aTier) {
        return new GT_MetaTileEntity_Hatch_Maintenance(aID, aName, aNameRegional, aTier, RepairMethod.AutoKit);
    }

    public static GT_MetaTileEntity_Hatch_Maintenance FullAuto(int aID, String aName, String aNameRegional, int aTier) {
        return new GT_MetaTileEntity_Hatch_Maintenance(aID, aName, aNameRegional, aTier, RepairMethod.FullAuto);
    }

    private GT_MetaTileEntity_Hatch_Maintenance(int aID, String aName, String aNameRegional, int aTier, RepairMethod method) {
        super(aID, aName, aNameRegional, aTier, GT_MetaTileEntity_Hatch_Maintenance.getBufferSize(method), GT_MetaTileEntity_Hatch_Maintenance.getShortDescription(method), new ITexture[0]);
        this.mMethod = method;
    }

    private GT_MetaTileEntity_Hatch_Maintenance(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, RepairMethod method) {
        super(aName, aTier, GT_MetaTileEntity_Hatch_Maintenance.getBufferSize(method), aDescription, aTextures);
        this.mMethod = method;
    }

    public boolean isAuto() {
        return this.mMethod != RepairMethod.Manual;
    }

    private static int getBufferSize(RepairMethod method) {
        return method == RepairMethod.AutoKit ? 4 : 1;
    }

    private static String getShortDescription(RepairMethod method) {
        switch (method) {
            case Manual: {
                return "For maintaining Multiblocks";
            }
            case AutoKit: {
                return "For automatically maintaining Multiblocks via repair kits";
            }
            case FullAuto: {
                return "For automatically maintaining Multiblocks without repair kits";
            }
        }
        return "";
    }

    private String getCostDescription() {
        switch (this.mMethod) {
            case Manual: {
                return "Cannot be shared between Multiblocks!";
            }
            case AutoKit: {
                return "1 Auto Repair Kit for each autorepair";
            }
            case FullAuto: {
                return "No need for maintaining!";
            }
        }
        return "";
    }

    @Override
    public String[] getDescription() {
        return GT_Utility.concat(this.mDescriptionArray, this.getCostDescription().split("\n"));
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_MAINTENANCE)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_MAINTENANCE), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_DUCTTAPE)};
    }

    @Override
    public void initDefaultModes(NBTTagCompound aNBT) {
        this.getBaseMetaTileEntity().setActive(true);
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return this.isAuto() && GT_Mod.gregtechproxy.mAMHInteraction;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_Maintenance(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mMethod);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, byte aSide, float aX, float aY, float aZ) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        if (this.mMethod != RepairMethod.FullAuto && aSide == aBaseMetaTileEntity.getFrontFacing()) {
            aBaseMetaTileEntity.openGUI(aPlayer);
        }
        return true;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.isAuto()) {
            return new GT_Container_2by2(aPlayerInventory, aBaseMetaTileEntity);
        }
        return new GT_Container_MaintenanceHatch(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.isAuto()) {
            return new GT_GUIContainer_2by2(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName());
        }
        return new GT_GUIContainer_MaintenanceHatch(aPlayerInventory, aBaseMetaTileEntity);
    }

    public void updateSlots() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
            this.mInventory[i] = null;
        }
    }

    private boolean areStacksSame(ItemStack a, ItemStack b) {
        return GT_Utility.areUnificationsEqual(a, b, true) || GT_Utility.areUnificationsEqual(GT_OreDictUnificator.get(false, a), b, true);
    }

    private int countStack(ItemStack[] aList, ItemStack aStack) {
        if (aStack == null) {
            return 0;
        }
        int count = 0;
        for (ItemStack tStack : aList) {
            if (!this.areStacksSame(tStack, aStack)) continue;
            count += tStack.field_77994_a;
        }
        return count;
    }

    private void fullRepair() {
        this.mCrowbar = true;
        this.mHardHammer = true;
        this.mScrewdriver = true;
        this.mSoftHammer = true;
        this.mSolderingTool = true;
        this.mWrench = true;
    }

    private void payCost(ItemStack[] repairCost) {
        block0: for (ItemStack row : repairCost) {
            if (row == null) continue;
            int rowCost = row.field_77994_a;
            for (ItemStack aStack : this.mInventory) {
                if (!this.areStacksSame(aStack, row)) continue;
                if (aStack.field_77994_a < rowCost) {
                    rowCost -= aStack.field_77994_a;
                    aStack.field_77994_a = 0;
                    continue;
                }
                aStack.field_77994_a -= rowCost;
                continue block0;
            }
        }
        this.updateSlots();
    }

    public boolean autoMaintainance() {
        if (!this.isAuto()) {
            return false;
        }
        if (this.mMethod == RepairMethod.FullAuto) {
            this.fullRepair();
            return true;
        }
        if (this.mInventory == null) {
            return false;
        }
        int kitsCount = this.countStack(this.mInventory, autoRepairKit);
        if (kitsCount >= GT_MetaTileEntity_Hatch_Maintenance.autoRepairKit.field_77994_a) {
            this.payCost(new ItemStack[]{autoRepairKit});
        } else {
            for (ItemStack row : oldRepairItems) {
                int inventoryCount = this.countStack(this.mInventory, row);
                if (row.field_77994_a <= inventoryCount) continue;
                return false;
            }
            this.payCost(oldRepairItems);
        }
        this.fullRepair();
        return true;
    }

    public void onToolClick(ItemStack aStack, EntityLivingBase aPlayer) {
        if (aStack == null || aPlayer == null) {
            return;
        }
        if (GT_OreDictUnificator.isItemStackInstanceOf(aStack, "craftingDuctTape")) {
            this.fullRepair();
            this.getBaseMetaTileEntity().setActive(false);
            --aStack.field_77994_a;
            return;
        }
        if (GT_Utility.isStackInList(aStack, GregTech_API.sWrenchList) && GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer)) {
            this.mWrench = true;
        }
        if (GT_Utility.isStackInList(aStack, GregTech_API.sScrewdriverList) && GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer)) {
            this.mScrewdriver = true;
        }
        if (GT_Utility.isStackInList(aStack, GregTech_API.sSoftHammerList) && GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer)) {
            this.mSoftHammer = true;
        }
        if (GT_Utility.isStackInList(aStack, GregTech_API.sHardHammerList) && GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer)) {
            this.mHardHammer = true;
        }
        if (GT_Utility.isStackInList(aStack, GregTech_API.sCrowbarList) && GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer)) {
            this.mCrowbar = true;
        }
        if (GT_Utility.isStackInList(aStack, GregTech_API.sSolderingToolList) && GT_ModHandler.useSolderingIron(aStack, aPlayer)) {
            this.mSolderingTool = true;
        }
        if (this.mSolderingTool && aPlayer instanceof EntityPlayerMP) {
            EntityPlayerMP tPlayer = (EntityPlayerMP)aPlayer;
            try {
                GT_Mod.achievements.issueAchievement((EntityPlayer)tPlayer, "maintainance");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (aStack.func_77973_b() instanceof ItemToolbox) {
            ItemToolbox tb = (ItemToolbox)aStack.func_77973_b();
            IHasGui tti = tb.getInventory((EntityPlayer)aPlayer, aStack);
            for (int i = 0; i < tti.func_70302_i_(); ++i) {
                this.onToolClick(tti.func_70301_a(i), aPlayer);
                ItemStack is = tti.func_70301_a(i);
                if (is == null || is.field_77994_a > 0) continue;
                tti.func_70299_a(i, null);
            }
        }
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        if (!this.isAuto() || !GT_Mod.gregtechproxy.mAMHInteraction) {
            return false;
        }
        if (this.isNotRepairItem(aStack)) {
            return false;
        }
        return this.isItemNotFull(aStack);
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        if (!this.isAuto() || !GT_Mod.gregtechproxy.mAMHInteraction) {
            return false;
        }
        if (this.isNotRepairItem(aStack)) {
            return false;
        }
        return this.isItemNotFull(aStack);
    }

    private boolean isNotRepairItem(ItemStack aStack) {
        if (this.areStacksSame(aStack, autoRepairKit)) {
            return false;
        }
        for (ItemStack nStack : oldRepairItems) {
            if (!this.areStacksSame(aStack, nStack)) continue;
            return false;
        }
        return true;
    }

    private boolean isItemNotFull(ItemStack aStack) {
        return this.countStack(this.mInventory, aStack) < 64;
    }

    public static enum RepairMethod {
        Manual,
        AutoKit,
        FullAuto;

    }
}

