/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.GT_Mod;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.objects.XSTR;
import gregtech.common.GT_Pollution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_Hatch_Muffler
extends GT_MetaTileEntity_Hatch {
    private static XSTR floatGen = new XSTR();

    public GT_MetaTileEntity_Hatch_Muffler(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, "Outputs the Pollution (Might cause acidic rains and poisoning)", new ITexture[0]);
    }

    public GT_MetaTileEntity_Hatch_Muffler(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Hatch_Muffler(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @Override
    public String[] getDescription() {
        String[] desc = new String[this.mDescriptionArray.length + 3];
        System.arraycopy(this.mDescriptionArray, 0, desc, 0, this.mDescriptionArray.length);
        desc[this.mDescriptionArray.length] = "DO NOT OBSTRUCT THE OUTPUT!";
        desc[this.mDescriptionArray.length + 1] = "Reduces Pollution to " + this.calculatePollutionReduction(100) + "%";
        desc[this.mDescriptionArray.length + 2] = "Recovers " + (105 - this.calculatePollutionReduction(100)) + "% of CO2/CO/SO2";
        return desc;
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_MUFFLER)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_MUFFLER)};
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing != 0;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_Muffler(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public boolean polluteEnvironment() {
        if (this.getBaseMetaTileEntity().getAirAtSide(this.getBaseMetaTileEntity().getFrontFacing())) {
            GT_Pollution.addPollution(this.getBaseMetaTileEntity(), this.calculatePollutionReduction(10000));
            return true;
        }
        return false;
    }

    public int calculatePollutionReduction(int aPollution) {
        return (int)((double)aPollution * Math.pow(0.7, this.mTier - 1));
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide() && this.getBaseMetaTileEntity().isActive()) {
            this.pollutionParticles(this.getBaseMetaTileEntity().getWorld(), "largesmoke");
        }
    }

    public void pollutionParticles(World aWorld, String name) {
        float zSpd;
        float xSpd;
        boolean chk3;
        boolean chk2;
        boolean chk1;
        float ran1 = floatGen.nextFloat();
        float ran2 = 0.0f;
        float ran3 = 0.0f;
        boolean bl = chk1 = ran1 * 100.0f < (float)this.calculatePollutionReduction(100);
        if (GT_Pollution.getPollution(this.getBaseMetaTileEntity()) >= GT_Mod.gregtechproxy.mPollutionSmogLimit) {
            ran2 = floatGen.nextFloat();
            ran3 = floatGen.nextFloat();
            chk2 = ran2 * 100.0f < (float)this.calculatePollutionReduction(100);
            boolean bl2 = chk3 = ran3 * 100.0f < (float)this.calculatePollutionReduction(100);
            if (!(chk1 || chk2 || chk3)) {
                return;
            }
        } else {
            if (!chk1) {
                return;
            }
            chk3 = false;
            chk2 = false;
        }
        IGregTechTileEntity aMuffler = this.getBaseMetaTileEntity();
        ForgeDirection aDir = ForgeDirection.getOrientation((int)aMuffler.getFrontFacing());
        float xPos = (float)aDir.offsetX * 0.76f + (float)aMuffler.getXCoord() + 0.25f;
        float yPos = (float)aDir.offsetY * 0.76f + (float)aMuffler.getYCoord() + 0.25f;
        float zPos = (float)aDir.offsetZ * 0.76f + (float)aMuffler.getZCoord() + 0.25f;
        float ySpd = (float)aDir.offsetY * 0.1f + 0.2f + 0.1f * floatGen.nextFloat();
        if (aDir.offsetY == -1) {
            float temp = floatGen.nextFloat() * 2.0f * (float)Math.PI;
            xSpd = (float)Math.sin(temp) * 0.1f;
            zSpd = (float)Math.cos(temp) * 0.1f;
        } else {
            xSpd = (float)aDir.offsetX * (0.1f + 0.2f * floatGen.nextFloat());
            zSpd = (float)aDir.offsetZ * (0.1f + 0.2f * floatGen.nextFloat());
        }
        if (chk1) {
            aWorld.func_72869_a(name, (double)(xPos + ran1 * 0.5f), (double)(yPos + floatGen.nextFloat() * 0.5f), (double)(zPos + floatGen.nextFloat() * 0.5f), (double)xSpd, (double)ySpd, (double)zSpd);
        }
        if (chk2) {
            aWorld.func_72869_a(name, (double)(xPos + ran2 * 0.5f), (double)(yPos + floatGen.nextFloat() * 0.5f), (double)(zPos + floatGen.nextFloat() * 0.5f), (double)xSpd, (double)ySpd, (double)zSpd);
        }
        if (chk3) {
            aWorld.func_72869_a(name, (double)(xPos + ran3 * 0.5f), (double)(yPos + floatGen.nextFloat() * 0.5f), (double)(zPos + floatGen.nextFloat() * 0.5f), (double)xSpd, (double)ySpd, (double)zSpd);
        }
    }
}

