/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_MetaTileEntity_Hatch_Output_Creative
extends GT_MetaTileEntity_Hatch {
    public GT_MetaTileEntity_Hatch_Output_Creative(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, new String[]{"Creative Fluid Output for Multiblocks"}, new ITexture[0]);
    }

    public GT_MetaTileEntity_Hatch_Output_Creative(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Hatch_Output_Creative(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isLiquidInput(byte aSide) {
        return false;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_Output_Creative(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        IFluidHandler tTileEntity;
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && (tTileEntity = aBaseMetaTileEntity.getITankContainerAtSide(aBaseMetaTileEntity.getFrontFacing())) != null) {
            boolean temp = true;
            while (temp && this.mFluid != null) {
                int tFilledAmount;
                temp = false;
                FluidStack tDrained = aBaseMetaTileEntity.drain(ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getFrontFacing()), 1, false);
                if (tDrained == null) continue;
                tDrained.amount = 100000;
                tDrained.amount = tFilledAmount = tTileEntity.fill(ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()), tDrained, false);
                if (tFilledAmount <= 0) continue;
                temp = true;
                tTileEntity.fill(ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()), tDrained, true);
            }
        }
    }

    @Override
    public boolean doesFillContainers() {
        return true;
    }

    @Override
    public boolean doesEmptyContainers() {
        return true;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    @Override
    public boolean displaysItemStack() {
        return true;
    }

    @Override
    public boolean displaysStackSize() {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aSide == aBaseMetaTileEntity.getFrontFacing() && aIndex == 1;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aSide == aBaseMetaTileEntity.getFrontFacing() && aIndex == 0;
    }

    @Override
    public int getCapacity() {
        return 100000;
    }

    @Override
    public int getTankPressure() {
        return 100;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            ItemStack tOutput;
            if (this.isFluidChangingAllowed() && this.getFillableStack() != null && this.getFillableStack().amount <= 0) {
                this.setFillableStack(null);
            }
            if (this.displaysItemStack() && this.getStackDisplaySlot() >= 0 && this.getStackDisplaySlot() < this.mInventory.length) {
                if (this.getDisplayedFluid() == null) {
                    if (ItemList.Display_Fluid.isStackEqual(this.mInventory[this.getStackDisplaySlot()], true, true)) {
                        this.mInventory[this.getStackDisplaySlot()] = null;
                    }
                } else {
                    this.mInventory[this.getStackDisplaySlot()] = GT_Utility.getFluidDisplayStack(this.getDisplayedFluid(), this.displaysStackSize());
                }
            }
            if (this.doesEmptyContainers()) {
                FluidStack tFluid = GT_Utility.getFluidForFilledItem(this.mInventory[this.getInputSlot()], true);
                if (tFluid != null && this.isFluidInputAllowed(tFluid)) {
                    if (this.getFillableStack() == null) {
                        if (this.isFluidInputAllowed(tFluid) && tFluid.amount <= this.getCapacity() && aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), GT_Utility.getContainerItem(this.mInventory[this.getInputSlot()], true), 1)) {
                            this.setFillableStack(tFluid.copy());
                            this.onEmptyingContainerWhenEmpty();
                            aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                        }
                    } else if (tFluid.isFluidEqual(this.getFillableStack())) {
                        if (aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), GT_Utility.getContainerItem(this.mInventory[this.getInputSlot()], true), 1)) {
                            this.getFillableStack().amount += tFluid.amount;
                            aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                        }
                    } else {
                        tFluid.amount = 100000;
                        this.setFillableStack(tFluid);
                    }
                } else if (tFluid == null && this.mFluid == null) {
                    this.mFluid = GT_ModHandler.getWater(100000L);
                }
            }
            if (this.doesFillContainers() && (tOutput = GT_Utility.fillFluidContainer(this.getDrainableStack(), this.mInventory[this.getInputSlot()], false, true)) != null && aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), tOutput, 1)) {
                FluidStack tFluid = GT_Utility.getFluidForFilledItem(tOutput, true);
                aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                if (tFluid != null) {
                    this.getDrainableStack().amount -= tFluid.amount;
                }
                if (this.getDrainableStack().amount <= 0 && this.isFluidChangingAllowed()) {
                    this.setDrainableStack(null);
                }
            }
            this.mFluid.amount = 100000;
        }
    }
}

