/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import gregtech.api.net.GT_Packet;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class GT_Packet_Key
extends GT_Packet {
    int playerId;
    int dimensionId;
    boolean alt;
    boolean ctrl;
    public static GT_Packet_Key inst = new GT_Packet_Key(false);
    public static HashMap<EntityPlayer, PressedKeys> pressedKeys = new HashMap();

    public GT_Packet_Key() {
        super(true);
    }

    public GT_Packet_Key(int playerId, int dimensionId, boolean alt, boolean ctrl) {
        super(false);
        this.playerId = playerId;
        this.alt = alt;
        this.ctrl = ctrl;
        this.dimensionId = dimensionId;
    }

    public GT_Packet_Key(boolean aIsReference) {
        super(aIsReference);
    }

    @Override
    public byte getPacketID() {
        return 9;
    }

    @Override
    public byte[] encode() {
        ByteArrayDataOutput tOut = ByteStreams.newDataOutput((int)10);
        tOut.writeInt(this.playerId);
        tOut.writeInt(this.dimensionId);
        tOut.writeBoolean(this.alt);
        tOut.writeBoolean(this.ctrl);
        return tOut.toByteArray();
    }

    @Override
    public GT_Packet decode(ByteArrayDataInput aData) {
        return new GT_Packet_Key(aData.readInt(), aData.readInt(), aData.readBoolean(), aData.readBoolean());
    }

    @Override
    public void process(IBlockAccess aWorld) {
        Entity anEntity;
        WorldServer w = DimensionManager.getWorld((int)this.dimensionId);
        if (w != null && (anEntity = w.func_73045_a(this.playerId)) instanceof EntityPlayer) {
            pressedKeys.put((EntityPlayer)anEntity, new PressedKeys(this.alt, this.ctrl));
        }
    }

    public static boolean isAltPressed(EntityPlayerMP aPlayer) {
        if (pressedKeys.get(aPlayer) == null) {
            return false;
        }
        return GT_Packet_Key.pressedKeys.get((Object)aPlayer).alt;
    }

    public static boolean isCtrlPressed(EntityPlayer aPlayer) {
        if (pressedKeys.get(aPlayer) == null) {
            return false;
        }
        return GT_Packet_Key.pressedKeys.get((Object)aPlayer).ctrl;
    }

    class PressedKeys {
        public boolean alt = false;
        public boolean ctrl = false;

        PressedKeys(boolean alt, boolean ctrl) {
            this.alt = alt;
            this.ctrl = ctrl;
        }
    }
}

