/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import net.minecraft.util.EnumChatFormatting;

public enum ColorFormat {
    BAD(EnumChatFormatting.RED),
    BETTER(EnumChatFormatting.YELLOW),
    GOOD(EnumChatFormatting.GREEN),
    NEUTRAL(EnumChatFormatting.AQUA),
    SPECIAL(EnumChatFormatting.LIGHT_PURPLE);

    private final EnumChatFormatting prefix;
    public static final DoubleFun DEFAULT;
    public static final DoubleFun MULTIBLOCK_STATUS;

    private ColorFormat(EnumChatFormatting prefix) {
        this.prefix = prefix;
    }

    public String format(float input) {
        return this.prefix + String.valueOf(input) + EnumChatFormatting.RESET;
    }

    public String format(int input) {
        return this.prefix + String.valueOf(input) + EnumChatFormatting.RESET;
    }

    public String format(String input) {
        return this.prefix + input + EnumChatFormatting.RESET;
    }

    public static String format(int value, int minValue, int maxValue, int badNormalized, int goodNormalized, DoubleFun decider) {
        int tempValue = value - minValue;
        if ((tempValue = (int)decider.decide((double)tempValue / ((double)(maxValue -= minValue) / 10000.0))) <= badNormalized) {
            return BAD.format(Integer.toString(value));
        }
        if (tempValue >= goodNormalized) {
            return GOOD.format(Integer.toString(value));
        }
        return BETTER.format(Integer.toString(value));
    }

    public static String format(int value, int minValue, int maxValue) {
        return ColorFormat.format(value, minValue, maxValue, 2000, 8000, DEFAULT);
    }

    public static String format(int value, int minValue, int maxValue, DoubleFun decider) {
        return ColorFormat.format(value, minValue, maxValue, 2000, 8000, decider);
    }

    static {
        DEFAULT = a -> a;
        MULTIBLOCK_STATUS = d -> d - 1999.0;
    }

    static interface DoubleFun {
        public double decide(double var1);
    }
}

