/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import java.util.Random;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class GT_UO_Fluid {
    public String Registry = "null";
    public int MaxAmount = 0;
    public int MinAmount = 0;
    public int Chance = 0;
    public int DecreasePerOperationAmount = 5;

    public GT_UO_Fluid(ConfigCategory aConfigCategory) {
        if (aConfigCategory.containsKey("Registry")) {
            aConfigCategory.get((String)"Registry").comment = "Fluid registry name";
            this.Registry = aConfigCategory.get("Registry").getString();
        }
        if (aConfigCategory.containsKey("MaxAmount")) {
            aConfigCategory.get((String)"MaxAmount").comment = "Max amount generation (per operation, sets the VeinData) 80000 MAX";
            this.MaxAmount = aConfigCategory.get("MaxAmount").getInt(0);
        }
        if (aConfigCategory.containsKey("MinAmount")) {
            aConfigCategory.get((String)"MinAmount").comment = "Min amount generation (per operation, sets the VeinData) 0 MIN";
            this.MinAmount = aConfigCategory.get("MinAmount").getInt(0);
        }
        if (aConfigCategory.containsKey("Chance")) {
            aConfigCategory.get((String)"Chance").comment = "Chance generating (weighted chance!, there will be a fluid in chunk always!)";
            this.Chance = aConfigCategory.get("Chance").getInt(0);
        }
        if (aConfigCategory.containsKey("DecreasePerOperationAmount")) {
            aConfigCategory.get((String)"DecreasePerOperationAmount").comment = "Decrease per operation (actual fluid gained works like (Litre)VeinData/5000)";
            this.DecreasePerOperationAmount = aConfigCategory.get("DecreasePerOperationAmount").getInt(5);
        }
    }

    public Fluid getFluid() {
        try {
            return FluidRegistry.getFluid((String)this.Registry);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getRandomAmount(Random aRandom) {
        double min = Math.pow((double)this.MinAmount * 100.0 * 5000.0, 0.2);
        double max = Math.pow((double)this.MaxAmount * 100.0 * 5000.0, 0.2);
        double amount = Math.pow(min + (max == 0.0 ? 0.0 : (double)aRandom.nextInt((int)(10000.0 * (max - min) + 1.0)) / 10000.0), 5.0);
        return (int)(amount / 100.0);
    }
}

