/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.GT_ArrayList;
import gregtech.api.objects.MaterialStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;

public class ItemData {
    private static final MaterialStack[] EMPTY_MATERIALSTACK_ARRAY = new MaterialStack[0];
    public final List<Object> mExtraData = new GT_ArrayList<Object>(false, 1);
    public final OrePrefixes mPrefix;
    public final MaterialStack mMaterial;
    public final MaterialStack[] mByProducts;
    public boolean mBlackListed;
    public ItemStack mUnificationTarget = null;

    public ItemData(OrePrefixes aPrefix, Materials aMaterial, boolean aBlackListed) {
        MaterialStack[] materialStackArray;
        this.mPrefix = aPrefix;
        this.mMaterial = aMaterial == null ? null : new MaterialStack(aMaterial, aPrefix.mMaterialAmount);
        this.mBlackListed = aBlackListed;
        if (aPrefix.mSecondaryMaterial == null || aPrefix.mSecondaryMaterial.mMaterial == null) {
            materialStackArray = EMPTY_MATERIALSTACK_ARRAY;
        } else {
            MaterialStack[] materialStackArray2 = new MaterialStack[1];
            materialStackArray = materialStackArray2;
            materialStackArray2[0] = aPrefix.mSecondaryMaterial.clone();
        }
        this.mByProducts = materialStackArray;
    }

    public ItemData(OrePrefixes aPrefix, Materials aMaterial) {
        this(aPrefix, aMaterial, false);
    }

    public ItemData(MaterialStack aMaterial, MaterialStack ... aByProducts) {
        this.mPrefix = null;
        this.mMaterial = aMaterial.mMaterial == null ? null : aMaterial.clone();
        this.mBlackListed = true;
        if (aByProducts == null) {
            this.mByProducts = EMPTY_MATERIALSTACK_ARRAY;
        } else {
            MaterialStack[] tByProducts = aByProducts.length < 1 ? EMPTY_MATERIALSTACK_ARRAY : new MaterialStack[aByProducts.length];
            int j = 0;
            for (MaterialStack aByProduct : aByProducts) {
                if (aByProduct == null || aByProduct.mMaterial == null) continue;
                tByProducts[j++] = aByProduct.clone();
            }
            this.mByProducts = j > 0 ? new MaterialStack[j] : EMPTY_MATERIALSTACK_ARRAY;
            System.arraycopy(tByProducts, 0, this.mByProducts, 0, this.mByProducts.length);
        }
    }

    public ItemData(Materials aMaterial, long aAmount, MaterialStack ... aByProducts) {
        this(new MaterialStack(aMaterial, aAmount), aByProducts);
    }

    public ItemData(Materials aMaterial, long aAmount, Materials aByProduct, long aByProductAmount) {
        this(new MaterialStack(aMaterial, aAmount), new MaterialStack(aByProduct, aByProductAmount));
    }

    public ItemData(ItemData ... aData) {
        this.mPrefix = null;
        this.mBlackListed = true;
        ArrayList<MaterialStack> aList = new ArrayList<MaterialStack>();
        ArrayList<MaterialStack> rList = new ArrayList<MaterialStack>();
        for (ItemData tData : aData) {
            if (tData == null) continue;
            if (tData.hasValidMaterialData() && tData.mMaterial.mAmount > 0L) {
                aList.add(tData.mMaterial.clone());
            }
            for (MaterialStack tMaterial : tData.mByProducts) {
                if (tMaterial.mAmount <= 0L) continue;
                aList.add(tMaterial.clone());
            }
        }
        for (MaterialStack aMaterial : aList) {
            boolean temp = true;
            for (MaterialStack tMaterial : rList) {
                if (aMaterial.mMaterial != tMaterial.mMaterial) continue;
                tMaterial.mAmount += aMaterial.mAmount;
                temp = false;
                break;
            }
            if (!temp) continue;
            rList.add(aMaterial.clone());
        }
        rList.sort((a, b) -> Long.compare(b.mAmount, a.mAmount));
        if (rList.isEmpty()) {
            this.mMaterial = null;
        } else {
            this.mMaterial = (MaterialStack)rList.get(0);
            rList.remove(0);
        }
        this.mByProducts = rList.toArray(new MaterialStack[0]);
    }

    public final boolean hasValidPrefixMaterialData() {
        return this.mPrefix != null && this.mMaterial != null && this.mMaterial.mMaterial != null;
    }

    public final boolean hasValidPrefixData() {
        return this.mPrefix != null;
    }

    public final boolean hasValidMaterialData() {
        return this.mMaterial != null && this.mMaterial.mMaterial != null;
    }

    public final ArrayList<MaterialStack> getAllMaterialStacks() {
        ArrayList<MaterialStack> rList = new ArrayList<MaterialStack>();
        if (this.hasValidMaterialData()) {
            rList.add(this.mMaterial);
        }
        rList.addAll(Arrays.asList(this.mByProducts));
        return rList;
    }

    public final MaterialStack getByProduct(int aIndex) {
        return aIndex >= 0 && aIndex < this.mByProducts.length ? this.mByProducts[aIndex] : null;
    }

    public boolean equals(Object taO) {
        if (this == taO) {
            return true;
        }
        if (taO == null || this.getClass() != taO.getClass()) {
            return false;
        }
        ItemData ttItemData = (ItemData)taO;
        return this.mPrefix == ttItemData.mPrefix && Objects.equals(this.mMaterial.mMaterial, ttItemData.mMaterial.mMaterial);
    }

    public int hashCode() {
        return this.mPrefix.ordinal() << 16 | this.mMaterial.mMaterial.mMetaItemSubID;
    }

    public String toString() {
        if (this.mPrefix == null || this.mMaterial == null || this.mMaterial.mMaterial == null) {
            return "";
        }
        return this.mPrefix.name() + this.mMaterial.mMaterial.mName;
    }
}

