/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.threads;

import gregtech.api.GregTech_API;
import gregtech.api.interfaces.tileentity.IMachineBlockUpdateable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public class GT_Runnable_MachineBlockUpdate
implements Runnable {
    private final int mX;
    private final int mY;
    private final int mZ;
    private final World mWorld;
    protected int mTime;
    protected int mTimer;
    protected boolean mShouldRun = true;
    static HashSet<GT_Runnable_MachineBlockUpdate> mWaitingThreads = new HashSet();

    public GT_Runnable_MachineBlockUpdate(World aWorld, int aX, int aY, int aZ, int aDelay, int aRadius) {
        this.mWorld = aWorld;
        this.mX = aX;
        this.mY = aY;
        this.mZ = aZ;
        this.mTimer = this.mTime = aDelay;
        if (!mWaitingThreads.contains(this)) {
            mWaitingThreads.add(this);
            new PathFinder(aWorld, aX, aY, aZ, aRadius, this).run();
        }
    }

    public GT_Runnable_MachineBlockUpdate(World aWorld, int aX, int aY, int aZ) {
        this(aWorld, aX, aY, aZ, 50, 2);
    }

    private static void stepToUpdateMachine(World aWorld, int aX, int aY, int aZ, HashSet<ChunkPosition> aList) {
        aList.add(new ChunkPosition(aX, aY, aZ));
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IMachineBlockUpdateable) {
            ((IMachineBlockUpdateable)tTileEntity).onMachineBlockUpdate();
        }
        Block b = aWorld.func_147439_a(aX, aY, aZ);
        int meta = aWorld.func_72805_g(aX, aY, aZ);
        if (b == GregTech_API.sBlockMachines && meta / 4 == 2) {
            return;
        }
        if (aList.size() < 5 || tTileEntity instanceof IMachineBlockUpdateable || GregTech_API.isMachineBlock(b, meta)) {
            if (!aList.contains(new ChunkPosition(aX + 1, aY, aZ))) {
                GT_Runnable_MachineBlockUpdate.stepToUpdateMachine(aWorld, aX + 1, aY, aZ, aList);
            }
            if (!aList.contains(new ChunkPosition(aX - 1, aY, aZ))) {
                GT_Runnable_MachineBlockUpdate.stepToUpdateMachine(aWorld, aX - 1, aY, aZ, aList);
            }
            if (!aList.contains(new ChunkPosition(aX, aY + 1, aZ))) {
                GT_Runnable_MachineBlockUpdate.stepToUpdateMachine(aWorld, aX, aY + 1, aZ, aList);
            }
            if (!aList.contains(new ChunkPosition(aX, aY - 1, aZ))) {
                GT_Runnable_MachineBlockUpdate.stepToUpdateMachine(aWorld, aX, aY - 1, aZ, aList);
            }
            if (!aList.contains(new ChunkPosition(aX, aY, aZ + 1))) {
                GT_Runnable_MachineBlockUpdate.stepToUpdateMachine(aWorld, aX, aY, aZ + 1, aList);
            }
            if (!aList.contains(new ChunkPosition(aX, aY, aZ - 1))) {
                GT_Runnable_MachineBlockUpdate.stepToUpdateMachine(aWorld, aX, aY, aZ - 1, aList);
            }
        }
    }

    public static void onTick() {
        Iterator<GT_Runnable_MachineBlockUpdate> iterator = mWaitingThreads.iterator();
        while (iterator.hasNext()) {
            GT_Runnable_MachineBlockUpdate tThread = iterator.next();
            if (tThread.mTimer-- >= 0) continue;
            if (tThread.mShouldRun) {
                new Thread(tThread).start();
            }
            iterator.remove();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GT_Runnable_MachineBlockUpdate that = (GT_Runnable_MachineBlockUpdate)o;
        return this.mX == that.mX && this.mY == that.mY && this.mZ == that.mZ && this.mWorld.field_73011_w.field_76574_g == that.mWorld.field_73011_w.field_76574_g;
    }

    public int hashCode() {
        return Objects.hash(this.mX, this.mY, this.mZ, this.mWorld.field_73011_w.field_76574_g);
    }

    @Override
    public void run() {
        try {
            GT_Runnable_MachineBlockUpdate.stepToUpdateMachine(this.mWorld, this.mX, this.mY, this.mZ, new HashSet<ChunkPosition>());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class PathFinder
    implements Runnable {
        World mWorld;
        int mX;
        int mY;
        int mZ;
        HashSet<ChunkPosition> mNextQueue;
        HashSet<ChunkPosition> mRNextQueue;
        HashSet<ChunkPosition> mAlreadyPassedSet;
        int mDepth;
        GT_Runnable_MachineBlockUpdate mUpdater;

        public PathFinder(World aWorld, int aX, int aY, int aZ, int aDepth, GT_Runnable_MachineBlockUpdate aUpdater) {
            this.mWorld = aWorld;
            this.mX = aX;
            this.mY = aY;
            this.mZ = aZ;
            this.mNextQueue = new HashSet();
            this.mRNextQueue = new HashSet();
            this.mAlreadyPassedSet = new HashSet();
            this.mNextQueue.add(new ChunkPosition(aX, aY, aZ));
            this.mUpdater = aUpdater;
            this.mDepth = aDepth;
        }

        @Override
        public void run() {
            if (this.find(this.mDepth)) {
                this.mUpdater.mShouldRun = false;
            }
        }

        public boolean find(int aDepth) {
            if (aDepth < 0) {
                return false;
            }
            for (ChunkPosition p : this.mNextQueue) {
                if (!this.processNode(this.mWorld, p, this.mAlreadyPassedSet)) continue;
                return true;
            }
            this.mNextQueue = this.mRNextQueue;
            this.mRNextQueue = new HashSet();
            return this.find(--aDepth);
        }

        public boolean processNode(World aWorld, ChunkPosition aPos, HashSet<ChunkPosition> aList) {
            int aZ = aPos.field_151328_c;
            int aY = aPos.field_151327_b;
            int aX = aPos.field_151329_a;
            for (GT_Runnable_MachineBlockUpdate r : mWaitingThreads) {
                if (r.mX != aX || r.mY != aY || r.mZ != aZ || aWorld.field_73011_w.field_76574_g != ((GT_Runnable_MachineBlockUpdate)r).mWorld.field_73011_w.field_76574_g || this.mUpdater.equals(r)) continue;
                r.mTimer = r.mTime;
                return true;
            }
            aList.add(new ChunkPosition(aX, aY, aZ));
            TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
            if (aList.size() < 5 || tTileEntity instanceof IMachineBlockUpdateable || GregTech_API.isMachineBlock(aWorld.func_147439_a(aX, aY, aZ), aWorld.func_72805_g(aX, aY, aZ))) {
                ChunkPosition pos = new ChunkPosition(aX + 1, aY, aZ);
                if (!aList.contains(pos)) {
                    this.mRNextQueue.add(pos);
                }
                if (!aList.contains(pos = new ChunkPosition(aX, aY, aZ + 1))) {
                    this.mRNextQueue.add(pos);
                }
                if (!aList.contains(pos = new ChunkPosition(aX, aY + 1, aZ))) {
                    this.mRNextQueue.add(pos);
                }
                if (!aList.contains(pos = new ChunkPosition(aX - 1, aY, aZ))) {
                    this.mRNextQueue.add(pos);
                }
                if (!aList.contains(pos = new ChunkPosition(aX, aY - 1, aZ))) {
                    this.mRNextQueue.add(pos);
                }
                if (!aList.contains(pos = new ChunkPosition(aX, aY, aZ - 1))) {
                    this.mRNextQueue.add(pos);
                }
            }
            return false;
        }
    }
}

