/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import cpw.mods.fml.common.Loader;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_ItsNotMyFaultException;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import gregtech.common.blocks.GT_TileEntity_Ores;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import speiger.src.crops.api.ICropCardInfo;

public class GT_BaseCrop
extends CropCard
implements ICropCardInfo {
    public static ArrayList<GT_BaseCrop> sCropList = new ArrayList();
    private String mName = "";
    private String mDiscoveredBy = "Gregorius Techneticies";
    private String[] mAttributes;
    private int mTier = 0;
    private int mMaxSize = 0;
    private int mAfterHarvestSize = 0;
    private int mHarvestSize = 0;
    private int[] mStats = new int[5];
    private int mGrowthSpeed = 0;
    private ItemStack mDrop = null;
    private ItemStack[] mSpecialDrops = null;
    private Materials mBlock = null;
    private static boolean bIc2NeiLoaded = Loader.isModLoaded((String)"Ic2Nei");

    public GT_BaseCrop(int aID, String aCropName, String aDiscoveredBy, ItemStack aBaseSeed, int aTier, int aMaxSize, int aGrowthSpeed, int aAfterHarvestSize, int aHarvestSize, int aStatChemical, int aStatFood, int aStatDefensive, int aStatColor, int aStatWeed, String[] aAttributes, ItemStack aDrop, ItemStack[] aSpecialDrops) {
        new GT_BaseCrop(aID, aCropName, aDiscoveredBy, aBaseSeed, aTier, aMaxSize, aGrowthSpeed, aAfterHarvestSize, aHarvestSize, aStatChemical, aStatFood, aStatDefensive, aStatColor, aStatWeed, aAttributes, null, aDrop, aSpecialDrops);
    }

    public GT_BaseCrop(int aID, String aCropName, String aDiscoveredBy, ItemStack aBaseSeed, int aTier, int aMaxSize, int aGrowthSpeed, int aAfterHarvestSize, int aHarvestSize, int aStatChemical, int aStatFood, int aStatDefensive, int aStatColor, int aStatWeed, String[] aAttributes, Materials aBlock, ItemStack aDrop, ItemStack[] aSpecialDrops) {
        this.mName = aCropName;
        aID = GT_Config.addIDConfig((Object)ConfigCategories.IDs.crops, this.mName.replaceAll(" ", "_"), aID);
        if (aDiscoveredBy != null && !aDiscoveredBy.equals("")) {
            this.mDiscoveredBy = aDiscoveredBy;
        }
        if (aDrop != null && aID > 0 && aID < 256) {
            this.mDrop = GT_Utility.copy(aDrop);
            this.mSpecialDrops = aSpecialDrops;
            this.mTier = Math.max(1, aTier);
            this.mMaxSize = Math.max(3, aMaxSize);
            this.mHarvestSize = Math.min(Math.max(aHarvestSize, 2), this.mMaxSize);
            this.mAfterHarvestSize = Math.min(Math.max(aAfterHarvestSize, 1), this.mMaxSize - 1);
            this.mStats[0] = aStatChemical;
            this.mStats[1] = aStatFood;
            this.mStats[2] = aStatDefensive;
            this.mStats[3] = aStatColor;
            this.mStats[4] = aStatWeed;
            this.mAttributes = aAttributes;
            this.mBlock = aBlock;
            if (GregTech_API.sRecipeFile.get((Object)ConfigCategories.Recipes.crops, aCropName, true)) {
                if (!Crops.instance.registerCrop((CropCard)this, aID)) {
                    throw new GT_ItsNotMyFaultException("Make sure the Crop ID is valid!");
                }
                if (aBaseSeed != null) {
                    Crops.instance.registerBaseSeed(aBaseSeed, (CropCard)this, 1, 1, 1, 1);
                }
                sCropList.add(this);
            }
        }
        if (bIc2NeiLoaded) {
            try {
                Class.forName("speiger.src.crops.api.CropPluginAPI").getMethod("registerCropInfo", Class.forName("speiger.src.crops.api.ICropCardInfo")).invoke((Object)Class.forName("speiger.src.crops.api.CropPluginAPI").getField("instance"), this);
            }
            catch (IllegalAccessException ex) {
                bIc2NeiLoaded = false;
            }
            catch (IllegalArgumentException ex) {
                bIc2NeiLoaded = false;
            }
            catch (InvocationTargetException ex) {
                bIc2NeiLoaded = false;
            }
            catch (NoSuchFieldException ex) {
                bIc2NeiLoaded = false;
            }
            catch (NoSuchMethodException ex) {
                bIc2NeiLoaded = false;
            }
            catch (SecurityException ex) {
                bIc2NeiLoaded = false;
            }
            catch (ClassNotFoundException ex) {
                bIc2NeiLoaded = false;
            }
        }
    }

    public byte getSizeAfterHarvest(ICropTile crop) {
        return (byte)this.mAfterHarvestSize;
    }

    public int growthDuration(ICropTile aCrop) {
        if (this.mGrowthSpeed < 200) {
            return super.growthDuration(aCrop);
        }
        return this.tier() * this.mGrowthSpeed;
    }

    public int getrootslength(ICropTile crop) {
        return 5;
    }

    public String[] attributes() {
        return this.mAttributes;
    }

    public String discoveredBy() {
        return this.mDiscoveredBy;
    }

    public final boolean canGrow(ICropTile aCrop) {
        if (GT_Mod.gregtechproxy.mCropNeedBlock && this.mBlock != null && aCrop.getSize() == this.mMaxSize - 1) {
            return this.isBlockBelow(aCrop);
        }
        return aCrop.getSize() < this.maxSize();
    }

    public final boolean canBeHarvested(ICropTile aCrop) {
        return aCrop.getSize() >= this.mHarvestSize;
    }

    public boolean canCross(ICropTile aCrop) {
        return aCrop.getSize() + 2 > this.maxSize();
    }

    public int stat(int n) {
        if (n < 0 || n >= this.mStats.length) {
            return 0;
        }
        return this.mStats[n];
    }

    public String name() {
        return this.mName;
    }

    public int tier() {
        return this.mTier;
    }

    public int maxSize() {
        return this.mMaxSize;
    }

    public ItemStack getGain(ICropTile aCrop) {
        int tDrop = 0;
        if (this.mSpecialDrops != null && (tDrop = ThreadLocalRandom.current().nextInt(0, this.mSpecialDrops.length * 2 + 2)) < this.mSpecialDrops.length && this.mSpecialDrops[tDrop] != null) {
            return GT_Utility.copy(this.mSpecialDrops[tDrop]);
        }
        return GT_Utility.copy(this.mDrop);
    }

    public boolean rightclick(ICropTile aCrop, EntityPlayer aPlayer) {
        if (!this.canBeHarvested(aCrop)) {
            return false;
        }
        return aCrop.harvest(aPlayer == null ? false : aPlayer instanceof EntityPlayerMP);
    }

    public int getOptimalHavestSize(ICropTile crop) {
        return this.maxSize();
    }

    public boolean isBlockBelow(ICropTile aCrop) {
        if (aCrop == null) {
            return false;
        }
        for (int i = 1; i < this.getrootslength(aCrop); ++i) {
            Block tBlock = aCrop.getWorld().func_147439_a(aCrop.getLocation().field_71574_a, aCrop.getLocation().field_71572_b - i, aCrop.getLocation().field_71573_c);
            if (tBlock instanceof GT_Block_Ores_Abstract) {
                Materials tMaterial;
                TileEntity tTileEntity = aCrop.getWorld().func_147438_o(aCrop.getLocation().field_71574_a, aCrop.getLocation().field_71572_b - i, aCrop.getLocation().field_71573_c);
                if (!(tTileEntity instanceof GT_TileEntity_Ores) || (tMaterial = GregTech_API.sGeneratedMaterials[((GT_TileEntity_Ores)tTileEntity).mMetaData % 1000]) == null || tMaterial == Materials._NULL) continue;
                return tMaterial == this.mBlock;
            }
            int tMetaID = aCrop.getWorld().func_72805_g(aCrop.getLocation().field_71574_a, aCrop.getLocation().field_71572_b - i, aCrop.getLocation().field_71573_c);
            ItemData tAssotiation = GT_OreDictUnificator.getAssociation(new ItemStack(tBlock, 1, tMetaID));
            if (tAssotiation != null && tAssotiation.mPrefix.toString().startsWith("ore") && tAssotiation.mMaterial.mMaterial == this.mBlock) {
                return true;
            }
            if (tAssotiation == null || tAssotiation.mPrefix != OrePrefixes.block || tAssotiation.mMaterial.mMaterial != this.mBlock) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getCropInformation() {
        if (this.mBlock != null) {
            ArrayList<String> result = new ArrayList<String>(1);
            result.add(String.format("Requires %s Ore or Block of %s as soil block to reach full growth.", this.mBlock.mName, this.mBlock.mName));
            return result;
        }
        return null;
    }

    @Override
    public ItemStack getDisplayItem() {
        if (this.mSpecialDrops != null && this.mSpecialDrops[this.mSpecialDrops.length - 1] != null) {
            return GT_Utility.copy(this.mSpecialDrops[this.mSpecialDrops.length - 1]);
        }
        return GT_Utility.copy(this.mDrop);
    }
}

