/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Log;
import gregtech.api.world.GT_Worldgen;
import gregtech.common.GT_Worldgen_GT_Ore_Layer;
import gregtech.common.blocks.GT_TileEntity_Ores;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public class GT_Worldgenerator
implements IWorldGenerator {
    private static int mEndAsteroidProbability = 300;
    private static int mGCAsteroidProbability = 50;
    private static int mSize = 100;
    private static int endMinSize = 50;
    private static int endMaxSize = 200;
    private static int gcMinSize = 100;
    private static int gcMaxSize = 400;
    private static boolean endAsteroids = true;
    private static boolean gcAsteroids = true;

    public GT_Worldgenerator() {
        endAsteroids = GregTech_API.sWorldgenFile.get((Object)"endasteroids", "GenerateAsteroids", true);
        endMinSize = GregTech_API.sWorldgenFile.get((Object)"endasteroids", "AsteroidMinSize", 50);
        endMaxSize = GregTech_API.sWorldgenFile.get((Object)"endasteroids", "AsteroidMaxSize", 200);
        mEndAsteroidProbability = GregTech_API.sWorldgenFile.get((Object)"endasteroids", "AsteroidProbability", 300);
        gcAsteroids = GregTech_API.sWorldgenFile.get((Object)"gcasteroids", "GenerateGCAsteroids", true);
        gcMinSize = GregTech_API.sWorldgenFile.get((Object)"gcasteroids", "GCAsteroidMinSize", 100);
        gcMaxSize = GregTech_API.sWorldgenFile.get((Object)"gcasteroids", "GCAsteroidMaxSize", 400);
        mGCAsteroidProbability = GregTech_API.sWorldgenFile.get((Object)"gcasteroids", "GCAsteroidProbability", 300);
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)0x3FFFFFFF);
    }

    public synchronized void generate(Random aRandom, int aX, int aZ, World aWorld, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        int tempDimensionId = aWorld.field_73011_w.field_76574_g;
        if (tempDimensionId != -1 && tempDimensionId != 1 && !aChunkGenerator.getClass().getName().contains("galacticraft")) {
            tempDimensionId = 0;
        }
        new WorldGenContainer(aX * 16, aZ * 16, tempDimensionId, aWorld, aChunkGenerator, aChunkProvider, aWorld.func_72807_a((int)(aX * 16 + 8), (int)(aZ * 16 + 8)).field_76791_y).run();
    }

    public static class WorldGenContainer
    implements Runnable {
        public int mX;
        public int mZ;
        public final int mDimensionType;
        public final World mWorld;
        public final IChunkProvider mChunkGenerator;
        public final IChunkProvider mChunkProvider;
        public final String mBiome;
        public static HashSet<ChunkCoordIntPair> mGenerated = new HashSet(2000);

        public WorldGenContainer(int aX, int aZ, int aDimensionType, World aWorld, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider, String aBiome) {
            this.mX = aX;
            this.mZ = aZ;
            this.mDimensionType = aDimensionType;
            this.mWorld = aWorld;
            this.mChunkGenerator = aChunkGenerator;
            this.mChunkProvider = aChunkProvider;
            this.mBiome = aBiome;
        }

        public int getVeinCenterCoordinate(int c) {
            return (c += c < 0 ? 1 : 3) - c % 3 - 2;
        }

        public boolean surroundingChunksLoaded(int xCenter, int zCenter) {
            return this.mWorld.func_72904_c(xCenter - 16, 0, zCenter - 16, xCenter + 16, 0, zCenter + 16);
        }

        public Random getRandom(int xChunk, int zChunk) {
            long worldSeed = this.mWorld.func_72905_C();
            Random fmlRandom = new Random(worldSeed);
            long xSeed = fmlRandom.nextLong() >> 3;
            long zSeed = fmlRandom.nextLong() >> 3;
            long chunkSeed = xSeed * (long)xChunk + zSeed * (long)zChunk ^ worldSeed;
            fmlRandom.setSeed(chunkSeed);
            return new XSTR(fmlRandom.nextInt());
        }

        @Override
        public void run() {
            Chunk tChunk;
            int xCenter = this.getVeinCenterCoordinate(this.mX >> 4);
            int zCenter = this.getVeinCenterCoordinate(this.mZ >> 4);
            Random random = this.getRandom(xCenter, zCenter);
            ChunkCoordIntPair centerChunk = new ChunkCoordIntPair(xCenter <<= 4, zCenter <<= 4);
            if (!mGenerated.contains(centerChunk) && this.surroundingChunksLoaded(xCenter, zCenter)) {
                mGenerated.add(centerChunk);
                if (GT_Worldgen_GT_Ore_Layer.sWeight > 0 && GT_Worldgen_GT_Ore_Layer.sList.size() > 0) {
                    boolean temp = true;
                    block6: for (int i = 0; i < 256 && temp; ++i) {
                        int tRandomWeight = random.nextInt(GT_Worldgen_GT_Ore_Layer.sWeight);
                        for (GT_Worldgen gT_Worldgen : GT_Worldgen_GT_Ore_Layer.sList) {
                            if ((tRandomWeight -= ((GT_Worldgen_GT_Ore_Layer)gT_Worldgen).mWeight) > 0) continue;
                            try {
                                if (!gT_Worldgen.executeWorldgen(this.mWorld, random, this.mBiome, this.mDimensionType, xCenter, zCenter, this.mChunkGenerator, this.mChunkProvider)) continue block6;
                                temp = false;
                                continue block6;
                            }
                            catch (Throwable e) {
                                e.printStackTrace(GT_Log.err);
                            }
                        }
                    }
                }
                int i = 0;
                int tX = xCenter - 16;
                while (i < 3) {
                    int j = 0;
                    int tZ = zCenter - 16;
                    while (j < 3) {
                        try {
                            for (GT_Worldgen tWorldGen : GregTech_API.sWorldgenList) {
                                tWorldGen.executeWorldgen(this.mWorld, random, this.mBiome, this.mDimensionType, tX, tZ, this.mChunkGenerator, this.mChunkProvider);
                            }
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace(GT_Log.err);
                        }
                        ++j;
                        tZ += 16;
                    }
                    ++i;
                    tX += 16;
                }
            }
            int tDimensionType = this.mWorld.field_73011_w.field_76574_g;
            String tDimensionName = this.mWorld.field_73011_w.func_80007_l();
            Random aRandom = new Random();
            if (tDimensionType == 1 && endAsteroids && (mEndAsteroidProbability <= 1 || aRandom.nextInt(mEndAsteroidProbability) == 0) || tDimensionName.equals("Asteroids") && gcAsteroids && (mGCAsteroidProbability <= 1 || aRandom.nextInt(mGCAsteroidProbability) == 0)) {
                short s;
                short primaryMeta = 0;
                boolean bl = false;
                short betweenMeta = 0;
                short sporadicMeta = 0;
                if (GT_Worldgen_GT_Ore_Layer.sWeight > 0 && GT_Worldgen_GT_Ore_Layer.sList.size() > 0) {
                    boolean temp = true;
                    block11: for (int i = 0; i < 256 && temp; ++i) {
                        int tRandomWeight = aRandom.nextInt(GT_Worldgen_GT_Ore_Layer.sWeight);
                        for (GT_Worldgen_GT_Ore_Layer tWorldGen : GT_Worldgen_GT_Ore_Layer.sList) {
                            if ((tRandomWeight -= tWorldGen.mWeight) > 0) continue;
                            try {
                                if ((!tWorldGen.mEndAsteroid || tDimensionType != 1) && (!tWorldGen.mAsteroid || tDimensionType != -30)) continue;
                                primaryMeta = tWorldGen.mPrimaryMeta;
                                s = tWorldGen.mSecondaryMeta;
                                betweenMeta = tWorldGen.mBetweenMeta;
                                sporadicMeta = tWorldGen.mSporadicMeta;
                                temp = false;
                                continue block11;
                            }
                            catch (Throwable e) {
                                e.printStackTrace(GT_Log.err);
                            }
                        }
                    }
                }
                if (GT_Values.D1) {
                    System.out.println("do asteroid gen: " + this.mX + " " + this.mZ);
                }
                int tX = this.mX + aRandom.nextInt(16);
                int tY = 50 + aRandom.nextInt(150);
                int tZ = this.mZ + aRandom.nextInt(16);
                if (tDimensionType == 1) {
                    mSize = aRandom.nextInt(endMaxSize - endMinSize);
                } else if (tDimensionName.equals("Asteroids")) {
                    mSize = aRandom.nextInt(gcMaxSize - gcMinSize);
                }
                if (this.mWorld.func_147439_a(tX, tY, tZ).isAir((IBlockAccess)this.mWorld, tX, tY, tZ)) {
                    float var6 = aRandom.nextFloat() * 3.141593f;
                    double var7 = (float)(tX + 8) + MathHelper.func_76126_a((float)var6) * (float)mSize / 8.0f;
                    double var9 = (float)(tX + 8) - MathHelper.func_76126_a((float)var6) * (float)mSize / 8.0f;
                    double var11 = (float)(tZ + 8) + MathHelper.func_76134_b((float)var6) * (float)mSize / 8.0f;
                    double var13 = (float)(tZ + 8) - MathHelper.func_76134_b((float)var6) * (float)mSize / 8.0f;
                    double var15 = tY + aRandom.nextInt(3) - 2;
                    double var17 = tY + aRandom.nextInt(3) - 2;
                    for (int var19 = 0; var19 <= mSize; ++var19) {
                        double var20 = var7 + (var9 - var7) * (double)var19 / (double)mSize;
                        double var22 = var15 + (var17 - var15) * (double)var19 / (double)mSize;
                        double var24 = var11 + (var13 - var11) * (double)var19 / (double)mSize;
                        double var26 = aRandom.nextDouble() * (double)mSize / 16.0;
                        double var28 = (double)(MathHelper.func_76126_a((float)((float)var19 * 3.141593f / (float)mSize)) + 1.0f) * var26 + 1.0;
                        double var30 = (double)(MathHelper.func_76126_a((float)((float)var19 * 3.141593f / (float)mSize)) + 1.0f) * var26 + 1.0;
                        int tMinX = MathHelper.func_76128_c((double)(var20 - var28 / 2.0));
                        int tMinY = MathHelper.func_76128_c((double)(var22 - var30 / 2.0));
                        int tMinZ = MathHelper.func_76128_c((double)(var24 - var28 / 2.0));
                        int tMaxX = MathHelper.func_76128_c((double)(var20 + var28 / 2.0));
                        int tMaxY = MathHelper.func_76128_c((double)(var22 + var30 / 2.0));
                        int tMaxZ = MathHelper.func_76128_c((double)(var24 + var28 / 2.0));
                        for (int eX = tMinX; eX <= tMaxX; ++eX) {
                            double var39 = ((double)eX + 0.5 - var20) / (var28 / 2.0);
                            if (!(var39 * var39 < 1.0)) continue;
                            for (int eY = tMinY; eY <= tMaxY; ++eY) {
                                double var42 = ((double)eY + 0.5 - var22) / (var30 / 2.0);
                                if (!(var39 * var39 + var42 * var42 < 1.0)) continue;
                                for (int eZ = tMinZ; eZ <= tMaxZ; ++eZ) {
                                    double var45 = ((double)eZ + 0.5 - var24) / (var28 / 2.0);
                                    if (!(var39 * var39 + var42 * var42 + var45 * var45 < 1.0) || !this.mWorld.func_147439_a(tX, tY, tZ).isAir((IBlockAccess)this.mWorld, tX, tY, tZ)) continue;
                                    int ranOre = aRandom.nextInt(50);
                                    if (ranOre < 3) {
                                        GT_TileEntity_Ores.setOreBlock(this.mWorld, eX, eY, eZ, primaryMeta, false, true);
                                        continue;
                                    }
                                    if (ranOre < 6) {
                                        GT_TileEntity_Ores.setOreBlock(this.mWorld, eX, eY, eZ, s, false, true);
                                        continue;
                                    }
                                    if (ranOre < 8) {
                                        GT_TileEntity_Ores.setOreBlock(this.mWorld, eX, eY, eZ, betweenMeta, false, true);
                                        continue;
                                    }
                                    if (ranOre < 10) {
                                        GT_TileEntity_Ores.setOreBlock(this.mWorld, eX, eY, eZ, sporadicMeta, false, true);
                                        continue;
                                    }
                                    if (tDimensionType == 1) {
                                        this.mWorld.func_147465_d(eX, eY, eZ, Blocks.field_150377_bs, 0, 2);
                                        continue;
                                    }
                                    if (!tDimensionName.equals("Asteroids")) continue;
                                    this.mWorld.func_147465_d(eX, eY, eZ, GregTech_API.sBlockGranites, 8, 3);
                                }
                            }
                        }
                    }
                }
            }
            if ((tChunk = this.mWorld.func_72938_d(this.mX, this.mZ)) != null) {
                tChunk.field_76643_l = true;
            }
        }
    }
}

