/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import cpw.mods.fml.common.FMLCommonHandler;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.metatileentity.IConnectable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Cable;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Fluid;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Frame;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Item;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine_GT_Recipe;
import gregtech.api.util.GT_ItsNotMyFaultException;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Utility;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class GT_Item_Machines
extends ItemBlock {
    public static Item INSTANCE;
    public static byte[] mShowStructure;
    public static int mLastID;
    private static long mTimer;
    private static int mClick;

    public GT_Item_Machines(Block par1) {
        super(par1);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(GregTech_API.TAB_GREGTECH.get());
        INSTANCE = this;
    }

    public static void postInit() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            mShowStructure = new byte[Short.MAX_VALUE];
            for (int i = 0; i < GregTech_API.METATILEENTITIES.length; ++i) {
                if (GregTech_API.METATILEENTITIES[i] == null || GregTech_API.METATILEENTITIES[i].getDescription().length <= 5) continue;
                GT_Item_Machines.mShowStructure[i] = 1;
            }
        }
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean par4) {
        try {
            NBTTagCompound aNBT;
            int tDamage = this.getDamage(aStack);
            if (tDamage <= 0 || tDamage >= GregTech_API.METATILEENTITIES.length) {
                return;
            }
            if (Arrays.stream(Thread.currentThread().getStackTrace()).noneMatch(el -> el.getClassName().equals("mcp.mobius.waila.overlay.DisplayUtil"))) {
                if (GT_Mod.gregtechproxy.allowDisableToolTips && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54))) {
                    if (mLastID != tDamage) {
                        if (mLastID > 0) {
                            if (mShowStructure[mLastID] > 0) {
                                GT_Item_Machines.mShowStructure[GT_Item_Machines.mLastID] = 1;
                            } else if (mShowStructure[mLastID] < 0) {
                                GT_Item_Machines.mShowStructure[GT_Item_Machines.mLastID] = -1;
                            }
                        }
                        mClick = 0;
                        mLastID = tDamage;
                    }
                    if (System.currentTimeMillis() - mTimer > 500L && mClick == 0) {
                        ++mClick;
                        mTimer = System.currentTimeMillis();
                    } else if (mClick == 2) {
                        if (System.currentTimeMillis() - mTimer < 500L) {
                            mTimer = System.currentTimeMillis();
                            mClick = 0;
                            int n = tDamage;
                            mShowStructure[n] = (byte)(mShowStructure[n] * -1);
                        } else {
                            mClick = 1;
                            mTimer = System.currentTimeMillis();
                        }
                    }
                } else if (mClick == 1) {
                    ++mClick;
                }
            }
            if (GregTech_API.METATILEENTITIES[tDamage] != null) {
                IGregTechTileEntity tTileEntity = GregTech_API.METATILEENTITIES[tDamage].getBaseMetaTileEntity();
                if (tTileEntity.getDescription() != null) {
                    int i = 0;
                    int numSkip = 1;
                    int n = 0;
                    for (String tDescription : tTileEntity.getDescription()) {
                        if (mShowStructure[tDamage] == -1 && n >= numSkip) {
                            aList.add(GT_LanguageManager.addStringLocalization("struct.tooltip", "===Shift double click to show description==="));
                            break;
                        }
                        ++n;
                        if (GT_Utility.isStringValid(tDescription)) {
                            if (tDescription.contains("%%%")) {
                                String[] tString = tDescription.split("%%%");
                                if (tString.length < 2) continue;
                                StringBuffer tBuffer = new StringBuffer();
                                Object[] tRep = new String[tString.length / 2];
                                for (int j = 0; j < tString.length; ++j) {
                                    if (j % 2 == 0) {
                                        tBuffer.append(tString[j]);
                                        continue;
                                    }
                                    tBuffer.append(" %s");
                                    tRep[j / 2] = tString[j];
                                }
                                aList.add(String.format(GT_LanguageManager.addStringLocalization("TileEntity_DESCRIPTION_" + tDamage + "_Index_" + i++, tBuffer.toString(), !GregTech_API.sPostloadFinished), tRep));
                                continue;
                            }
                            String tTranslated = GT_LanguageManager.addStringLocalization("TileEntity_DESCRIPTION_" + tDamage + "_Index_" + i++, tDescription, !GregTech_API.sPostloadFinished);
                            aList.add(tTranslated.equals("") ? tDescription : tTranslated);
                            continue;
                        }
                        ++i;
                    }
                }
                if (tTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_BasicMachine_GT_Recipe && tTileEntity.getMetaTileEntity().getCapacity() > 0) {
                    aList.add(GT_LanguageManager.addStringLocalization("TileEntity_Fluid_CAPACITY", "Fluid Tank: ", !GregTech_API.sPostloadFinished) + tTileEntity.getMetaTileEntity().getCapacity() + "L");
                }
                if (tTileEntity.getEUCapacity() > 0L) {
                    if (tTileEntity.getInputVoltage() > 0L) {
                        aList.add(GT_LanguageManager.addStringLocalization("TileEntity_EUp_IN", "Voltage IN: ", !GregTech_API.sPostloadFinished) + EnumChatFormatting.GREEN + tTileEntity.getInputVoltage() + " (" + GT_Values.VN[GT_Utility.getTier(tTileEntity.getInputVoltage())] + ")" + EnumChatFormatting.GRAY);
                    }
                    if (tTileEntity.getOutputVoltage() > 0L) {
                        aList.add(GT_LanguageManager.addStringLocalization("TileEntity_EUp_OUT", "Voltage OUT: ", !GregTech_API.sPostloadFinished) + EnumChatFormatting.GREEN + tTileEntity.getOutputVoltage() + " (" + GT_Values.VN[GT_Utility.getTier(tTileEntity.getOutputVoltage())] + ")" + EnumChatFormatting.GRAY);
                    }
                    if (tTileEntity.getOutputAmperage() > 1L) {
                        aList.add(GT_LanguageManager.addStringLocalization("TileEntity_EUp_AMOUNT", "Amperage: ", !GregTech_API.sPostloadFinished) + EnumChatFormatting.YELLOW + tTileEntity.getOutputAmperage() + EnumChatFormatting.GRAY);
                    }
                    aList.add(GT_LanguageManager.addStringLocalization("TileEntity_EUp_STORE", "Capacity: ", !GregTech_API.sPostloadFinished) + EnumChatFormatting.BLUE + tTileEntity.getEUCapacity() + EnumChatFormatting.GRAY);
                }
            }
            if ((aNBT = aStack.func_77978_p()) != null) {
                if (aNBT.func_74767_n("mWaterProof")) {
                    aList.add(GT_LanguageManager.addStringLocalization("GT_WATERPROOF", "Is Water Proof", !GregTech_API.sPostloadFinished));
                }
                if (aNBT.func_74767_n("mMuffler")) {
                    aList.add(GT_LanguageManager.addStringLocalization("GT_TileEntity_MUFFLER", "has Muffler Upgrade", !GregTech_API.sPostloadFinished));
                }
                if (aNBT.func_74767_n("mSteamConverter")) {
                    aList.add(GT_LanguageManager.addStringLocalization("GT_TileEntity_STEAMCONVERTER", "has Steam Upgrade", !GregTech_API.sPostloadFinished));
                }
                byte tAmount = 0;
                tAmount = aNBT.func_74771_c("mSteamTanks");
                if (tAmount > 0) {
                    aList.add(tAmount + " " + GT_LanguageManager.addStringLocalization("GT_TileEntity_STEAMTANKS", "Steam Tank Upgrades", !GregTech_API.sPostloadFinished));
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public String func_77667_c(ItemStack aStack) {
        short tDamage = (short)this.getDamage(aStack);
        if (tDamage < 0 || tDamage >= GregTech_API.METATILEENTITIES.length) {
            return "";
        }
        if (GregTech_API.METATILEENTITIES[tDamage] != null) {
            return this.func_77658_a() + "." + GregTech_API.METATILEENTITIES[tDamage].getMetaName();
        }
        return "";
    }

    public String func_77653_i(ItemStack aStack) {
        String aName = super.func_77653_i(aStack);
        short tDamage = (short)this.getDamage(aStack);
        if (tDamage >= 0 && tDamage < GregTech_API.METATILEENTITIES.length && GregTech_API.METATILEENTITIES[tDamage] != null) {
            Materials aMaterial = null;
            if (GregTech_API.METATILEENTITIES[tDamage] instanceof GT_MetaPipeEntity_Fluid) {
                aMaterial = ((GT_MetaPipeEntity_Fluid)GregTech_API.METATILEENTITIES[tDamage]).mMaterial;
            } else if (GregTech_API.METATILEENTITIES[tDamage] instanceof GT_MetaPipeEntity_Cable) {
                aMaterial = ((GT_MetaPipeEntity_Cable)GregTech_API.METATILEENTITIES[tDamage]).mMaterial;
            } else if (GregTech_API.METATILEENTITIES[tDamage] instanceof GT_MetaPipeEntity_Item) {
                aMaterial = ((GT_MetaPipeEntity_Item)GregTech_API.METATILEENTITIES[tDamage]).mMaterial;
            } else if (GregTech_API.METATILEENTITIES[tDamage] instanceof GT_MetaPipeEntity_Frame) {
                aMaterial = ((GT_MetaPipeEntity_Frame)GregTech_API.METATILEENTITIES[tDamage]).mMaterial;
            }
            if (aMaterial != null) {
                return aMaterial.getLocalizedNameForItem(aName);
            }
        }
        return aName;
    }

    public void func_77622_d(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        super.func_77622_d(aStack, aWorld, aPlayer);
        short tDamage = (short)this.getDamage(aStack);
        if (tDamage < 0 || tDamage >= GregTech_API.METATILEENTITIES.length && GregTech_API.METATILEENTITIES[tDamage] != null) {
            GregTech_API.METATILEENTITIES[tDamage].onCreated(aStack, aWorld, aPlayer);
        }
    }

    public boolean placeBlockAt(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int side, float hitX, float hitY, float hitZ, int aMeta) {
        short tDamage = (short)this.getDamage(aStack);
        if (tDamage > 0) {
            if (GregTech_API.METATILEENTITIES[tDamage] == null) {
                return false;
            }
            byte tMetaData = GregTech_API.METATILEENTITIES[tDamage].getTileEntityBaseType();
            if (!aWorld.func_147465_d(aX, aY, aZ, this.field_150939_a, (int)tMetaData, 3)) {
                return false;
            }
            if (aWorld.func_147439_a(aX, aY, aZ) != this.field_150939_a) {
                throw new GT_ItsNotMyFaultException("Failed to place Block even though World.setBlock returned true. It COULD be MCPC/Bukkit causing that. In case you really have that installed, don't report this Bug to me, I don't know how to fix it.");
            }
            if (aWorld.func_72805_g(aX, aY, aZ) != tMetaData) {
                throw new GT_ItsNotMyFaultException("Failed to set the MetaValue of the Block even though World.setBlock returned true. It COULD be MCPC/Bukkit causing that. In case you really have that installed, don't report this Bug to me, I don't know how to fix it.");
            }
            IGregTechTileEntity tTileEntity = (IGregTechTileEntity)aWorld.func_147438_o(aX, aY, aZ);
            if (tTileEntity != null) {
                IGregTechTileEntity aTileEntity;
                tTileEntity.setInitialValuesAsNBT(tTileEntity.isServerSide() ? aStack.func_77978_p() : null, tDamage);
                if (aPlayer != null) {
                    tTileEntity.setOwnerName(aPlayer.func_70005_c_());
                }
                tTileEntity.getMetaTileEntity().initDefaultModes(aStack.func_77978_p());
                byte aSide = GT_Utility.getOppositeSide(side);
                if (tTileEntity.getMetaTileEntity() instanceof IConnectable) {
                    ((IConnectable)((Object)tTileEntity.getMetaTileEntity())).connect(aSide);
                } else if (aPlayer != null && aPlayer.func_70093_af() && (aTileEntity = tTileEntity.getIGregTechTileEntityAtSide(aSide)) != null && aTileEntity.getMetaTileEntity() instanceof IConnectable) {
                    ((IConnectable)((Object)aTileEntity.getMetaTileEntity())).connect((byte)side);
                }
            }
        } else if (!aWorld.func_147465_d(aX, aY, aZ, this.field_150939_a, (int)tDamage, 3)) {
            return false;
        }
        if (aWorld.func_147439_a(aX, aY, aZ) == this.field_150939_a) {
            this.field_150939_a.func_149689_a(aWorld, aX, aY, aZ, (EntityLivingBase)aPlayer, aStack);
            this.field_150939_a.func_149714_e(aWorld, aX, aY, aZ, (int)tDamage);
        }
        return true;
    }

    static {
        mShowStructure = null;
        mLastID = -1;
        mTimer = 0L;
        mClick = 0;
    }
}

