/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiFakeItemButton;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconButton;
import gregtech.api.gui.widgets.GT_GuiIntegerTextBox;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.net.GT_Packet_TileEntityCover;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fluids.Fluid;

public class GT_Cover_Arm
extends GT_CoverBehavior {
    public final int mTickRate;
    protected static final int EXPORT_MASK = 0x40000000;
    protected static final int SLOT_ID_MASK = 16383;
    protected static final int SLOT_ID_MIN = 0;
    protected static final int CONVERTED_BIT = Integer.MIN_VALUE;

    public GT_Cover_Arm(int aTickRate) {
        this.mTickRate = aTickRate;
    }

    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        int toSlot;
        int fromSlot;
        TileEntity toTile;
        TileEntity fromTile;
        if (aTileEntity instanceof IMachineProgress && !((IMachineProgress)((Object)aTileEntity)).isAllowedToWork()) {
            return aCoverVariable;
        }
        if (aCoverVariable >>> 29 == 0) {
            aCoverVariable = Integer.MIN_VALUE | (aCoverVariable + 1 & 0x3FFF) << 14 | 0x40000000;
        } else if (aCoverVariable >>> 29 == 7) {
            aCoverVariable = Integer.MIN_VALUE | Math.min(Math.abs(aCoverVariable - 1), 16383);
        }
        boolean usePower = false;
        if (aTileEntity.getUniversalEnergyCapacity() >= 128L) {
            if (aTileEntity.isUniversalEnergyStored(256L)) {
                usePower = true;
            } else {
                return aCoverVariable;
            }
        }
        if ((aCoverVariable & 0x40000000) > 0) {
            fromTile = (TileEntity)aTileEntity;
            toTile = aTileEntity.getTileEntityAtSide(aSide);
            fromSlot = aCoverVariable & 0x3FFF;
            toSlot = aCoverVariable >> 14 & 0x3FFF;
        } else {
            fromTile = aTileEntity.getTileEntityAtSide(aSide);
            toTile = (TileEntity)aTileEntity;
            fromSlot = aCoverVariable >> 14 & 0x3FFF;
            toSlot = aCoverVariable & 0x3FFF;
        }
        int movedItems = 0;
        if (fromSlot > 0 && toSlot > 0) {
            if (fromTile instanceof IInventory && toTile instanceof IInventory) {
                movedItems = GT_Utility.moveFromSlotToSlot((IInventory)fromTile, (IInventory)toTile, fromSlot - 1, toSlot - 1, null, false, (byte)64, (byte)1, (byte)64, (byte)1);
            }
        } else if (toSlot > 0) {
            byte side = (aCoverVariable & 0x40000000) > 0 ? aSide : GT_Utility.getOppositeSide(aSide);
            movedItems = GT_Utility.moveOneItemStackIntoSlot(fromTile, toTile, side, toSlot - 1, null, false, (byte)64, (byte)1, (byte)64, (byte)1);
        } else if (fromSlot > 0) {
            byte toSide = (aCoverVariable & 0x40000000) > 0 ? aSide : GT_Utility.getOppositeSide(aSide);
            if (fromTile instanceof IInventory) {
                movedItems = GT_Utility.moveFromSlotToSide((IInventory)fromTile, toTile, fromSlot - 1, toSide, null, false, (byte)64, (byte)1, (byte)64, (byte)1);
            }
        } else {
            byte toSide;
            byte fromSide;
            if ((aCoverVariable & 0x40000000) > 0) {
                fromSide = aSide;
                toSide = GT_Utility.getOppositeSide(aSide);
            } else {
                fromSide = GT_Utility.getOppositeSide(aSide);
                toSide = aSide;
            }
            movedItems = GT_Utility.moveOneItemStack(fromTile, toTile, fromSide, toSide, null, false, (byte)64, (byte)1, (byte)64, (byte)1);
        }
        if (usePower) {
            aTileEntity.decreaseStoredEnergyUnits(4 * movedItems, true);
        }
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int step = 0;
        step = GT_Utility.getClickedFacingCoords(aSide, aX, aY, aZ)[0] >= 0.5f ? (step += aPlayer.func_70093_af() ? 256 : 16) : (step -= aPlayer.func_70093_af() ? 256 : 16);
        aCoverVariable = this.getNewVar(aCoverVariable, step);
        this.sendMessageToPlayer(aPlayer, aCoverVariable);
        return aCoverVariable;
    }

    @Override
    public boolean onCoverRightclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int step = GT_Utility.getClickedFacingCoords(aSide, aX, aY, aZ)[0] >= 0.5f ? 1 : -1;
        aCoverVariable = this.getNewVar(aCoverVariable, step);
        this.sendMessageToPlayer(aPlayer, aCoverVariable);
        aTileEntity.setCoverDataAtSide(aSide, aCoverVariable);
        return true;
    }

    private void sendMessageToPlayer(EntityPlayer aPlayer, int var) {
        if ((var & 0x40000000) != 0) {
            aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_001", new Object[]{(var >> 14 & 0x3FFF) - 1}));
        } else {
            aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_002", new Object[]{(var & 0x3FFF) - 1}));
        }
    }

    private int getNewVar(int var, int step) {
        int intSlot = var & 0x3FFF;
        int adjSlot = var >> 14 & 0x3FFF;
        if ((var & 0x40000000) == 0) {
            int x = intSlot + step;
            if (x > 16383) {
                return this.createVar(0, 16383, 0);
            }
            if (x < 1) {
                return this.createVar(-step - intSlot + 1, 0, 0x40000000);
            }
            return this.createVar(0, x, 0);
        }
        int x = adjSlot - step;
        if (x > 16383) {
            return this.createVar(16383, 0, 0x40000000);
        }
        if (x < 1) {
            return this.createVar(0, step - adjSlot + 1, 0);
        }
        return this.createVar(x, 0, 0x40000000);
    }

    private int createVar(int adjSlot, int intSlot, int export) {
        return Integer.MIN_VALUE | export | (adjSlot & 0x3FFF) << 14 | intSlot & 0x3FFF;
    }

    @Override
    public boolean letsRedstoneGoIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean alwaysLookConnected(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return this.mTickRate;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public Object getClientGUI(byte aSide, int aCoverID, int coverData, ICoverable aTileEntity) {
        return new GUI(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GUI
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private GT_GuiIntegerTextBox intSlot;
        private GT_GuiIntegerTextBox adjSlot;
        private GT_GuiFakeItemButton intSlotIcon;
        private GT_GuiFakeItemButton adjSlotIcon;
        private int coverVariable;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;
        private final String ANY_TEXT;
        private boolean export;
        private int internalSlotID;
        private int adjacentSlotID;
        private final int maxIntSlot;
        private final int maxAdjSlot;

        public GUI(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.ANY_TEXT = GT_Cover_Arm.this.trans("ANY", "Any");
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            this.export = (this.coverVariable & 0x40000000) > 0;
            this.internalSlotID = this.coverVariable & 0x3FFF;
            this.adjacentSlotID = this.coverVariable >> 14 & 0x3FFF;
            new GT_GuiIconButton(this, 0, 10, 25, GT_GuiIcon.EXPORT).setTooltipText(GT_Cover_Arm.this.trans("006", "Export"));
            new GT_GuiIconButton(this, 1, 28, 25, GT_GuiIcon.IMPORT).setTooltipText(GT_Cover_Arm.this.trans("007", "Import"));
            this.intSlot = new GT_GuiIntegerTextBox(this, 2, 10, 45, 41, 12);
            this.setBoxText(this.intSlot, this.internalSlotID - 1);
            this.intSlot.func_146203_f(6);
            this.adjSlot = new GT_GuiIntegerTextBox(this, 3, 10, 63, 41, 12);
            this.setBoxText(this.adjSlot, this.adjacentSlotID - 1);
            this.adjSlot.func_146203_f(6);
            if (this.tile instanceof TileEntity && !this.tile.isDead()) {
                this.maxIntSlot = this.tile.func_70302_i_() - 1;
                TileEntity adj = this.tile.getTileEntityAtSide(this.side);
                this.maxAdjSlot = adj instanceof IInventory ? ((IInventory)adj).func_70302_i_() - 1 : -1;
            } else {
                this.maxIntSlot = -1;
                this.maxAdjSlot = -1;
            }
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            if (this.export) {
                this.getFontRenderer().func_78276_b(GT_Cover_Arm.this.trans("006", "Export"), 64, 29, -11184811);
            } else {
                this.getFontRenderer().func_78276_b(GT_Cover_Arm.this.trans("007", "Import"), 64, 29, -11184811);
            }
            this.getFontRenderer().func_78276_b(GT_Cover_Arm.this.trans("254", "Internal slot#"), 64, 47, -11184811);
            this.getFontRenderer().func_78276_b(GT_Cover_Arm.this.trans("255", "Adjacent slot#"), 64, 65, -11184811);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.intSlot.func_146195_b(true);
            this.updateButtons();
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            if (this.buttonClickable(btn.field_146127_k)) {
                this.export = btn.field_146127_k == 0;
                this.coverVariable = this.getNewCoverVariable();
                GT_Values.NW.sendToServer(new GT_Packet_TileEntityCover(this.side, this.coverID, this.coverVariable, this.tile));
            }
            this.updateButtons();
        }

        private void updateButtons() {
            for (Object o : this.field_146292_n) {
                GuiButton b = (GuiButton)o;
                b.field_146124_l = this.buttonClickable(b.field_146127_k);
            }
        }

        @Override
        public void onMouseWheel(int x, int y, int delta) {
            for (GT_GuiIntegerTextBox box : this.textBoxes) {
                if (!box.func_146206_l()) continue;
                int step = Math.max(1, Math.abs(delta / 120));
                step = (GUI.func_146272_n() ? 50 : (GUI.func_146271_m() ? 5 : 1)) * (delta > 0 ? step : -step);
                int maxSlot = box.id == 3 ? this.maxAdjSlot : this.maxIntSlot;
                int val = this.parseTextBox(box, maxSlot);
                if (val < 0) {
                    val = -1;
                }
                if (maxSlot < (val += step)) {
                    val = maxSlot < 0 ? -1 : maxSlot;
                } else if (val < 0) {
                    val = -1;
                }
                this.setBoxText(box, val);
                return;
            }
        }

        @Override
        public void applyTextBox(GT_GuiIntegerTextBox box) {
            int val = -1;
            if (box.id == 2) {
                val = this.parseTextBox(box, this.maxIntSlot);
                this.internalSlotID = val + 1;
            } else if (box.id == 3) {
                val = this.parseTextBox(box, this.maxAdjSlot);
                this.adjacentSlotID = val + 1;
            }
            this.setBoxText(box, val);
            this.coverVariable = this.getNewCoverVariable();
            GT_Values.NW.sendToServer(new GT_Packet_TileEntityCover(this.side, this.coverID, this.coverVariable, this.tile));
        }

        @Override
        public void resetTextBox(GT_GuiIntegerTextBox box) {
            int val = 0;
            if (box.id == 2) {
                val = this.internalSlotID - 1;
            } else if (box.id == 3) {
                val = this.adjacentSlotID - 1;
            }
            this.setBoxText(box, val);
        }

        private void setBoxText(GT_GuiIntegerTextBox box, int val) {
            box.func_146180_a(val < 0 ? this.ANY_TEXT : String.valueOf(val));
        }

        private int parseTextBox(GT_GuiIntegerTextBox box, int maxSlot) {
            int val;
            String text = box.func_146179_b();
            if (text == null) {
                return -1;
            }
            if ((text = text.trim()).startsWith(this.ANY_TEXT)) {
                text = text.substring(this.ANY_TEXT.length());
            }
            if (text.isEmpty()) {
                return -1;
            }
            try {
                val = Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                return -1;
            }
            if (maxSlot < val) {
                if (maxSlot < 0) {
                    return -1;
                }
                return maxSlot;
            }
            if (val < 0) {
                return 0;
            }
            return val;
        }

        private int getNewCoverVariable() {
            return (this.export ? 0x40000000 : 0) | (this.adjacentSlotID & 0x3FFF) << 14 | this.internalSlotID & 0x3FFF | Integer.MIN_VALUE;
        }

        private boolean buttonClickable(int id) {
            if (id == 0) {
                return !this.export;
            }
            return this.export;
        }
    }
}

