/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconButton;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.net.GT_Packet_TileEntityCover;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fluids.Fluid;

public class GT_Cover_Conveyor
extends GT_CoverBehavior {
    public final int mTickRate;
    private final int mMaxStacks;

    public GT_Cover_Conveyor(int aTickRate) {
        this.mTickRate = aTickRate;
        this.mMaxStacks = 1;
    }

    public GT_Cover_Conveyor(int aTickRate, int maxStacks) {
        this.mTickRate = aTickRate;
        this.mMaxStacks = maxStacks;
    }

    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        byte moved;
        if (aCoverVariable % 6 > 1 && aTileEntity instanceof IMachineProgress && ((IMachineProgress)((Object)aTileEntity)).isAllowedToWork() != aCoverVariable % 6 < 4) {
            return aCoverVariable;
        }
        TileEntity tTileEntity = aTileEntity.getTileEntityAtSide(aSide);
        ICoverable fromEntity = aCoverVariable % 2 == 0 ? aTileEntity : tTileEntity;
        ICoverable toEntity = aCoverVariable % 2 != 0 ? aTileEntity : tTileEntity;
        byte fromSide = aCoverVariable % 2 != 0 ? GT_Utility.getOppositeSide(aSide) : aSide;
        byte toSide = aCoverVariable % 2 == 0 ? GT_Utility.getOppositeSide(aSide) : aSide;
        boolean costsEnergy = !(aCoverVariable % 2 != 0 && aSide == 1 || aCoverVariable % 2 == 0 && aSide == 0 || aTileEntity.getUniversalEnergyCapacity() < 128L);
        for (int i = 0; i < this.mMaxStacks && (!costsEnergy || aTileEntity.isUniversalEnergyStored(256L)) && (moved = GT_Utility.moveOneItemStack(fromEntity, toEntity, fromSide, toSide, null, false, (byte)64, (byte)1, (byte)64, (byte)1)) != 0; ++i) {
            if (!costsEnergy) continue;
            aTileEntity.decreaseStoredEnergyUnits(4 * moved, true);
        }
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((aCoverVariable = (aCoverVariable + (aPlayer.func_70093_af() ? -1 : 1)) % 12) < 0) {
            aCoverVariable = 11;
        }
        switch (aCoverVariable) {
            case 0: {
                aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_006", new Object[0]));
                break;
            }
            case 1: {
                aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_007", new Object[0]));
                break;
            }
            case 2: {
                aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_008", new Object[0]));
                break;
            }
            case 3: {
                aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_009", new Object[0]));
                break;
            }
            case 4: {
                aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_010", new Object[0]));
                break;
            }
            case 5: {
                aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_011", new Object[0]));
                break;
            }
            case 6: {
                aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_012", new Object[0]));
                break;
            }
            case 7: {
                aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_013", new Object[0]));
                break;
            }
            case 8: {
                aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_014", new Object[0]));
                break;
            }
            case 9: {
                aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_015", new Object[0]));
                break;
            }
            case 10: {
                aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_016", new Object[0]));
                break;
            }
            case 11: {
                aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_017", new Object[0]));
            }
        }
        return aCoverVariable;
    }

    @Override
    public boolean letsRedstoneGoIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return aCoverVariable >= 6 || aCoverVariable % 2 != 0;
    }

    @Override
    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return aCoverVariable >= 6 || aCoverVariable % 2 == 0;
    }

    @Override
    public boolean alwaysLookConnected(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return this.mTickRate;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public Object getClientGUI(byte aSide, int aCoverID, int coverData, ICoverable aTileEntity) {
        return new GUI(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GUI
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private int coverVariable;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public GUI(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            GT_GuiIconButton b = new GT_GuiIconButton(this, 0, 10, 25, GT_GuiIcon.EXPORT).setTooltipText(GT_Cover_Conveyor.this.trans("006", "Export"));
            b = new GT_GuiIconButton(this, 1, 28, 25, GT_GuiIcon.IMPORT).setTooltipText(GT_Cover_Conveyor.this.trans("007", "Import"));
            b = new GT_GuiIconButton(this, 2, 10, 43, GT_GuiIcon.CHECKMARK).setTooltipText(GT_Cover_Conveyor.this.trans("228", "Ignore"));
            b = new GT_GuiIconButton(this, 3, 28, 43, GT_GuiIcon.REDSTONE_ON).setTooltipText(GT_Cover_Conveyor.this.trans("229", "Conditional"));
            b = new GT_GuiIconButton(this, 4, 46, 43, GT_GuiIcon.REDSTONE_OFF).setTooltipText(GT_Cover_Conveyor.this.trans("230", "Invert Condition"));
            b = new GT_GuiIconButton(this, 5, 10, 61, GT_GuiIcon.ALLOW_INPUT).setTooltipText(GT_Cover_Conveyor.this.trans("231", "Allow Input"));
            b = new GT_GuiIconButton(this, 6, 28, 61, GT_GuiIcon.BLOCK_INPUT).setTooltipText(GT_Cover_Conveyor.this.trans("232", "Block Input"));
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            this.field_146289_q.func_78276_b(GT_Cover_Conveyor.this.trans("-1", "Import/Export"), 64, 28, -11184811);
            this.field_146289_q.func_78276_b(GT_Cover_Conveyor.this.trans("229", "Conditional"), 64, 46, -11184811);
            this.field_146289_q.func_78276_b(GT_Cover_Conveyor.this.trans("-1", "Enable Input"), 64, 64, -11184811);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.updateButtons();
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            if (this.getClickable(btn.field_146127_k)) {
                this.coverVariable = this.getNewCoverVariable(btn.field_146127_k);
                GT_Values.NW.sendToServer(new GT_Packet_TileEntityCover(this.side, this.coverID, this.coverVariable, this.tile));
            }
            this.updateButtons();
        }

        private void updateButtons() {
            for (Object o : this.field_146292_n) {
                GuiButton b = (GuiButton)o;
                b.field_146124_l = this.getClickable(b.field_146127_k);
            }
        }

        private int getNewCoverVariable(int id) {
            switch (id) {
                case 0: {
                    return this.coverVariable & 0xFFFFFFFE;
                }
                case 1: {
                    return this.coverVariable | 1;
                }
                case 2: {
                    if (this.coverVariable > 5) {
                        return 6 | this.coverVariable & 0xFFFFFFF1;
                    }
                    return this.coverVariable & 0xFFFFFFF1;
                }
                case 3: {
                    if (this.coverVariable > 5) {
                        return 8 | this.coverVariable & 0xFFFFFFF1;
                    }
                    return 2 | this.coverVariable & 0xFFFFFFF1;
                }
                case 4: {
                    if (this.coverVariable > 5) {
                        return 0xA | this.coverVariable & 0xFFFFFFF1;
                    }
                    return 4 | this.coverVariable & 0xFFFFFFF1;
                }
                case 5: {
                    if (this.coverVariable > 5) break;
                    return this.coverVariable + 6;
                }
                case 6: {
                    if (this.coverVariable <= 5) break;
                    return this.coverVariable - 6;
                }
            }
            return this.coverVariable;
        }

        private boolean getClickable(int id) {
            if (this.coverVariable < 0 | 11 < this.coverVariable) {
                return false;
            }
            switch (id) {
                case 0: 
                case 1: {
                    return (1 & this.coverVariable) != id;
                }
                case 2: {
                    return this.coverVariable % 6 >= 2;
                }
                case 3: {
                    return this.coverVariable % 6 < 2 | 4 <= this.coverVariable % 6;
                }
                case 4: {
                    return this.coverVariable % 6 < 4;
                }
                case 5: {
                    return this.coverVariable < 6;
                }
                case 6: {
                    return this.coverVariable >= 6;
                }
            }
            return false;
        }
    }
}

