/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconButton;
import gregtech.api.gui.widgets.GT_GuiIntegerTextBox;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.net.GT_Packet_TileEntityCover;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_Cover_FluidRegulator
extends GT_CoverBehavior {
    public final int mTransferRate;

    public GT_Cover_FluidRegulator(int aTransferRate) {
        this.mTransferRate = aTransferRate;
    }

    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aCoverVariable == 0) {
            return aCoverVariable;
        }
        if (aTileEntity instanceof IFluidHandler) {
            FluidStack tLiquid;
            ForgeDirection directionTo;
            ForgeDirection directionFrom;
            IFluidHandler tTank1;
            IFluidHandler tTank2;
            if (aCoverVariable > 0) {
                tTank2 = aTileEntity.getITankContainerAtSide(aSide);
                tTank1 = (IFluidHandler)aTileEntity;
                directionFrom = ForgeDirection.UNKNOWN;
                directionTo = ForgeDirection.getOrientation((int)aSide).getOpposite();
            } else {
                tTank1 = aTileEntity.getITankContainerAtSide(aSide);
                tTank2 = (IFluidHandler)aTileEntity;
                directionFrom = ForgeDirection.getOrientation((int)aSide).getOpposite();
                directionTo = ForgeDirection.UNKNOWN;
            }
            if (tTank1 != null && tTank2 != null && (tLiquid = tTank1.drain(directionFrom, Math.abs(aCoverVariable), false)) != null) {
                tLiquid = tLiquid.copy();
                tLiquid.amount = tTank2.fill(directionTo, tLiquid, false);
                if (tLiquid.amount > 0) {
                    if (aTileEntity.getUniversalEnergyCapacity() >= (long)Math.min(1, tLiquid.amount / 10)) {
                        if (aTileEntity.isUniversalEnergyStored(Math.min(1, tLiquid.amount / 10))) {
                            aTileEntity.decreaseStoredEnergyUnits(Math.min(1, tLiquid.amount / 10), true);
                            tTank2.fill(directionTo, tTank1.drain(directionFrom, tLiquid.amount, true), true);
                        }
                    } else {
                        tTank2.fill(directionTo, tTank1.drain(directionFrom, tLiquid.amount, true), true);
                    }
                }
            }
        }
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        aCoverVariable = GT_Utility.getClickedFacingCoords(aSide, aX, aY, aZ)[0] >= 0.5f ? (aCoverVariable += aPlayer.func_70093_af() ? 256 : 16) : (aCoverVariable -= aPlayer.func_70093_af() ? 256 : 16);
        if (aCoverVariable > this.mTransferRate) {
            aCoverVariable = this.mTransferRate;
        }
        if (aCoverVariable < 0 - this.mTransferRate) {
            aCoverVariable = 0 - this.mTransferRate;
        }
        aPlayer.func_146105_b(new ChatComponentTranslation("Interaction_DESCRIPTION_Index_048", new Object[]{aCoverVariable}).func_150257_a(new ChatComponentTranslation("Interaction_DESCRIPTION_Index_049", new Object[]{aCoverVariable * 20}).func_150257_a((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_050", new Object[0]))));
        return aCoverVariable;
    }

    @Override
    public boolean onCoverRightclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        aCoverVariable = GT_Utility.getClickedFacingCoords(aSide, aX, aY, aZ)[0] >= 0.5f ? ++aCoverVariable : --aCoverVariable;
        if (aCoverVariable > this.mTransferRate) {
            aCoverVariable = this.mTransferRate;
        }
        if (aCoverVariable < 0 - this.mTransferRate) {
            aCoverVariable = 0 - this.mTransferRate;
        }
        aPlayer.func_146105_b(new ChatComponentTranslation("Interaction_DESCRIPTION_Index_048", new Object[]{aCoverVariable}).func_150257_a(new ChatComponentTranslation("Interaction_DESCRIPTION_Index_049", new Object[]{aCoverVariable * 20}).func_150257_a((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_050", new Object[0]))));
        aTileEntity.setCoverDataAtSide(aSide, aCoverVariable);
        return true;
    }

    @Override
    public boolean letsRedstoneGoIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return false;
    }

    @Override
    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return false;
    }

    @Override
    public boolean alwaysLookConnected(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 1;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public Object getClientGUI(byte aSide, int aCoverID, int coverData, ICoverable aTileEntity) {
        return new GUI(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GUI
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private GT_GuiIntegerTextBox tBox;
        private GT_GuiIntegerTextBox lBox;
        private int coverVariable;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;
        private int speed;
        private boolean export;

        public GUI(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            this.speed = Math.abs(this.coverVariable);
            this.export = this.coverVariable >= 0;
            new GT_GuiIconButton(this, 0, 10, 25, GT_GuiIcon.EXPORT).setTooltipText(GT_Cover_FluidRegulator.this.trans("006", "Export"));
            new GT_GuiIconButton(this, 1, 28, 25, GT_GuiIcon.IMPORT).setTooltipText(GT_Cover_FluidRegulator.this.trans("007", "Import"));
            this.tBox = new GT_GuiIntegerTextBox(this, 2, 10, 45, 69, 12);
            this.tBox.func_146180_a(String.valueOf(this.speed));
            this.tBox.func_146203_f(10);
            this.lBox = new GT_GuiIntegerTextBox(this, 3, 10, 63, 69, 12);
            this.lBox.func_146180_a(String.valueOf((long)this.speed * 20L));
            this.lBox.func_146203_f(10);
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            this.getFontRenderer().func_78276_b(GT_Cover_FluidRegulator.this.trans("229", "Import/Export"), 82, 29, -11184811);
            this.getFontRenderer().func_78276_b(GT_Cover_FluidRegulator.this.trans("049", "L/tick "), 82, 47, -11184811);
            this.getFontRenderer().func_78276_b(GT_Cover_FluidRegulator.this.trans("050", "L/sec"), 82, 65, -11184811);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.updateButtons();
            this.tBox.func_146195_b(true);
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            if (this.getClickable(btn.field_146127_k)) {
                this.coverVariable = this.getNewCoverVariable(btn.field_146127_k);
                GT_Values.NW.sendToServer(new GT_Packet_TileEntityCover(this.side, this.coverID, this.coverVariable, this.tile));
            }
            this.updateButtons();
        }

        @Override
        public void onMouseWheel(int x, int y, int delta) {
            for (GT_GuiIntegerTextBox box : this.textBoxes) {
                long i;
                if (!box.func_146206_l()) continue;
                int step = Math.max(1, Math.abs(delta / 120));
                step = (GUI.func_146272_n() ? 50 : (GUI.func_146271_m() ? 5 : 1)) * (delta > 0 ? step : -step);
                try {
                    i = Long.parseLong(box.func_146179_b());
                }
                catch (NumberFormatException e) {
                    return;
                }
                if (i > 9223372036854774807L) break;
                if ((i += (long)step) <= 0L) {
                    i = 0L;
                }
                box.func_146180_a(String.valueOf(i));
                break;
            }
        }

        @Override
        public void applyTextBox(GT_GuiIntegerTextBox box) {
            long i;
            String s = box.func_146179_b().trim();
            try {
                i = Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                this.resetTextBox(box);
                return;
            }
            if (box.id == 3) {
                i /= 20L;
            }
            if (i > (long)GT_Cover_FluidRegulator.this.mTransferRate) {
                i = GT_Cover_FluidRegulator.this.mTransferRate;
            } else if (i <= 0L) {
                i = 0L;
            }
            this.speed = (int)i;
            this.tBox.func_146180_a(String.valueOf(this.speed));
            this.lBox.func_146180_a(String.valueOf(this.speed * 20));
            this.coverVariable = this.getNewCoverVariable(2);
            GT_Values.NW.sendToServer(new GT_Packet_TileEntityCover(this.side, this.coverID, this.coverVariable, this.tile));
        }

        @Override
        public void resetTextBox(GT_GuiIntegerTextBox box) {
            box.func_146180_a(String.valueOf(this.speed));
        }

        private void updateButtons() {
            for (Object o : this.field_146292_n) {
                GuiButton b = (GuiButton)o;
                b.field_146124_l = this.getClickable(b.field_146127_k);
            }
        }

        private int getNewCoverVariable(int id) {
            switch (id) {
                case 0: {
                    this.export = true;
                    return this.speed;
                }
                case 1: {
                    this.export = false;
                    return -this.speed;
                }
                case 2: {
                    if (this.export) {
                        return this.speed;
                    }
                    return -this.speed;
                }
            }
            return this.coverVariable;
        }

        private boolean getClickable(int id) {
            return id == 0 ^ this.export;
        }
    }
}

