/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconCheckButton;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.net.GT_Packet_TileEntityCover;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_Cover_LiquidMeter
extends GT_CoverBehavior {
    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aTileEntity instanceof IFluidHandler) {
            FluidTankInfo[] tTanks = ((IFluidHandler)aTileEntity).getTankInfo(ForgeDirection.UNKNOWN);
            long tMax = 0L;
            long tUsed = 0L;
            if (tTanks != null) {
                for (FluidTankInfo tTank : tTanks) {
                    if (tTank == null) continue;
                    tMax += (long)tTank.capacity;
                    FluidStack tLiquid = tTank.fluid;
                    if (tLiquid == null) continue;
                    tUsed += (long)tLiquid.amount;
                }
            }
            if (tUsed == 0L) {
                aTileEntity.setOutputRedstoneSignal(aSide, (byte)(aCoverVariable != 0 ? 15 : 0));
            } else if (tUsed >= tMax) {
                aTileEntity.setOutputRedstoneSignal(aSide, (byte)(aCoverVariable != 0 ? 0 : 15));
            } else {
                aTileEntity.setOutputRedstoneSignal(aSide, (byte)(aCoverVariable != 0 ? 14L - 14L * tUsed / tMax : 1L + 14L * tUsed / tMax));
            }
        } else {
            aTileEntity.setOutputRedstoneSignal(aSide, (byte)0);
        }
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aCoverVariable == 0) {
            aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_054", new Object[0]));
        } else {
            aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("Interaction_DESCRIPTION_Index_055", new Object[0]));
        }
        return aCoverVariable == 0 ? 1 : 0;
    }

    @Override
    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 5;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public Object getClientGUI(byte aSide, int aCoverID, int coverData, ICoverable aTileEntity) {
        return new GUI(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GUI
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private int coverVariable;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public GUI(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            new GT_GuiIconCheckButton(this, 0, 10, 25, GT_GuiIcon.REDSTONE_OFF, GT_GuiIcon.REDSTONE_ON);
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            String s2 = this.coverVariable == 0 ? GT_Cover_LiquidMeter.this.trans("NORMAL", "Normal") : GT_Cover_LiquidMeter.this.trans("INVERTED", "Inverted");
            this.field_146289_q.func_78276_b(s2, 28, 29, -11184811);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.updateButtons();
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            boolean state = false;
            if (btn.field_146127_k == 0) {
                state = ((GT_GuiIconCheckButton)btn).isChecked();
            }
            this.coverVariable = this.getNewCoverVariable(btn.field_146127_k, state);
            GT_Values.NW.sendToServer(new GT_Packet_TileEntityCover(this.side, this.coverID, this.coverVariable, this.tile));
            this.updateButtons();
        }

        private void updateButtons() {
            for (Object o : this.field_146292_n) {
                GuiButton b = (GuiButton)o;
                if (b.field_146127_k != 0) continue;
                ((GT_GuiIconCheckButton)b).setChecked(this.coverVariable == 0);
            }
        }

        private int getNewCoverVariable(int id, boolean buttonState) {
            if (id == 0) {
                if (buttonState) {
                    return this.coverVariable | 1;
                }
                return this.coverVariable & 0xFFFFFFFE;
            }
            return this.coverVariable;
        }
    }
}

